/*
	Copyright (c) 2005-2022 AO Kaspersky Lab
*/

function EE(area) {

	this._area = area;

	this._cast = [
		{
                  group: 'Kaspersky Embedded Systems Security 3.4<br>Development Team',
		  members: ["Vladislav Ovcharik", "Oleg Bykov", "Victor Matyushenkov", "and others"]
		},
		{
		  group: 'Kaspersky Embedded Systems Security 3.4<br>Management Team',
		  members: ["Andrey Guzhov", "Vladislav Ovcharik", "Maxim Lankin"]
		},
		{
		  group: 'Kaspersky Embedded Systems Security 3.4<br>QA Team',
		  members: ["Georgy Borzunov", "Alexey Goroshinsky", "Alexey Erin", "Yury Kolosov", "and others"]
		},
		{
		  group: 'Kaspersky Embedded Systems Security 3.4<br>Doc&amp;Loc Team',
		  members: ["Andrey Latyshev", "and others"]
		},
		{
		  group: 'Special Thanks',
		  members: ["Eugene Kaspersky<br>for the Inspiration<br>", "Daniel Wischnewski and the German LO<br>for help and valuable advices<br>", "Andrey Agapov, Dmitry Rybak and HQ Support<br>for the critical approach"]
		}
	];

	this._petCount = 5;
	this._pets = [];
	this._container = null;
	this._eeDiv = null;
	this._castDiv = null;
	this._castGroupDiv = null;
	this._castPeopleDiv = null;
	this._started = false;
	this._triggerString = '';
	this._petsTimer = null;
	this._petMaxLeft = null;
	this._petMaxTop = null;
	this._castTimer = null;
	this._castActiveGroup = 0;
	this._rotateTicks = 0;

	this.processKey = function (keyCode) {
		var that = this;
		if (this._started) {
			if (keyCode == 27) {
				setTimeout(function () { that.stop(); }, 1);
			}
		} else {
			if (keyCode >= 97 && keyCode <= 122) {
				this._triggerString = (this._triggerString + String.fromCharCode(keyCode)).slice(-4);
				if (this._triggerString === "wsee" || this._triggerString === "fsee" || this._triggerString === "kess" || this._triggerString === "ess" || this._triggerString === "kics") {
					setTimeout(function () { that.start(); }, 1);
				}
			}
		}
		return true;
	};

	this._convertCoord = function (s) {
		return parseInt(s.substr(0, s.length - 2));
	};

	this._updatePets = function () {
		var foundAlive = false;
		var redEyedFound = false;
		for (var i = 0; i < this._pets.length; i++) {
			var pet = this._pets[i].div;
			var status = this._pets[i].status;
			if (status === 'killed') {
				if (this._pets[i].killTimer > 10) {
					pet.style.display = 'none';
				} else {
					foundAlive = true;
					this._pets[i].killTimer++;
				}
			} else {
				foundAlive = true;
				var posDiff = this._pets[i].posDiff;
				var left_move = Math.round((0.5 - Math.random()) * 10 * 0.2 + posDiff.left * 0.9);
				var top_move = Math.round((0.5 - Math.random()) * 10 * 0.2 + posDiff.top * 0.9);
				var left = this._convertCoord(pet.style.left) + left_move;
				posDiff.left = left_move;
				if (left < 0) {
					left = 0;
					posDiff.left = -posDiff.left;
				}
				if (left > this._petMaxLeft) {
					left = this._petMaxLeft;
					posDiff.left = -posDiff.left;
				}
				var top = this._convertCoord(pet.style.top) + top_move;
				posDiff.top = top_move;
				if (top < 0) {
					top = 0;
					posDiff.top = -posDiff.top;
				}
				if (top > this._petMaxTop) {
					top = this._petMaxTop;
					posDiff.top = -posDiff.top;
				}
				pet.style.left = left;
				pet.style.top = top;
				if (this._pets[i].redEyeCount > 0) {
					redEyedFound = true;
					if (this._pets[i].redEyeCount % 2 == 0) {
						this._pets[i].img.src = 'images/ee/pet.png';
					} else {
						this._pets[i].img.src = 'images/ee/pet_red.png';
					}
					if (this._pets[i].redEyeCount == 4)
						this._pets[i].redEyeCount = 0;
					else
						this._pets[i].redEyeCount++;
				}
			}
		}
		var that = this;
		if (!foundAlive) {
			setTimeout(function() { that.stop(); }, 100);
			return;
		}
		if (!redEyedFound && Math.random() < 0.2) {
			var red_index = Math.floor(Math.random() * this._pets.length);
			if (this._pets[red_index].status === 'normal')
				this._pets[red_index].redEyeCount = 1;
		}
		if (this._started)
			this._petsTimer = setTimeout(function() { that._updatePets(); }, 80);
	};

	this._killPet = function(index) {
		this._pets[index].status = 'killed';
		this._pets[index].img.src = 'images/ee/pet_wet_place.png';
	};

	this._focusPet = function(index) {
		this._pets[index].status = 'focused';
		this._pets[index].img.src = 'images/ee/pet_yellow.png';
	};

	this._unfocusPet = function (index) {
		if (this._pets[index].status === 'focused') {
			this._pets[index].status = 'normal';
			this._pets[index].img.src = 'images/ee/pet.png';
		}
	};

	this._initPets = function () {
		var that = this;
		this._pets = [];
		for (var i = 0; i < this._petCount; i++) {
			var pet = document.createElement('div');
			pet.className = 'pet';
			pet.style.top = Math.floor(Math.random() * this._petMaxTop);
			pet.style.left = Math.floor(Math.random() * this._petMaxLeft);
			var img = document.createElement('img');
			img.src = 'images/ee/pet.png';
			pet.appendChild(img);
			var closure_fix = function (index) {
				var index2 = index;
				pet.onclick = function () { that._killPet(index2); }
				pet.onmouseenter = function () { that._focusPet(index2); }
				pet.onmouseleave = function () { that._unfocusPet(index2); }
			};
			closure_fix(i);
			this._eeDiv.appendChild(pet);
			this._pets.push({ div: pet, img: img, posDiff: { top: 0, left: 0 }, status: 'normal', redEyeCount: 0, killTimer: 0 });
		}
		this._petsTimer = setTimeout(function() { that._updatePets(); } , 80);
	};

	this._initCast = function () {
		var that = this;
		this._castDiv = document.createElement('div');
		this._castDiv.className = 'cast';
		this._castGroupDiv = document.createElement('div');
		this._castGroupDiv.className = 'group';
		this._castDiv.appendChild(this._castGroupDiv);
		this._castPeopleDiv = document.createElement('div');
		this._castPeopleDiv.className = 'people';
		this._castDiv.appendChild(this._castPeopleDiv);
		this._eeDiv.appendChild(this._castDiv);
		this._castTimer = setTimeout(function() { that._rotateCastShow(); } , 1);
	}

	this._rotateCastHide = function () {
		var that = this;
		if (!this._started)
			return;
		try {
			if (this._castDiv.filters[0].status === 2) {
				this._castTimer = setTimeout(function() { that._rotateCastHide(); }, 1000);
				return;
			}
		} catch (e) {
		}
		try { this._castDiv.filters[0].apply(); } catch (e) {}
		this._castDiv.style.visibility = "hidden";
		try { this._castDiv.filters[0].play(1); } catch (e) {}
		this._castTimer = setTimeout(function() { that._rotateCastShow(); } , 1000);
	}

	this._rotateCastShow = function () {
		var that = this;
		if (!this._started)
			return;
		try {
			if (this._castDiv.filters[0].status === 2) {
				this._castTimer = setTimeout(function() { that._rotateCastShow(); }, 1000);
				return;
			}
		} catch (e) {
		}
		this._castGroupDiv.innerHTML = this._cast[this._castActiveGroup].group;
		var peopleHtml = '';
		for (var i = 0; i < this._cast[this._castActiveGroup].members.length; ++i) {
			if (i > 0)
				peopleHtml += '<br>';
			peopleHtml += this._cast[this._castActiveGroup].members[i];
		}
		this._castPeopleDiv.innerHTML = peopleHtml;
		try { this._castDiv.filters[0].apply(); } catch (e) {}
		this._castDiv.style.visibility = "visible";
		try { this._castDiv.filters[0].play(1); } catch (e) {}
		this._castActiveGroup++;
		if (this._castActiveGroup >= this._cast.length)
			this._castActiveGroup = 0;
		this._castTimer = setTimeout(function() { that._rotateCastHide(); } , 7000);
	}

	this.start = function () {
		if (this._started)
			return false;
		this._started = true;
		this._castActiveGroup = 0;
		this._container = document.body;
		this._eeDiv = document.createElement('div');
		this._eeDiv.className = 'ee';
		var ar = document.getElementById(this._area);
		this._eeDiv.style.width = ar.offsetWidth;
		this._eeDiv.style.height = ar.offsetHeight;
		this._container.appendChild(this._eeDiv);
		this._petMaxLeft = this._eeDiv.offsetWidth - 28;
		this._petMaxTop = this._eeDiv.offsetHeight - 28;
		this._initPets();
		this._initCast();
		try { this._eeDiv.filters[0].apply(); } catch (e) {}
		this._eeDiv.style.visibility = "visible";
		try { this._eeDiv.filters[0].play(2); } catch (e) {}
		return true;
	};

	this.stop = function() {
		this._started = false;
		if (this._castTimer) {
			clearTimeout(this._castTimer);
			this._castTimer = null;
		}
		if (this._petsTimer) {
			clearTimeout(this._petsTimer);
			this._petsTimer = null;
		}
		this._container.removeChild(this._eeDiv);
		this._eeDiv = null;
	}

}
