/*
	Copyright (c) 2022 AO Kaspersky Lab
*/

function ViewController(installationLinks) {

	this._runFolder = '';
	this._installationLinks = installationLinks;

	this.localizeHtml = function (id, text)
	{
		document.getElementById(id).innerHTML = text;
	}

	this.localizeText = function (id, text) 
	{
		document.getElementById(id).innerText = text;
	}

	this.setExplanationAreaText = function (text)
	{
		document.getElementById('explanation-area').innerHTML = (text == null ? '' : text);
	}

	this.setupExplanationTextProvider = function (id_or_el, text)
	{
		var el = typeof id_or_el == "string" ? document.getElementById(id_or_el) : id_or_el;
		var that = this;
		el.onmouseover = function () { that.setExplanationAreaText(text); }
		el.onmouseout = function () { that.setExplanationAreaText(); }
	}

	this.callShell = function (appInfo) {
		try
		{
			var shell = new ActiveXObject("Shell.Application");
			shell.ShellExecute(appInfo.app, appInfo.arg, appInfo.path ? this._runFolder + appInfo.path : null);
		}
		catch (ex)
		{
			window.alert(ex.Message);
		}
	}

	this.onLinkKeyPress = function (keycode, appInfo)
	{
		if (keycode == 32)
			this.callShell(appInfo);
		return false;
	}

	this.setupLinks = function (id, listName)
	{
		var that = this;
		var list = this._installationLinks[listName];
		var el = document.getElementById(id);
		el.innerHTML = '';
		for (var i = 0; i < list.length; ++i) {
			var item = list[i];
			var a = document.createElement('a');
			a.href = '#';
			a.innerHTML = item.link_text;
			var closure_fix = function (item2) {
				var item = item2;
				a.onclick = function() { that.callShell(item); }
				a.onkeypress = function() { that.onLinkKeyPress(event.keyCode, item); }
			};
			closure_fix(item);
			if (item.popup_text && item.popup_text != '')
				this.setupExplanationTextProvider(a, item.popup_text);
			var li = document.createElement('li');
			li.appendChild(a);
			el.appendChild(li);
		}
	}

	this.loadGeneralLocalization = function ()
	{
		document.title = L_Title_Text;
		this.localizeHtml('title', L_Resources_Advertising_Name);
		this.localizeHtml('subtitle', L_Resources_Advertising);
		this.localizeText('installation-caption-text', L_Deployment_Text);
		this.localizeText('documentation-caption-text', L_Resources_Text);
		if(typeof L_Resources_Advertising_Condition !== 'undefined')
		{
			this.localizeHtml('disclaimer', L_Resources_Advertising_Condition);
		}
		this.localizeHtml('copyright', L_Copyright_Text);
		this.localizeHtml('exit-link', L_Exit_Text);
	}

	this.initRunFolder = function ()
	{
	  var fullPath = decodeURI(document.URL.replace(/%/g, "%25"));
		var dir = fullPath;
		if (dir.substr(0, 7).toLowerCase() === 'file://')
			dir = dir.substr(7);
		var pos = Math.max(dir.lastIndexOf("\\"), dir.lastIndexOf("/"));
		if (pos != -1)
			dir = dir.substr(0, pos + 1);
		this._runFolder = dir;
	}

	this.resizeWindowToFitAndCenter = function ()
	{
		var container = document.getElementById('container');
		var currViewportWidth = L_Window_Width;
		var currViewportHeight = container.offsetHeight;

		try
		{
			window.resizeTo(currViewportWidth, currViewportHeight);
			var chromeWidth = currViewportWidth - document.body.offsetWidth;

			window.resizeTo(currViewportWidth + chromeWidth, currViewportHeight);
			var chromeHeight = currViewportHeight - document.body.offsetHeight;
			currViewportHeight = container.offsetHeight;

				
			window.resizeTo(currViewportWidth + chromeWidth, currViewportHeight + chromeHeight);

			var x = (window.screen.availWidth - (currViewportWidth + chromeWidth)) / 2;
			var y = (window.screen.availHeight - (currViewportHeight + chromeHeight)) / 2;
			window.moveTo(x, y);
		}  catch (e) { }
	}

	this.onBodyKeyPress = function () {
		if (ee)
			ee.processKey(event.keyCode);
	}

	this.init = function ()
	{
		this.initRunFolder();
		this.loadGeneralLocalization();
		this.setupExplanationTextProvider('installation-caption', L_DeploymentComment_Text);
		this.setupExplanationTextProvider('documentation-caption', L_ResourcesComment_Text);
		this.setupLinks('installation-links', 'deployments');
		this.setupLinks('documentation-links', 'docs');
		this.resizeWindowToFitAndCenter();
		document.body.onkeypress = this.onBodyKeyPress;
	}
}

