unit Common;

interface

uses
  Windows, Classes, Controls, Mask, Variants, DBGrids, stdCtrls;

type
  TTerritoryStruct = record
    OblastID: Variant;
    NameObl: string;
    RayonID: Variant;
    NameRay: string;
    SelSovetID: Variant;
    NameSovet: string;
    PunktID: Variant;
    NamePunkt: string;
    Level: integer;
    SOATO: variant;
  end;

 //         
procedure GridResize(Grid: TDBGrid; MainCol: integer);

function EndSoato(LT: TTerritoryStruct): variant;

function VarToStrN(V: variant): string;

function VarToStrN1(V: variant): string;

function PartMag(P: variant; M: variant): variant;

procedure CommonSchetEditKeyPress(Sender: TObject; var Key: Char);

procedure CommonSchetEditChange(Sender: TObject);

function ReturnDateFromDateTime(DT: TDatetime): TDate;

function DaysInMonth(Month, Year: word): integer;

implementation

uses
  SysUtils;

function DaysInMonth(Month, Year: word): integer;
begin
  case Month of
    1, 3, 5, 7, 8, 10, 12:
      Result := 31;
    4, 6, 9, 11:
      Result := 30;
    2:
      if IsLeapYear(Year) then
        Result := 29
      else
        Result := 28;
  else
    Result := 0;
  end;
end;

function ReturnDateFromDateTime(DT: TDatetime): TDate;
var
  D, M, Y: word;
begin
  DecodeDate(DT, Y, M, D);
  Result := EncodeDate(Y, M, D);
end;

function VarToStrN1(V: variant): string;
begin
  if (VarIsNull(V)) or (VarToStr(V) = '') or (VarToStr(V) = 'NULL') then
  begin
    result := 'NULL';
    Exit;
  end
  else
  begin
    result := '''' + VarToStr(V) + '''';
  end;
end;

function VarToStrN(V: variant): string;
begin
  if (VarIsNull(V)) or (VarToStr(V) = '') then
  begin
    result := '[NULL]';
    Exit;
  end
  else
  begin
    result := VarToStr(V);
  end;
end;

function EndSoato(LT: TTerritoryStruct): variant;
var
  S: string;
  i: integer;
begin
  S := VarToStr(LT.SOATO);
  case LT.Level of
    0:
      begin
        for i := 2 to 10 do
          S[i] := '9';
        result := S;
      end;
    1:
      begin
        for i := 5 to 10 do
          S[i] := '9';
        result := S;
      end;
    2:
      begin
        for i := 8 to 10 do
          S[i] := '9';
        result := S;
      end;
    3:
      result := LT.SOATO;
  end;
end;

procedure GridResize(Grid: TDBGrid; MainCol: integer);
var
  w, i: integer;
begin
  w := Grid.ClientWidth;

  for i := 0 to Grid.Columns.Count - 1 do
    if i <> MainCol then
      w := w - Grid.Columns[i].Width;

  w := w - Grid.Columns.Count;

  Grid.Columns[MainCol].Width := w;
end;

procedure CommonSchetEditChange(Sender: TObject);
begin
  if (Length((Sender as TEdit).Text) = 2) and (Pos('.', (Sender as TEdit).Text) = 0) then
  begin
    (Sender as TEdit).Text := (Sender as TEdit).Text + '.';
    (Sender as TEdit).SelStart := Length((Sender as TEdit).Text);
  end;
end;

procedure CommonSchetEditKeyPress(Sender: TObject; var Key: Char);
begin
  if (Key = #8) and (Length((Sender as TEdit).Text) = 3) then
  begin
    (Sender as TEdit).Text := Copy((Sender as TEdit).Text, 1, 1);
    (Sender as TEdit).SelStart := Length((Sender as TEdit).Text);
    Key := #0;
  end;

  if (Pos('.', (Sender as TEdit).Text) > 2) and ((Sender as TEdit).SelStart < 3) then
  begin
    Key := #0;
  end;

  if not (Key in ['0'..'9', #27, #8]) then
    Key := #0;
end;

function PartMag(P: variant; M: variant): variant;
begin
  if VarIsNull(P) then
    Result := M
  else
    Result := P;
end;

initialization

finalization

end.

