unit uAddProvNDS;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, DB, ADODB, uMoveControl, Mask;

type
  TfrmAddProvNDS = class(TForm)
    pnlMain: TPanel;
    btnOk: TButton;
    btnCancel: TButton;
    gbBankV: TGroupBox;
    dsAUDTV: TDataSource;
    aqryAUDTV: TADOQuery;
    dsAUKTV: TDataSource;
    aqryAUKTV: TADOQuery;
    Label3: TLabel;
    Label4: TLabel;
    dblcobAUDTV: TDBLookupComboBox;
    Label5: TLabel;
    Label6: TLabel;
    dblcobAUKTV: TDBLookupComboBox;
    Bevel1: TBevel;
    aqrySchet: TADOQuery;
    dsSchet: TDataSource;
    edtDTV: TEdit;
    edtKTV: TEdit;
    Label1: TLabel;
    Edit1: TEdit;
    NdsDt: TDBEdit;
    NdsKt: TDBEdit;
    procedure btnOkClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure FormKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure edtDTVKeyPress(Sender: TObject; var Key: Char);
    procedure edtDTVChange(Sender: TObject);
    procedure edtDTVExit(Sender: TObject);
    procedure edtKTVExit(Sender: TObject);
    function CheckSchet(Schet: string): variant;
    function CheckBankSchet(Schet: string): variant;
    procedure dblcobAUDTVKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
  private
    { Private declarations }
    Contr: TMoveControl;

    procedure GetAUSQL(IDSchet:variant; dbcobAU: TDBLookupComboBox; var DatSet: TADOQuery);
    function CheckGrantProv(DT, KT: Variant): integer;
  public
    { Public declarations }
  end;

var
  frmAddProvNDS: TfrmAddProvNDS;

implementation

uses uProvNDS;

{$R *.dfm}

procedure TfrmAddProvNDS.btnOkClick(Sender: TObject);
var
   ch: integer;
begin
 if ((edtDTV.Text = '') and (edtKTV.Text <> '')) or
    ((edtDTV.Text <> '') and (edtKTV.Text = ''))   then
 begin
   MessageDlg('   !!!',mtWarning,[mbOK],0);
   edtDTV.SetFocus;
   Exit;
 end;

 if (edtDTV.Text <> '') and (edtKTV.Text <> '') then begin
  ch := CheckGrantProv(edtDTV.tag, edtKTV.tag);
  case ch of
    0: begin
        MessageDlg('      !!!  !!!',mtWarning,[mbOK],0);
        edtDTV.SetFocus;
        Exit;
       end;
    1: begin
        MessageDlg('  !!!  !!!',mtWarning,[mbOK],0);
        edtDTV.SetFocus;
        Exit;
       end;
  end;
 ///

     if dblcobAUKTV.Text='' then
      PrNDS :=0
     else
     if Pos('10',dblcobAUKTV.Text)<>0 then
      PrNDS :=1
     else
     if Pos('20',dblcobAUKTV.Text)<>0 then
      PrNDS :=2
     else
     if Pos('25',dblcobAUKTV.Text)<>0 then
      PrNDS :=3
//23.10.2019
     else
     if Pos(AnsiLowerCase(''),dblcobAUKTV.Text)<>0 then
      PrNDS :=4
     else
     begin
      Application.MessageBox(PChar('     18. '),'',MB_OK+MB_ICONERROR);
      dblcobAUKTV.SetFocus;
      exit;
     end;
     if Edit1.Text='' then
     begin
      Application.MessageBox(PChar('    . '),'',MB_OK+MB_ICONERROR);
      Edit1.SetFocus;
      Exit;
     end
     else
     FrmProvNDS.Edit1.Text:=Edit1.Text;

// end;

 //
 end;
 ModalResult := mrOk;
end;

procedure TfrmAddProvNDS.FormCreate(Sender: TObject);
begin
 Edit1.Text:=frmProvNDS.Edit1.Text;
 Contr := TMoveControl.Create(Self);

 aqrySchet.Open;

end;

procedure TfrmAddProvNDS.GetAUSQL(IDSchet:variant; dbcobAU: TDBLookupComboBox; var DatSet: TADOQuery);
var
   Priz: integer;
begin
 aqrySchet.Locate('idSchetSubSchet',IDSchet,[]);
 Priz := aqrySchet.FieldByName('SchetPriz').AsInteger;

 with DatSet do begin
  Close; SQL.Clear;
  case Priz of
    4,5: begin
          SQL.Add('SELECT *,');
          SQL.Add('  CASE IsNull(APS.kodAPrizSchet,'''') WHEN '''' THEN /*Convert(varchar,APS.TabN) + '', '' +*/ IsNull(SW.fio,''! !'')');
          SQL.Add('   ELSE RTrim(APS.nameAPrizSchet) + '', '' + IsNull(Convert(varchar,NDS),''! !'') END as label, ');
          SQL.Add('  CASE IsNull(APS.kodAPrizSchet,'''') WHEN '''' THEN RTRIM(APS.TabN) ELSE kodAPrizSchet END as kod ');

          SQL.Add('FROM tbSprAprizSchet APS');
          SQL.Add('     LEFT OUTER JOIN tbSprNDS NDS ON NDS.idNds = APS.idNDS');
          SQL.Add('     LEFT OUTER JOIN Spr_Works SW ON SW.TabN = APS.tabN');

          SQL.Add('WHERE APS.idSchetSubSchet = '+  VarToStr(IDSchet));

          SQL.Add('ORDER BY label');
         end;
    2,9: begin
          SQL.Add('SELECT APB.*, PR.namePredpr + '' - '' + RSchet as label, idPrizBank as kod');
          SQL.Add('FROM tbSprAPrizBank APB');
          SQl.Add('     INNER JOIN tbPredpr PR ON APB.idBank = PR.idPredpr');
          SQL.Add('WHERE idSchetSubSchet = '+  VarToStr(IDSchet));
          SQL.Add('ORDER BY label ');
         end;
   3,10: begin
          SQL.Add('SELECT APK.*, RTRIM(APK.TabN) + '', '' + SW.fio as label, APK.TabN as kod');
          SQL.Add('FROM tbSprAPrizKassa APK');
          SQL.Add('     INNER JOIN Spr_Works SW ON APK.TabN = SW.TabN');
          SQL.Add('WHERE idSchetSubSchet = '+  VarToStr(IDSchet));
          SQL.Add('ORDER BY label ');
         end;
   else begin  Exit; end;
  end;
  Open;
//  dbcobAU.KeyValue := FieldByName('kod').Value;
  if IsEmpty then Close;
 end;
end;

function TfrmAddProvNDS.CheckGrantProv(DT, KT: Variant): integer;
begin
 result := 2;
 with frmProvNDS.aqryWork do begin
  Close; SQl.Clear;
  SQL.Add('SELECT * FROM tbSprRazrProv WHERE idSchetSubSchetDT = '+VarToStr(DT)+' AND idSchetSubSchetKT = '+VarToStr(KT));
  Open;
   if IsEmpty then begin
     result := 0;
     Exit;
    end else
     if FieldByName('PrizBlok').AsVariant <> 0 then result := 1;
  Close;
 end;
end;

procedure TfrmAddProvNDS.FormDestroy(Sender: TObject);
begin
 Contr.Free;
end;

procedure TfrmAddProvNDS.FormKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
 if Key = VK_RETURN then begin
   Contr.NextControl;
 end;
end;

procedure TfrmAddProvNDS.edtDTVKeyPress(Sender: TObject; var Key: Char);
begin
 if (Key = #8) and (Length((Sender as TEdit).Text) = 3) then begin
  (Sender as TEdit).Text := Copy((Sender as TEdit).Text,1,1);
  (Sender as TEdit).SelStart := Length((Sender as TEdit).Text);
  Key := #0;
 end;

 if not (Key in ['0'..'9',#27,#8]) then Key := #0;
end;

procedure TfrmAddProvNDS.edtDTVChange(Sender: TObject);
begin
  if Length((Sender as TEdit).Text) = 2 then begin
   (Sender as TEdit).Text := (Sender as TEdit).Text + '.';
   (Sender as TEdit).SelStart := Length((Sender as TEdit).Text);
  end;
end;

procedure TfrmAddProvNDS.edtDTVExit(Sender: TObject);
var
   IDS: variant;
begin
  IDS := CheckSchet((Sender as TEdit).Text);
  if IDS = NULL then begin
   Application.MessageBox(' -  !',' ',MB_OK+MB_ICONERROR);
   (Sender as TEdit).Tag := -1;
   (Sender as TEdit).SetFocus;
  end else begin
   (Sender as TEdit).Tag := IDS;
   GetAUSQL(IDS, dblcobAUDTV, aqryAUDTV);
//     dblcobAUDTV.KeyValue := NULL;
//     NDSDt.Text:='';
 end;
end;

procedure TfrmAddProvNDS.edtKTVExit(Sender: TObject);
var
   IDS: variant;
begin
  IDS := CheckSchet((Sender as TEdit).Text);
  if IDS = NULL then begin
   Application.MessageBox(' -  !',' ',MB_OK+MB_ICONERROR);
   (Sender as TEdit).Tag := -1;
   (Sender as TEdit).SetFocus;
  end else begin
   (Sender as TEdit).Tag := IDS;
    GetAUSQL(IDS, dblcobAUKTV, aqryAUKTV);
//     dblcobAUKTV.KeyValue := NULL;
 //    NDSKt.Text:='';
 end;
end;

function TfrmAddProvNDS.CheckSchet(Schet: string): variant;
var
   KS, SS: string;
   P: integer;
begin
 P := Pos('.',Schet);
 if (P = 0) or
    (Schet = '') then begin
  result := NULL;
  Exit;
 end;

 KS := Copy(Schet,1,P-1);
 SS := Copy(Schet,P+1,Length(Schet)-3);

 if (KS = '') or (SS = '') then begin
  result := NULL;
  Exit;
 end;

 with frmProvNDS.aqryCheckExistSchet do begin
  Close;
  Parameters.ParamByName('ks').Value := KS;
  Parameters.ParamByName('ss').Value := SS;
  Open;
  if RecordCount = 0 then begin

    result := NULL;
   end else begin

    result := FieldByName('idSchetSubSchet').value;
  end;
  Close;
 end;
end;

function TfrmAddProvNDS.CheckBankSchet(Schet: string): variant;
var
   KS, SS: string;
   P: integer;
begin
 P := Pos('.',Schet);
 if (P = 0) or
    (Schet = '') then begin
  result := NULL;
  Exit;
 end;

 KS := Copy(Schet,1,P-1);
 SS := Copy(Schet,P+1,Length(Schet)-3);

 with frmProvNDS.aqryCheckBankSchet do begin
  Close;
  Parameters.ParamByName('ks').Value := KS;
  Parameters.ParamByName('ss').Value := SS;
  Open;
  if RecordCount = 0 then begin

    result := NULL;
   end else begin

    result := FieldByName('idSchetSubSchet').value;
  end;
  Close;
 end;
end;

procedure TfrmAddProvNDS.dblcobAUDTVKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
if Key=46 then
 begin
  (Sender as TDBLookupCombobox).KeyValue:=null;
  if Sender=dblcobAUDTV then
   NDSDt.Text:=''
   else
   NDSKt.Text:='';
 end;
end;

end.
