unit uDataModuleNDS;

interface

uses
  SysUtils, Classes, DB, ADODB, Forms, Messages, Dialogs, Variants;

type
  T_dmNDS = class(TDataModule)
    _db: TADOConnection;
    aqryWork: TADOQuery;
    aspGetOborotInfo: TADOStoredProc;
    aqryCheckExistSchet: TADOQuery;
    aqryCheckBankSchet: TADOQuery;
    procedure DataModuleCreate(Sender: TObject);
    procedure _dbAfterConnect(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    function CheckSchet(Schet: string): variant;
    function CheckBankSchet(Schet: string): variant;
  end;

var
  _dmNDS: T_dmNDS;

implementation

{$R *.dfm}

procedure T_dmNDS.DataModuleCreate(Sender: TObject);
var
   F: TextFile;
   S:string;
begin
 try
  _db.Connected := False;
  AssignFile(F, ExtractFilePath(Application.ExeName)+'\connect.ini');
  Reset(F);
  Read(F,S);
  CloseFile(F);
  _db.ConnectionString := S;
  _db.Open;
  if _db.Connected = false then begin Application.Terminate; Exit; end;
 except
  on E: Exception do begin
    MessageDlg('     : '+ E.Message +') !!!', mtError, [mbOk],0);
    Application.Terminate;
  end;
 end;
end;

procedure T_dmNDS._dbAfterConnect(Sender: TObject);
begin
 with _dmNDS.aqryWork do begin
  Close; SQL.Clear;
  SQL.Add('SET DATEFORMAT ''dmy''');
  ExecSQL;
 end;
end;

function T_dmNDS.CheckSchet(Schet: string): variant;
var
   KS, SS: string;
   P: integer;
begin
 P := Pos('.',Schet);
 if (P = 0) or
    (Schet = '') then begin
  result := NULL;
  Exit;
 end;

 KS := Copy(Schet,1,P-1);
 SS := Copy(Schet,P+1,Length(Schet)-3);

 if (KS = '') or (SS = '') then begin
  result := NULL;
  Exit;
 end;

 with aqryCheckExistSchet do begin
  Close;
  Parameters.ParamByName('ks').Value := KS;
  Parameters.ParamByName('ss').Value := SS;
  Open;
  if RecordCount = 0 then begin

    result := NULL;
   end else begin

    result := FieldByName('idSchetSubSchet').value;
  end;
  Close;
 end;
end;

function T_dmNDS.CheckBankSchet(Schet: string): variant;
var
   KS, SS: string;
   P: integer;
begin
 P := Pos('.',Schet);
 if (P = 0) or
    (Schet = '') then begin
  result := NULL;
  Exit;
 end;

 KS := Copy(Schet,1,P-1);
 SS := Copy(Schet,P+1,Length(Schet)-3);

 with aqryCheckBankSchet do begin
  Close;
  Parameters.ParamByName('ks').Value := KS;
  Parameters.ParamByName('ss').Value := SS;
  Open;
  if RecordCount = 0 then begin

    result := NULL;
   end else begin

    result := FieldByName('idSchetSubSchet').value;
  end;
  Close;
 end;
end;

end.
