unit uProvNDS;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, ActnList, DB, ADODB, ImgList, Grids, DBGrids,
  ExtCtrls, ComCtrls, ToolWin, StdCtrls, Mask, DBCtrls,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, EhLibVCL,
  GridsEh, DBAxisGridsEh, DBGridEh, System.Actions, System.UITypes;

type
  TfrmProvNDS = class(TForm)
    ToolBar1: TToolBar;
    ToolButton1: TToolButton;
    pnlInfo: TPanel;
    ImageList: TImageList;
    HotImageList: TImageList;
    pmProvNDS: TPopupMenu;
    dsProvNDS: TDataSource;
    aqryProvNDS: TADOQuery;
    ActionList: TActionList;
    aAddProvNds: TAction;
    aEditProvNDS: TAction;
    aDelProvNDS: TAction;
    aCloseProvNDS: TAction;
    aRefreshProvNDS: TAction;
    ToolButton2: TToolButton;
    ToolButton3: TToolButton;
    ToolButton4: TToolButton;
    ToolButton5: TToolButton;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N4: TMenuItem;
    N5: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    _db: TADOConnection;
    aqryWork: TADOQuery;
    aqryCheckExistSchet: TADOQuery;
    aqryCheckBankSchet: TADOQuery;
    Label1: TLabel;
    Edit1: TDBEdit;
    DBGridEh1: TDBGridEh;
    aqryProvNDSId1: TAutoIncField;
    aqryProvNDSIdDt: TIntegerField;
    aqryProvNDSIdKt: TIntegerField;
    aqryProvNDSAuDt: TStringField;
    aqryProvNDSAuKt: TStringField;
    aqryProvNDSPrNDS: TWordField;
    aqryProvNDSNumSpr: TStringField;
    aqryProvNDSIdNDSDt: TIntegerField;
    aqryProvNDSIdNDSKt: TIntegerField;
    aqryProvNDSlabelDTV: TStringField;
    aqryProvNDSlabelKTV: TStringField;
    aqryProvNDSlabelAUDTV: TStringField;
    aqryProvNDSlabelAUKTV: TStringField;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure aRefreshProvNDSExecute(Sender: TObject);
    procedure FormActivate(Sender: TObject);
    procedure aCloseProvNDSExecute(Sender: TObject);
    procedure dsProvNDSDataChange(Sender: TObject; Field: TField);
    procedure aDelProvNDSExecute(Sender: TObject);
    procedure aAddProvNdsExecute(Sender: TObject);
    procedure aEditProvNDSExecute(Sender: TObject);
    procedure sdbgProvNDSDblClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmProvNDS: TfrmProvNDS;
  PrNDS: byte;
  IdNDSDt, IdNDSKt: integer;

implementation

uses
  uAddProvNDS, Common;

{$R *.dfm}

procedure TfrmProvNDS.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action := caFree;
  frmProvNDS := nil;
end;

procedure TfrmProvNDS.aRefreshProvNDSExecute(Sender: TObject);
var
  OID: variant;
begin
  with aqryProvNDS do
  begin
    if IsEmpty then
      OID := -1
    else
      OID := FieldByName('id1').Value;

    Close;

    try
      Open;
    except
      on E: exception do
        Application.MessageBox(PChar('      : '
          + E.Message), '', MB_OK + MB_ICONERROR)
    end;

    if OID > 0 then
    begin
      Locate('id1', OID, []);
      Edit1.Text := FieldByName('NumSpr').AsString;
    end;
  end;
end;

procedure TfrmProvNDS.FormActivate(Sender: TObject);
begin
  aRefreshProvNDS.Execute;
end;

procedure TfrmProvNDS.aCloseProvNDSExecute(Sender: TObject);
begin
  Close;
end;

procedure TfrmProvNDS.dsProvNDSDataChange(Sender: TObject; Field: TField);
begin
  aDelProvNDS.Enabled := not aqryProvNDS.IsEmpty;
  aEditProvNDS.Enabled := not aqryProvNDS.IsEmpty;
end;

procedure TfrmProvNDS.aDelProvNDSExecute(Sender: TObject);
begin
  if Application.MessageBox('    ?',
    '', MB_YESNO + MB_ICONQUESTION + MB_DEFBUTTON2) <> ID_YES then
    Exit;

  with aqryWork do
  begin
    Close;
    SQL.Clear;
    SQL.Add('DELETE FROM buh.dbo.tbSFProvNDS');
    SQL.Add('WHERE id1 = ' + aqryProvNDS.FieldByName('id1').asString);
    try
      ExecSQL;
      aRefreshProvNDS.Execute;
    except
      on E: Exception do
        MessageDlg('   : ' + E.Message, mtError, [mbOk], 0);
    end;
  end;
end;

procedure TfrmProvNDS.aAddProvNdsExecute(Sender: TObject);
begin
  try
    frmAddProvNDS := TfrmAddProvNDS.Create(Self);
    frmAddProvNDS.Edit1.Text := Edit1.Text;
    if frmAddProvNDS.ShowModal() = mrOk then
    begin
      with aqryWork, frmAddProvNDS do
      begin
        Close;
        SQL.Clear;
        SQL.Add('INSERT INTO buh.dbo.tbSFProvNDS');
        SQL.Add('VALUES (');
        SQL.Add(VarToStr(edtDTV.Tag) + ',');
        SQL.Add(VarToStr(edtKTV.Tag) + ',');
        SQL.Add(VarToStrN1(dblcobAUDTV.KeyValue) + ',');
        SQL.Add(VarToStrN1(dblcobAUKTV.KeyValue) + ',');
        SQL.Add(VarToStr(PrNDS) + ',');
        SQL.Add(Edit1.Text + ',');
        if NDSDt.Text <> '' then
          SQL.Add(VarToStr(NDSDt.Text) + ',')
        else
          SQL.Add('null,');
        if NDSKt.Text <> '' then
          SQL.Add(VarToStr(NDSKt.Text) + ')')
        else
          SQL.Add('null)');

        ExecSQL;

        aRefreshProvNDS.Execute;

        Close;
        SQl.Clear;
        SQL.Add('SELECT MAX(id1) FROM buh.dbo.tbSFProvNDS');
        Open;
        aqryProvNDS.Locate('id1', Fields[0].Value, []);
        Close;
      end;
    end;
// finally
    frmAddProvNDS.Free();
  except
    on E: Exception do
    begin
      if Pos(AnsiUpperCase('Duplicate'), AnsiUpperCase(E.Message)) <> 0 then
        Application.MessageBox(PChar('  .'), '', MB_OK + MB_ICONError)
      else
        MessageDlg('  / . ' + E.Message, mtError, [mbOK], 0);
      Exit;
    end;
  end;
// end;
end;

procedure TfrmProvNDS.aEditProvNDSExecute(Sender: TObject);
begin
  try
    frmAddProvNDS := TfrmAddProvNDS.Create(Self);
    frmAddProvNDS.Edit1.Text := Edit1.Text;

    with frmAddProvNDS, aqryProvNDS do
    begin

      if FieldByName('idDT').IsNull then
        edtDTV.Tag := -1
      else
        edtDTV.Tag := FieldByName('idDT').AsInteger;
      edtDTV.Text := FieldByName('labelDTV').AsString;
      if FieldByName('idKT').IsNull then
        edtKTV.Tag := -1
      else
        edtKTV.Tag := FieldByName('idKT').AsInteger;
      edtKTV.Text := FieldByName('labelKTV').AsString;

      edtDTV.OnExit(edtDTV);
      edtKTV.OnExit(edtKTV);

      dblcobAUDTV.KeyValue := TRIM(FieldByName('AUDT').AsString);
      dblcobAUKTV.KeyValue := TRIM(FieldByName('AUKT').AsString);
    end;

    if frmAddProvNDS.ShowModal() = mrOk then
    begin
      with aqryWork, frmAddProvNDS do
      begin
        Close;
        SQL.Clear;
        SQL.Add('UPDATE buh.dbo.tbSFProvNDS');
        SQL.Add('SET ');

        SQL.Add('idDT = ');
        if edtDTV.Tag = -1 then
          SQL.Add('NULL,')
        else
          SQL.Add(VarToStr(edtDTV.Tag) + ',');
        SQL.Add('idKT = ');
        if edtKTV.Tag = -1 then
          SQL.Add('NULL,')
        else
          SQL.Add(VarToStr(edtKTV.Tag) + ',');
        SQL.Add('AUDT = ' + VarToStrN1(dblcobAUDTV.KeyValue) + ',');
        SQL.Add('AUKT = ' + VarToStrN1(dblcobAUKTV.KeyValue) + ',');
        SQL.Add('PrNDS = ' + VarToStr(PrNDS) + ',');
        if NDSDt.Text <> '' then
          SQL.Add('IdNDSDt = ' + NDSDt.Text + ',')
        else
          SQL.Add('IdNDSDt=null,');
        if NDSKt.Text <> '' then
          SQL.Add('IdNDSKt = ' + NDSKt.Text + ',')
        else
          SQL.Add('IdNDSKt=null,');
        SQL.Add('NumSPr = ' + Edit1.Text);
        SQL.Add(' WHERE id1 = ' + aqryProvNDS.FieldByName('id1').asString);

        ExecSQL;

        aRefreshProvNDS.Execute;
      end;
    end;
  finally
    frmAddProvNDS.Free();
  end;
end;

procedure TfrmProvNDS.sdbgProvNDSDblClick(Sender: TObject);
begin
  aEditProvNDS.Execute;
end;

procedure TfrmProvNDS.FormCreate(Sender: TObject);
var
  F: TextFile;
  S: string;
begin
  try
    _db.Connected := False;
    AssignFile(F, ExtractFilePath(Application.ExeName) + '\MDBConnect.ini');
    Reset(F);
    Read(F, S);
    CloseFile(F);
    _db.ConnectionString := S;
    _db.Open;
    if _db.Connected = false then
    begin
      Application.Terminate;
      Exit;
    end;
    aqryProvNDS.Close;
    aqryProvNDS.Open;
  except
    on E: Exception do
    begin
      MessageDlg('     : ' + E.Message + ') !!!', mtError, [mbOk], 0);
      Application.Terminate;
    end;
  end;
end;

end.

