unit uSearch;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, StdCtrls, Buttons, ComCtrls, ExtCtrls, DBCtrls, DBLookupEh;

type
  TfrmSearch = class(TForm)
    SearchEdit: TEdit;
    SearchStatusBar: TStatusBar;
    SearchQuery: TADOQuery;
    DBNavigator1: TDBNavigator;
    SearchDataSource: TDataSource;
    SearchRG: TRadioGroup;
    SearchBtn: TButton;
    procedure SearchBtnClick(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
    procedure SearchRGClick(Sender: TObject);
  private
    { Private declarations }
    LookupCB: TDBLookupComboboxEh;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; LookupCB: TDBLookupComboboxEh); reintroduce; overload;
  end;

var
  frmSearch: TfrmSearch;

implementation

uses uDM;

{$R *.dfm}

constructor TfrmSearch.Create(AOwner: TComponent; LookupCB: TDBLookupComboboxEh);
begin
  inherited Create(AOwner);

  Self.LookupCB := LookupCB;
end;

procedure TfrmSearch.SearchBtnClick(Sender: TObject);
begin
  with SearchQuery do
  begin
    Close;

    case SearchRG.ItemIndex of
      0:
        SQL[SQL.Count - 2] := 'AND namePredpr LIKE ' + QuotedStr('%' + SearchEdit.Text + '%');
      1:
        SQL[SQL.Count - 2] := 'AND UNN LIKE ' + QuotedStr('%' + SearchEdit.Text + '%');
    end;

    Open;
    First;
  end;

  SearchStatusBar.SimpleText := SearchQuery.FieldByName('namePredpr').AsString;
  LookupCB.KeyValue := SearchQuery.FieldByName('idPredpr').Value;
end;

procedure TfrmSearch.SearchRGClick(Sender: TObject);
begin
  SearchEdit.SetFocus;
end;

procedure TfrmSearch.DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
begin
  SearchStatusBar.SimpleText := SearchQuery.FieldByName('namePredpr').AsString;
  LookupCB.KeyValue := SearchQuery.FieldByName('idPredpr').Value;
end;

end.

