unit uUpdStat;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, DBCtrls, ComCtrls, DB, ADODB, System.DateUtils,
  Vcl.ExtCtrls, DBGridEh, Vcl.Mask, DBCtrlsEh, DBLookupEh;

type
  TfrmUpdStat = class(TForm)
    Label7: TLabel;
    dsNPredpr: TDataSource;
    qNPredpr: TADOQuery;
    Label3: TLabel;
    FirstPicker: TDateTimePicker;
    Label4: TLabel;
    SecPicker: TDateTimePicker;
    FindBtn: TSpeedButton;
    ProgressBar1: TProgressBar;
    LogMemo: TMemo;
    TopPanel: TPanel;
    PredprDBLCBEh: TDBLookupComboboxEh;
    Bevel1: TBevel;
    AllRB: TRadioButton;
    NotFinalRB: TRadioButton;
    StartUpdateBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FindBtnClick(Sender: TObject);
    procedure StartUpdateBtnClick(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  frmUpdStat: TfrmUpdStat;

implementation

uses
  uSearch, StatusUpdater, uDM;

{$R *.dfm}

procedure TfrmUpdStat.FormCreate(Sender: TObject);
begin
  FirstPicker.Date := StrToDate('01.' + IntToStr(monthOf(now())) + '.' + IntToStr(YearOf(now())));
  SecPicker.Date := now();

  qNPredpr.Close;
  qNPredpr.Open;
end;

procedure TfrmUpdStat.StartUpdateBtnClick(Sender: TObject);
var
  ThreadStatus: TThreadStatus;
begin
  LogMemo.Clear;

  with DM.qInvoices do
  begin
    Close;
    Parameters.ParamByName('FirstDate').Value := DateToStr(FirstPicker.DateTime);
    Parameters.ParamByName('SecDate').Value := DateToStr(SecPicker.DateTime);
    Parameters.ParamByName('IdSender').Value := PredprDBLCBEh.KeyValue;

    if AllRB.Checked then
      SQL[SQL.Count - 1] := 'AND (ISNULL(h.invStatus,0) not in (6,7))';

    if NotFinalRB.Checked then
      SQL[SQL.Count - 1] := 'AND (ISNULL(h.invStatus,0) not in (5,6,7))';

    Open;
  end;

  //  
  ThreadStatus := TThreadStatus.Create(true, DM.qInvoices, ProgressBar1, TopPanel, LogMemo);
  ThreadStatus.FreeOnTerminate := true;
  ThreadStatus.Priority := tpNormal;
  ThreadStatus.Start;
end;

procedure TfrmUpdStat.FindBtnClick(Sender: TObject);
begin
  frmSearch := TfrmSearch.Create(Self, PredprDBLCBEh);
  frmSearch.ShowModal;
  frmSearch.Free;
end;

end.

