unit StatusUpdater;

interface

uses
  Forms, SysUtils, ComObj, Dialogs, Classes, ComCtrls, StdCtrls, Buttons,
  IniFiles, System.UITypes, System.AnsiStrings, Winapi.ActiveX;

type
  EAuthException = class(Exception);

  EConnectException = class(Exception);

type
  TThreadStatus = class(TThread)
  private
    Progress, Count, Error: integer;
    recv_path, recv2_path, ErrorMessageText: string;
    EVatService, InvVatStatus: OleVariant;
    Data: TStringList;
    ProgressBar: TProgressBar;
    StartBtn: TButton;
    ClearTrashBtn: TButton;
    procedure SetProgress;
    procedure MessageSend;
    procedure ErrorMessage;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; recv, recv2: string; Data:
      TStringList; Progress: TProgressBar; StartBtn, ClearTrashBtn: TButton); overload;
  end;

implementation

constructor TThreadStatus.Create(CreateSuspended: Boolean; recv, recv2: string;
  Data: TStringList; Progress: TProgressBar; StartBtn, ClearTrashBtn: TButton);
begin
  inherited Create(CreateSuspended);
  Self.recv_path := recv;
  Self.recv2_path := recv2;
  Self.Data := Data;
  Self.ProgressBar := Progress;
  Self.StartBtn := StartBtn;
  Self.ClearTrashBtn := ClearTrashBtn;
end;

function GetStatusId(Status: string): Integer; //   
begin
  Result := IndexStr(Status, ['IN_PROGRESS', 'IN_PROGRESS_ERROR', 'COMPLETED',
    'ON_AGREEMENT', 'COMPLETED_SIGNED', 'CANCELLED', 'ON_AGREEMENT_CANCEL', 'NOT_FOUND', 'ERROR']) + 1;
end;

procedure TThreadStatus.SetProgress;
begin
  ProgressBar.Position := Progress;
end;

procedure TThreadStatus.ErrorMessage;
begin
  MessageDlg(ErrorMessageText, mtError, [mbOK], 0);
end;

procedure TThreadStatus.MessageSend;
begin
  MessageDlg('  .  : ' + IntToStr(Count) +
    '. : ' + IntToStr(Error) + '.', mtInformation, [mbOK], 0);
end;

procedure TThreadStatus.Execute; //     EInvVatService
var
  res, err, i: Integer;
  ip, socket, InvName_no_pref, InvName_no_post: string;
  Ini: Tinifile;
begin
  err := 0;
  Self.Count := 0;
  Self.StartBtn.Enabled := False;
  Self.ClearTrashBtn.Enabled := False;

  Ini := TiniFile.Create(extractfilepath(paramstr(0)) + 'Gear.ini');
  ip := Ini.ReadString('Proxy', 'Ip', '');
  socket := Ini.ReadString('Proxy', 'Socket', '');
  Ini.Free;
  CoInitialize(nil);

  try
    EVatService := CreateOleObject('EInvVatService.Connector');

    if EVatService.Login['', 0] <> 0 then
      raise EAuthException.Create('    .');

    if (Length(ip) > 0) and (Length(socket) > 0) then
      EVatService.SetProxy[ip, socket, '', '', '1'];

    //https://185.32.226.170/eInvoiceTest
    if EVatService.Connect['https://ws.vat.gov.by/InvoicesWS/services/InvoicesPort'] <> 0 then
      raise EConnectException.Create('    .');

    for i := 0 to Self.Data.Count - 1 do
    begin
      Progress := 100 * (i + 1) div Self.Data.Count;
      Synchronize(Setprogress);

      InvName_no_pref := Copy(Self.Data[i], Pos('-', Self.Data[i]) + 1, Length(Self.Data
        [i]) - Pos('-', Self.Data[i]) + 1);
      InvName_no_post := Copy(InvName_no_pref, 1, pos('.', InvName_no_pref) - 1);

      InvVatStatus := EVatService.GetStatus[InvName_no_post];
      try
        res := InvVatStatus.Verify;

        if res <> 0 then
        begin
          ErrorMessageText := EVatService.LastError;
          Synchronize(ErrorMessage);
          Break;
        end
        else if GetStatusId(InvVatStatus.status) in [5, 6, 7] then  //   
        begin
          DeleteFile(Self.recv_path + Self.Data[i]);
          if FileExists(Self.recv2_path + 'invoicetrue-' + InvName_no_post + '.xml') then
            DeleteFile(Self.recv2_path + 'invoicetrue-' + InvName_no_post + '.xml');
          Inc(Self.Count);
        end;
      except
        on EAccessViolation do
          Inc(err);
      end;
    end;

    Error := err;
    Synchronize(MessageSend);
  except
    on e: Exception do
    begin
      ErrorMessageText := e.Message;
      Synchronize(ErrorMessage);
    end;
  end;

  Self.Data.Free;
  Self.StartBtn.Enabled := True;
  Self.ClearTrashBtn.Enabled := True;
  CoUninitialize;
end;

end.

