unit uMainMove;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Vcl.ImgList, System.UITypes;

type
  TfrmMain = class(TForm)
    MainPB: TProgressBar;
    StartBtn: TButton;
    ClearTrashBtn: TButton;
    ImageList_24: TImageList;
    procedure StartBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure ClearTrashBtnClick(Sender: TObject);
  private
    { Private declarations }
    recv_path, recv2_path, recv3_path, recv3_old_path: string;

    procedure FindFileInFolder(path, ext: string; FileList: TStringList);
    procedure ReplaceFile(inp, outp, filename, ext: string);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

uses StatusUpdater;

{$R *.dfm}

procedure TfrmMain.FindFileInFolder(path, ext: string; FileList: TStringList);
Var SR : TSearchRec;
    Res : Integer;
begin
  Res := FindFirst(path+ext, faAnyFile, SR);

  while Res = 0 do
  begin
    FileList.Add(Sr.Name);
    Res := FindNext(SR);
  end;

  FindClose(SR);
end;

procedure TfrmMain.ReplaceFile(inp, outp, filename, ext: string);
var pathin, pathout: string;
begin
  pathin:=inp+filename+ext;
  pathout:=outp+filename+ext;
  CopyFile(pchar(pathin), pchar(pathout), false);
  DeleteFile(pathin);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var F: TextFile;
    xml_path: string;
begin
  if not FileExists('Path.ini') then
  begin
    MessageDlg(' Path.ini  ', mtError, [mbOK], 0);
    Application.Terminate;
    Exit;
  end;

  AssignFile(F, ExtractFilePath(Application.ExeName)+'Path.ini');
  Reset(F);
  Readln(F, Self.recv3_path);
  Readln(F, Self.recv3_old_path);
  CloseFile(F);

  xml_path := Copy(Self.recv3_path, 1, LastDelimiter('\', Copy(Self.recv3_path, 1, Length(Self.recv3_path)-1)));
  Self.recv_path := xml_path+'recv\';
  Self.recv2_path := xml_path+'recv2\';
end;

procedure TfrmMain.ClearTrashBtnClick(Sender: TObject);
var ThreadStatus: TThreadStatus;
    FileList: TStringList;
begin
  if (not DirectoryExists(Self.recv_path)) or (not DirectoryExists(Self.recv2_path)) then
  begin
    MessageDlg('    .', mtError, [mbOK], 0);
    Exit;
  end;

  FileList := TStringList.Create;
  FindFileInFolder(Self.recv_path, '*.xml', FileList);

  if FileList.Count=0 then
  begin
    MessageDlg('   ', mtWarning, [mbOK], 0);
    FileList.Free;
    Exit;
  end;

  //  
  ThreadStatus:= TThreadStatus.Create(true, Self.recv_path, Self.recv2_path,
                                      FileList, MainPB, StartBtn,
                                      ClearTrashBtn);
  ThreadStatus.FreeOnTerminate:=true;
  ThreadStatus.Priority:=tpNormal;
  ThreadStatus.Start;
end;

procedure TfrmMain.StartBtnClick(Sender: TObject);
var i: Integer;
    str: string;
    FileList: TStringList;
begin
  if (not DirectoryExists(Self.recv3_path)) or (not DirectoryExists(Self.recv3_old_path)) then
  begin
    MessageDlg('    .', mtError, [mbOK], 0);
    Application.Terminate;
    Exit;
  end;

  FileList := TStringList.Create;

  try
    FindFileInFolder(Self.recv3_path, '*.ticket.xml', FileList);

    if FileList.Count>0 then
    begin
      for i:=0 to FileList.Count-1 do
      begin
        str:=Copy(FileList[i], 1, pos('.', FileList[i])-1);
        ReplaceFile(Self.recv3_path, Self.recv3_old_path, str, '.sgn.xml');
        ReplaceFile(Self.recv3_path, Self.recv3_old_path, str, '.sgn2.xml');
        ReplaceFile(Self.recv3_path, Self.recv3_old_path, str, '.ticket.text.xml');
        ReplaceFile(Self.recv3_path, Self.recv3_old_path, str, '.ticket.xml');

        MainPB.Position:=100*(i+1) div FileList.Count;
      end;

      MessageDlg(' ', mtInformation, [mbOK], 0);
    end
    else MessageDlg('   ', mtWarning, [mbOK], 0);
  finally
    FileList.Free;
  end;
end;

end.
