unit uAddUpdZeroExclude;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.ExtCtrls, Vcl.StdCtrls, System.UITypes;

type
  TfrmAddUpdZeroExclude = class(TForm)
    TopPanel: TPanel;
    BottomPanel: TPanel;
    FilialEdit: TLabeledEdit;
    InvoiceEdit: TLabeledEdit;
    SaveBtn: TButton;
    CancelBtn: TButton;
    procedure SaveBtnClick(Sender: TObject);
  private
    { Private declarations }
    idRecord: Integer;
    Update: Boolean;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); overload; override;
    constructor Create(AOwner: TComponent; idRecord: Integer; filial: SmallInt;
      invoice: string); reintroduce; overload;
  end;

var
  frmAddUpdZeroExclude: TfrmAddUpdZeroExclude;

implementation

uses
  uCompDM;

{$R *.dfm}

constructor TfrmAddUpdZeroExclude.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  Self.Caption := ' ';
  Self.Update := False;
end;

constructor TfrmAddUpdZeroExclude.Create(AOwner: TComponent; idRecord: Integer;
  filial: SmallInt; invoice: string);
begin
  inherited Create(AOwner);

  Self.Caption := ' ';
  Self.Update := True;
  Self.idRecord := idRecord;

  FilialEdit.Text := IntToStr(filial);
  InvoiceEdit.Text := invoice;
end;

procedure TfrmAddUpdZeroExclude.SaveBtnClick(Sender: TObject);
begin
  if Length(Trim(FilialEdit.Text)) = 0 then
  begin
    MessageDlg('  ', mtWarning, [mbOK], 0);
    Exit;
  end;

  if Length(Trim(InvoiceEdit.Text)) <> 25 then
  begin
    MessageDlg('   ', mtWarning, [mbOK], 0);
    Exit;
  end;

  with CompDM do
  try
    if not Self.Update then
      InsertZeroExclude(StrToInt(Trim(FilialEdit.Text)), Trim(InvoiceEdit.Text))
    else
      UpdateZeroExclude(Self.idRecord, StrToInt(Trim(FilialEdit.Text)), Trim(InvoiceEdit.Text));

    ModalResult := mrOk;
  except
    on EDB: EDBOperationException do
      MessageDlg(EDB.Message, mtError, [mbOK], 0);
    on E: Exception do
      MessageDlg('   : ' + E.Message, mtError, [mbOK], 0);
  end;
end;

end.

