unit uCompareMain;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, DBGridEh,
  Vcl.StdCtrls, Vcl.Mask, DBCtrlsEh, DBLookupEh, EhLibVCL, GridsEh,
  DBAxisGridsEh, Vcl.ComCtrls, System.Win.ComObj, System.UITypes, Vcl.ExtCtrls,
  PrnDbgeh, Vcl.Menus, MemTableEh, MemTableDataEh, Data.DB, DBGridEhImpExp,
  System.IniFiles;

type
  TfrmComparer = class(TForm)
    FirstDTP: TDateTimePicker;
    SecondDTP: TDateTimePicker;
    FirstDTPLbl: TLabel;
    SecondDTPLbl: TLabel;
    InvDBGridEh: TDBGridEh;
    PredprDBLCBEh: TDBLookupComboboxEh;
    SearchBtn: TButton;
    LoadExcelFileBtn: TButton;
    XLSOpenDialog: TOpenDialog;
    MainProgressBar: TProgressBar;
    MainStatusBar: TStatusBar;
    UpdateBtn: TButton;
    MainPageControl: TPageControl;
    InvTabSheet: TTabSheet;
    DuplicatesFilialTabSheet: TTabSheet;
    TopPanel: TPanel;
    DuplicatesFilialDBGridEh: TDBGridEh;
    PredprLbl: TLabel;
    SubInvDBGridEh: TDBGridEh;
    PrintDBGridEh: TPrintDBGridEh;
    DuplicatesOblpoTabSheet: TTabSheet;
    DuplicatesOblpoDBGridEh: TDBGridEh;
    SubDuplicatesOblpoDBGridEh: TDBGridEh;
    InstrumentsPanel: TPanel;
    ShowFiltersBtn: TButton;
    FiltersPanel: TPanel;
    FilialRG: TRadioGroup;
    FilterBtn: TButton;
    ClearFilterBtn: TButton;
    XLSSaveDialog: TSaveDialog;
    StatePM: TPopupMenu;
    SetHidePMBtn: TMenuItem;
    ShowAllStatePMBtn: TMenuItem;
    ShowNotHideStatePMBtn: TMenuItem;
    SetNotHidePMBtn: TMenuItem;
    MainMenu: TMainMenu;
    StateMMBtn: TMenuItem;
    ExportMMBtn: TMenuItem;
    ExportExcelMMBtn: TMenuItem;
    ExportPrintMMBtn: TMenuItem;
    SaveStateMMBtn: TMenuItem;
    LoadStateMMBtn: TMenuItem;
    SettingsMMBtn: TMenuItem;
    FilterSettingsMMBtn: TMenuItem;
    ShowMatchesCB: TCheckBox;
    ExportCSVMMBtn: TMenuItem;
    CSVSaveDialog: TSaveDialog;
    InfoSheet: TTabSheet;
    InvoicesDuplDBGridEh: TDBGridEh;
    InvoicesDuplGB: TGroupBox;
    ZeroExcludeMMBtn: TMenuItem;
    SelfProvCB: TCheckBox;
    procedure FormCreate(Sender: TObject);
    procedure SearchBtnClick(Sender: TObject);
    procedure LoadExcelFileBtnClick(Sender: TObject);
    procedure UpdateBtnClick(Sender: TObject);
    procedure InvDBGridEhRowDetailPanelShow(Sender: TCustomDBGridEh; var CanShow: Boolean);
    procedure InvDBGridEhCheckRowHaveDetailPanel(Sender: TCustomDBGridEh; var RowHaveDetailPanel: Boolean);
    procedure PrintDBGridEhAfterPrint(Sender: TObject);
    procedure DuplicatesOblpoDBGridEhRowDetailPanelShow(Sender: TCustomDBGridEh; var CanShow: Boolean);
    procedure MainPageControlChange(Sender: TObject);
    procedure InvDBGridEhSortMarkingChanged(Sender: TObject);
    procedure ShowFiltersBtnClick(Sender: TObject);
    procedure ClearFilterBtnClick(Sender: TObject);
    procedure FilterBtnClick(Sender: TObject);
    procedure StatePMPopup(Sender: TObject);
    procedure SetHidePMBtnClick(Sender: TObject);
    procedure ShowAllStatePMBtnClick(Sender: TObject);
    procedure ShowNotHideStatePMBtnClick(Sender: TObject);
    procedure SetNotHidePMBtnClick(Sender: TObject);
    procedure SaveStateMMBtnClick(Sender: TObject);
    procedure LoadStateMMBtnClick(Sender: TObject);
    procedure ExportExcelMMBtnClick(Sender: TObject);
    procedure ExportPrintMMBtnClick(Sender: TObject);
    procedure FilterSettingsMMBtnClick(Sender: TObject);
    procedure ExportCSVMMBtnClick(Sender: TObject);
    procedure ZeroExcludeMMBtnClick(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
  private    { Private declarations }
    procedure MultiSorting(DBGridEh: TDBGridEh);
    procedure PrintGrid(DBGridEh: TDBGridEh; title: string);
    procedure SetFilter(DBGridEh: TDBGridEh; _Filter: string);
    procedure ChangeHide(Value: Boolean);
  public    { Public declarations }
  end;

var
  frmComparer: TfrmComparer;


implementation

uses
  uCompDM, uSearch, uLoadExcelThread, uCompareDataThread, uSaveComeralState,
  uLoadComeralState, uFilterSettings, uZeroExcludeSettings;

{$R *.dfm}

procedure TfrmComparer.MultiSorting(DBGridEh: TDBGridEh);
var
  i: Integer;
  s: WideString;
begin
  //    
  with DBGridEh.SortMarkedColumns do
  begin
    if Count = 0 then
      Exit;

    s := DBGridEh.Columns[Items[0].Index].FieldName;

    if Items[0].Title.SortMarker = smUpEh then
      s := s + ' ASC'
    else
      s := s + ' DESC';

    for i := 1 to Count - 1 do
    try
      s := s + ', ' + DBGridEh.Columns[Items[i].Index].FieldName;

      if Items[i].Title.SortMarker = smUpEh then
        s := s + ' ASC'
      else
        s := s + ' DESC';
    except
    end;
  end;

  s := StringReplace(s, 'StatusText', '[Status]', [rfReplaceAll]);
  CompDM.CompareMemTableEh.SortByFields(s);
end;

procedure TfrmComparer.PrintGrid(DBGridEh: TDBGridEh; title: string);
begin
  PrintDBGridEh.DBGridEh := DBGridEh;
  PrintDBGridEh.Title.Clear;
  PrintDBGridEh.Title.Text := title;
  PrintDBGridEh.Preview;
end;

procedure TfrmComparer.SetFilter(DBGridEh: TDBGridEh; _Filter: string);
begin
  with DBGridEh.DataSource.DataSet do
  begin
    Filtered := False;
    Filter := _Filter;
    Filtered := True;
  end;
end;

procedure TfrmComparer.ChangeHide(Value: Boolean);

  procedure SetHideState(value: Boolean);
  begin
    with CompDM.TmpComeralInvMemTableEh do
    begin
      Edit;
      FieldByName('hide').AsBoolean := value;
      Post;
    end;
  end;

var
  i: Integer;
begin
  with CompDM.TmpComeralInvMemTableEh do
  begin
    DisableControls;

    if InvDBGridEh.SelectedRows.Count = 0 then
      SetHideState(Value)
    else
    begin
      for i := 0 to InvDBGridEh.SelectedRows.Count - 1 do
      begin
        GotoBookmark(pointer(InvDBGridEh.SelectedRows[i]));
        SetHideState(Value);
      end
    end;

    InvDBGridEh.SelectedRows.Clear;
    EnableControls;
  end;
end;

procedure TfrmComparer.SetHidePMBtnClick(Sender: TObject);
begin
  ChangeHide(True);
end;

procedure TfrmComparer.SetNotHidePMBtnClick(Sender: TObject);
begin
  ChangeHide(False);
end;

procedure TfrmComparer.ClearFilterBtnClick(Sender: TObject);
begin
  FilialRG.ItemIndex := -1;

  if (InvDBGridEh.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
    if ShowNotHideStatePMBtn.Checked then
      SetFilter(InvDBGridEh, 'hide=0')
    else
      InvDBGridEh.DataSource.DataSet.Filtered := False
  else
    InvDBGridEh.DataSource.DataSet.Filtered := False;

  DuplicatesFilialDBGridEh.DataSource.DataSet.Filtered := False;
  DuplicatesOblpoDBGridEh.DataSource.DataSet.Filtered := False;
end;

procedure TfrmComparer.ExportCSVMMBtnClick(Sender: TObject);
var
  CurrentGrid: TDBGridEh;
begin
  CSVSaveDialog.FileName := '  ' + DateToStr(FirstDTP.Date) +
    ' - ' + DateToStr(SecondDTP.Date);

  if CSVSaveDialog.Execute then
  begin
    case MainPageControl.ActivePageIndex of
      0:
        begin
          CurrentGrid := InvDBGridEh;
          CurrentGrid.Columns[0].Visible := True;

          if (CurrentGrid.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
            CurrentGrid.Columns[16].Visible := False;
        end;
      1:
        CurrentGrid := DuplicatesFilialDBGridEh;
      2:
        CurrentGrid := DuplicatesOblpoDBGridEh;
    else
      begin
        MessageDlg('     .', mtWarning, [mbOK], 0);
        Exit;
      end;
    end;

    CurrentGrid.Columns[0].Visible := True;

    if not CurrentGrid.DataSource.DataSet.IsEmpty then
      SaveDBGridEhToExportFile(TDBGridEhExportAsCSV, CurrentGrid, CSVSaveDialog.FileName, true);

    if MainPageControl.ActivePageIndex = 0 then
    begin
      CurrentGrid.Columns[0].Visible := False;

      if (CurrentGrid.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
        CurrentGrid.Columns[16].Visible := True;
    end;

    MessageDlg('  CSV .', mtInformation, [mbOk], 0);
  end;
end;

procedure TfrmComparer.DuplicatesOblpoDBGridEhRowDetailPanelShow(Sender:
  TCustomDBGridEh; var CanShow: Boolean);
begin
  with CompDM do
    SelectSprProv(SelectSprProvQ, SelectSvodDuplesOblpodocnumber.AsString,
      SelectSvodDuplesOblponumdocpart.AsString, SelectSvodDuplesOblponumbuhspr.AsString,
      SelectSvodDuplesOblpoidPredpr.AsString,
      SelectSvodDuplesOblpoinvoicefullname.AsString, SelectSvodDuplesOblpodocdate.AsDateTime,
      SelectSvodDuplesOblpofilial.AsInteger);
end;

procedure TfrmComparer.ExportExcelMMBtnClick(Sender: TObject);
var
  CurrentGrid: TDBGridEh;
begin
  XlsSaveDialog.FileName := '  ' + DateToStr(FirstDTP.Date) +
    ' - ' + DateToStr(SecondDTP.Date);

  if XlsSaveDialog.Execute then
  begin
    case MainPageControl.ActivePageIndex of
      0:
        begin
          CurrentGrid := InvDBGridEh;
          CurrentGrid.Columns[0].Visible := True;

          if (CurrentGrid.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
            CurrentGrid.Columns[16].Visible := False;
        end;
      1:
        CurrentGrid := DuplicatesFilialDBGridEh;
      2:
        CurrentGrid := DuplicatesOblpoDBGridEh;
    else
      begin
        MessageDlg('     .', mtWarning, [mbOK], 0);
        Exit;
      end;
    end;

    CurrentGrid.Columns[0].Visible := True;

    if not CurrentGrid.DataSource.DataSet.IsEmpty then
//      ExportDBGridEhToXlsx(CurrentGrid, XlsSaveDialog.FileName, [], True);
      SaveDBGridEhToExportFile(TDBGridEhExportAsXls, CurrentGrid, XlsSaveDialog.FileName, true);

    if MainPageControl.ActivePageIndex = 0 then
    begin
      CurrentGrid.Columns[0].Visible := False;

      if (CurrentGrid.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
        CurrentGrid.Columns[16].Visible := True;
    end;

    MessageDlg('  Excel .', mtInformation, [mbOk], 0);
  end;
end;

procedure TfrmComparer.ExportPrintMMBtnClick(Sender: TObject);
var
  period: string;
begin
  //    
  period := '   ' + DateToStr(FirstDTP.Date) + '  ' + DateToStr(SecondDTP.Date);

  case MainPageControl.ActivePageIndex of
    0:
      begin
        InvDBGridEh.DataGrouping.GroupLevels[0].ExpandNodes;
        PrintGrid(InvDBGridEh, '   ' + period);
      end;
    1:
      begin
        PrintGrid(DuplicatesFilialDBGridEh, '    ' + period);
      end;
    2:
      begin
        PrintGrid(DuplicatesOblpoDBGridEh, '    ' + period);
      end;
  end;
end;

procedure TfrmComparer.FilterBtnClick(Sender: TObject);
var
  invFilterStr, signers: string;
  filterFilials, filterMatches: Boolean;
begin
  if not ShowMatchesCB.Checked then
  begin
    invFilterStr :=      //'(((ndsinvoice IS NULL) OR (ndsexcel IS NULL) OR (ndsspr IS NULL)) OR ((ndsspr IS NOT NULL) AND (ndsexcel IS NOT NULL) AND (ndsspr<>ndsexcel)))';
      '(((ndsexcel IS NULL) OR (ndsspr IS NULL)) OR ((ndsspr IS NOT NULL) AND (ndsexcel IS NOT NULL) AND (ndsspr<>ndsexcel)))';
    filterMatches := True;
  end
  else
    filterMatches := False;

  if FilialRG.ItemIndex < 0 then
  begin
    if (InvDBGridEh.DataSource.Name = 'TmpComeralInvMemTableEhDS') then
      if ShowNotHideStatePMBtn.Checked then
      begin
        if not filterMatches then
          SetFilter(InvDBGridEh, 'hide=0')
        else
          invFilterStr := invFilterStr + ' AND (hide=0)';
      end
      else
        InvDBGridEh.DataSource.DataSet.Filtered := False;

    filterFilials := False;
  end
  else
  begin
    signers := CompDM.GetSignersByFilial(FilialRG.Items[FilialRG.ItemIndex]);

    if Length(signers) > 0 then
      invFilterStr := '(filial=' + FilialRG.Items[FilialRG.ItemIndex] +
        ' OR (filial is NULL AND signerfio in (' + signers + '))' + ' OR (filial is NULL AND signerfio IS NULL))'
    else
      invFilterStr := 'filial=' + FilialRG.Items[FilialRG.ItemIndex] + ' OR filial is NULL';

    if (InvDBGridEh.DataSource.Name = 'TmpComeralInvMemTableEhDS') and (ShowNotHideStatePMBtn.Checked) then
      invFilterStr := invFilterStr + ' AND hide=0';

    filterFilials := True;
  end;

  if filterFilials or filterMatches then
    SetFilter(InvDBGridEh, invFilterStr);

  if filterFilials then
  begin
    SetFilter(DuplicatesFilialDBGridEh, 'dopUNN=' + FilialRG.Items[FilialRG.ItemIndex]);
    SetFilter(DuplicatesOblpoDBGridEh, 'Filial=' + FilialRG.Items[FilialRG.ItemIndex]);
  end;
end;

procedure TfrmComparer.FilterSettingsMMBtnClick(Sender: TObject);
begin
  frmFilterSettings := TfrmFilterSettings.Create(Self);
  frmFilterSettings.ShowModal;
  frmFilterSettings.Free;
end;

procedure TfrmComparer.FormClose(Sender: TObject; var Action: TCloseAction);
var
  iniPath: string;
  iniFile: TIniFile;
begin
  iniPath := ExtractFilePath(ParamStr(0)) + 'Config.ini';

  if not FileExists(iniPath) then
    Exit;

  iniFile := TIniFile.Create(iniPath);

  try
    iniFile.WriteString('Settings', 'SelfProv', BoolToStr(SelfProvCB.Checked));
  finally
    iniFile.Free;
  end;
end;

procedure TfrmComparer.FormCreate(Sender: TObject);
var
  iniFile: TIniFile;
  iniPath: string;
begin
  with CompDM do
  begin
    SelectPlatPredpr.Close;
    SelectPlatPredpr.Open;

    SelectOblDopUnn.Close;
    SelectOblDopUnn.Open;
    SelectOblDopUnn.First;

    while not SelectOblDopUnn.Eof do
    begin
      FilialRG.Items.Add(SelectOblDopUnn.FieldByName('dopUnn').AsString);

      SelectOblDopUnn.Next;
    end;

    MainPageControl.Pages[DuplicatesOblpoTabSheet.PageIndex].TabVisible := not IsFilial;
    FilialRG.Enabled := not IsFilial;
    SaveStateMMBtn.Enabled := not IsFilial;

    if IsFilial then
      Self.Caption := Self.Caption + ' - ' + Filial;
  end;

  FirstDTP.DateTime := Now();
  SecondDTP.DateTime := FirstDTP.DateTime;

  MainPageControl.ActivePageIndex := 0;

  //      ,    
  StateMMBtn.ImageIndex := 5;
  ExportMMBtn.ImageIndex := 8;
  SettingsMMBtn.ImageIndex := 10;

  iniPath := ExtractFilePath(ParamStr(0)) + 'Config.ini';

  if FileExists(iniPath) then
  begin
    iniFile := TIniFile.Create(iniPath);
    try
      SelfProvCB.Checked := StrToBool(iniFile.ReadString('Settings', 'SelfProv', '0'));
    finally
      iniFile.Free;
    end;
  end;
end;

procedure TfrmComparer.SaveStateMMBtnClick(Sender: TObject);
begin
  with CompDM do
  begin
    if not CompareMemTableEh.Active then
    begin
      MessageDlg('    .', mtWarning, [mbOK], 0);
      Exit;
    end;

    SaveComeralState := TSaveComeralState.Create(True, MainProgressBar,
      MainStatusBar, MainPageControl, LoadExcelFileBtn, UpdateBtn, InstrumentsPanel, MainMenu);
    SaveComeralState.FreeOnTerminate := true;
    SaveComeralState.Priority := tpNormal;
    SaveComeralState.Start;
  end;
end;

procedure TfrmComparer.SearchBtnClick(Sender: TObject);
begin
  frmSearch := TfrmSearch.Create(Self, PredprDBLCBEh);
  frmSearch.ShowModal;
  frmSearch.Free;
end;

procedure TfrmComparer.ShowAllStatePMBtnClick(Sender: TObject);
begin
  FilterBtn.Click;
end;

procedure TfrmComparer.ShowFiltersBtnClick(Sender: TObject);
begin
  if FiltersPanel.Visible then
  begin
    ShowFiltersBtn.Caption := ' ';
    ShowFiltersBtn.ImageIndex := 5;
    FiltersPanel.Visible := False;
  end
  else
  begin
    ShowFiltersBtn.Caption := ' ';
    ShowFiltersBtn.ImageIndex := 4;
    FiltersPanel.Visible := True;
  end;
end;

procedure TfrmComparer.ShowNotHideStatePMBtnClick(Sender: TObject);
begin
  FilterBtn.Click;
end;

procedure TfrmComparer.StatePMPopup(Sender: TObject);
begin
  if InvDBGridEh.DataSource.Name = 'CompareMemTableEhDS' then
    Abort;
end;

procedure TfrmComparer.UpdateBtnClick(Sender: TObject);
var
  idPredpr: Int64;
  DupleFios: string;
begin
  //         
  if FirstDTP.Date > SecondDTP.Date then
  begin
    MessageDlg('   .', mtError, [mbOK], 0);
    Exit;
  end;

  if CompDM.CheckComeralSignersDuplicates(DupleFios) then
  begin
    MessageDlg('     .' + #10#13 + DupleFios, mtError, [mbOK], 0);
    Exit;
  end;

  if Length(PredprDBLCBEh.Text) > 0 then
    idPredpr := StrToInt64(VarToStr(PredprDBLCBEh.KeyValue))
  else
    idPredpr := 0;

  with InvDBGridEh do
  begin
    DataGrouping.Active := False;
    DataSource := CompDM.CompareMemTableEhDS;
    DataGrouping.Active := True;
    Columns[16].Visible := False;
  end;

  SubInvDBGridEh.DataSource := CompDM.SelectSprProvDS;

  CompareData := TCompareData.Create(True, idPredpr, FirstDTP.Date, SecondDTP.Date,
    SelfProvCB.Checked, MainProgressBar, MainStatusBar, MainPageControl,
    LoadExcelFileBtn, UpdateBtn, InstrumentsPanel, MainMenu, InvDBGridEh.Columns
    [8].Footer, InvDBGridEh.Columns[9].Footer, InvDBGridEh.Columns[11].Footer);
  CompareData.FreeOnTerminate := true;
  CompareData.Priority := tpNormal;
  CompareData.Start;
end;

procedure TfrmComparer.ZeroExcludeMMBtnClick(Sender: TObject);
begin
  frmZeroExcludeSettings := TfrmZeroExcludeSettings.Create(Self);
  frmZeroExcludeSettings.ShowModal;
  frmZeroExcludeSettings.Free;
end;

procedure TfrmComparer.InvDBGridEhCheckRowHaveDetailPanel(Sender:
  TCustomDBGridEh; var RowHaveDetailPanel: Boolean);
begin
  //           
  if Sender.DataSource.Name = 'CompareMemTableEhDS' then
    RowHaveDetailPanel := not CompDM.CompareMemTableEhndsspr.IsNull
  else
    RowHaveDetailPanel := not CompDM.TmpComeralInvMemTableEhndsspr.IsNull;
end;

procedure TfrmComparer.InvDBGridEhRowDetailPanelShow(Sender: TCustomDBGridEh; var CanShow: Boolean);
begin
  with CompDM do
    if Sender.DataSource.Name = 'CompareMemTableEhDS' then
      SelectSprProv(SelectSprProvQ, CompareMemTableEhdocnumber.AsString,
        CompareMemTableEhnumdocpart.AsString, CompareMemTableEhnumbuhspr.AsString,
        CompareMemTableEhidPredpr.AsString, CompareMemTableEhinvoicefullname.AsString,
        CompareMemTableEhdocdate.AsDateTime, CompareMemTableEhfilial.AsInteger)
    else
      SelectSprProv(SelectTmpComeralProv, TmpComeralInvMemTableEhdocnumber.AsString,
        TmpComeralInvMemTableEhnumdocpart.AsString,
        TmpComeralInvMemTableEhnumbuhspr.AsString, TmpComeralInvMemTableEhidPredpr.AsString,
        TmpComeralInvMemTableEhinvoicefullname.AsString,
        TmpComeralInvMemTableEhdocdate.AsDateTime, TmpComeralInvMemTableEhfilial.AsInteger);
end;

procedure TfrmComparer.InvDBGridEhSortMarkingChanged(Sender: TObject);
begin
  with CompDM do
  begin
    if CompareMemTableEh.IsEmpty then
      Exit;

    MultiSorting(TDBGridEh(Sender));
  end;
end;

procedure TfrmComparer.LoadExcelFileBtnClick(Sender: TObject);
begin
  //    XLSX    
  if Length(XLSOpenDialog.FileName) > 0 then
    if MessageBox(Self.Handle, PChar('     ' +
      '  .' + #10#13 + '?'), PChar(' '),
      MB_YESNO + MB_ICONWARNING) = mrNo then
      Exit;

  if not XLSOpenDialog.Execute then
    Exit;

  LoadExcelProcess := TLoadExcelProcess.Create(True, XLSOpenDialog.Files,
    MainProgressBar, MainStatusBar, MainPageControl, LoadExcelFileBtn, UpdateBtn, InstrumentsPanel, MainMenu);
  LoadExcelProcess.FreeOnTerminate := true;
  LoadExcelProcess.Priority := tpNormal;
  LoadExcelProcess.Start;
end;

procedure TfrmComparer.LoadStateMMBtnClick(Sender: TObject);
var
  idPredpr: Int64;
begin
  with CompDM do
  begin
    with InvDBGridEh do
    begin
      DataGrouping.Active := False;
      DataSource := TmpComeralInvMemTableEhDS;
      DataGrouping.Active := True;
      Columns[16].Visible := True;
    end;

    SubInvDBGridEh.DataSource := SelectTmpComeralProvDS;

    if Length(PredprDBLCBEh.Text) > 0 then
      idPredpr := StrToInt64(VarToStr(PredprDBLCBEh.KeyValue))
    else
      idPredpr := 0;

    LoadComeralState := TLoadComeralState.Create(True, idPredpr, MainProgressBar,
      MainStatusBar, MainPageControl, LoadExcelFileBtn, UpdateBtn, InstrumentsPanel, MainMenu);
    LoadComeralState.FreeOnTerminate := true;
    LoadComeralState.Priority := tpNormal;
    LoadComeralState.Start;
  end;
end;

procedure TfrmComparer.MainPageControlChange(Sender: TObject);
begin
  //       
  if InvDBGridEh.RowDetailPanel.Visible then
    InvDBGridEh.RowDetailPanel.Visible := False;

  if DuplicatesOblpoDBGridEh.RowDetailPanel.Visible then
    DuplicatesOblpoDBGridEh.RowDetailPanel.Visible := False;
end;

procedure TfrmComparer.PrintDBGridEhAfterPrint(Sender: TObject);
begin
  //    
  if MainPageControl.ActivePageIndex = 0 then
    InvDBGridEh.DataGrouping.GroupLevels[0].CollapseNodes;
end;

end.

