unit uLoadComeralState;

interface

uses
  System.Classes, uBaseCompThread, Vcl.ComCtrls, Vcl.StdCtrls, Vcl.ExtCtrls,
  System.SysUtils, Data.DB, Vcl.Menus;

type
  TLoadComeralState = class(TBaseCompThread)
  private
    { Private declarations }
    idPredpr: Int64;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; idPredpr: int64; ProgressBar:
      TProgressBar; StatusBar: TStatusBar; PageControl: TPageControl;
      LoadExcelFileBtn, UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu); overload;
  end;

var
  LoadComeralState: TLoadComeralState;

implementation

uses
  uCompDM;

{ TLoadComeralState }

constructor TLoadComeralState.Create(CreateSuspended: Boolean; idPredpr: int64;
  ProgressBar: TProgressBar; StatusBar: TStatusBar; PageControl: TPageControl;
  LoadExcelFileBtn, UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu);
begin
  inherited Create(CreateSuspended, ProgressBar, StatusBar, PageControl,
    LoadExcelFileBtn, UpdateBtn, InsPanel, MainMenu);

  Self.idPredpr := idPredpr;
end;

procedure TLoadComeralState.Execute;
begin
  with CompDM do
  begin
    Self.Enabled := False;
    Synchronize(ChangeControlAvailability);

    Self.PBStyle := pbstMarquee;
    Synchronize(SetProgressBarStyle);

    Synchronize(TmpComeralInvMemTableEh.DisableControls);

    TmpComeralInvMemTableEh.Active := False;

    with SelectTmpComeralInv do
    begin
      Close;
      if Self.idPredpr > 0 then
        SQL[2] := 'WHERE ISNULL(idPredpr,0)=' + IntToStr(Self.idPredpr)
      else
        SQL[2] := '--   ';

      Open;

      if IsEmpty then
      begin
        Self.DialogMessage := '   .';
        Synchronize(ShowInfoDialog);
      end
      else
      begin
        TmpComeralInvMemTableEh.Active := True;
        TmpComeralInvMemTableEh.SortByFields('namepredpr,invoicefullname');
        TmpComeralInvMemTableEh.First;
      end;
    end;

    Synchronize(TmpComeralInvMemTableEh.EnableControls);

    Self.PBStyle := pbstNormal;
    Synchronize(SetProgressBarStyle);

    Self.Enabled := True;
    Synchronize(ChangeControlAvailability);
  end;
end;

end.

