unit uLoadExcelThread;

interface

uses
  System.Classes, System.SysUtils, System.Variants, System.Win.ComObj,
  Vcl.ComCtrls, Vcl.StdCtrls, Vcl.ExtCtrls, uBaseCompThread, Vcl.Dialogs,
  Vcl.Menus, Data.DB;

type
//  TLoadExcelProcess = class(TThread)
  TLoadExcelProcess = class(TBaseCompThread)
  private
    { Private declarations }
    FilePaths: TStrings;
    function VarToCurr(Value: Variant): Currency;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; FilePaths: TStrings;
      ProgressBar: TProgressBar; StatusBar: TStatusBar; PageControl:
      TPageControl; LoadExcelFileBtn, UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu); overload;
  end;

var
  LoadExcelProcess: TLoadExcelProcess;

implementation

uses
  uCompDM;

// TLoadExcelProcess
//     Excel

constructor TLoadExcelProcess.Create(CreateSuspended: Boolean; FilePaths:
  TStrings; ProgressBar: TProgressBar; StatusBar: TStatusBar; PageControl:
  TPageControl; LoadExcelFileBtn, UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu);
begin
  inherited Create(CreateSuspended, ProgressBar, StatusBar, PageControl,
    LoadExcelFileBtn, UpdateBtn, InsPanel, MainMenu);

  Self.FilePaths := FilePaths;
end;

function TLoadExcelProcess.VarToCurr(Value: Variant): Currency;
begin
  //  Variant  Currency   
  Result := StrToCurr(CompDM.UpdateDecimalSeparator(VarToStr(Value)));
end;

procedure TLoadExcelProcess.Execute;
var
  ExcelApp, WorkSheet, FData: OLEVariant;
  i, Rows, StartIndex: Integer;
  PredprId: Int64;
  PredprName, FileName, ShortName: string;
  dopunn, docDate: Variant;
  isFilialSigner: Boolean;
begin
  //      XLS/XLSX
  ExcelApp := CreateOleObject('Excel.Application');
  ExcelApp.DisplayAlerts := False;

  Self.Enabled := False;
  Synchronize(ChangeControlAvailability);

  Self.PBStyle := pbstMarquee;
  Synchronize(SetProgressBarStyle);

  with CompDM do
  try
    CrExcelTemp.ExecSQL;

    if IsFilial then
      GetSignersByFilial(filial);

    for FileName in Self.FilePaths do
    begin
      StartIndex := 3;
      ShortName := Copy(FileName, LastDelimiter('\', FileName) + 1, Length(FileName)
        - LastDelimiter('\', FileName));

      Self.StatusText := '  ' + ShortName;
      Synchronize(SetStatusBarText);

      ExcelApp.Workbooks.Open(FileName, ReadOnly := true);

      //  WorkSheets    IDE  ,     
      WorkSheet := ExcelApp.Workbooks[1].WorkSheets[1];
      Rows := WorkSheet.UsedRange.Rows.Count;
      FData := WorkSheet.UsedRange.Value;

      Self.StatusText := '  ' + ShortName + '  ...';
      Synchronize(SetStatusBarText);

      //      
      for i := 1 to Rows do
        if (Length(Trim(VarToStr(FData[i, 1]))) <> 0) and (Trim(VarToStr(FData[i,
          1])) <> '  ') then
        begin
          StartIndex := i;
          Break;
        end;

      //          
      for i := StartIndex to Rows do
      try
        if Length(VarToStr(FData[i, 15])) = 0 then
          Continue;

        // 
        if Length(Trim(VarToStr(FData[i, 10]))) = 0 then
          dopunn := null
        else
          dopunn := Trim(VarToStr(FData[i, 10]));

        if IsFilial then
        begin
          isFilialSigner := SelectSignersByFilialQ.Locate('fio', Trim(VarToStr(FData
            [i, 14])), [loCaseInsensitive]);

          //       
          if ((Length(Trim(VarToStr(FData[i, 14]))) > 0) or (dopunn <> null))
            and (((VarToStr(dopunn) <> Filial) and (not isFilialSigner))) then
            Continue;
        end;

        // 
        if Length(Trim(VarToStr(FData[i, 3]))) = 0 then
        begin
          PredprId := StrToInt64(Trim(VarToStr(FData[i, 2])) + '0000');
          PredprName := Trim(VarToStr(FData[i, 2])) + ' - ' + Trim(VarToStr(FData[i, 4]));
        end
        else
        begin
          PredprId := StrToInt64(Trim(VarToStr(FData[i, 2])) + Trim(VarToStr(FData[i, 3])));
          PredprName := Trim(VarToStr(FData[i, 2])) + ' ' + Trim(VarToStr(FData[i,
            3])) + ' - ' + Trim(VarToStr(FData[i, 4]));
        end;

        //  
        if Length(Trim(VarToStr(FData[i, 39]))) = 0 then
          docDate := null
        else
          docDate := VarToDateTime(FData[i, 39]);

        InsertExcelTemp(PredprId, PredprName, VarToStr(FData[i, 15]), VarToStr(FData
          [i, 38]), '', VarToStr(FData[i, 11]), VarToStr(FData[i, 14]),
          VarToDateTime(FData[i, 20]), 5, VarToCurr(FData[i, 43]), VarToCurr(FData
          [i, 41]), VarToCurr(FData[i, 44]), docDate, dopunn);
      except
        on eIns: EInsExcelTempException do
        begin
          Self.DialogMessage := eIns.Message + #10#13 + VarToStr(FData[i, 15]);
          Synchronize(ShowErrorDialog);
        end;
        on eConv: EVariantTypeCastError do
        begin
          Self.DialogMessage := '      ' + VarToStr(FData[i, 15]);
          Synchronize(ShowErrorDialog);
        end;
        on e: Exception do
        begin
          Self.DialogMessage := '   : ' + e.Message + #10#13 + VarToStr(FData[i, 15]);
          Synchronize(ShowErrorDialog);
        end;
      end;

      ExcelApp.Workbooks.Close;
    end;
  finally
    Self.StatusText := '   ...';
    Synchronize(SetStatusBarText);

    ExcelApp.Quit;
    VarClear(FData);
    VarClear(WorkSheet);
    VarClear(ExcelApp);
  end;

  Self.StatusText := ' ';
  Synchronize(SetStatusBarText);

  Self.Enabled := True;
  Synchronize(ChangeControlAvailability);

  Self.PBStyle := pbstNormal;
  Synchronize(SetProgressBarStyle);
end;

end.

