unit uSaveComeralState;

interface

uses
  System.Classes, uBaseCompThread, System.SysUtils, Vcl.ComCtrls;

type
  TSaveComeralState = class(TBaseCompThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

var
  SaveComeralState: TSaveComeralState;

implementation

uses
  uCompDM;

{ TSaveComeralState }

procedure TSaveComeralState.Execute;
begin
  with CompDM do
  begin
    Self.Enabled := False;
    Synchronize(ChangeControlAvailability);

    Self.PBStyle := pbstMarquee;
    Synchronize(SetProgressBarStyle);

    try
      //     
      try
        DelTmpComeralInvQ.ExecSQL;
      except
        on E: Exception do
          raise EDelTmpComeralInvException('     tmpComeralInv,  : '
            + e.Message)
      end;

      //      tmpComeralInv
      Synchronize(CompareMemTableEh.DisableControls);

      SelectSvodInv.First;

      while not SelectSvodInv.Eof do
      begin
        try
          // 11.03.2021   ,    
//          if (((SelectSvodInvndsinvoice.IsNull) or (SelectSvodInvndsexcel.IsNull)
//            or (SelectSvodInvndsspr.IsNull)) or ((not SelectSvodInvndsspr.IsNull)
//            and (not SelectSvodInvndsexcel.IsNull) and (SelectSvodInvndsspr.AsCurrency
//            <> SelectSvodInvndsexcel.AsCurrency))) then
          InsertTmpComeralInv(SelectSvodInvidPredpr.AsVariant,
            SelectSvodInvinvoicefullname.AsVariant, SelectSvodInvdatetrans.AsVariant,
            SelectSvodInvstatus.AsVariant, SelectSvodInvrecipientname.AsVariant,
            SelectSvodInvsignerfio.AsVariant, SelectSvodInvnamepredpr.AsVariant,
            SelectSvodInvdocnumber.AsVariant, SelectSvodInvdocdate.AsVariant,
            SelectSvodInvndsexcel.AsVariant, SelectSvodInvndsspr.AsVariant,
            SelectSvodInvndsinvoice.AsVariant, SelectSvodInvtotalcostinv.AsVariant,
            SelectSvodInvtotalcostvatinv.AsVariant, SelectSvodInvfilial.AsVariant,
            SelectSvodInvsvplace.AsVariant, SelectSvodInvnumbuhspr.AsVariant,
            SelectSvodInvnumdocpart.AsVariant);
        except
          on e: EInsTmpComeralInvException do
          begin
            Self.DialogMessage := '   : ' + e.Message;
            Synchronize(ShowErrorDialog);
          end;
        end;

        SelectSvodInv.Next;
      end;

      //      tmpComeralProv
      try
        RewriteInsTmpComeralProv.ExecSQL;
      except
        on e: Exception do
        begin
          Self.DialogMessage := '    : ' + e.Message;
          Synchronize(ShowErrorDialog);
        end;
      end;

      Synchronize(CompareMemTableEh.EnableControls);
    except
      on edel: EDelTmpComeralInvException do
      begin
        Self.DialogMessage := edel.Message;
        Synchronize(ShowErrorDialog);
      end;
      on E: Exception do
      begin
        Self.DialogMessage := '   ,  : ' + e.Message;
        Synchronize(ShowErrorDialog);
      end;
    end;

    Self.PBStyle := pbstNormal;
    Synchronize(SetProgressBarStyle);

    Self.Enabled := True;
    Synchronize(ChangeControlAvailability);

    Self.DialogMessage := ' ';
    Synchronize(ShowInfoDialog)
  end;
end;

end.

