unit uFindPredpr;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, StdCtrls, Buttons, ComCtrls, ExtCtrls, DBCtrls, DBLookupEh;

type
  TfrmFindPredpr = class(TForm)
    SearchEdit: TEdit;
    StatusBar1: TStatusBar;
    BitBtn1: TBitBtn;
    SearchQuery: TADOQuery;
    DBNavigator1: TDBNavigator;
    SearchDataSource: TDataSource;
    SearchRG: TRadioGroup;
    procedure BitBtn1Click(Sender: TObject);
    procedure DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
  private
    { Private declarations }
    CB: TComboBox;
    LookupCB: TDBLookupComboboxEh;
    FindType: Byte;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; LookupCB: TDBLookupComboboxEh); reintroduce; overload;
    constructor Create(AOwner: TComponent; CB: TComboBox); reintroduce; overload;
  end;

var
  frmFindPredpr: TfrmFindPredpr;

implementation

uses uSVDM;

{$R *.dfm}

constructor TfrmFindPredpr.Create(AOwner: TComponent; LookupCB: TDBLookupComboboxEh);
begin
  inherited Create(AOwner);

  Self.LookupCB := LookupCB;
  Self.FindType := 1;
end;

constructor TfrmFindPredpr.Create(AOwner: TComponent; CB: TComboBox);
begin
  inherited Create(AOwner);

  Self.CB := CB;
  Self.FindType := 0;
end;

procedure TfrmFindPredpr.BitBtn1Click(Sender: TObject);
begin
  SearchQuery.Close;

  case SearchRG.ItemIndex of
    0:
      SearchQuery.SQL[SearchQuery.SQL.Count - 2] := 'AND namePredpr LIKE ' +
        QuotedStr('%' + SearchEdit.Text + '%');
    1:
      SearchQuery.SQL[SearchQuery.SQL.Count - 2] := 'AND UNN LIKE ' + QuotedStr('%' + SearchEdit.Text + '%');
  end;

  SearchQuery.Open;

  SearchQuery.First;
  StatusBar1.Panels[0].Text := SearchQuery.FieldByName('namePredpr').AsString;

  case Self.FindType of
    0:
      CB.ItemIndex := CB.Items.IndexOf(SearchQuery.FieldByName('namePredpr').AsString);
    1:
      LookupCB.KeyValue := SearchQuery.FieldByName('idPredpr').Value;
  end;
end;

procedure TfrmFindPredpr.DBNavigator1Click(Sender: TObject; Button: TNavigateBtn);
begin
  StatusBar1.Panels[0].Text := SearchQuery.FieldByName('namePredpr').AsString;

  case Self.FindType of
    0:
      CB.ItemIndex := CB.Items.IndexOf(SearchQuery.FieldByName('namePredpr').AsString);
    1:
      LookupCB.KeyValue := SearchQuery.FieldByName('idPredpr').Value;
  end;
end;

end.

