unit uForeignInfo;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.StdCtrls, Vcl.ComCtrls, Vcl.ExtCtrls, System.UITypes;

type
  TfrmForeignInfo = class(TForm)
    TopPanel: TPanel;
    ForeignTypeRG: TRadioGroup;
    InfoPanel: TPanel;
    NumberEdit: TLabeledEdit;
    FirstDateDTP: TDateTimePicker;
    FirstDateLbl: TLabel;
    SaveRussiaBtn: TButton;
    DeleteRussiaBtn: TButton;
    BottomPanel: TPanel;
    SecondDateLbl: TLabel;
    SecondDateDTP: TDateTimePicker;
    procedure ForeignTypeRGClick(Sender: TObject);
    procedure SaveRussiaBtnClick(Sender: TObject);
    procedure DeleteRussiaBtnClick(Sender: TObject);
  private
    { Private declarations }
    idSender: Integer;
    compilingYear: Integer;
    number: Int64;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent; idSender, compilingYear: Integer;
      number: Int64; taxesNumber: string; taxesDate: TDateTime; declaration:
      string; dateRelease, dateActualExport: TDateTime); reintroduce;
  end;

var
  frmForeignInfo: TfrmForeignInfo;

implementation

uses
  uDM;

{$R *.dfm}

constructor TfrmForeignInfo.Create(AOwner: TComponent; idSender, compilingYear:
  Integer; number: Int64; taxesNumber: string; taxesDate: TDateTime; declaration:
  string; dateRelease, dateActualExport: TDateTime);
begin
  inherited Create(AOwner);

  Self.idSender := idSender;
  Self.compilingYear := compilingYear;
  Self.number := number;

  FirstDateDTP.DateTime := Now();
  SecondDateDTP.DateTime := Now();

  if Length(Trim(taxesNumber)) > 0 then
  begin
    NumberEdit.Text := taxesNumber;
    FirstDateDTP.DateTime := taxesDate;

    ForeignTypeRG.ItemIndex := 0;
  end
  else if Length(Trim(declaration)) > 0 then
  begin
    NumberEdit.Text := declaration;
    FirstDateDTP.DateTime := dateRelease;
    SecondDateDTP.DateTime := dateActualExport;

    ForeignTypeRG.ItemIndex := 1;
  end;
end;

procedure TfrmForeignInfo.DeleteRussiaBtnClick(Sender: TObject);
begin
  with DM do
  try
    UpdateInvForeignInfo('invoices', Self.idSender, Self.compilingYear, Self.number,
      null, null, null, null, null);
    UpdateInvForeignInfo('#invoicesout', Self.idSender, Self.compilingYear, Self.number,
      null, null, null, null, null);

    ModalResult := mrOk;
  except
    on E: Exception do
      MessageDlg('      : ' + E.Message, mtError, [mbOK], 0);
  end;
end;

procedure TfrmForeignInfo.ForeignTypeRGClick(Sender: TObject);
begin
  case ForeignTypeRG.ItemIndex of
    0:
      begin
        NumberEdit.EditLabel.Caption := '  ';
        FirstDateLbl.Caption := '  ';
        SecondDateDTP.Visible := False;
        SecondDateLbl.Visible := False;
      end;
    1:
      begin
        NumberEdit.EditLabel.Caption := '   ';
        FirstDateLbl.Caption := '  ';
        SecondDateLbl.Caption := '     ';
        SecondDateDTP.Visible := True;
        SecondDateLbl.Visible := True;
      end;
  end;
end;

procedure TfrmForeignInfo.SaveRussiaBtnClick(Sender: TObject);
begin
  if Length(Trim(NumberEdit.Text)) = 0 then
  begin
    MessageDlg(' "' + NumberEdit.EditLabel.Caption + '"    ', mtWarning, [mbOK], 0);
    Exit;
  end;

  with DM do
  try
    case ForeignTypeRG.ItemIndex of
      0:
        begin
          UpdateInvForeignInfo('invoices', Self.idSender, Self.compilingYear,
            Self.number, NumberEdit.Text, FirstDateDTP.Date, null, null, null);
          UpdateInvForeignInfo('#invoicesout', Self.idSender, Self.compilingYear,
            Self.number, NumberEdit.Text, FirstDateDTP.Date, null, null, null);
        end;
      1:
        begin
          UpdateInvForeignInfo('invoices', Self.idSender, Self.compilingYear,
            Self.number, null, null, NumberEdit.Text, FirstDateDTP.Date, SecondDateDTP.Date);
          UpdateInvForeignInfo('#invoicesout', Self.idSender, Self.compilingYear,
            Self.number, null, null, NumberEdit.Text, FirstDateDTP.Date, SecondDateDTP.Date);
        end;
    end;

    ModalResult := mrOk;
  except
    on E: Exception do
      MessageDlg('      : ' + E.Message, mtError, [mbOK], 0);
  end;
end;

end.

