unit Sver1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StrUtils, DateUtils, DB, ADODB;

type
  TfrmMain = class(TForm)
    MainMenu1: TMainMenu;
    N4: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    N3: TMenuItem;
    N5: TMenuItem;
    N21: TMenuItem;
    N22: TMenuItem;
    N6: TMenuItem;
    N7: TMenuItem;
    N8: TMenuItem;
    NotStatus5: TADOQuery;
    BUHConnection: TADOConnection;
    SelectNastrUNN: TADOQuery;
    N9: TMenuItem;
    N10: TMenuItem;
    NotStatus5ForThread: TADOQuery;
    procedure N1Click(Sender: TObject);
    procedure N4Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure N5Click(Sender: TObject);
    procedure N21Click(Sender: TObject);
    procedure N22Click(Sender: TObject);
    procedure N6Click(Sender: TObject);
    procedure N7Click(Sender: TObject);
    procedure N8Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure N9Click(Sender: TObject);
    procedure N10Click(Sender: TObject);
  private    { Private declarations }
    procedure ReplaceFilesToUpload;
  public    { Public declarations }
  end;

var
  frmMain: TfrmMain;


implementation

uses
  uCheckSvSigns;

{$R *.dfm}

procedure TfrmMain.ReplaceFilesToUpload;
var
  RecV, RecV3, Path, NSF: string;
  F: TextFile;
begin
  AssignFile(F, ExtractFilePath(Application.ExeName) + 'RecV.ini');
  Reset(F);
  Read(F, RecV);
  CloseFile(F);

  AssignFile(F, ExtractFilePath(Application.ExeName) + 'RecV3.ini');
  Reset(F);
  Read(F, RecV3);
  CloseFile(F);

  AssignFile(F, ExtractFilePath(Application.ExeName) + 'Path.ini');
  Reset(F);
  ReadLn(F, Path);
  ReadLn(F, Path);
  CloseFile(F);

  with NotStatus5 do
  begin
    Close;
    Open;

    if not IsEmpty then
    begin
      First;

      while not eof do
      begin
        NSF := FieldByName('NSF').AsString;

        if (FileExists(RecV3 + NSF + '.sgn2.xml') and FileExists(RecV3 + NSF +
          '.ticket.xml') and FileExists(RecV3 + NSF + '.ticket.text.xml')) then
        begin
          DeleteFile(RecV3 + NSF + '.sgn2.xml');
          DeleteFile(RecV3 + NSF + '.ticket.xml');
          DeleteFile(RecV3 + NSF + '.ticket.text.xml');
        end;

        if FileExists(RecV + NSF + '.sgn.xml') then
          CopyFile(PChar(RecV + NSF + '.sgn.xml'), PChar(RecV3 + NSF + '.sgn.xml'), False)
        else if FileExists(Path + NSF + '.sgn.xml') then
          CopyFile(PChar(Path + NSF + '.sgn.xml'), PChar(RecV3 + NSF + '.sgn.xml'), False);

        Next;
      end;
    end;
  end;
end;

procedure TfrmMain.N1Click(Sender: TObject);
var
  S1: TStrings;
  F: TextFile;
  S, S2, Path: string;
  dd, mm, yy: word;
  CurrDate: TDate;
begin
  AssignFile(F, ExtractFilePath(Application.ExeName) + 'RecV.ini');
  Reset(F);
  Read(F, S);
  CloseFile(F);

  if not (SelectNastrUNN.FieldByName('UNN').AsString = '600037767') then
  begin
    Path := S;
    S1 := TStringList.Create();
    S1.LoadFromFile(Path + 'last.update.time');
    S2 := S1.Text;
    CurrDate := Now();
    yy := YearOf(CurrDate);
    mm := MonthOf(CurrDate);
    dd := DayOf(CurrDate);
    IncAMonth(yy, mm, dd, -2);
    S1.Text := StuffString(S1.Text, 1, 4, IntToStr(yy));
    S1.Text := StuffString(S1.Text, 6, 2, RightStr(('0' + IntToStr(mm)), 2));
    S1.Text := StuffString(S1.Text, 9, 2, RightStr(('0' + IntToStr(dd)), 2));
    S1.SaveToFile(Path + 'last.update.time');
  end;

  WinExec('Project1.exe', SW_HIDE);
end;

procedure TfrmMain.N4Click(Sender: TObject);
begin
  WinExec('SverkaProv.exe', SW_HIDE);
end;

procedure TfrmMain.N3Click(Sender: TObject);
begin
  ReplaceFilesToUpload;

  WinExec('signAndUploadRecvDir.bat', SW_Show);
end;

procedure TfrmMain.N5Click(Sender: TObject);
begin
  WinExec('Move.exe', SW_HIDE);
end;

procedure TfrmMain.N21Click(Sender: TObject);
begin
  WinExec('sv_exe.exe', SW_HIDE);
end;

procedure TfrmMain.N22Click(Sender: TObject);
begin
  WinExec('SFReestr.exe', SW_HIDE);
end;

procedure TfrmMain.N6Click(Sender: TObject);
begin
  WinExec('UpdateStat.exe', SW_HIDE);
end;

procedure TfrmMain.N7Click(Sender: TObject);
begin
  WinExec('SFNastr.exe', SW_HIDE);
end;

procedure TfrmMain.N8Click(Sender: TObject);
begin
  WinExec('SFProtokol.exe', SW_HIDE);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  S: string;
  F: TextFile;
begin
  // 13.02.2020
  AssignFile(F, ExtractFilePath(Application.ExeName) + 'BuhConnect.ini');
  Reset(F);
  Read(F, S);
  CloseFile(F);

  BUHConnection.Close();
  BUHConnection.ConnectionString := S;
  BUHConnection.Open();

  SelectNastrUNN.Close;
  SelectNastrUNN.Open;

  if (SelectNastrUNN.FieldByName('UNN').AsString = '600037767') then
  begin
    N3.Visible := False;
    N6.Visible := False;

    CheckSvSigns := TCheckSvSigns.Create(True, ExtractFilePath(Application.ExeName), NotStatus5ForThread);
    CheckSvSigns.FreeOnTerminate := true;
    CheckSvSigns.Priority := tpNormal;
    CheckSvSigns.Start;
  end
  else
  begin
    N3.Visible := True;
    N6.Visible := True;
  end;
end;

procedure TfrmMain.N9Click(Sender: TObject);
begin
  WinExec('SFAddProv.exe', SW_HIDE);
end;

procedure TfrmMain.N10Click(Sender: TObject);
begin
  ReplaceFilesToUpload;
end;

end.

