unit uCheckSvSigns;

interface

uses
  Classes, SysUtils, ADODB, DB, IdGlobal, Winapi.Windows;

type
  TCheckSvSigns = class(TThread)
  private
    { Private declarations }
    AppPath: string;
    SelectQuery: TADOQuery;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; AppPath: string; SelectQuery: TADOQuery); overload;
  end;

var
  CheckSvSigns: TCheckSvSigns;

implementation

constructor TCheckSvSigns.Create(CreateSuspended: Boolean; AppPath: string; SelectQuery: TADOQuery);
begin
  inherited Create(CreateSuspended);

  Self.AppPath := AppPath;
  Self.SelectQuery := SelectQuery;
end;

procedure TCheckSvSigns.Execute;
var
  RecV, RecV3, Path, NSF: string;
  F: TextFile;
begin
  AssignFile(F, AppPath + 'RecV.ini');
  Reset(F);
  Read(F, RecV);
  CloseFile(F);

  AssignFile(F, AppPath + 'RecV3.ini');
  Reset(F);
  Read(F, RecV3);
  CloseFile(F);

  AssignFile(F, AppPath + 'Path.ini');
  Reset(F);
  ReadLn(F, Path);
  ReadLn(F, Path);
  CloseFile(F);

  with Self.SelectQuery do
  begin
    Close;
    Open;

    if not IsEmpty then
    begin
      First;

      while not eof do
      begin
        NSF := FieldByName('NSF').AsString;

        if FileExists(Path + NSF + '.sgn.xml') then
          CopyFile(PChar(Path + NSF + '.sgn.xml'), PChar(RecV3 + NSF + '.sgn.xml'), False)
        else if FileExists(RecV + NSF + '.sgn.xml') then
          CopyFile(PChar(RecV + NSF + '.sgn.xml'), PChar(RecV3 + NSF + '.sgn.xml'), False);

        Next;
      end;
    end;
  end;
end;

end.

