unit NaklUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, DBTables, frxClass, frxADOComponents, frxDBSet,StdCtrls,
  frxDesgn, frxPreview;

type
  TCategory = 1..3;
  TRange = 0..19;
  TGenus = (masculine,neuter,feminine);
  TOccasion = 1..3;
  TNumeral = class
  private
    C: TCategory;
    R: TRange;
    G: TGenus;
    W: String;
  public
    property Category: TCategory
          read C;
    property Range: TRange
          read R;
    property Word: String
          read W;
    property Genus: TGenus
          read G;
    constructor Create(const Category: TCategory;
                       const Range: TRange;
                       const Word: String;
                       const Genus: TGenus = masculine);
  end;
  TMultiplicity = class
  private
    C: TCategory;
    O: TOccasion;
    W: String;
  public
    property Category: TCategory
          read C;
    property Occasion: TOccasion
          read O;
    property Word: String
          read W;
    constructor Create(const Category: TCategory;
                       const Occasion: TOccasion;
                       const Word: String);
  end;
  TNaklFlag = (nfTr, nfSumNDS, nfVsegoSNDS, nfStoimost, nfStoimost2_1,
    nfStoimost2_2, nfNastrGrTov, nfCenPriobr, nfCenTr, nfProcTr,
    nfCenWNal, nfTrPredpr, nfFace);
  TNaklFlags = set of TNaklFlag;

  Settings = record
    tr:Boolean;
    sumNDS:Boolean;
    vsegoSNDS:Boolean;
    stoimost:Boolean;
    stoimost2_1:Boolean;
    stoimost2_2:Boolean;
    nastrGrTov:Boolean;
    cenPriobr:Boolean;
    cenTr:Boolean;
    procTr:Boolean;
    cenWNal:Boolean;
    trPredpr:Boolean;
    face:Boolean;
    vesTr:String;
    TTN:String;
    numDoc:String;
    seria:String;
    pogr:String;
    razg:String;
    vidPer:String;
    prim:String;
    PRAll:String;
    idDoc:Integer;
    otpRaz:String;
    dateDov:String;
    vlTr:String;
    sposPogr:String;
    sposRazgr:String;
    vrPrib:String;
    vrUb:String;
    vrProst:String;
    MOLGruzPoluch:String;
    nomPric:String;
    copies:Integer;
    agreement:String;
    aliasName:String;
    login:String[25];
    password:String[25];
  end;

  TNaklForm = class(TfrxPreviewForm)
    frxDatasetPrCap: TfrxDBDataset;
    frxADOComponents1: TfrxADOComponents;
    frxDatasetPrStr: TfrxDBDataset;
    PrCapQuery: TQuery;
    PrCapQueryIdDoc: TIntegerField;
    PrCapQueryIdPredpr: TSmallintField;
    PrCapQueryKodSkl: TSmallintField;
    PrCapQueryVidDoc: TSmallintField;
    PrCapQueryDateDoc: TDateTimeField;
    PrCapQueryNumDoc: TIntegerField;
    PrCapQueryNameGrOper: TStringField;
    PrCapQueryUNNPlatPredpr: TStringField;
    PrCapQueryOKPOPlatPredpr: TStringField;
    PrCapQueryUNNPlatSkl: TStringField;
    PrCapQueryOKPOPlatSkl: TStringField;
    PrCapQueryLICPlatPred: TStringField;
    PrCapQueryLICPlatSkl: TStringField;
    PrCapQueryNamePredpr: TStringField;
    PrCapQueryNameSkl: TStringField;
    PrCapQueryStHoFlSkl: TStringField;
    PrCapQueryNamePlatPredpr: TStringField;
    PrCapQueryRschetPlatPredpr: TStringField;
    PrCapQueryKodMFOPlatPredpr: TStringField;
    PrCapQueryBankPlatPredpr: TStringField;
    PrCapQueryTownBankPredpr: TStringField;
    PrCapQueryRSchetPlatSkl: TStringField;
    PrCapQueryKodMFOPlatSkl: TStringField;
    PrCapQueryBankPlatSkl: TStringField;
    PrCapQueryTownBankSkl: TStringField;
    PrCapQueryTownPredpr: TStringField;
    PrCapQueryStHoFlPredpr: TStringField;
    PrCapQueryTownPlatPredpr: TStringField;
    PrCapQueryStHoFlPlatPredpr: TStringField;
    PrCapQueryPhonePlatPredpr: TStringField;
    PrCapQueryFaxPlatPredpr: TStringField;
    PrCapQueryNamePlatSkl: TStringField;
    PrCapQueryFIODir: TStringField;
    PrCapQueryTownPlatSkl: TStringField;
    PrCapQueryStHoFlPlatSkl: TStringField;
    PrCapQueryPhonePlatSkl: TStringField;
    PrCapQueryFaxPlatSkl: TStringField;
    PrCapQueryDogovor: TStringField;
    PrCapQueryCelPriobr: TStringField;
    PrCapQueryFioMol: TStringField;
    PrCapQueryProfMol: TStringField;
    PrCapQueryDover: TStringField;
    PrCapQueryPutList: TStringField;
    PrCapQueryVoditel: TStringField;
    PrCapQueryMarkAvto: TStringField;
    PrCapQueryOwnAvto: TStringField;
    PrCapQueryNomAvto: TStringField;
    PrCapQuerySumNDS: TBCDField;
    PrCapQuerySumIncNDS: TBCDField;
    PrCapQuerySumNac: TBCDField;
    PrCapQuerySumNacOpt: TBCDField;
    PrCapQuerySumTrn: TBCDField;
    PrCapQuerySumSkid: TBCDField;
    PrCapQueryItogo: TBCDField;
    PrCapQueryItogoTov: TBCDField;
    PrCapQueryItogoTar: TBCDField;
    PrCapQueryItogoRoz: TBCDField;
    PrCapQueryItogoOO: TBCDField;
    PrCapQueryItogoKolF: TBCDField;
    PrCapQueryItogoKolM: TBCDField;
    PrCapQueryItogoMas: TBCDField;
    PrCapQueryItogoKolKzp: TBCDField;
    PrCapQueryPrSumNds: TStringField;
    PrCapQueryPrVsego: TStringField;
    PrCapQueryItogoKolTov: TBCDField;
    PrCapQuerySert: TStringField;
    PrCapQueryItogoNaim: TSmallintField;
    PrCapQueryItogoTovR: TBCDField;
    PrCapQueryItogoTarR: TBCDField;
    PrCapQuerySumOpl: TBCDField;
    PrCapQueryFIOGlBuh: TStringField;
    PrCapQueryPoluchat: TStringField;
    PrCapQueryIndexSkl: TStringField;
    PrCapQueryIndexPlatSkl: TStringField;
    PrCapQueryIndexPredpr: TStringField;
    PrCapQueryIndexPlatPredpr: TStringField;
    PrCapQueryTownSkl: TStringField;
    PrCapQueryTovar: TBCDField;
    PrCapQueryStTara: TBCDField;
    PrCapQueryTara: TBCDField;
    PrCapQuerySumNDSRozn: TBCDField;
    PrCapQuerySumSkidPokup: TBCDField;
    PrStrQuery: TQuery;
    PrStrQueryNameVidTov: TStringField;
    PrStrQueryKodGr: TSmallintField;
    PrStrQueryKodPGr: TSmallintField;
    PrStrQueryMinUp: TBCDField;
    PrStrQueryVidUp: TStringField;
    PrStrQueryArt: TStringField;
    PrStrQueryModel: TStringField;
    PrStrQuerySizes: TStringField;
    PrStrQueryHight: TStringField;
    PrStrQuerySort: TStringField;
    PrStrQuerySertif: TStringField;
    PrStrQueryFasov: TBCDField;
    PrStrQueryEdIz: TStringField;
    PrStrQueryCenO: TBCDField;
    PrStrQueryCenRoz: TBCDField;
    PrStrQueryCenSt: TBCDField;
    PrStrQueryNDS: TBCDField;
    PrStrQueryNacOpt: TBCDField;
    PrStrQueryNacRozn: TBCDField;
    PrStrQueryNacObpit: TBCDField;
    PrStrQuerySkidPokup: TBCDField;
    PrStrQueryNacPosr: TBCDField;
    PrStrQuerySkidPost: TBCDField;
    PrStrQueryNalTr: TBCDField;
    PrStrQueryNalProd: TBCDField;
    PrStrQueryKolF: TBCDField;
    PrStrQueryKolm: TSmallintField;
    PrStrQuerySumNDS: TBCDField;
    PrStrQuerySumNDSR: TBCDField;
    PrStrQueryPrRazl: TStringField;
    PrStrQueryCenPor: TBCDField;
    PrStrQueryCenPriobr: TBCDField;
    PrStrQueryNamePredpr: TStringField;
    PrStrQueryNameCountry: TStringField;
    PrStrQueryKolPor: TBCDField;
    PrStrQueryProtkl: TStringField;
    PrStrQuerySertif1: TStringField;
    PrStrQuerySertif2: TStringField;
    PrStrQueryIdDoc: TIntegerField;
    PrStrQueryVes: TBCDField;
    PrStrQueryIdPrizLog: TSmallintField;
    PrCapQueryDateOtgr: TDateTimeField;
    PrCapQueryOtpRaz: TStringField;
    PrCapQueryNdsBns: TBCDField;
    PrCapQuerySumBns: TBCDField;
    PrCapQuerySumNdsBonus: TBCDField;
    SumBnsQuery: TQuery;
    frxDBDataset1: TfrxDBDataset;
    PrCapQueryNameF3Predpr: TStringField;
    PrCapQueryRschetF3Predpr: TStringField;
    PrCapQueryKodMFOF3Predpr: TStringField;
    PrCapQueryBankF3Predpr: TStringField;
    PrCapQueryTownF3Predpr: TStringField;
    PrCapQueryTownBankF3: TStringField;
    PrCapQueryUNNF3Predpr: TStringField;
    PrCapQueryOKPOF3Predpr: TStringField;
    PrCapQueryLICF3Pred: TStringField;
    PrCapQueryIndexF3Predpr: TStringField;
    PrCapQueryStHoFlF3Predpr: TStringField;
    PrCapQueryIdF3: TSmallintField;
    PrStrQueryPNT: TIntegerField;
    PrStrQuerypriznsyria: TStringField;
    PrStrQueryUsl: TBCDField;
    PrStrQueryKolKzp: TBCDField;
    PrStrQueryEdIzDop: TStringField;
    PrStrQuerySkidOv: TBCDField;
    PrStrQueryKolOv: TBCDField;
    PrStrQueryKolZ: TBCDField;
    mdb: TDatabase;
    PrStrQueryPNTTar1: TIntegerField;
    PrStrQueryPNTTar3: TIntegerField;
    frxDesigner1: TfrxDesigner;
    NameGrPrQuery: TQuery;
    PrCapQueryProfMol1: TStringField;
    PrStrQueryprLogBKS: TSmallintField;
    PrCapQuerySumNacRozn: TBCDField;
    PrCapQuerySumNacObpit: TBCDField;
    PrCapQueryTovarOO: TBCDField;
    FioDovQuery: TQuery;
    FioDovQueryFio: TStringField;
    PrCapQueryOblPlat: TStringField;
    PrCapQueryOblPlatSkl: TStringField;
    PrCapQueryRaionPlat: TStringField;
    PrCapQueryRaionPlatSkl: TStringField;
    frxReport2: TfrxReport;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    function Propis(S:Currency;KK:integer):string;
    function Num(Q:string;X:integer):string;
    function PROPER(S: string): string;
    procedure Run();
    procedure FormCreate(Sender: TObject);
    procedure PrintBClick(Sender:TObject); reintroduce;

  private
  { Private declarations }
    NalProdEd: string;
    Tr:Boolean;
    Sgs:Settings;
  public
  { Public declarations }
    function Rounding(Value:Currency):Currency; //     ..
    function kopeiki(Value:Currency):String;
    function IntToWords(Value:Integer;Genus:TGenus = masculine):String;
    function Pow(const Base:Integer; const Exponent:Byte):Int64;
    constructor Create(AOwner:TComponent;ASgs:Settings); overload;
  end;

var
  PrSumNds,PrVsego,PrSmall,Exsp: String;
  Cen4_1, Cen4_2 : TfrxMemoView;
  Memo6_3, Memo6_1, Memo6_4, Memo6_2, Sum6 : TfrxMemoView;
  NumberTTN, SeriaSecondPage, SumNDS_1,
  VsegoSNDS_3, VsegoSNDS_1, VsegoSNDS_2, Mest, MassaBrutto,
  NumNakl, Memo389, Memo388, Memo1,
  Memo338, Itog, KolProd, Stoimost, Stoimost2, DataDoc,
  SummNDS, VsSNDS, KolGrMest, MassBrutt, Zakazchik,
  Memo94, UNN_1 : TfrxMemoView;
  //===  ===//
  NamePredpr, NalProd, Memo59, Memo88, Memo89, Memo32, Memo33, Memo149, Memo159,
  Memo96, Memo300, Memo336, SumSumNDS, Memo35: TfrxMemoView;
  //===  ===//
  SumTov, SumTar, SumStTar, SumTovRozn, SumTarRozn, SumVsSNds : TfrxMemoView;
  Memo3, Memo4, Memo5, Memo6, Memo7, Memo118, Memo292,
  Memo51, Memo34, Memo57 : TfrxMemoView;

  MasterData1 : TfrxMasterData;
  DetailData1 : TfrxDetailData;
  VssndsInt, i, IdCheckNastrGrTov : integer;
  S : Currency;
  VssndsFloat:Currency;

implementation

uses Math, StrUtils;

{$R *.dfm}

var
  DllApp : TApplication;
  NumeralList:TList;
  MultiList:TList;

procedure TNaklForm.PrintBClick(Sender:TObject);
var
  key:Word;
begin
  key := ord('p');
  FormKeyDown(Sender, key, [ssCtrl]);
end;

constructor TNaklForm.Create(AOwner:TComponent;ASgs:Settings);
begin
  inherited Create(AOwner);

  Sgs := ASgs;
end;

procedure TNaklForm.Run();
var
  StText,StText2,SumNdsText,VsSNdsText,qwert:String;
  kolline,kolitog,i,a,z,GrPr:integer;
begin
   //   

   if Sgs.PRAll='' then
   begin
      PrCapQuery.Active:=False;
      PrCapQuery.ParamByName('IdDoc').Value:=Sgs.idDoc; // SklDM.DocQuery.FieldByName('IdDoc').Value;
      PrCapQuery.Active:=True;
   end;
   with PrCapQuery do
   begin
      Close;
      Params.ParamByName('idDoc').Value := Sgs.idDoc;
      Open;
   end;
   with PrstrQuery do
   begin
      ParamByName('IdDoc').Value:=Sgs.idDoc; //SklDm.DocQuery.FieldByName('idDoc').Value;
      Open;
   end;

   NameGrPrQuery.Active:=False;
   NameGrPrQuery.ParamByName('IdDoc').Value := Sgs.idDoc;
   NameGrPrQuery.Active:=True;
   if (NameGrPrQuery.FieldByName('NameGrPredpr').AsString)='' then
      Grpr:=1
   else
      GrPr:=0;
   SumBnsQuery.Active:=False;
   SumBnsQuery.ParamByName('IdDoc').Value := Sgs.idDoc;
   SumBnsQuery.Active:=True;
//===================//
//===  ===//
//===================//
   frxReport2.Variables['cp_Agreement']:=QuotedStr(Sgs.agreement);
   frxReport2.Variables['cp_RecCount']:=QuotedStr(intToStr(PrStrQuery.RecordCount));//frxReport1

   frxReport2.Variables['forSumNDS_1']:=QuotedStr(BoolToStr(Sgs.sumNDS));
   frxReport2.PrepareReport(True);

   frxReport2.Modified:=True;

//=====================//
//=== 1-  ===//
//=====================//

  with (frxReport2.FindObject('cp_Memo287') as TfrxMemoView) do
    Text:=Sgs.otpRaz;

   Zakazchik := frxReport2.FindObject('cp_Zakazchik') as TfrxMemoView;//frxReport1

   if Tr then
      frxReport2.Variables['cp_IdTrCheck']:=QuotedStr('1')//frxReport1
   else
      frxReport2.Variables['cp_IdTrCheck']:=QuotedStr('0');//frxReport1

   if Sgs.face then
      frxReport2.Variables['cp_IdF3Check']:=QuotedStr('1')//frxReport1
   else
      frxReport2.Variables['cp_IdF3Check']:=QuotedStr('0');//frxReport1

  with (frxReport2.FindObject('cp_Memo151') as TfrxMemoView) do
    Text:=Sgs.sposPogr;

  with (frxReport2.FindObject('cp_Memo161') as TfrxMemoView) do
    Text:=Sgs.sposRazgr;

  with (frxReport2.FindObject('cp_Memo152') as TfrxMemoView) do
    Text:=Sgs.vrPrib;

  with (frxReport2.FindObject('cp_Memo153') as TfrxMemoView) do
    Text:=Sgs.vrUb;

  with (frxReport2.FindObject('cp_Memo154') as TfrxMemoView) do
    Text:=Sgs.vrProst;

  with (frxReport2.FindObject('cp_Memo8') as TfrxMemoView) do
    Text:=Sgs.nomPric;

   with (frxReport2.FindObject('cp_Memo291') as TfrxMemoView) do
   if Sgs.MOLGruzPoluch<>'' then
      Text:='[frxDatasetPrCap."ProfMol1"]'+ Sgs.MOLGruzPoluch
   else
      Text:='[frxDatasetPrCap."Poluchat"]';

   Memo292 := frxReport2.FindObject('cp_Memo292') as TfrxMemoView;//frxReport1
   Memo118 := frxReport2.FindObject('cp_Memo118') as TfrxMemoView;//frxReport1
   if PrCapQuery.FieldByName('Dover').IsNull then
   begin
      Memo292.Text:='';
      Memo118.Text:='';
   end
   else
   begin
      with FioDovQuery do
      begin
         ParamByName('IdPredpr').Value:= PrCapQuery.FieldByName('idpredpr').Value;
         ExecSql;
         open;
      end;
      If FioDovquery.RecordCount=1 then
         Memo118.Text:='  '+Sgs.dateDov+'.  '+PrCapQuery.FieldByName('NamePlatPredpr').AsString+'  '+FioDovQuery.FieldByName('Fio').AsString
      else
         Memo118.Text:='  '+Sgs.dateDov+'.  '+PrCapQuery.FieldByName('NamePlatPredpr').AsString;
   end;
   if not (Sgs.face) then
   begin
      if Tr=True then
         Zakazchik.Text:=''
      else
         Zakazchik.Text:=''
   end
   else
      Zakazchik.Text:=PrCapQuery.FieldByName('NameF3Predpr').Value+
      ', '+PrCapQuery.FieldByName('IndexF3Predpr').Value+' '+{PrCapQuery.FieldByName('TownF3Predpr').Value +', '+} PrCapQuery.FieldByName('StHoFlF3Predpr').Value+' ;';

   SumNDS_1 := frxReport2.FindObject('cp_SumNDS_1') as TfrxMemoView;//frxReport1

   if not (Sgs.sumNDS) then
      SumNDS_1.Text:='[<frxDatasetPrCap."SumIncNDS">+<frxDatasetPrCap."SumNDSRozn">]'
   else
      SumNDS_1.Text:='[<frxDatasetPrCap."SumIncNDS">+<frxDatasetPrCap."SumNDS">]';

   SumNDS_1.GetData;
   SumNDS_1.Value:=SumNDS_1.Value+PrCapQuery.FieldByName('SumNdsBonus').Value;
   if SumNDS_1.Text<>'0' then
   begin
      S:=SumNDS_1.Value;
      SumNDS_1.Memo.Text:=PROPER(Propis(S,0))+'   '
      +Copy(SumNDS_1.Text, Pos(',', SumNDS_1.Text)+1, 2)+' .';
   end
   else
      SumNDS_1.Memo.Text:='';

   //-------------------//
   VsegoSNDS_1 := frxReport2.FindObject('cp_VsegoSNDS_1') as TfrxMemoView;//frxReport1
   VsegoSNDS_1.GetData;
   if VsegoSNDS_1.Memo.Text<>'0' then
   begin
     if not (Sgs.stoimost2_1) then
     begin
        if Sgs.sumNDS then
           VsegoSNDS_1.Value:=PrCapQuery.FieldByName('Itogo').AsFloat+PrCapQuery.FieldByName('SumNDS').AsFloat+SumBnsQuery.FieldByName('sumbns').AsFloat
        else
           VsegoSNDS_1.Value:=PrCapQuery.FieldByName('ItogoRoz').AsFloat
     end
     else
     begin
       if Sgs.sumNDS then
          VsegoSNDS_1.Value:=PrCapQuery.FieldByName('ItogoOO').AsFloat+PrCapQuery.FieldByName('SumNDS').AsFloat
       else
           VsegoSNDS_1.Value:=PrCapQuery.FieldByName('ItogoRoz').AsFloat
     end;
     S := VsegoSNDS_1.Value;

     VsegoSNDS_1.Memo.Text:=PROPER(Propis(S,0))+'   '
     +RightStr(CurrToStrF(S, ffNumber, 2) , 2) +' .';

   end
   else
      VsegoSNDS_1.Memo.Text:='';

   Mest := frxReport2.FindObject('cp_Mest') as TfrxMemoView;//frxReport1
   Mest.GetData;
   if Mest.Memo.Text<>'0' then
   begin
      S:=Mest.Value;
      Mest.Memo.Text:=Propis(S,2);
   end
   else
      Mest.Memo.Text:='';

   //-------------------//

   MassaBrutto := frxReport2.FindObject('cp_MassaBrutto') as TfrxMemoView;//frxReport1
   MassaBrutto.GetData;
   If (Sgs.PRAll<>' ') and (Sgs.vesTr<>'') then
      MassaBrutto.Memo.Text:=FloatToStr(StrToFloat(MassaBrutto.Memo.Text)+StrToFloat(Sgs.vesTr));
   if MassaBrutto.Memo.Text<>'0' then
   begin
      S:=MassaBrutto.Value;
      MassaBrutto.Memo.Text:= IntToWords(Trunc(s))+'  '+IntToWords((Trunc(s*1000) mod 1000) div 1)+' ';
   end
   else
      MassaBrutto.Memo.Text:='';

   //-------------------//

   Memo338 := frxReport2.FindObject('cp_Memo338') as TfrxMemoView;//frxReport1
   Memo338.GetData;
   if NalProdEd<>'' then
      Memo338.Memo.Text:=FloatToStr(Rounding(StrToFloat( NalProdEd )*PrStrQuery.FieldByName('KolF').Value));
   if Memo338.Memo.Text='0' then
      Memo338.Memo.Text:='';

   //-------------------//

   UNN_1 := frxReport2.FindObject('cp_UNN_1') as TfrxMemoView;//frxReport1

   if Tr then
      UNN_1.Text:=PrCapQuery.FieldByName('UNNPlatPredpr').Value
   else
   begin
      if Sgs.face then
         UNN_1.Text:=PrCapQuery.FieldByName('UNNF3Predpr').Value
      else
         UNN_1.Text:=PrCapQuery.FieldByName('UNNPlatSkl').Value;
   end;

   //===    ===//
   NumberTTN := frxReport2.FindObject('cp_NumberTTN') as TfrxMemoView;//frxReport1
   If Sgs.PRAll<>' ' then
      NumberTTN.Text:=Sgs.TTN
   else
      NumberTTN.Text:=Sgs.numDoc;
   //===   ===//
  with (frxReport2.FindObject('cp_Seria') as TfrxMemoView) do
    if Sgs.seria<>'' then
      Memo.Text:=Sgs.seria;
   //===    ===//
  with (frxReport2.FindObject('cp_Pogr') as TfrxMemoView) do
    if (Sgs.pogr='') or (SGs.pogr=' ') or (Sgs.pogr='  ') or (Sgs.pogr='   ') then
      Text:=PrCapQuery.FieldByName('TownSkl').Value+', '+PrCapQuery.FieldByName('StHoFlSkl').Value
    else
      Memo.Text:=Sgs.pogr;
   //===    ===//
  with (frxReport2.FindObject('cp_Razgr') as TfrxMemoView) do
    if (Sgs.razg='') or (Sgs.razg=' ') or (Sgs.razg='  ') or (Sgs.razg='   ') then
      Text:=PrCapQuery.FieldByName('TownPredpr').Value+', '+PrCapQuery.FieldByName('StHoFlPredpr').Value
    else
      Memo.Text:=Sgs.razg;
   //===    ===//
  with (frxReport2.FindObject('cp_PriborMemo') as TfrxMemoView) do
    if Sgs.vidPer<>'' then
      Memo.Text:='   ( )    '+Sgs.vidPer;

   //===   ===//
   with (frxReport2.FindObject('cp_Primechanie') as TfrxMemoView) do
   if Sgs.prim<>'' then
      Memo.Text:=Sgs.prim;

   //==================================//

   Itog := frxReport2.FindObject('cp_Itog') as TfrxMemoView;//frxReport1
   if Sgs.PRAll<>'*' then
      Itog.Memo.Text:=' :'
   else
      Itog.Memo.Text:='  :';


   KolProd := frxReport2.FindObject('cp_KolProd') as TfrxMemoView;//frxReport1
   KolProd.GetData;
   if KolProd.Value='0' then
      KolProd.Memo.Text:='';

   Stoimost := frxReport2.FindObject('cp_Stoimost') as TfrxMemoView;//frxReport1
   Stoimost.GetData;
   if Sgs.stoimost2_1 then  //PrCenPriobr
   begin
      if Sgs.sumNDS then
         Stoimost.Text:=kopeiki(PrCapQuery.FieldByName('ItogoOO').AsFloat)
      else
         Stoimost.Text:=kopeiki(PrCapQuery.FieldByName('ItogoRoz').AsFloat)
   end
   else
   begin
      if Sgs.sumNDS then  //PrCenO
         Stoimost.Text:= kopeiki(PrCapQuery.FieldByName('Itogo').AsFloat+SumBnsQuery.FieldByName('sumbns').AsFloat)
      else
         Stoimost.Text:=kopeiki(PrCapQuery.FieldByName('ItogoRoz').AsFloat)
   end;

   Stoimost2 := frxReport2.FindObject('cp_Stoimost2') as TfrxMemoView;//frxReport1
   if Sgs.sumNDS and Sgs.stoimost2_2 then
      Stoimost2.Text:=kopeiki(Rounding(PrCapQuery.FieldByName('ItogoRoz').AsFloat));
   Stoimost2.GetData;

   StText2 := Stoimost2.Text;

   SummNDS := frxReport2.FindObject('cp_SummNDS') as TfrxMemoView;//frxReport1
   if not Sgs.sumNDS then
      SummNDS.Text:='[<frxDatasetPrCap."SumIncNDS">+<frxDatasetPrCap."SumNDSRozn">]'
   else
      SummNDS.Text:='[<frxDatasetPrCap."SumIncNDS">+<frxDatasetPrCap."SumNDS">]';

   SummNDS.GetData;
   if Sgs.PRAll<>'*' then
   begin
      SummNDS.Value:=SummNDS.Value+PrCapQuery.FieldByName('SumNdsBonus').Value;
      SummNDS.Value:=kopeiki(Rounding(StrToFloat(SummNDS.Value)));
      if SummNDS.Text<>' ' then
         SummNDS.Text:=kopeiki(Rounding(StrToFloat(SummNDS.Value)));
      if SummNDS.Text='0' then
         SummNDS.Text:='';
   end
   else
      SummNDS.Value:='';

   SumNdsText := SummNDS.Text;

   Memo51 := frxReport2.FindObject('cp_Memo51') as TfrxMemoView;//frxReport1
   if not Sgs.sumNDS then
      Memo51.Text:='[frxDatasetPrCap."SumNDSRozn"]'
   else
      Memo51.Text:='[frxDatasetPrCap."SumNDS"]';

   Memo57 := frxReport2.FindObject('cp_Memo57') as TfrxMemoView;//frxReport1
   Memo57.Text:='[frxDatasetPrCap."SumSkid"]';

   VsSNDS := frxReport2.FindObject('cp_VsSNDS') as TfrxMemoView;//frxReport1
   if Sgs.stoimost2_1 then
      if Sgs.sumNDS then
         VsSNDS.Text:=kopeiki(PrCapQuery.FieldByName('ItogoOO').AsFloat+PrCapQuery.FieldByName('SumNDS').AsFloat)
      else
         VsSNDS.Text:=kopeiki(PrCapQuery.FieldByName('ItogoRoz').AsFloat)
   else
      if Sgs.sumNDS then
         VsSNDS.Text:=kopeiki(PrCapQuery.FieldByName('Itogo').AsFloat+PrCapQuery.FieldByName('SumNDS').AsFloat+SumBnsQuery.FieldByName('sumbns').AsFloat)
      else
         VsSNDS.Text:=kopeiki(PrCapQuery.FieldByName('ItogoRoz').AsFloat);
   VsSNdsText := VsSNDS.Text;
   KolGrMest := frxReport2.FindObject('cp_KolGrMest') as TfrxMemoView;//frxReport1
   KolGrMest.GetData;
   //=== Kol-vo naimenovaniy ===//
   Memo1 := frxReport2.FindObject('Memo1') as TfrxMemoView;
   Memo1.Text:='[Line]';
   Memo1.GetData;
   kolline:=Memo1.Value;
   Memo1.Text:='[Line]';

//=== Kol-vo stranic ===//

   MassBrutt := frxReport2.FindObject('cp_MassBrutt') as TfrxMemoView;//frxReport1
   MassBrutt.GetData;
   If (Sgs.PRAll<>' ') and (Sgs.vesTr<>'') then
   begin
      if MassBrutt.Value<>'' then
         MassBrutt.Value:=FloatToStr(StrToFloat(MassBrutt.Value)+StrToFloat(Sgs.vesTr))
      else
         MassBrutt.Value:=Sgs.vesTr;
   end;

//============//
//=== ===//
//============//
   SumTov := frxReport2.FindObject('cp_SumTov') as TfrxMemoView;//frxReport1
   if Sgs.PRAll='*' then
      SumTov.Text:='';
   SumTov.Text:='[frxDatasetPrCap."ItogoTov"]';
   SumTov.GetData;
   if SumTov.Value='0' then
      SumTov.Text:='';

   SumTar := frxReport2.FindObject('cp_SumTar') as TfrxMemoView;//frxReport1
   SumTar.GetData;
   if Sgs.PRAll='*' then
      SumTar.Text:='';
   if SumTar.Value='0' then
      SumTar.Text:='';

   SumStTar := frxReport2.FindObject('cp_SumStTar') as TfrxMemoView;//frxReport1
   SumStTar.GetData;
   if Sgs.PRAll='*' then
      SumStTar.Text:='';
   if SumStTar.Value='0' then
      SumStTar.Text:='';

   SumTovRozn := frxReport2.FindObject('cp_SumTovRozn') as TfrxMemoView;//frxReport1
   SumTovRozn.GetData;
   if Sgs.PRAll='*' then
      SumTovRozn.Text:='';
   if SumTovRozn.Value='0' then
      SumTovRozn.Text:='';
   if SumTovRozn.Value <> 0 then
   begin
      if SGs.stoimost2_2 then
         SumTovRozn.Value := SumTovRozn.Value
      else
         SumTovRozn.Text:='';
   end;

   SumTarRozn := frxReport2.FindObject('cp_SumTarRozn') as TfrxMemoView;//frxReport1
   if Sgs.PRAll='*' then
      SumTarRozn.Text:='';
   if SumTarRozn.Value='0' then
      SumTarRozn.Text:='';
   if SumTarRozn.Value <> '' then
   begin
      if Sgs.stoimost2_2 then
         SumTarRozn.Value := SumTarRozn.Value
      else
         SumTarRozn.Text:='';
   end;

//===================//
//=== : ===//
//===================//

//============================//
//=== : 1-  ===//
//============================//

   //frxReport1.ShowReport(true);

//=====================//
//=== 2-  ===//
//=====================//
   frxReport2.Variables['NameGrPr']:=GrPr;
   if Sgs.trPredpr then
   begin
      frxReport2.Variables['cp_forTrPredpr']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['forTrPredpr']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['forTrPredpr']:=QuotedStr('0');
      frxReport2.Variables['forTrPredpr']:=QuotedStr('0');
   end;

   if Sgs.nastrGrTov then
   begin
      frxReport2.Variables['cp_IdCheckNastrGrTov']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['IdCheckNastrGrTov']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_IdCheckNastrGrTov']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['IdCheckNastrGrTov']:=QuotedStr('0');
   end;

//===============================//
//===     ===//
//===============================//
//======================================//
//=== :     ===//
//======================================//

//==============================================//
//=== :    ===//
//==============================================//
   Memo88 := frxReport2.FindObject('Memo88') as TfrxMemoView;
   Memo88.Text:='[frxDatasetPrStr."EdIz"]';
   Memo32 := frxReport2.FindObject('Memo32') as TfrxMemoView;
   Memo32.Text:='[frxDatasetPrStr."EdIzDop"]';
   Memo96 := frxReport2.FindObject('Memo96') as TfrxMemoView;
   Memo96.Text:='[IIF(<frxDatasetPrStr."KolM"><>0,<frxDatasetPrStr."KolM">,'+chr(39)+chr(39)+')]';
   Memo300 := frxReport2.FindObject('Memo300') as TfrxMemoView;
   if SGs.stoimost and Sgs.sumNDS and Sgs.cenTr and not Sgs.vsegoSNDS
                              and not Sgs.stoimost2_2 and not Sgs.procTr and not Sgs.cenWNal
                              and not Sgs.stoimost2_1 and not Sgs.cenPriobr then
      Memo300.Text:='[<frxDatasetPrStr."Art">+IIF(<frxDatasetPrStr."CenPor"><>0,'+chr(39)+'   '+chr(39)+'+FloatToStr(<frxDatasetPrStr."CenPor">)+'+chr(39)+' -  '+chr(39)+'+FloatToStr(<frxDatasetPrStr."KolPor">),IIF((<frxDatasetPrStr."CenSt"><>0) and (<frxDatasetPrStr."KodGr"><>15),'+chr(39)+chr(39)+',IIF(<frxDatasetPrStr."Sort">='+chr(39)+chr(39)+','+chr(39)+chr(39)+','+chr(39)+'  '+chr(39)+')+<frxDatasetPrStr."Sort">))+'+chr(39)+'  '+chr(39)+'+'
   else
      Memo300.Text:='[<frxDatasetPrStr."Art">+IIF(<frxDatasetPrStr."Sort">='+chr(39)+chr(39)+','+chr(39)+chr(39)+','+chr(39)+'  '+chr(39)+'+<frxDatasetPrStr."Sort">)+'+chr(39)+'  '+chr(39)+'+ IIF(<frxDatasetPrStr."CenPor"><>0,'+chr(39)+'   '+chr(39)+'+FloatToStr(<frxDatasetPrStr."CenPor">)+'+chr(39)+' -  '+chr(39)+'+FloatToStr(<frxDatasetPrStr."KolPor">),IIF((<frxDatasetPrStr."CenSt"><>0) and (<frxDatasetPrStr."PNTTAR1"><>0),'+chr(39)+'    '+chr(39)+'+FloatToStr(<frxDatasetPrStr."CenSt">),IIF((<frxDatasetPrStr."CenSt"><>0) and (<frxDatasetPrStr."PNTTar3"><>0),'+chr(39)+'   '+chr(39)+'+FloatToStr(<frxDatasetPrStr."CenSt">)+'+chr(39)+' *** '+chr(39)+','+chr(39)+chr(39)+')))+'+chr(39)+'  '+chr(39)+'+';

   Memo300.Text:=Memo300.Text+'IIF(<frxDatasetPrStr."Model"><>'+chr(39)+chr(39)+','+chr(39)+'  '+chr(39)+'+<frxDatasetPrStr."Model">,'+chr(39)+chr(39)+')+IIF(<frxDatasetPrStr."Sizes"><>'+chr(39)+chr(39)+','+chr(39)+'  '+chr(39)+'+<frxDatasetPrStr."Sizes">,'+chr(39)+chr(39)+')+IIF(<frxDatasetPrStr."Hight"><>'+chr(39)+chr(39)+','+chr(39)+'  '+chr(39)+'+<frxDatasetPrStr."Hight">,'+chr(39)+chr(39)+')+';
   Memo300.Text:=Memo300.Text+'IIF(<frxDatasetPrStr."Sertif"><>'+chr(39)+chr(39)+',<frxDatasetPrStr."Sertif">,'+chr(39)+chr(39)+')+'+chr(39)+'  '+chr(39)+'+IIF(<frxDatasetPrStr."Sertif1"><>'+chr(39)+chr(39)+',<frxDatasetPrStr."Sertif1">,'+chr(39)+chr(39)+')+'+chr(39)+' '+chr(39)+'+IIF(<frxDatasetPrStr."Sertif2"><>'+chr(39)+chr(39)+',<frxDatasetPrStr."Sertif2">,'+chr(39)+chr(39)+')+'+chr(39)+' '+chr(39)+ '+IIF(<frxDatasetPrStr."Protkl"><>'+chr(39)+chr(39)+','+chr(39)+' .  '+chr(39)+'+<frxDatasetPrStr."Protkl">,'+chr(39)+chr(39)+')]';

   if Sgs.stoimost and Sgs.sumNDS and Sgs.cenTr and not Sgs.vsegoSNDS
                              and not Sgs.stoimost2_2 and not Sgs.procTr and not Sgs.cenWNal
                              and not Sgs.stoimost2_1 and not Sgs.cenPriobr then
      frxReport2.Variables['VernutTaru']:=QuotedStr('0')
   else
      frxReport2.Variables['VernutTaru']:=QuotedStr('1');


//===   9-  ===//
   SumVsSNds := frxReport2.FindObject('SumVsSNds') as TfrxMemoView;
//=== :   9-  ===//

//===   6-  ===//
//=== :   6-  ===//


   NamePredpr := frxReport2.FindObject('NamePredpr') as TfrxMemoView;
   NamePredpr.Text:='[IIF(<frxDatasetPrStr."NamePredpr"><>'+chr(39)+chr(39)+',<frxDatasetPrStr."NamePredpr">,IIF(<frxDatasetPrStr."NameCountry"><>'+chr(39)+chr(39)+',<frxDatasetPrStr."NameCountry">,'+chr(39)+chr(39)+'))]';
   NalProd := frxReport2.FindObject('NalProd') as TfrxMemoView;
   Cen4_1 := frxReport2.FindObject('Cen4_1') as TfrxMemoView;
   Cen4_2 := frxReport2.FindObject('Cen4_2') as TfrxMemoView;
//===6===//
   Memo6_1 := frxReport2.FindObject('Memo6_1') as TfrxMemoView;
   Memo6_2 := frxReport2.FindObject('Memo6_2') as TfrxMemoView;
   Memo6_3 := frxReport2.FindObject('Memo6_3') as TfrxMemoView;
   Memo6_4 := frxReport2.FindObject('Memo6_4') as TfrxMemoView;

   if Sgs.sumNDS then// ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_ONds')
   begin
      frxReport2.Variables['cp_Pr_ONds']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_ONds']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_ONds']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_ONds']:=QuotedStr('0');
   end;

   if Sgs.vsegoSNDS then// ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_RNds')
   begin
      frxReport2.Variables['cp_Pr_RNds']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_RNds']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_RNds']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_RNds']:=QuotedStr('0');
   end;

   if Sgs.stoimost2_2 // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_CenRoz'))
   then begin
      frxReport2.Variables['cp_Pr_CenRoz']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_CenRoz']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_CenRoz']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_CenRoz']:=QuotedStr('0');
   end;

   if Sgs.stoimost // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_CenOpt'))
   then begin
      frxReport2.Variables['cp_Pr_CenOpt']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_CenOpt']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_CenOpt']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_CenOpt']:=QuotedStr('0');
   end;

   if Sgs.cenPriobr // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_CenPriobr'))
   then begin
      frxReport2.Variables['cp_Pr_CenPriobr']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_CenPriobr']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_CenPriobr']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_CenPriobr']:=QuotedStr('0');
   end;

   if Sgs.cenTr // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_CenTr'))
   then begin
      frxReport2.Variables['cp_Pr_CenTr']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_CenTr']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_CenTr']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_CenTr']:=QuotedStr('0');
   end;

   if Sgs.procTr // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_ProcTr'))
   then begin
      frxReport2.Variables['cp_Pr_ProcTr']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_ProcTr']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_ProcTr']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_ProcTr']:=QuotedStr('0');
   end;

   if Sgs.cenWNal // (ReturnTypeFieldP(SklDM.DocQueryKodSkl.Value,'Pr_CenWNal'))
   then begin
      frxReport2.Variables['cp_Pr_CenWNal']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_CenWNal']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_CenWNal']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_CenWNal']:=QuotedStr('0');
   end;

   if Sgs.stoimost2_1 // (ReturnTypeFieldN(SklDM.DocQueryKodSkl.Value,'Pr_SchCenPriobr'))
   then begin
      frxReport2.Variables['cp_Pr_SchCenPriobr']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['Pr_SchCenPriobr']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_Pr_SchCenPriobr']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['Pr_SchCenPriobr']:=QuotedStr('0');
   end;

   if Sgs.PRAll='*'
   then begin
      frxReport2.Variables['cp_PrAll']:=QuotedStr('1');//frxReport1
      frxReport2.Variables['PrAll']:=QuotedStr('1');
   end
   else
   begin
      frxReport2.Variables['cp_PrAll']:=QuotedStr('0');//frxReport1
      frxReport2.Variables['PrAll']:=QuotedStr('0');
   end;

//============================================================//
//=== : ,   Memo   ===//
//============================================================//

   NumNakl := frxReport2.FindObject('NumNakl') as TfrxMemoView;
   If Sgs.PRAll<>' ' then
      NumNakl.Memo.Text:= Sgs.TTN
   else
      NumNakl.Memo.Text:=Sgs.numDoc;

   SeriaSecondPage := frxReport2.FindObject('SeriaSecondPage') as TfrxMemoView;
   if Sgs.seria<>'' then
      SeriaSecondPage.Text:=Sgs.seria;

   Memo3 := frxReport2.FindObject('Memo3') as TfrxMemoView;
   Memo4 := frxReport2.FindObject('Memo4') as TfrxMemoView;
   Memo5 := frxReport2.FindObject('Memo5') as TfrxMemoView;
   Memo6 := frxReport2.FindObject('Memo6') as TfrxMemoView;
   Memo7 := frxReport2.FindObject('Memo7') as TfrxMemoView;

   if (PrCapQuery.FieldByName('SumBns').Value<>0) then
      Memo3.Text:='';

   if (PrCapQuery.FieldByName('SumBns').Value<>0) then
      Memo4.Text:=FloatToStr(PrCapQuery.FieldByName('SumBns').AsFloat);

   if (PrCapQuery.FieldByName('SumBns').Value<>0) then
      Memo5.Text:=FloatToStr(PrCapQuery.FieldByName('NdsBns').AsFloat);

   if (PrCapQuery.FieldByName('SumBns').Value<>0) then
      Memo6.Text:=FloatToStr(PrCapQuery.FieldByName('SumNdsBonus').AsFloat);

   if (PrCapQuery.FieldByName('SumBns').Value<>0) then
      Memo7.Text:=FloatToStr(PrCapQuery.FieldByName('SumBns').AsFloat);

   frxReport2.ShowReport(True);
   //frxReport2.ShowPreparedReport;

end;

procedure TNaklForm.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  Action:=caFree;
end;

//============================//
//===   ===//
//============================//

function TNaklForm.Propis(S:Currency;KK:Integer):string;
var
  S1:string;
  Rub:string;
  Kop:string;
  Prop:string;
  A1_1:string;
  A1_3:string;
  A4_6:string;
  A7_9:string;
  C:string;
begin
  C:='000000000000000';
  Prop:=' ';
  S1:=FloatToStrF(S,ffFixed,15,2);
  S1:=Copy(C,1,(15-length(S1)))+S1;
  Rub:=Copy(S1,1,12);
  Kop:=Copy(S1,14,2);
  A1_1:=Copy(Rub,1,3);
  A1_3:=Copy(Rub,4,3);
  A4_6:=Copy(Rub,7,3);
  A7_9:=Copy(Rub,10,3);
  If StrToInt(A1_1)>0 then
    Prop:=Num(A1_1,3);
  If StrToInt(A1_3)>0 then
    Prop:=Prop+Num(A1_3,1);
  If StrToInt(A4_6)>0 then
    Prop:=Prop+Num(A4_6,2);
  If StrToInt(A7_9)>0 then
    Prop:=Prop+Num(A7_9,0);
  if Length(Prop)=1 then
    Prop:='';
  if KK=0 then
    //Propis:=Prop+'  .'+ Kop+'  .'
    Propis:=Prop+'   '
  else
  begin
    if KK=1 then
      Propis:=Prop+'  '+ Kop
    else
      Propis:=Prop
  end;
end;

function TNaklForm.Num(Q:string;X:integer):string;
var
  I,J,K,L:integer;
  A:Array[1..9,1..5] of string;
begin
  A[1,1]:=' ';
  A[2,1]:=' ';
  A[3,1]:=' ';
  A[4,1]:=' ';
  A[5,1]:=' ';
  A[6,1]:=' ';
  A[7,1]:=' ';
  A[8,1]:=' ';
  A[9,1]:=' ';
  //*
  A[1,2]:=' ';
  A[2,2]:=' ';
  A[3,2]:=' ';
  A[4,2]:=' ';
  A[5,2]:=' ';
  A[6,2]:=' ';
  A[7,2]:=' ';
  A[8,2]:=' ';
  A[9,2]:=' ';
  //*
  A[1,3]:=' ';
  A[2,3]:=' ';
  A[3,3]:=' ';
  A[4,3]:=' ';
  A[5,3]:=' ';
  A[6,3]:=' ';
  A[7,3]:=' ';
  A[8,3]:=' ';
  A[9,3]:=' ';
  //*
  A[1,4]:=' ';
  A[2,4]:=' ';
  A[3,4]:=' ';
  A[4,4]:=' ';
  A[5,4]:=' ';
  A[6,4]:=' ';
  A[7,4]:=' ';
  A[8,4]:=' ';
  A[9,4]:=' ';
  //*
  A[1,5]:=' ';
  A[2,5]:=' ';
  A[3,5]:=' ';
  A[4,5]:=' ';
  A[5,5]:=' ';
  A[6,5]:=' ';
  A[7,5]:=' ';
  A[8,5]:=' ';
  A[9,5]:=' ';
  Result:='';
  I:=StrToInt(Copy(Q,1,1));
  J:=StrToInt(Copy(Q,2,1));
  K:=StrToInt(Copy(Q,3,1));
  L:=StrToInt(Q);
  if I>0 then
    Result:=Result+A[I,1];
  if ((J>1) or ((J=1) and (K=0))) then
  begin
    Result:=Result+A[J,2];
    if K>0 then
      if X<>2 then
        Result:=Result+A[K,4]
      else
        Result:=Result+A[K,5];
  end;
  if ((J=1) and (K>0)) then
    Result:=Result+A[K,3];
  if ((J=0) and (K>0)) then
    if X<>2 then
      Result:=Result+A[K,4]
    else
      Result:=Result+A[K,5];
  if X=3 then
  begin
    if L>0 then
      Result:=Result+' ';
    if (((L>4) and (L<21)) or (K>4) or ((J=0) and (K=0))) then
      Result:=Result+''
    else
      if ((K>=2) and (K<=4)) then
        Result:=Result+'';
  end;
  if X=1 then
  begin
    if L>0 then
      Result:=Result+' ';
    if (((L>4) and (L<21)) or (K>4) or ((J=0) and (K=0))) then
      Result:=Result+''
    else
      if ((K>=2) and (K<=4)) then
        Result:=Result+'';
  end;
  if X=2 then
  begin
    if L>0 then
      Result:=Result+' ';
    if ((K=1) and ((L<9) or (L>20))) then
      Result:=Result+''
    else
      if (((K>1) and (K<5))and((L<9) or (L>20))and (J<>1)) then
        Result:=Result+'';
  end;
end;

function TNaklForm.PROPER(S: string): string;
var
  X: Integer;
begin
  Result := '';
  if Length(s) = 0 then
    exit;
  for X := 1 to length(s) do
    if s[x]<>' ' then
    begin
      S[x] := AnsiUpperCase(s[x])[1];
      Break;
    end;
  Result := S;
end;

function TNaklForm.Rounding(Value:Currency):Currency; //     ..
begin
  Result := Trunc(Value*100+0.5)/100;
end;

function TNaklForm.kopeiki(Value:Currency):String; //    
begin
   //Result := IntToStr(Trunc(Value))+','+Copy(FloatToStr(Frac(Value))+'000',3,2)
   Result := FormatCurr('#0.00#',Value);
end;

function TNaklForm.Pow(const Base:Integer; const Exponent:Byte):Int64;
var
  i:Byte;
begin
  Result := 1;
  for i:=1 to Exponent do
  begin
    Result := Result * Base;
  end;
end;

constructor TNumeral.Create(const Category: TCategory;
                            const Range: TRange;
                            const Word: String;
                            const Genus: TGenus = masculine);
begin
  Self.C := Category;
  Self.R := Range;
  Self.W := Word;
  Self.G := Genus;
end;

constructor TMultiplicity.Create(const Category: TCategory;
                                 const Occasion: TOccasion;
                                 const Word: String);
begin
  Self.C := Category;
  Self.O := Occasion;
  Self.W := Word;
end;

function TNaklForm.IntToWords(Value:Integer;Genus:TGenus = masculine):String;
var
  z,x,c,i,j,r,temp,offset,i_:Integer;
  g:TGenus;
  tempStr:String;
  flag:Boolean;
begin
   if Value = 0 then
      Result := ''
   else
   begin
      Result := NullAsStringValue;
      for c:=0 to 3 do
      Begin
         offset := c*3;
         x:=3;
         tempStr := NullAsStringValue;
         flag := False;
         for z:=2 downto 0 do
         begin
            temp := (Value mod Pow(10,x+offset)) div Pow(10,z+offset);
            if temp = 0 then
            begin
               Dec(x);
               Continue;
            end
            else
            begin
               flag := True;
               i_ := -1;
               CASE c of
               0 : g := Genus;
               1 : g := feminine
               else
                   g := masculine;
               end;
               for i:=0 to NumeralList.Count-1 do
                  if (TNumeral(NumeralList.Items[i]).Range = temp) and
                  (TNumeral(NumeralList.Items[i]).Category = x) then
                  begin
                     i_ := i;
                     if (TNumeral(NumeralList.Items[i]).Genus = g) then
                        Break;
                  end;
               if i_ <> -1 then
               begin
                  tempStr := tempStr + TNumeral(NumeralList.Items[i_]).Word;
                  if z<>0 then
                     tempStr := tempStr + ' ';
                  Dec(x);
               end;
            end;
         end;

         if flag then
         begin
            CASE temp of
               1    : r := 1;
               2..4 : r := 2
            else
               r := 3;
            end;
            for j:=0 to MultiList.Count-1 do
               if (TMultiplicity(MultiList.Items[j]).Occasion = r) and
               (TMultiplicity(MultiList.Items[j]).Category = c) then
                  tempStr := tempStr+' '+TMultiplicity(MultiList.Items[j]).Word;
         end;

         Result := tempStr+' '+Result;
      End;
   end;   
end;

procedure TNaklForm.FormCreate(Sender: TObject);
begin
  frxReport2.Preview := Preview;
  inherited;

  with mdb do
  begin
    Connected:=False;
    AliasName:=Sgs.aliasName;
    Params.Strings[0]:= Sgs.login;
    Params.Strings[1]:= Sgs.password;
    Connected:=True;
  end;

  frxReport2.PrintOptions.Copies := Sgs.copies;
  WindowState := wsMaximized;

  Run;
end;

initialization

NumeralList := TList.Create();
NumeralList.Add(TNumeral.Create(1,0,''));
NumeralList.Add(TNumeral.Create(1,1,''));
NumeralList.Add(TNumeral.Create(1,1,'',neuter));
NumeralList.Add(TNumeral.Create(1,1,'',feminine));
NumeralList.Add(TNumeral.Create(1,2,''));
NumeralList.Add(TNumeral.Create(1,2,'',feminine));
NumeralList.Add(TNumeral.Create(1,3,''));
NumeralList.Add(TNumeral.Create(1,4,''));
NumeralList.Add(TNumeral.Create(1,5,''));
NumeralList.Add(TNumeral.Create(1,6,''));
NumeralList.Add(TNumeral.Create(1,7,''));
NumeralList.Add(TNumeral.Create(1,8,''));
NumeralList.Add(TNumeral.Create(1,9,''));
NumeralList.Add(TNumeral.Create(2,10,''));
NumeralList.Add(TNumeral.Create(2,11,''));
NumeralList.Add(TNumeral.Create(2,12,''));
NumeralList.Add(TNumeral.Create(2,13,''));
NumeralList.Add(TNumeral.Create(2,14,''));
NumeralList.Add(TNumeral.Create(2,15,''));
NumeralList.Add(TNumeral.Create(2,16,''));
NumeralList.Add(TNumeral.Create(2,17,''));
NumeralList.Add(TNumeral.Create(2,18,''));
NumeralList.Add(TNumeral.Create(2,19,''));
NumeralList.Add(TNumeral.Create(2,2,''));
NumeralList.Add(TNumeral.Create(2,3,''));
NumeralList.Add(TNumeral.Create(2,4,''));
NumeralList.Add(TNumeral.Create(2,5,''));
NumeralList.Add(TNumeral.Create(2,6,''));
NumeralList.Add(TNumeral.Create(2,7,''));
NumeralList.Add(TNumeral.Create(2,8,''));
NumeralList.Add(TNumeral.Create(2,9,''));
NumeralList.Add(TNumeral.Create(3,1,''));
NumeralList.Add(TNumeral.Create(3,2,''));
NumeralList.Add(TNumeral.Create(3,3,''));
NumeralList.Add(TNumeral.Create(3,4,''));
NumeralList.Add(TNumeral.Create(3,5,''));
NumeralList.Add(TNumeral.Create(3,6,''));
NumeralList.Add(TNumeral.Create(3,7,''));
NumeralList.Add(TNumeral.Create(3,8,''));
NumeralList.Add(TNumeral.Create(3,9,''));

MultiList := TList.Create();
MultiList.Add(TMultiplicity.Create(1,3,''));
MultiList.Add(TMultiplicity.Create(1,2,''));
MultiList.Add(TMultiplicity.Create(1,1,''));
MultiList.Add(TMultiplicity.Create(2,3,''));
MultiList.Add(TMultiplicity.Create(2,2,''));
MultiList.Add(TMultiplicity.Create(2,1,''));
MultiList.Add(TMultiplicity.Create(3,3,''));
MultiList.Add(TMultiplicity.Create(3,2,''));
MultiList.Add(TMultiplicity.Create(3,1,''));

end.

