library NaklPrj;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as eters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Forms,
  Windows,
  Variants,
  Dialogs,
  StdCtrls,
  DBTables,
  NaklUnit in 'NaklUnit.pas' {NaklForm};

{$R *.res}

var
   DllApp : TApplication;
   NaklForm:TNaklForm;
   
Procedure DllEntryPoint(Reason : Integer);
Begin
   if Reason = DLL_PROCESS_DETACH then
   begin
      try
         if Assigned(NaklForm) then
         begin
            NaklForm.Free;
            NaklForm:=nil;
         end;
      finally
         if Assigned(DllApp) then
            Application := DllApp;
      end;
   end;
End;

Procedure ShowBegRepForm(
  App : TApplication;
  MyforReturnTypeTrPredpr:Boolean;
  MyforOtpRaz:String;
  FormyTrCheckBox:Boolean;
  MyforSumNDS_1:Boolean;
  MyforVsegoSNDS_1:Boolean;
  MyforVesTrEdit:String;
  MyforTTNEdit:String;
  MyforNumDoc:String;
  MyforSeria:String;
  MyforPogr:String;
  MyforRazg:String;
  MyforVidPer:String;
  MyforPrim:String;
  MyforStoimost:Boolean;
  MyforStoimost2_1:Boolean;
  MyforStoimost2_2:Boolean;
  MyforCheckNastrGrTov:Boolean;
  MyforPr_CenPriobr:Boolean;
  MyforPr_CenTr:Boolean;
  MyforPr_ProcTr:Boolean;
  MyforPr_CenWNal:Boolean;
  MyforPRAll:String;
  MyforIdDoc:Integer;
  MyforAliasName:String;
  MyforLogin:String;
  MyforPassword:String;
  MyforCopyEdit:String;
  MyforFace3:Boolean;
  MyforDateDov:String;
  MyforVlTr:String;
  MyforSposPogr:String;
  MyforSposRazgr:String;
  MyforVrPrib:String;
  MyforVrUb:String;
  MyforVrProst:String;
  MyforMOLGruzPoluch:String;
  MyforNomPric:String;
  AAgreement:String);
var
  exSgs:Settings;
Begin
  if NaklForm <> nil then
    exit;
  if not Assigned(DllApp) then
  begin
    DllApp := Application;
    Application := App;
  end;
  try
    exSgs.trPredpr := MyforReturnTypeTrPredpr;
    exSgs.tr := FormyTrCheckBox;
    exSgs.sumNDS := MyforSumNDS_1;
    exSgs.vsegoSNDS := MyforVsegoSNDS_1;
    exSgs.stoimost := MyforStoimost;
    exSgs.stoimost2_1 := MyforStoimost2_1;
    exSgs.stoimost2_2 := MyforStoimost2_2;
    exSgs.nastrGrTov := MyforCheckNastrGrTov;
    exSgs.cenPriobr := MyforPr_CenPriobr;
    exSgs.cenTr := MyforPr_CenTr;
    exSgs.procTr := MyforPr_ProcTr;
    exSgs.cenWNal := MyforPr_CenWNal;
    exSgs.face := MyforFace3;

    exSgs.otpRaz := MyforOtpRaz;
    exSgs.vesTr:=MyforVesTrEdit;
    exSgs.TTN:=MyforTTNEdit;
    exSgs.numDoc:=MyforNumDoc;
    exSgs.seria:=MyforSeria;
    exSgs.pogr:=MyforPogr;
    exSgs.razg:=MyforRazg;
    exSgs.vidPer:=MyforVidPer;
    exSgs.prim:=MyforPrim;
    exSgs.PRAll:=MyforPRAll;
    exSgs.idDoc:=MyforIdDoc;
    exSgs.copies:=StrToInt(MyforCopyEdit);
    exSgs.dateDov:=MyforDateDov;
    exSgs.vlTr:=MyforVlTr;
    exSgs.sposPogr:=MyforSposPogr;
    exSgs.sposRazgr:=MyforSposRazgr;
    exSgs.vrPrib:=MyforVrPrib;
    exSgs.vrUb:=MyforVrUb;
    exSgs.vrProst:=MyforVrProst;
    exSgs.MOLGruzPoluch:=MyforMOLGruzPoluch;
    exSgs.nomPric:=MyforNomPric;
    exSgs.agreement := AAgreement;

    exSgs.aliasName := MyforAliasName;
    exSgs.login := MyforLogin;
    exSgs.password := MyforPassword;

    NaklForm := TNaklForm.Create(Application.MainForm, exSgs);
    //LockWindowUpdate(NaklForm.Handle); //(DllApp.Handle)

    NaklForm.Show;
    //NaklForm.Run;
  except
    on E : Exception do
      ShowMessage(E.ClassName+'    : '+E.Message);
  end;
End;

exports
   ShowBegRepForm;

begin
   DllProc := @DllEntryPoint;
end.
