﻿using System;
using System.Data;
using System.Windows.Forms;
using SHDocVw;
using mshtml;
using HtmlAgilityPack;
using System.Reflection;
using System.Threading;

namespace skko
{
    public partial class Form1 : Form
    {
        new private void DoubleBuffered(DataGridView DataGridView, bool Enable)
        {
            try
            {
                Cursor.Current = Cursors.WaitCursor;

                Type DataGridViewType = DataGridView.GetType();
                PropertyInfo PropertyInfo = DataGridViewType.GetProperty("DoubleBuffered", BindingFlags.Instance | BindingFlags.NonPublic);
                PropertyInfo.SetValue(DataGridView, Enable, null);

                Cursor.Current = Cursors.Default;
            }
            catch (Exception Ex)
            {
                Cursor.Current = Cursors.Default;

                MessageBox.Show(Ex.ToString());
            }
        }

        private object o = null;
        private InternetExplorer IE = new InternetExplorer();

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            DoubleBuffered(dataGridView1, true);
            DoubleBuffered(dataGridView2, true);
        }

        private void button1_Click(object sender, EventArgs e)
        {
            IWebBrowserApp wb = IE;
            wb.Visible = true; //necessary to launch IE
        }

        private void button2_Click(object sender, EventArgs e)
        {
            //datatable
            DataTable dt = new DataTable();
            dt.Columns.Add("Уникальный номер");
            dt.Columns.Add("Номер чека");
            dt.Columns.Add("Кассир");
            dt.Columns.Add("Дата и время выдачи платежного документа");
            dt.Columns.Add("Наименование (код) валюты");
            dt.Columns.Add("Итого общая стоимость услуг/товаров по платежному документу");
            dt.Columns.Add("Сумма скидки/наценки по платежному документу");
            dt.Columns.Add("Итого к оплате");
            dt.Columns.Add("Итого безналичными");
            dt.Columns.Add("Итого наличными");
            dt.Columns.Add("Итого другими способами оплаты");
            dt.Columns.Add(" ");
            dt.DefaultView.Sort = "Номер чека";
            DataTable dt2 = new DataTable();
            dt2.Columns.Add("Уникальный номер");
            dt2.Columns.Add("Номер чека");
            dt2.Columns.Add("EAN13");
            dt2.Columns.Add("Кол-во");
            dt2.Columns.Add("Сумма продажи");
            dt2.Columns.Add("Сумма скидки/наценки");
            dt2.DefaultView.Sort = "Номер чека";

            for (int j = 1; j <= Convert.ToInt32(textBox2.Text); j++)
            {
                if (j == 1)
                {
                    IE.Navigate("https://skko.by/core/cashbox/" + textBox1.Text + "/checks/?date=" + dateTimePicker1.Value.ToString("dd.MM.yyyy"), ref o, ref o, ref o, ref o);
                }
                else
                {
                    IE.Navigate("https://skko.by/core/cashbox/" + textBox1.Text + "/checks/?date=" + dateTimePicker1.Value.ToString("dd.MM.yyyy") + "&page=" + j, ref o, ref o, ref o, ref o);
                }

                while (IE.ReadyState != tagREADYSTATE.READYSTATE_COMPLETE)
                {
                    Cursor.Current = Cursors.WaitCursor;
                }
                Thread.Sleep(3333);

                IHTMLDocument2 htmldoc = IE.Document as IHTMLDocument2;
                string content = htmldoc.body.parentElement.outerHTML;
                richTextBox1.Text = content;

                HtmlAgilityPack.HtmlDocument doc = new HtmlAgilityPack.HtmlDocument();
                doc.LoadHtml(content);

                foreach (HtmlNode table in doc.DocumentNode.SelectNodes(xpath: "//div[@class='col-lg-8']/table/tbody"))
                {
                    //select table

                    foreach (HtmlNode row in table.SelectNodes("tr"))
                    {
                        //for each row
                        //row start
                        DataRow r = dt.NewRow();
                        int i = 0; //number of coulumnc inc

                        //without details
                        HtmlNodeCollection cells = row.SelectNodes("td[@class='hiddenCheck']/table[@class='table-no-border']/tbody/tr/td");

                        if (cells == null)
                            continue;

                        foreach (HtmlNode cell in cells)
                        {
                            r[i] = cell.InnerText;
                            i++;
                            //cell value
                        }

                        //row end
                        dt.Rows.Add(r);

                        foreach (HtmlNode row2 in table.SelectNodes("tr[@id='" + row.Attributes["id"].Value + "']/td[@class='hiddenCheck']/table[@class='table table-striped']/tbody/tr"))
                        {
                            //for each row
                            //row start
                            DataRow r2 = dt2.NewRow();
                            int i2; //number of coulumnc inc

                            //without ean
                            HtmlNodeCollection cells2 = row2.SelectNodes("td");

                            if (cells2 == null)
                                continue;

                            //уникальный номер и номер чека
                            r2[0] = r[0];
                            r2[1] = r[1];
                            i2 = 2;

                            foreach (HtmlNode cell2 in cells2)
                            {
                                r2[i2] = cell2.InnerText;

                                //remove whitespace from EAN13
                                if (i2 == 2)
                                    r2[i2] = cell2.InnerText.Replace(" ", "");

                                i2++;
                                //cell value
                            }

                            //row end
                            dt2.Rows.Add(r2);
                        }
                    }
                }
            }
            //data grid view
            dataGridView1.DataSource = dt;
            dataGridView2.DataSource = dt2;
        }
    }
}