﻿CREATE SEQUENCE SYSLOGSEQ_GEN INCREMENT BY 1 START WITH 1 CACHE 20;

CREATE TABLE ACCOUNTTYPE (
       ACCOUNTTYPEID        INTEGER NOT NULL,
       ACCOUNTTYPENAME      character varying(50) NOT NULL,
       ACCOUNTTYPEVALUE     INTEGER NOT NULL,
       ACCOUNTKINDVALUE     INTEGER NOT NULL,
       MAXCREDIT            DECIMAL(18,6) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ACCOUNTTYPE
       ADD CONSTRAINT XPKACCOUNTTYPE PRIMARY KEY (ACCOUNTTYPEID);


CREATE TABLE ART (
       ARTID                INTEGER NOT NULL,
       GRPID                INTEGER NOT NULL,
       OFFERID              INTEGER NULL,
       TAXGRPID             INTEGER NOT NULL,
       MODGRPID             INTEGER NULL,
       ARTCODE              INTEGER NOT NULL,
       COMPOSCARDID         INTEGER NULL,
       ARTNAME              character varying(50) NOT NULL,
       ARTSNAME             character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE UNIQUE INDEX XAK1ART ON ART
(
       ARTCODE                        ASC
);

CREATE INDEX IDX_ART_UN ON ART
(
       UPDATENUM                      ASC
);


ALTER TABLE ART
       ADD CONSTRAINT XPKART PRIMARY KEY (ARTID);


CREATE TABLE ARTEXTGRP (
       ARTID                INTEGER NOT NULL,
       EXTGRPID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ARTEXTGRP
       ADD CONSTRAINT XPKARTEXTGRP PRIMARY KEY (ARTID, EXTGRPID);


CREATE TABLE ARTHOTKEY (
       ARTHOTKEYID          INTEGER NOT NULL,
       ARTHOTKEYSETID       INTEGER NOT NULL,
       PACKID               INTEGER NULL,
       ARTHOTKEYSTROKE      character varying(30) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ARTHOTKEY
       ADD CONSTRAINT XPKARTHOTKEY PRIMARY KEY (ARTHOTKEYID);


CREATE TABLE ARTHOTKEYSET (
       ARTHOTKEYSETID       INTEGER NOT NULL,
       ARTHOTKEYSETNAME     character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ARTHOTKEYSET
       ADD CONSTRAINT XPKARTHOTKEYSET PRIMARY KEY (ARTHOTKEYSETID);


CREATE TABLE ARTMODGRP (
       ARTID                INTEGER NOT NULL,
       MODGRPID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ARTMODGRP
       ADD CONSTRAINT XPKARTMODGRP PRIMARY KEY (ARTID, MODGRPID);


CREATE TABLE ARTPRNGRP (
       ARTID                INTEGER NOT NULL,
       PRNGRPID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ARTPRNGRP
       ADD CONSTRAINT XPKARTPRNGRP PRIMARY KEY (ARTID, PRNGRPID);


CREATE TABLE ARTSDEPT (
       ARTID                INTEGER NOT NULL,
       SDEPTID              INTEGER NOT NULL,
       ARTNUM               INTEGER NULL,
       KEYID                INTEGER NULL,
       PACKSHELFLIFE        INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_ARTSDEPT_UN ON ARTSDEPT
(
       UPDATENUM                      ASC
);


ALTER TABLE ARTSDEPT
       ADD CONSTRAINT XPKARTSDEPT PRIMARY KEY (ARTID, SDEPTID);


CREATE TABLE AVANSREC (
       AVANSRECNUM          INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       CASHIERNAME          character varying(50) NOT NULL,
       AVANSRECTIME         character varying(14) NOT NULL,
       AVANSRECDATA         bytea NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            SMALLINT NOT NULL
);

CREATE INDEX XIE1AVANSREC ON AVANSREC
(
       AVANSRECTIME                   ASC
);

CREATE INDEX XIE2AVANSREC ON AVANSREC
(
       UPDATENUM                      ASC
);


ALTER TABLE AVANSREC
       ADD CONSTRAINT PK_AVANSREC PRIMARY KEY (AVANSRECNUM, SESSID, 
              SYSTEMID, SAREAID);


CREATE TABLE BACKACCOUNTTRANS (
       BACKACCOUNTTRANSID   character varying(36) NOT NULL,
       SAREAID              INTEGER NULL,
       SYSTEMID             INTEGER NULL,
       CLNTID               INTEGER NOT NULL,
       CURRENCYID           INTEGER NOT NULL,
       ACCOUNTTYPEID        INTEGER NOT NULL,
       TRANSTIME            character varying(14) NOT NULL,
       TRANSTYPE            INTEGER NOT NULL,
       TRANSSUM             DECIMAL(18,6) NOT NULL,
       AUTOCREATEACCOUNT    SMALLINT NOT NULL,
       ACCOUNTDOCSOURCE     INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_BACKACCOUNTTRANS_UN ON BACKACCOUNTTRANS
(
       UPDATENUM                      ASC
);

CREATE INDEX IDX_BACKACCOUNTTRANS_TYPE ON BACKACCOUNTTRANS
(
       TRANSTYPE                      ASC
);


ALTER TABLE BACKACCOUNTTRANS
       ADD CONSTRAINT XPKBACKACCOUNTTRANS PRIMARY KEY (
              BACKACCOUNTTRANSID);


CREATE TABLE BACKDIRS (
       DIRNAME              character varying(50) NOT NULL,
       FIELDNAME            character varying(50) NOT NULL,
       FIELDTYPE            INTEGER NOT NULL
);


ALTER TABLE BACKDIRS
       ADD CONSTRAINT XPKBACKDIRS PRIMARY KEY (DIRNAME);


CREATE TABLE BACKREQUEST (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTTYPE          INTEGER NOT NULL,
       REQUESTTIME          character varying(14) NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1BACKREQUEST ON BACKREQUEST
(
       UPDATENUM                      ASC
);


ALTER TABLE BACKREQUEST
       ADD CONSTRAINT XPKBACKREQUEST PRIMARY KEY (SAREAID, SYSTEMID, 
              REQUESTID);


CREATE TABLE BACKREQUESTITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTKEY           INTEGER NOT NULL,
       REQUESTVAL           character varying(1024) NULL,
       DELFLAG              INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1BACKREQUESTITEMS ON BACKREQUESTITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE BACKREQUESTITEMS
       ADD CONSTRAINT XPKBACKREQUESTITEMS PRIMARY KEY (SAREAID, 
              SYSTEMID, REQUESTID, REQUESTKEY);


CREATE TABLE BARC (
       BARCID               INTEGER NOT NULL,
       BARCNAME             character varying(50) NULL,
       BARCMASK             character varying(30) NOT NULL,
       PREFIXLEN            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE UNIQUE INDEX XAK1BARC ON BARC
(
       BARCMASK                       ASC
);


ALTER TABLE BARC
       ADD CONSTRAINT XPKBARC PRIMARY KEY (BARCID);


CREATE TABLE BINARYDATA (
       BINARYDATAID         INTEGER NOT NULL,
       BINARYDATAVALUE      bytea NULL,
       BYNARYDATANAME       character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE BINARYDATA
       ADD CONSTRAINT XPKBINARYDATA PRIMARY KEY (BINARYDATAID);


CREATE TABLE BINPROPERTY (
       BINPROPERTYKEY       INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NOT NULL,
       BINARYDATAID         INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE BINPROPERTY
       ADD CONSTRAINT XPKBINPROPERTY PRIMARY KEY (BINPROPERTYKEY, 
              PROPERTYGRPID);


CREATE TABLE BONUS (
       BONUSID              INTEGER NOT NULL,
       BONUSNAME            character varying(50) NOT NULL,
       BONUSVAL             character varying(512) NOT NULL,
       BONUSCOND            character varying(512) NULL,
       BONUSTIME            character varying(512) NULL,
       BONUSDATE            character varying(512) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE BONUS
       ADD CONSTRAINT XPKBONUS PRIMARY KEY (BONUSID);


CREATE TABLE BONUSOFFER (
       BONUSOFFERID         INTEGER NOT NULL,
       BONUSOFFERNAME       character varying(50) NOT NULL,
       BONUSOFFERVAL        character varying(512) NOT NULL,
       BONUSOFFERCOND       character varying(512) NULL,
       BONUSOFFERTIME       character varying(512) NULL,
       BONUSOFFERDATE       character varying(512) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE BONUSOFFER
       ADD CONSTRAINT XPKBONUSOFFER PRIMARY KEY (BONUSOFFERID);


CREATE TABLE CASHIER (
       CASHIERID            INTEGER NOT NULL,
       CASHIERGRPID         INTEGER NOT NULL,
       CASHIERKEY           character varying(50) NOT NULL,
       CASHIERNAME          character varying(50) NOT NULL,
       CASHIERDISABLED      SMALLINT NOT NULL,
       CASHIERSAREACONTROL  SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1CASHIER ON CASHIER
(
       CASHIERKEY                     ASC
);


ALTER TABLE CASHIER
       ADD CONSTRAINT XPKCASHIER PRIMARY KEY (CASHIERID);


CREATE TABLE CASHIERGRP (
       CASHIERGRPID         INTEGER NOT NULL,
       CASHIERGRPNAME       character varying(50) NOT NULL,
       CASHIERGRPDISABLED   SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHIERGRP
       ADD CONSTRAINT XPKCASHIERGRP PRIMARY KEY (CASHIERGRPID);


CREATE TABLE CASHIERPVG (
       CASHIERPVGKEY        INTEGER NOT NULL,
       CASHIERGRPID         INTEGER NOT NULL,
       CASHIERPVGVALUE      SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHIERPVG
       ADD CONSTRAINT XPKCASHIERPVG PRIMARY KEY (CASHIERPVGKEY, 
              CASHIERGRPID);


CREATE TABLE CASHIO (
       CASHIOID             INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       TXTBINID             INTEGER NULL,
       CASHIERID            INTEGER NULL,
       CASHIOSUM            DECIMAL(18,6) NULL,
       CASHIOFINAL          DECIMAL(18,6) NULL,
       CASHIOINP            SMALLINT NOT NULL,
       CASHIOTIME           character varying(14) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHIO
       ADD CONSTRAINT XPKCASHIO PRIMARY KEY (CASHIOID, SESSID, 
              SYSTEMID, SAREAID);


CREATE TABLE CASHPROFILE (
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILENAME      character varying(50) NOT NULL,
       SYSLOGPROFILEID      INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILE
       ADD CONSTRAINT XPKCASHPROFILE PRIMARY KEY (CASHPROFILEID);


CREATE TABLE CASHPROFILEBPVG (
       CASHPROFILEBPVGKEY   INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILEBPVGVALUE bytea NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILEBPVG
       ADD CONSTRAINT XPKCASHPROFILEBPVG PRIMARY KEY (
              CASHPROFILEBPVGKEY, CASHPROFILEID);


CREATE TABLE CASHPROFILECOLOR (
       CASHPROFILECOLORKEY  INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILECOLORVALUE INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILECOLOR
       ADD CONSTRAINT XPKCASHPROFILECOLOR PRIMARY KEY (
              CASHPROFILECOLORKEY, CASHPROFILEID);


CREATE TABLE CASHPROFILEKEY (
       CASHPROFILEKEYKEY    INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILEKEYVALUE  INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILEKEY
       ADD CONSTRAINT XPKCASHPROFILEKEY PRIMARY KEY (
              CASHPROFILEKEYKEY, CASHPROFILEID);


CREATE TABLE CASHPROFILEPVG (
       CASHPROFILEPVGKEY    INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILEPVGVALUE  INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILEPVG
       ADD CONSTRAINT XPKCASHPROFILEPVG PRIMARY KEY (
              CASHPROFILEPVGKEY, CASHPROFILEID);


CREATE TABLE CASHPROFILESPVG (
       CASHPROFILESPVGKEY   INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       CASHPROFILESPVGVALUE character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CASHPROFILESPVG
       ADD CONSTRAINT XPKCASHPROFILESPVG PRIMARY KEY (
              CASHPROFILESPVGKEY, CASHPROFILEID);


CREATE TABLE CLIENTACTIVITY (
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       EVENTCODE            INTEGER NOT NULL,
       EVENTTIME            character varying(14) NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CLIENTACTIVITY
       ADD CONSTRAINT XPKCLIENTACTIVITY PRIMARY KEY (SYSTEMID, 
              SAREAID, EVENTCODE);


CREATE TABLE CLNT (
       CLNTID               INTEGER NOT NULL,
       CLNTGRPID            INTEGER NOT NULL,
       COMPANYID            INTEGER NULL,
       PROPERTYGRPID        INTEGER NULL,
       CLNTNAME             character varying(50) NOT NULL,
       CLNTBIRTHDAY         character varying(14) NULL,
       LOCKED               SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       PRIMARYEMAIL         character varying(50) NULL,
       UPDATENUM            INTEGER NOT NULL,
       PRIMARYPHONE         character varying(50) NULL
);

CREATE INDEX IDX_CLNTUPDATENUM ON CLNT
(
       UPDATENUM                      ASC
);

CREATE INDEX IDX_CLNT_DF ON CLNT
(
       DELFLAG                        ASC
);


ALTER TABLE CLNT
       ADD CONSTRAINT XPKCLNT PRIMARY KEY (CLNTID);


CREATE TABLE CLNTFORM (
       CLNTFORMID           INTEGER NOT NULL,
       CLNTFORMNAME         character varying(50) NOT NULL,
       ORDERNUM             INTEGER NOT NULL,
       USESAREA             SMALLINT NOT NULL,
       ACTIVEFROM           character varying(14) NULL,
       ACTIVETO             character varying(14) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CLNTFORM
       ADD CONSTRAINT XPKCLNTFORM PRIMARY KEY (CLNTFORMID);


CREATE TABLE CLNTFORMITEMS (
       CLNTFORMID           INTEGER NOT NULL,
       CLNTFORMITEMID       INTEGER NOT NULL,
       CLNTFORMITEM         character varying(100) NOT NULL,
       ORDERNUM             INTEGER NOT NULL,
       ISREQUIRED           SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CLNTFORMITEMS
       ADD CONSTRAINT XPKCLNTFORMITEMS PRIMARY KEY (CLNTFORMID, 
              CLNTFORMITEMID);


CREATE TABLE CLNTFORMPROPERTY (
       CLNTID               INTEGER NOT NULL,
       CLNTFORMID           INTEGER NOT NULL,
       CLNTFORMITEMID       INTEGER NOT NULL,
       CLNTPROPERTYVAL      character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_CLNTFORMPROPERTY_UN ON CLNTFORMPROPERTY
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTFORMPROPERTY
       ADD CONSTRAINT XPKCLNTFORMPROPERTY PRIMARY KEY (CLNTID, 
              CLNTFORMID, CLNTFORMITEMID);


CREATE TABLE CLNTFORMRESULT (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       CLNTFORMID           INTEGER NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       FILLTIME             character varying(14) NOT NULL,
       CLNTID               INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1CLNTFORMRESULT ON CLNTFORMRESULT
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTFORMRESULT
       ADD CONSTRAINT XPKCLNTFORMRESULT PRIMARY KEY (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID);


CREATE TABLE CLNTFORMRESULTITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       CLNTFORMITEMID       INTEGER NOT NULL,
       CLNTFORMITEMVAL      character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1CLNTFORMRESULTITEMS ON CLNTFORMRESULTITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTFORMRESULTITEMS
       ADD CONSTRAINT XPKCLNTFORMRESULTITEMS PRIMARY KEY (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID, CLNTFORMITEMID);


CREATE TABLE CLNTGRP (
       CLNTGRPID            INTEGER NOT NULL,
       DISCID               INTEGER NULL,
       BONUSID              INTEGER NULL,
       CLNTGRPNAME          character varying(50) NOT NULL,
       CLNTGRPMANUAL        SMALLINT NOT NULL,
       CLNTGRPTYPE          INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_CLNTGRP_UN ON CLNTGRP
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTGRP
       ADD CONSTRAINT XPKCLNTGRP PRIMARY KEY (CLNTGRPID);


CREATE TABLE CLNTLISTACTIVITY (
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SYSTEMTYPE           character varying(50) NOT NULL,
       SYSTEMNAME           character varying(100) NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CLNTLISTACTIVITY
       ADD CONSTRAINT XPKCLNTLISTACTIVITY PRIMARY KEY (SYSTEMID, 
              SAREAID);


CREATE TABLE CLNTPROPERTY (
       CLNTID               INTEGER NOT NULL,
       CLNTPROPERTYKEY      INTEGER NOT NULL,
       CLNTPROPERTYVAL      character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_CLNTPROPERTY_UN ON CLNTPROPERTY
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTPROPERTY
       ADD CONSTRAINT XPKCLNTPROPERTY PRIMARY KEY (CLNTID, 
              CLNTPROPERTYKEY);


CREATE TABLE CLNTSUM (
       CLNTID               INTEGER NOT NULL,
       CURRENCYID           INTEGER NOT NULL,
       CLNTSUM              DECIMAL(18,6) NOT NULL,
       LOYALTYCLUBID        INTEGER NOT NULL,
       CLNTBONUS            DECIMAL(18,6) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL,
       UPDATETIME           character varying(14) NOT NULL
);

CREATE INDEX IDX_CLNTSUM_UN ON CLNTSUM
(
       UPDATENUM                      ASC
);


ALTER TABLE CLNTSUM
       ADD CONSTRAINT XPKCLNTSUM PRIMARY KEY (CLNTID, CURRENCYID, 
              LOYALTYCLUBID);


CREATE TABLE CLNTSYNCACTIVITY (
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       EVENTCODE            INTEGER NOT NULL,
       DIRNAME              character varying(30) NOT NULL,
       DIRECTION            SMALLINT NOT NULL,
       EVENTTIME            character varying(14) NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CLNTSYNCACTIVITY
       ADD CONSTRAINT XPKCLNTSYNCACTIVITY PRIMARY KEY (SYSTEMID, 
              SAREAID, EVENTCODE, DIRNAME);


CREATE TABLE COMPANY (
       COMPANYID            INTEGER NOT NULL,
       COMPANYGRPID         INTEGER NOT NULL,
       PURCHPRCLEVELID      INTEGER NULL,
       COMPANYNAME          character varying(100) NOT NULL,
       COMPANYSNAME         character varying(100) NULL,
       CERTIFICATENUM       character varying(100) NULL,
       MAILADDR             character varying(100) NULL,
       JURIDICALADDR        character varying(100) NULL,
       PHONES               character varying(50) NULL,
       REGISTRYNUM          character varying(50) NULL,
       TAXIDENTNUM          character varying(50) NULL,
       PAYVAT               SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE COMPANY
       ADD CONSTRAINT XPKCOMPANY PRIMARY KEY (COMPANYID);


CREATE TABLE COMPANYBACKREQUEST (
       SAREAID              INTEGER NOT NULL,
       SYSTEAMID            INTEGER NOT NULL,
       COMPANYREQUESTID     INTEGER NOT NULL,
       COMPANYNAME          character varying(50) NOT NULL,
       COMPANYSNAME         character varying(50) NULL,
       CERTIFICATENUM       character varying(50) NULL,
       MAILADDR             character varying(50) NULL,
       JURIDICALADDR        character varying(50) NULL,
       PHONES               character varying(50) NULL,
       REGISTRYNUM          character varying(50) NULL,
       TAXIDENTNUM          character varying(50) NULL,
       REQUESTSENDTIME      character varying(14) NOT NULL,
       SAUSERID             INTEGER NOT NULL,
       SAUSERNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE COMPANYBACKREQUEST
       ADD CONSTRAINT XPKCOMPANYBACKREQUEST PRIMARY KEY (SAREAID, 
              SYSTEAMID, COMPANYREQUESTID);


CREATE TABLE COMPANYGRP (
       COMPANYGRPID         INTEGER NOT NULL,
       COMPANYGRPNAME       character varying(50) NOT NULL,
       PARENTCOMPANYGRPID   INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE COMPANYGRP
       ADD CONSTRAINT XPKCOMPANYGRP PRIMARY KEY (COMPANYGRPID);


CREATE TABLE COMPOSCARD (
       COMPOSCARDID         INTEGER NOT NULL,
       TASTE                TEXT NULL,
       APPEARANCE           TEXT NULL,
       NORMMB               TEXT NULL,
       NORMFX               TEXT NULL,
       COMPOSCARDNUM        character varying(50) NOT NULL,
       CARDCOMMENT          TEXT NULL,
       PRODUCTION           TEXT NULL,
       FEATURE              TEXT NULL,
       MENUWEIGHT           character varying(30) NULL,
       COMPOSCARDDATE       character varying(14) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE COMPOSCARD
       ADD CONSTRAINT XPKCOMPOSCARD PRIMARY KEY (COMPOSCARDID);


CREATE TABLE COMPOSINGR (
       COMPOSINGRID         INTEGER NOT NULL,
       COMPOSCARDID         INTEGER NOT NULL,
       ARTID                INTEGER NULL,
       NETWEIGHT            INTEGER NOT NULL,
       GROSSWEIGHT          INTEGER NOT NULL,
       WEIGHT               INTEGER NOT NULL,
       COMPOSINGRDATE       character varying(14) NOT NULL,
       PURCHPRICE           DECIMAL(18,6) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE COMPOSINGR
       ADD CONSTRAINT XPKCOMPOSINGR PRIMARY KEY (COMPOSINGRID, 
              COMPOSCARDID);


CREATE TABLE CURRENCY (
       CURRENCYID           INTEGER NOT NULL,
       CURRENCYNAME         character varying(50) NOT NULL,
       CURRENCYSNAME        character varying(50) NULL,
       CURRENCYRATE         DECIMAL(18,6) NOT NULL,
       CURRENCYABBR         character varying(30) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE CURRENCY
       ADD CONSTRAINT XPKCURRENCY PRIMARY KEY (CURRENCYID);


CREATE TABLE DATAPUMPCFG (
       CFGKEY               character varying(50) NOT NULL,
       PROFILEID            INTEGER NOT NULL,
       CFGVALUE             character varying(100) NOT NULL
);


ALTER TABLE DATAPUMPCFG
       ADD CONSTRAINT XPKDATAPUMPCFG PRIMARY KEY (CFGKEY, PROFILEID);


CREATE TABLE DATAPUMPDIRS (
       DIRNAME              character varying(50) NOT NULL,
       SOURCETYPE           INTEGER NOT NULL,
       PUMPDIR              INTEGER NOT NULL,
       UPDATETIME           character varying(14) NULL,
       PUMPPRIORITY         INTEGER NOT NULL,
       PUMPUPDATENUM        INTEGER NOT NULL
);


ALTER TABLE DATAPUMPDIRS
       ADD CONSTRAINT XPKDATAPUMPDIRS PRIMARY KEY (DIRNAME, 
              SOURCETYPE);


CREATE TABLE DATASERVERCFG (
       CFGKEY               INTEGER NOT NULL,
       CFGVALUE             character varying(1024) NULL
);


ALTER TABLE DATASERVERCFG
       ADD CONSTRAINT XPKDATASERVERCFG PRIMARY KEY (CFGKEY);


CREATE TABLE DATASYNCBLOCKEDCLIENTS2 (
       CLIENTID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       CLIENTNAME           character varying(30) NULL,
       BLOCKTYPE            character varying(100) NOT NULL
);


ALTER TABLE DATASYNCBLOCKEDCLIENTS2
       ADD CONSTRAINT XPKDATASYNCBLOCKEDCLIENTS2 PRIMARY KEY (
              CLIENTID, SAREAID);


CREATE TABLE DATASYNCCLNT (
       CLNTKEY              character varying(50) NOT NULL,
       CLNTVALUE            character varying(100) NULL
);


ALTER TABLE DATASYNCCLNT
       ADD CONSTRAINT XPKDATASYNCCLNT PRIMARY KEY (CLNTKEY);


CREATE TABLE DATASYNCDIRS (
       DIRNAME              character varying(50) NOT NULL,
       SYNCDIR              INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL,
       SYNCPRIORITY         INTEGER NOT NULL
);


ALTER TABLE DATASYNCDIRS
       ADD CONSTRAINT XPKDATASYNCDIRS PRIMARY KEY (DIRNAME);


CREATE TABLE DATASYNCSERVERCFG (
       CFGKEY               character varying(50) NOT NULL,
       PROFILEID            INTEGER NOT NULL,
       CFGVALUE             character varying(100) NOT NULL
);


ALTER TABLE DATASYNCSERVERCFG
       ADD CONSTRAINT XPKDATASYNCSERVERCFG PRIMARY KEY (CFGKEY, 
              PROFILEID);


CREATE TABLE DCARD (
       DCARDID              character varying(30) NOT NULL,
       CLNTID               INTEGER NOT NULL,
       DCARDCODE            character varying(30) NOT NULL,
       DCARDNAME            character varying(50) NULL,
       ISPAYMENT            SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       PINCODE              character varying(256) NULL,
       UPDATENUM            INTEGER NOT NULL,
       LOCKED               SMALLINT NOT NULL
);

CREATE UNIQUE INDEX XIE1DCARD ON DCARD
(
       DCARDCODE                      ASC
);

CREATE INDEX IDX_DCARD_UN ON DCARD
(
       UPDATENUM                      ASC
);


ALTER TABLE DCARD
       ADD CONSTRAINT XPKDCARD PRIMARY KEY (DCARDID);


CREATE TABLE DISC (
       DISCID               INTEGER NOT NULL,
       DISCNAME             character varying(50) NOT NULL,
       DISCVAL              character varying(512) NOT NULL,
       DISCCOND             character varying(512) NULL,
       DISCTIME             character varying(512) NULL,
       DISCDATE             character varying(512) NULL,
       DISCMANUALINP        SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE DISC
       ADD CONSTRAINT XPKDISC PRIMARY KEY (DISCID);


CREATE TABLE DISCOFFER (
       DISCOFFERID          INTEGER NOT NULL,
       DISCOFFERNAME        character varying(50) NOT NULL,
       DISCOFFERVAL         character varying(512) NOT NULL,
       DISCOFFERCOND        character varying(512) NULL,
       DISCOFFERTIME        character varying(512) NULL,
       DISCOFFERDATE        character varying(512) NULL,
       DISCOFFERMANUALINP   SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE DISCOFFER
       ADD CONSTRAINT XPKDISCOFFER PRIMARY KEY (DISCOFFERID);


CREATE TABLE DOC (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       DOCDATE              character varying(14) NOT NULL,
       DOCTYPE              INTEGER NOT NULL,
       DOCNUM               character varying(30) NULL,
       HEADERQTY            INTEGER NOT NULL,
       ITEMSQTY             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1DOC ON DOC
(
       UPDATENUM                      ASC
);

CREATE INDEX XIE2DOC ON DOC
(
       DOCDATE                        ASC
);


ALTER TABLE DOC
       ADD CONSTRAINT XPKDOC PRIMARY KEY (SAREAID, SYSTEMID, DOCID);


CREATE TABLE DOCHEADER (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       FIELDKEY             INTEGER NOT NULL,
       FIELDVALUE           character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NULL
);

CREATE INDEX XIE1DOCHEADER ON DOCHEADER
(
       UPDATENUM                      ASC
);


ALTER TABLE DOCHEADER
       ADD CONSTRAINT XPKDOCHEADER PRIMARY KEY (SAREAID, SYSTEMID, 
              DOCID, FIELDKEY);


CREATE TABLE DOCITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       DOCITEMNUM           INTEGER NOT NULL,
       ARTID                INTEGER NOT NULL,
       ARTCODE              INTEGER NOT NULL,
       PACKID               INTEGER NOT NULL,
       ARTNAME              character varying(50) NOT NULL,
       PACKNAME             character varying(50) NULL,
       PACKDTYPE            INTEGER NULL,
       QUANTMASK            INTEGER NULL,
       UNITID               INTEGER NULL,
       UNITNAME             character varying(50) NULL,
       TAXGRPRATE           INTEGER NULL,
       QUANTITY             INTEGER NULL,
       PRICE                DECIMAL(18,6) NULL,
       PRICEVAT             DECIMAL(18,6) NULL,
       ITEMSUM              DECIMAL(18,6) NULL,
       ITEMSUMVAT           DECIMAL(18,6) NULL,
       DISCSUM              DECIMAL(18,6) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1DOCITEMS ON DOCITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE DOCITEMS
       ADD CONSTRAINT XPKDOCITEMS PRIMARY KEY (SAREAID, SYSTEMID, 
              DOCID, DOCITEMNUM);


CREATE TABLE DOCREQUEST (
       SAREAID              INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       DOCTYPE              INTEGER NOT NULL,
       DOCNUM               character varying(30) NOT NULL,
       DOCDATE              character varying(14) NOT NULL,
       PRICETYPE            INTEGER NOT NULL,
       HEADERQTY            INTEGER NOT NULL,
       ITEMSQTY             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE DOCREQUEST
       ADD CONSTRAINT XPKDOCREQUEST PRIMARY KEY (SAREAID, DOCID);


CREATE TABLE DOCREQUESTHEADER (
       SAREAID              INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       FIELDKEY             INTEGER NOT NULL,
       FIELDVALUE           character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE DOCREQUESTHEADER
       ADD CONSTRAINT XPKDOCREQUESTHEADER PRIMARY KEY (SAREAID, DOCID, 
              FIELDKEY);


CREATE TABLE DOCREQUESTITEMS (
       SAREAID              INTEGER NOT NULL,
       DOCID                INTEGER NOT NULL,
       DOCITEMNUM           INTEGER NOT NULL,
       PACKID               INTEGER NOT NULL,
       QUANTITY             INTEGER NULL,
       PRICE                DECIMAL(18,6) NULL,
       DISCSUM              DECIMAL(18,6) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE DOCREQUESTITEMS
       ADD CONSTRAINT XPKDOCREQUESTITEMS PRIMARY KEY (SAREAID, DOCID, 
              DOCITEMNUM);


CREATE TABLE EVENTS (
       EVENTCODE            INTEGER NOT NULL,
       EVENTLENG            INTEGER NOT NULL,
       EVENTCONTENT         character varying(1024) NOT NULL
);


ALTER TABLE EVENTS
       ADD CONSTRAINT XPKEVENTS PRIMARY KEY (EVENTCODE, EVENTLENG);


CREATE TABLE EXBARC (
       EXBARCID             INTEGER NOT NULL,
       PACKID               INTEGER NOT NULL,
       EXBARCTYPE           character varying(30) NOT NULL,
       EXBARCBODY           character varying(30) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1EXBARC ON EXBARC
(
       EXBARCBODY                     ASC
);

CREATE INDEX IDX_EXBARC_UN ON EXBARC
(
       UPDATENUM                      ASC
);


ALTER TABLE EXBARC
       ADD CONSTRAINT XPKEXBARC PRIMARY KEY (EXBARCID);


CREATE TABLE EXTGRP (
       EXTGRPID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       PARENTEXTGRPID       INTEGER NULL,
       EXTGRPNAME           character varying(50) NOT NULL,
       EXTGRPPICTURE        bytea NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE EXTGRP
       ADD CONSTRAINT XPKEXTGRP PRIMARY KEY (EXTGRPID);


CREATE TABLE FIRM (
       FIRMID               INTEGER NOT NULL,
       LOYALTYCLUBID        INTEGER NULL,
       FIRMNAME             character varying(100) NOT NULL,
       CURRENCYID           INTEGER NULL,
       FIRMADDR             character varying(100) NULL,
       DOCPREFIX            character varying(30) NULL,
       CERTIFICATENUM       character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       MAILADDR             character varying(100) NULL,
       UPDATENUM            INTEGER NOT NULL,
       PHONES               character varying(50) NULL,
       REGISTRYNUM          character varying(50) NULL,
       TAXIDENTNUM          character varying(50) NULL,
       ASKPINCODE           SMALLINT NULL
);


ALTER TABLE FIRM
       ADD CONSTRAINT XPKFIRM PRIMARY KEY (FIRMID);


CREATE TABLE FIRMWAREHOUSE (
       FIRMID               INTEGER NOT NULL,
       WAREHOUSEID          INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE FIRMWAREHOUSE
       ADD CONSTRAINT XPKFIRMWAREHOUSE PRIMARY KEY (FIRMID, 
              WAREHOUSEID);


CREATE TABLE GRP (
       GRPID                INTEGER NOT NULL,
       OFFERID              INTEGER NULL,
       PARENTGRPID          INTEGER NULL,
       GRPNAME              character varying(50) NOT NULL,
       GRPPICTURE           bytea NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE GRP
       ADD CONSTRAINT XPKGRP PRIMARY KEY (GRPID);


CREATE TABLE HALL (
       HALLID               INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       PRNSCHEMEID          INTEGER NULL,
       HALLNAME             character varying(50) NOT NULL,
       HALLPICTURE          bytea NULL,
       HALLMINIPICTURE      bytea NULL,
       HALLSORTKEY          INTEGER NULL,
       HALLFASTKEY          character varying(30) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE HALL
       ADD CONSTRAINT XPKHALL PRIMARY KEY (HALLID);


CREATE TABLE LOCALCLNTFORMRESULT (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       TARGETSYSTEM         INTEGER NOT NULL,
       CLNTFORMID           INTEGER NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       FILLTIME             character varying(14) NOT NULL,
       CLNTID               INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1LOCALCLNTFORMRESULT ON LOCALCLNTFORMRESULT
(
       UPDATENUM                      ASC
);


ALTER TABLE LOCALCLNTFORMRESULT
       ADD CONSTRAINT XPKLOCALCLNTFORMRESULT PRIMARY KEY (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID);


CREATE TABLE LOCALCLNTFORMRESULTITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       CLNTFORMITEMID       INTEGER NOT NULL,
       CLNTFORMITEMVAL      character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1LOCALCLNTFORMRESULTITEMS ON LOCALCLNTFORMRESULTITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE LOCALCLNTFORMRESULTITEMS
       ADD CONSTRAINT XPKLOCALCLNTFORMRESULTITEMS PRIMARY KEY (
              SAREAID, SYSTEMID, CLNTFORMRESULTID, CLNTFORMITEMID);


CREATE TABLE LOCALREQUEST (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       TARGETSYSTEM         INTEGER NOT NULL,
       REQUESTTYPE          INTEGER NOT NULL,
       REQUESTTIME          character varying(14) NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1LOCALREQUEST ON LOCALREQUEST
(
       UPDATENUM                      ASC
);


ALTER TABLE LOCALREQUEST
       ADD CONSTRAINT XPKLOCALREQUEST PRIMARY KEY (SAREAID, SYSTEMID, 
              REQUESTID);


CREATE TABLE LOCALREQUESTITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTKEY           INTEGER NOT NULL,
       REQUESTVAL           character varying(1024) NULL,
       DELFLAG              INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1LOCALREQUESTITEMS ON LOCALREQUESTITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE LOCALREQUESTITEMS
       ADD CONSTRAINT XPKLOCALREQUESTITEMS PRIMARY KEY (SAREAID, 
              SYSTEMID, REQUESTID, REQUESTKEY);


CREATE TABLE LOYALTYCLUB (
       LOYALTYCLUBID        INTEGER NOT NULL,
       CURRENCYID           INTEGER NOT NULL,
       ACCUMACCOUNTTYPEID   INTEGER NOT NULL,
       BONUSACCOUNTTYPEID   INTEGER NOT NULL,
       CLNTFORMID           INTEGER NULL,
       LOYALTYCLUBNAME      character varying(50) NOT NULL,
       ASKPINCODE           SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE LOYALTYCLUB
       ADD CONSTRAINT XPKLOYALTYCLUB PRIMARY KEY (LOYALTYCLUBID);


CREATE TABLE MODGRP (
       MODGRPID             INTEGER NOT NULL,
       MODGRPNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE MODGRP
       ADD CONSTRAINT XPKMODGRP PRIMARY KEY (MODGRPID);


CREATE TABLE MPDBINFO (
       INFOKEY              character varying(30) NOT NULL,
       INFOVAL              character varying(100) NULL
);


ALTER TABLE MPDBINFO
       ADD CONSTRAINT XPKMPDBINFO PRIMARY KEY (INFOKEY);


CREATE TABLE MSGSUB (
       MSGSUBID             character varying(36) NOT NULL,
       MSGSUBCONDID         INTEGER NULL,
       ISACTIVE             SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE MSGSUB
       ADD CONSTRAINT XPKMSGSUB PRIMARY KEY (MSGSUBID);


CREATE TABLE MSGSUBCOND (
       MSGSUBCONDID         INTEGER NOT NULL,
       MSGSUBCONDNAME       character varying(50) NOT NULL,
       MSGSUBTYPE           character varying(36) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE MSGSUBCOND
       ADD CONSTRAINT XPKMSGSUBCOND PRIMARY KEY (MSGSUBCONDID);


CREATE TABLE MSGSUBPARAM (
       MSGSUBPARAMID        INTEGER NOT NULL,
       MSGSUBCONDID         INTEGER NOT NULL,
       CASHMSGSUBID         character varying(50) NULL,
       PARAMCOND            character varying(512) NULL,
       PARAMTEXT            character varying(512) NULL,
       ISACTIVE             SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE MSGSUBPARAM
       ADD CONSTRAINT XPKMSGSUBPARAM PRIMARY KEY (MSGSUBPARAMID, 
              MSGSUBCONDID);


CREATE TABLE NUMBERS (
       NUMBERID             INTEGER NOT NULL,
       NUMBERVALUE          DECIMAL(18,6) NOT NULL,
       NUMBERNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_NUMBERS_UN ON NUMBERS
(
       UPDATENUM                      ASC
);


ALTER TABLE NUMBERS
       ADD CONSTRAINT XPKNUMBERS PRIMARY KEY (NUMBERID);


CREATE TABLE NUMPROPERTY (
       NUMPROPERTYKEY       INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NOT NULL,
       NUMBERID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_NUMPROPERTY_UN ON NUMPROPERTY
(
       UPDATENUM                      ASC
);


ALTER TABLE NUMPROPERTY
       ADD CONSTRAINT XPKNUMPROPERTY PRIMARY KEY (NUMPROPERTYKEY, 
              PROPERTYGRPID);


CREATE TABLE OFFER (
       OFFERID              INTEGER NOT NULL,
       DISCOFFERID          INTEGER NULL,
       BONUSOFFERID         INTEGER NULL,
       OFFERNAME            character varying(50) NOT NULL,
       SALEOFFERID          INTEGER NULL,
       OFFERCODE            character varying(50) NULL,
       OFFERAUTOASSIGN      SMALLINT NOT NULL,
       OFFERMANUAL          SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE OFFER
       ADD CONSTRAINT XPKOFFER PRIMARY KEY (OFFERID);


CREATE TABLE PACK (
       PACKID               INTEGER NOT NULL,
       ARTID                INTEGER NOT NULL,
       BARCID               INTEGER NULL,
       TAREID               INTEGER NULL,
       OFFERID              INTEGER NULL,
       UNITID               INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NULL,
       PACKNAME             character varying(50) NULL,
       PACKQUANT            INTEGER NOT NULL,
       QUANTMASK            INTEGER NOT NULL,
       PACKDTYPE            INTEGER NOT NULL,
       PACKSHELFLIFE        INTEGER NOT NULL,
       ISDEFAULT            SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PACK_UN ON PACK
(
       UPDATENUM                      ASC
);


ALTER TABLE PACK
       ADD CONSTRAINT XPKPACK PRIMARY KEY (PACKID);


CREATE TABLE PACKPRC (
       PACKID               INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       TRFSCHEMEID          INTEGER NULL,
       PACKPRICE            DECIMAL(18,6) NOT NULL,
       PACKMINPRICE         DECIMAL(18,6) NOT NULL,
       PACKBONUSMINPRICE    DECIMAL(18,6) NOT NULL,
       PACKEXTMINPRICE      DECIMAL(18,6) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PACKPRC_UN ON PACKPRC
(
       UPDATENUM                      ASC
);


ALTER TABLE PACKPRC
       ADD CONSTRAINT XPKPACKPRC PRIMARY KEY (PACKID, PRCLEVELID);


CREATE TABLE PAYMENTSCHEME (
       PAYMENTSCHEMEID      INTEGER NOT NULL,
       PAYMENTSCHEMENAME    character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PAYMENTSCHEME
       ADD CONSTRAINT XPKPAYMENTSCHEME PRIMARY KEY (PAYMENTSCHEMEID);


CREATE TABLE PAYMENTSCHEMEITEMS (
       PAYMENTSCHEMEID      INTEGER NOT NULL,
       CURRENCYID           INTEGER NOT NULL,
       ACCOUNTTYPEID        INTEGER NOT NULL,
       ORDERKEY             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PAYMENTSCHEMEITEMS
       ADD CONSTRAINT XPKPAYMENTSCHEMEITEMS PRIMARY KEY (
              PAYMENTSCHEMEID, CURRENCYID, ACCOUNTTYPEID);


CREATE TABLE PCCLNTSUM (
       CLNTID               INTEGER NOT NULL,
       CURRENCYID           INTEGER NOT NULL,
       LOYALTYCLUBID        INTEGER NOT NULL,
       CLNTSUM              DECIMAL(18,6) NOT NULL,
       CLNTBONUS            DECIMAL(18,6) NOT NULL,
       UPDATETIME           character varying(14) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1PCCLNTSUM ON PCCLNTSUM
(
       UPDATENUM                      ASC
);


ALTER TABLE PCCLNTSUM
       ADD CONSTRAINT XPKPCCLNTSUM PRIMARY KEY (CLNTID, CURRENCYID, 
              LOYALTYCLUBID);


CREATE TABLE PCREQUESTITEMSSYNC (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTKEY           INTEGER NOT NULL,
       REQUESTVAL           character varying(1024) NULL,
       DELFLAG              INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PCREQUESTITEMSSYNC
       ADD CONSTRAINT XPKPCREQUESTITEMSSYNC PRIMARY KEY (SAREAID, 
              SYSTEMID, REQUESTID, REQUESTKEY);


CREATE TABLE PCREQUESTSYNC (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTTYPE          INTEGER NOT NULL,
       REQUESTTIME          character varying(14) NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1PCREQUESTSYNC ON PCREQUESTSYNC
(
       UPDATENUM                      ASC
);


ALTER TABLE PCREQUESTSYNC
       ADD CONSTRAINT XPKPCREQUESTSYNC PRIMARY KEY (SAREAID, SYSTEMID, 
              REQUESTID);


CREATE TABLE PKHOLDER (
       TABLENAME            character varying(50) NOT NULL,
       FIELDNAME            character varying(50) NOT NULL,
       LASTPK               INTEGER NOT NULL
);


ALTER TABLE PKHOLDER
       ADD CONSTRAINT XPKPKHOLDER PRIMARY KEY (TABLENAME, FIELDNAME);


CREATE TABLE PLACE (
       PLACEID              INTEGER NOT NULL,
       HALLID               INTEGER NOT NULL,
       PRNSCHEMEID          INTEGER NULL,
       PLACENAME            character varying(50) NOT NULL,
       PLACEX               INTEGER NOT NULL,
       PLACEY               INTEGER NOT NULL,
       PLACESIZEX           INTEGER NOT NULL,
       PLACESIZEY           INTEGER NOT NULL,
       PLACEVIEWTYPE        INTEGER NOT NULL,
       PLACEPICTURE         bytea NULL,
       PLACECOLOR           INTEGER NULL,
       PLACEFONTCOLOR       INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       PLACEFONTSIZE        INTEGER NOT NULL,
       PLACETARIFF          INTEGER NULL,
       UPDATENUM            INTEGER NOT NULL,
       PLACEFONTBACKCOLOR   INTEGER NULL
);


ALTER TABLE PLACE
       ADD CONSTRAINT XPKPLACE PRIMARY KEY (PLACEID, HALLID);


CREATE TABLE POSTPONEDREC (
       POSTPONEDRECNUM      INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       CASHIERNAME          character varying(50) NOT NULL,
       POSTPONEDRECTIME     character varying(14) NOT NULL,
       POSTPONEDRECDATA     bytea NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            SMALLINT NOT NULL
);


ALTER TABLE POSTPONEDREC
       ADD CONSTRAINT XPKPOSTPONEDREC PRIMARY KEY (POSTPONEDRECNUM, 
              SESSID, SYSTEMID, SAREAID);


CREATE TABLE PRCLEVEL (
       PRCLEVELID           INTEGER NOT NULL,
       PRCLEVELNAME         character varying(50) NOT NULL,
       PRCLEVELKEY          INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRCLEVEL
       ADD CONSTRAINT XPKPRCLEVEL PRIMARY KEY (PRCLEVELID);


CREATE TABLE PRN (
       PRNID                INTEGER NOT NULL,
       PRNNAME              character varying(50) NOT NULL,
       PRNSRVNAME           character varying(50) NOT NULL,
       PRNSRVPORT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRN
       ADD CONSTRAINT XPKPRN PRIMARY KEY (PRNID);


CREATE TABLE PRNGRP (
       PRNGRPID             INTEGER NOT NULL,
       PRNGRPNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRNGRP
       ADD CONSTRAINT XPKPRNGRP PRIMARY KEY (PRNGRPID);


CREATE TABLE PRNGRPPRNSCHEME (
       PRNGRPID             INTEGER NOT NULL,
       PRNSCHEMEID          INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRNGRPPRNSCHEME
       ADD CONSTRAINT XPKPRNGRPPRNSCHEME PRIMARY KEY (PRNGRPID, 
              PRNSCHEMEID);


CREATE TABLE PRNPRNGRP (
       PRNID                INTEGER NOT NULL,
       PRNGRPID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRNPRNGRP
       ADD CONSTRAINT XPKPRNPRNGRP PRIMARY KEY (PRNID, PRNGRPID);


CREATE TABLE PRNSCHEME (
       PRNSCHEMEID          INTEGER NOT NULL,
       PRNSCHEMENAME        character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRNSCHEME
       ADD CONSTRAINT XPKPRNSCHEME PRIMARY KEY (PRNSCHEMEID);


CREATE TABLE PROCESSINGPUMPCFG (
       CFGKEY               character varying(30) NOT NULL,
       CFGVALUE             character varying(100) NULL
);


ALTER TABLE PROCESSINGPUMPCFG
       ADD CONSTRAINT XPKPROCESSINGPUMPCFG PRIMARY KEY (CFGKEY);


CREATE TABLE PROPERTYGRP (
       PROPERTYGRPID        INTEGER NOT NULL,
       PROPERTYGRPNAME      character varying(50) NOT NULL,
       PROPERTYGRPTYPE      INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PROPERTYGRP_UN ON PROPERTYGRP
(
       UPDATENUM                      ASC
);


ALTER TABLE PROPERTYGRP
       ADD CONSTRAINT XPKPROPERTYGRP PRIMARY KEY (PROPERTYGRPID);


CREATE TABLE PUMPPROFILE (
       PROFILEID            INTEGER NOT NULL,
       PROFILENAME          character varying(30) NOT NULL
);


ALTER TABLE PUMPPROFILE
       ADD CONSTRAINT XPKPUMPPROFILE PRIMARY KEY (PROFILEID);


CREATE TABLE REST (
       PACKID               INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       WAREHOUSEID          INTEGER NOT NULL,
       RESTQUANT            INTEGER NOT NULL,
       RESTDATE             character varying(14) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE REST
       ADD CONSTRAINT XPKREST PRIMARY KEY (SAREAID, PACKID, 
              WAREHOUSEID);


CREATE TABLE SALEOFFER (
       SALEOFFERID          INTEGER NOT NULL,
       SALEOFFERNAME        character varying(50) NOT NULL,
       SALEOFFERVAL         character varying(512) NOT NULL,
       SALEOFFERCOND        character varying(512) NULL,
       SALEOFFERTIME        character varying(512) NULL,
       SALEOFFERDATE        character varying(512) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SALEOFFER
       ADD CONSTRAINT XPKSALEOFFER PRIMARY KEY (SALEOFFERID);


CREATE TABLE SALES (
       SALESNUM             INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       TXTBINID             INTEGER NULL,
       SALESTAG             INTEGER NOT NULL,
       SALESTIME            character varying(14) NULL,
       FRECNUM              character varying(30) NULL,
       SRECNUM              INTEGER NOT NULL,
       SALESBARC            character varying(30) NULL,
       SALESDISC            DECIMAL(18,6) NULL,
       SALESPRICE           DECIMAL(18,6) NULL,
       SALESSUM             DECIMAL(18,6) NULL,
       BONUSSUM             DECIMAL(18,6) NULL,
       SALESCOUNT           INTEGER NULL,
       SALESCODE            INTEGER NULL,
       SALESTYPE            INTEGER NULL,
       SALESCANC            SMALLINT NOT NULL,
       SALESFLAGS           INTEGER NULL,
       SALESREFUND          INTEGER NOT NULL,
       PACKNAME             character varying(30) NULL,
       PACKCOUNT            INTEGER NULL,
       CASHIERID            INTEGER NOT NULL,
       SALESATTRI           INTEGER NULL,
       SALESATTRS           character varying(100) NULL,
       SALESEXTCOUNT        INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       CLNTID               INTEGER NULL,
       SALESBONUS           DECIMAL(18,6) NULL,
       SYSTEMTYPE           INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SALES ON SALES
(
       FRECNUM                        ASC
);

CREATE INDEX XIE2SALES ON SALES
(
       UPDATENUM                      ASC
);

CREATE INDEX IDX_SALES_SALESTIME ON SALES
(
       SALESTIME                      ASC
);


ALTER TABLE SALES
       ADD CONSTRAINT XPKSALES PRIMARY KEY (SAREAID, SYSTEMID, SESSID, 
              SALESNUM);


CREATE TABLE SALESBONUS (
       BONUSTRANSID         character varying(36) NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SRECNUM              INTEGER NOT NULL,
       USERID               INTEGER NOT NULL,
       CLIENTID             INTEGER NOT NULL,
       DCARDID              character varying(30) NOT NULL,
       CIRRENCYID           INTEGER NOT NULL,
       ACCOUNTTYPE          INTEGER NOT NULL,
       TRANSTYPE            INTEGER NOT NULL,
       BONUSSUM             DECIMAL(18,6) NOT NULL,
       TRANSTIME            character varying(14) NOT NULL,
       SIGNATURE            character varying(200) NULL,
       DELFLAG              SMALLINT NOT NULL,
       ACCOUNTDOCSOURCE     INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE3SALESBONUS ON SALESBONUS
(
       UPDATENUM                      ASC
);

CREATE INDEX XIE4SALESBONUS ON SALESBONUS
(
       TRANSTIME                      ASC
);


ALTER TABLE SALESBONUS
       ADD CONSTRAINT XPKSALESBONUS PRIMARY KEY (BONUSTRANSID);


CREATE TABLE SALESEXT (
       SALESNUM             INTEGER NOT NULL,
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SALESEXTKEY          INTEGER NOT NULL,
       SALESEXTVALUE        character varying(2000) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SALESEXT ON SALESEXT
(
       UPDATENUM                      ASC
);


ALTER TABLE SALESEXT
       ADD CONSTRAINT XPKSALESEXT PRIMARY KEY (SAREAID, SYSTEMID, 
              SESSID, SALESNUM, SALESEXTKEY);


CREATE TABLE SAMCLNTFORMRESULT (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       CLNTFORMID           INTEGER NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       FILLTIME             character varying(14) NOT NULL,
       CLNTID               INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SAMCLNTFORMRESULT ON SAMCLNTFORMRESULT
(
       UPDATENUM                      ASC
);


ALTER TABLE SAMCLNTFORMRESULT
       ADD CONSTRAINT XPKSAMCLNTFORMRESULT PRIMARY KEY (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID);


CREATE TABLE SAMCLNTFORMRESULTITEMS (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       CLNTFORMRESULTID     INTEGER NOT NULL,
       CLNTFORMITEMID       INTEGER NOT NULL,
       CLNTFORMITEMVAL      character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SAMCLNTFORMRESULTITEMS ON SAMCLNTFORMRESULTITEMS
(
       UPDATENUM                      ASC
);


ALTER TABLE SAMCLNTFORMRESULTITEMS
       ADD CONSTRAINT XPKSAMCLNTFORMRESULTITEMS PRIMARY KEY (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID, CLNTFORMITEMID);


CREATE TABLE SAMGRACTION (
       ACTIONID             INTEGER NOT NULL,
       ACTIONNAME           character varying(50) NOT NULL,
       ISACTIVE             SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAMGRACTION
       ADD CONSTRAINT XPKSAMGRACTION PRIMARY KEY (ACTIONID);


CREATE TABLE SAMGRACTIONFIELDS (
       ACTIONID             INTEGER NOT NULL,
       DIRNAME              character varying(30) NOT NULL,
       FIELDNAME            character varying(30) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAMGRACTIONFIELDS
       ADD CONSTRAINT XPKSAMGRACTIONFIELDS PRIMARY KEY (ACTIONID, 
              DIRNAME, FIELDNAME);


CREATE TABLE SAMREQUESTITEMSSYNC (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTKEY           INTEGER NOT NULL,
       REQUESTVAL           character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_SAMREQUESTITEMSSYNC_UN ON SAMREQUESTITEMSSYNC
(
       UPDATENUM                      ASC
);


ALTER TABLE SAMREQUESTITEMSSYNC
       ADD CONSTRAINT XPKSAMREQUESTITEMSSYNC PRIMARY KEY (SAREAID, 
              SYSTEMID, REQUESTID, REQUESTKEY);


CREATE TABLE SAMREQUESTSYNC (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       REQUESTID            INTEGER NOT NULL,
       REQUESTTYPE          INTEGER NOT NULL,
       REQUESTTIME          character varying(14) NOT NULL,
       ITEMSCOUNT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SAMREQUESTSYNC ON SAMREQUESTSYNC
(
       UPDATENUM                      ASC
);


ALTER TABLE SAMREQUESTSYNC
       ADD CONSTRAINT XPKSAMREQUESTSYNC PRIMARY KEY (SAREAID, 
              SYSTEMID, REQUESTID);


CREATE TABLE SAREA (
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       ARTHOTKEYSETID       INTEGER NULL,
       FIRMID               INTEGER NOT NULL,
       WAREHOUSEID          INTEGER NULL,
       PRNSCHEMEID          INTEGER NULL,
       CURRENCYID           INTEGER NULL,
       SAREANAME            character varying(50) NOT NULL,
       SAREAADDR            character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       ASKPINCODE           SMALLINT NULL,
       RECEIPTHEADER        character varying(100) NULL,
       RECEIPTFOOTER        character varying(100) NULL,
       UPDATENUM            INTEGER NOT NULL,
       RECEIPTFIRSTHEADER   character varying(100) NULL,
       RECEIPTENDFOOTER     character varying(100) NULL
);


ALTER TABLE SAREA
       ADD CONSTRAINT XPKSAREA PRIMARY KEY (SAREAID);


CREATE TABLE SAREACASHIER (
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREACASHIER
       ADD CONSTRAINT XPKSAREACASHIER PRIMARY KEY (SAREAID, CASHIERID);


CREATE TABLE SAREACLNTCFG (
       CFGKEY               character varying(30) NOT NULL,
       CFGVALUE             character varying(100) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_SAREACLNTGRP_UN ON SAREACLNTCFG
(
       UPDATENUM                      ASC
);


ALTER TABLE SAREACLNTCFG
       ADD CONSTRAINT XPKSAREACLNTCFG PRIMARY KEY (CFGKEY);


CREATE TABLE SAREACLNTFORM (
       SAREAID              INTEGER NOT NULL,
       CLNTFORMID           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NULL
);


ALTER TABLE SAREACLNTFORM
       ADD CONSTRAINT XPKSAREACLNTFORM PRIMARY KEY (SAREAID, 
              CLNTFORMID);


CREATE TABLE SAREACLNTGRP (
       SAREAID              INTEGER NOT NULL,
       CLNTGRPID            INTEGER NOT NULL,
       DISCID               INTEGER NULL,
       BONUSID              INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREACLNTGRP
       ADD CONSTRAINT XPKSAREACLNTGRP PRIMARY KEY (SAREAID, CLNTGRPID);


CREATE TABLE SAREAMGRPUMPCFG (
       CFGKEY               character varying(30) NOT NULL,
       CFGVALUE             character varying(100) NULL
);


ALTER TABLE SAREAMGRPUMPCFG
       ADD CONSTRAINT XPKSAREAMGRPUMPCFG PRIMARY KEY (CFGKEY);


CREATE TABLE SAREAMSGSUB (
       SAREAID              INTEGER NOT NULL,
       MSGSUBID             character varying(36) NOT NULL,
       MSGSUBCONDID         INTEGER NULL,
       ISACTIVE             SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREAMSGSUB
       ADD CONSTRAINT XPKSAREAMSGSUB PRIMARY KEY (SAREAID, MSGSUBID);


CREATE TABLE SAREAOFFER (
       SAREAID              INTEGER NOT NULL,
       OFFERID              INTEGER NOT NULL,
       DISCOFFERID          INTEGER NULL,
       BONUSOFFERID         INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       SALEOFFERID          INTEGER NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT XPKSAREAOFFER PRIMARY KEY (SAREAID, OFFERID);


CREATE TABLE SAREAPRC (
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREAPRC
       ADD CONSTRAINT XPKSAREAPRC PRIMARY KEY (SAREAID, PRCLEVELID);


CREATE TABLE SAREASAUSER (
       SAREAID              INTEGER NOT NULL,
       SAUSERID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREASAUSER
       ADD CONSTRAINT XPKSAREASAUSER PRIMARY KEY (SAREAID, SAUSERID);


CREATE TABLE SAREATXTBIN (
       SAREAID              INTEGER NOT NULL,
       TXTBINID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREATXTBIN
       ADD CONSTRAINT XPKSAREATXTBIN PRIMARY KEY (SAREAID, TXTBINID);


CREATE TABLE SAUSER (
       SAUSERID             INTEGER NOT NULL,
       SAUSERPROFILEID      INTEGER NOT NULL,
       SAUSERPASSWORD       character varying(30) NOT NULL,
       SAUSERNAME           character varying(50) NOT NULL,
       SAUSERDISABLED       SMALLINT NOT NULL,
       USERSAREACONTROL     SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAUSER
       ADD CONSTRAINT XPKSAUSER PRIMARY KEY (SAUSERID);


CREATE TABLE SAUSERPROFILE (
       SAUSERPROFILEID      INTEGER NOT NULL,
       SAUSERPROFILENAME    character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAUSERPROFILE
       ADD CONSTRAINT XPKSAUSERPROFILE PRIMARY KEY (SAUSERPROFILEID);


CREATE TABLE SAUSERPVG (
       SAUSERPVGKEY         INTEGER NOT NULL,
       SAUSERPROFILEID      INTEGER NOT NULL,
       SAUSERPVGVALUE       INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAUSERPVG
       ADD CONSTRAINT XPKSAUSERPVG PRIMARY KEY (SAUSERPVGKEY, 
              SAUSERPROFILEID);


CREATE TABLE SCALEACTIVITY (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       SCALENAME            character varying(50) NOT NULL,
       SCALEFRIENDLYNAME    character varying(50) NOT NULL,
       ERRORNUM             INTEGER NOT NULL,
       ERRORMSG             character varying(2000) NULL,
       ISACTIVE             SMALLINT NOT NULL,
       LASTSYNCTIME         character varying(14) NULL,
       LASTPINGTIME         character varying(14) NULL,
       UPDATENUM            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALEACTIVITY
       ADD CONSTRAINT XPKSCALEACTIVITY PRIMARY KEY (SAREAID, SYSTEMID, 
              SCALEID);


CREATE TABLE SCHEDULEDCLIENTS (
       ENTRYNAME            character varying(30) NOT NULL,
       CHANNELTYPE          character varying(30) NOT NULL,
       CONNPARAM            character varying(100) NOT NULL,
       PRIORITY             INTEGER NOT NULL,
       ISACTIVE             SMALLINT NOT NULL
);


ALTER TABLE SCHEDULEDCLIENTS
       ADD CONSTRAINT XPKSCHEDULEDCLIENTS PRIMARY KEY (ENTRYNAME);


CREATE TABLE SDEPT (
       SDEPTID              INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SDEPTNAME            character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SDEPT
       ADD CONSTRAINT XPKSDEPT PRIMARY KEY (SDEPTID);


CREATE TABLE SESS (
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       WORKDAYID            INTEGER NULL,
       SESSSTART            character varying(14) NOT NULL,
       SESSCASHIN           DECIMAL(18,6) NOT NULL,
       SESSCASHINIT         DECIMAL(18,6) NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SESS
       ADD CONSTRAINT XPKSESS PRIMARY KEY (SESSID, SYSTEMID, SAREAID);


CREATE TABLE SESSEND (
       SESSID               INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SESSEND              character varying(14) NOT NULL,
       SESSCASHOUT          DECIMAL(18,6) NOT NULL,
       SESSCASHFINAL        DECIMAL(18,6) NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SESSEND
       ADD CONSTRAINT XPKSESSEND PRIMARY KEY (SESSID, SYSTEMID, 
              SAREAID);


CREATE TABLE STRINGS (
       STRINGID             INTEGER NOT NULL,
       STRINGVALUE          character varying(1024) NULL,
       STRINGNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_STRINGS_UN ON STRINGS
(
       UPDATENUM                      ASC
);


ALTER TABLE STRINGS
       ADD CONSTRAINT XPKSTRINGS PRIMARY KEY (STRINGID);


CREATE TABLE STRPROPERTY (
       STRPROPERTYKEY       INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NOT NULL,
       STRINGID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_STRPROPERTY_UN ON STRPROPERTY
(
       UPDATENUM                      ASC
);


ALTER TABLE STRPROPERTY
       ADD CONSTRAINT XPKSTRPROPERTY PRIMARY KEY (STRPROPERTYKEY, 
              PROPERTYGRPID);


CREATE TABLE SYNCPROFILE (
       PROFILEID            INTEGER NOT NULL,
       PROFILENAME          character varying(30) NOT NULL
);


ALTER TABLE SYNCPROFILE
       ADD CONSTRAINT XPKSYNCPROFILE PRIMARY KEY (PROFILEID);


CREATE TABLE SYSLOG (
       SYSTEMID             INTEGER NOT NULL,
       SEQ                  INTEGER NOT NULL DEFAULT nextval('SYSLOGSEQ_GEN'),
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NULL,
       EVENTTIME            character varying(14) NULL,
       EVENTCODE            INTEGER NULL,
       EVENTDATA            character varying(2000) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SYSLOG ON SYSLOG
(
       UPDATENUM                      ASC
);

CREATE INDEX XIE2SYSLOG ON SYSLOG
(
       EVENTTIME                      ASC
);

CREATE INDEX XIE3SYSLOG ON SYSLOG
(
       EVENTCODE                      ASC
);


ALTER TABLE SYSLOG
       ADD CONSTRAINT XPKSYSLOG PRIMARY KEY (SYSTEMID, SEQ, SAREAID);


CREATE TABLE SYSLOGEVENT (
       SYSLOGPROFILEID      INTEGER NOT NULL,
       SYSLOGEVENTCODE      INTEGER NOT NULL,
       SYSLOGEVENTVALUE     SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SYSLOGEVENT
       ADD CONSTRAINT XPKSYSLOGEVENT PRIMARY KEY (SYSLOGPROFILEID, 
              SYSLOGEVENTCODE);


CREATE TABLE SYSLOGPROFILE (
       SYSLOGPROFILEID      INTEGER NOT NULL,
       SYSLOGPROFILENAME    character varying(50) NOT NULL,
       SYSLOGPROFILETYPE    INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SYSLOGPROFILE
       ADD CONSTRAINT XPKSYSLOGPROFILE PRIMARY KEY (SYSLOGPROFILEID);


CREATE TABLE TARE (
       TAREID               INTEGER NOT NULL,
       TARENAME             character varying(50) NULL,
       TAREWEIGHT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_TARE_UN ON TARE
(
       UPDATENUM                      ASC
);


ALTER TABLE TARE
       ADD CONSTRAINT XPKTARE PRIMARY KEY (TAREID);


CREATE TABLE TAX (
       TAXID                INTEGER NOT NULL,
       TAXGRPID             INTEGER NOT NULL,
       TAXNAME              character varying(50) NULL,
       TAXRATE              INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TAX
       ADD CONSTRAINT XPKTAX PRIMARY KEY (TAXID);


CREATE TABLE TAXGRP (
       TAXGRPID             INTEGER NOT NULL,
       TAXGRPNAME           character varying(50) NULL,
       TAXGRPRATE           INTEGER NOT NULL,
       TAXGRPTYPE           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TAXGRP
       ADD CONSTRAINT XPKTAXGRP PRIMARY KEY (TAXGRPID);


CREATE TABLE TRFDAY (
       TRFDAYOFWEEK         INTEGER NOT NULL,
       TRFSCHEMEID          INTEGER NOT NULL,
       TRFDAYPRICE          DECIMAL(18,6) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TRFDAY
       ADD CONSTRAINT XPKTRFDAY PRIMARY KEY (TRFDAYOFWEEK, 
              TRFSCHEMEID);


CREATE TABLE TRFDAYTRFTIME (
       TRFDAYOFWEEK         INTEGER NOT NULL,
       TRFSCHEMEID          INTEGER NOT NULL,
       TRFTIMEID            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TRFDAYTRFTIME
       ADD CONSTRAINT XPKTRFDAYTRFTIME PRIMARY KEY (TRFDAYOFWEEK, 
              TRFSCHEMEID, TRFTIMEID);


CREATE TABLE TRFSCHEME (
       TRFSCHEMEID          INTEGER NOT NULL,
       TRFSCHEMENAME        character varying(50) NOT NULL,
       TRFSCHEMEPERIOD      INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TRFSCHEME
       ADD CONSTRAINT XPKTRFSCHEME PRIMARY KEY (TRFSCHEMEID);


CREATE TABLE TRFTIME (
       TRFTIMEID            INTEGER NOT NULL,
       TRFTIMENAME          character varying(50) NOT NULL,
       TRFTIMEBEGIN         character varying(14) NOT NULL,
       TRFTIMEEND           character varying(14) NOT NULL,
       TRFTIMEPRICE         DECIMAL(18,6) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TRFTIME
       ADD CONSTRAINT XPKTRFTIME PRIMARY KEY (TRFTIMEID);


CREATE TABLE TXTBIN (
       TXTBINID             INTEGER NOT NULL,
       TXTBINCLS            INTEGER NOT NULL,
       TXTBINTEXT           character varying(100) NOT NULL,
       TXTBINKEY            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TXTBIN
       ADD CONSTRAINT XPKTXTBIN PRIMARY KEY (TXTBINID);


CREATE TABLE UNIT (
       UNITID               INTEGER NOT NULL,
       UNITNAME             character varying(50) NOT NULL,
       UNITFULLNAME         character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_UNIT_UN ON UNIT
(
       UPDATENUM                      ASC
);


ALTER TABLE UNIT
       ADD CONSTRAINT XPKUNIT PRIMARY KEY (UNITID);


CREATE TABLE WAREHOUSE (
       WAREHOUSEID          INTEGER NOT NULL,
       WAREHOUSENAME        character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE WAREHOUSE
       ADD CONSTRAINT XPKWAREHOUSE PRIMARY KEY (WAREHOUSEID);


CREATE TABLE WGPLUGINSETTINGS (
       PLUGINID             character varying(36) NOT NULL,
       VERSION              character varying(50) NOT NULL,
       DATA                 TEXT NOT NULL
);


ALTER TABLE WGPLUGINSETTINGS
       ADD CONSTRAINT XPKWGPLUGINSETTINGS PRIMARY KEY (PLUGINID);


CREATE TABLE WORKDAY (
       WORKDAYID            INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       WORKDAYSTART         character varying(14) NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE WORKDAY
       ADD CONSTRAINT XPKWORKDAY PRIMARY KEY (WORKDAYID, SYSTEMID, 
              SAREAID);


CREATE TABLE WORKDAYEND (
       WORKDAYID            INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       WORKDAYEND           character varying(14) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE WORKDAYEND
       ADD CONSTRAINT XPKWORKDAYEND PRIMARY KEY (WORKDAYID, SYSTEMID, 
              SAREAID);


CREATE TABLE ZREP (
       ZREPID               INTEGER NOT NULL,
       WORKDAYID            INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NOT NULL,
       ZREPFPSN             character varying(50) NULL,
       ZREPFISCNUM          character varying(50) NULL,
       ZREPSALES            character varying(100) NULL,
       ZREPREFS             character varying(100) NULL,
       ZREPTIME             character varying(14) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE ZREP
       ADD CONSTRAINT XPKZREP PRIMARY KEY (ZREPID, WORKDAYID, 
              SYSTEMID, SAREAID);


ALTER TABLE ART
       ADD CONSTRAINT R_265
              FOREIGN KEY (COMPOSCARDID)
                             REFERENCES COMPOSCARD  (COMPOSCARDID);


ALTER TABLE ART
       ADD CONSTRAINT R_184
              FOREIGN KEY (MODGRPID)
                             REFERENCES MODGRP  (MODGRPID);


ALTER TABLE ART
       ADD CONSTRAINT R_2
              FOREIGN KEY (GRPID)
                             REFERENCES GRP  (GRPID);


ALTER TABLE ART
       ADD CONSTRAINT R_4
              FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);


ALTER TABLE ART
       ADD CONSTRAINT R_44
              FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);


ALTER TABLE ARTEXTGRP
       ADD CONSTRAINT R_185
              FOREIGN KEY (EXTGRPID)
                             REFERENCES EXTGRP  (EXTGRPID);


ALTER TABLE ARTEXTGRP
       ADD CONSTRAINT R_186
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE ARTHOTKEY
       ADD CONSTRAINT R_22
              FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE ARTHOTKEY
       ADD CONSTRAINT R_25
              FOREIGN KEY (ARTHOTKEYSETID)
                             REFERENCES ARTHOTKEYSET  (ARTHOTKEYSETID);


ALTER TABLE ARTMODGRP
       ADD CONSTRAINT R_182
              FOREIGN KEY (MODGRPID)
                             REFERENCES MODGRP  (MODGRPID);


ALTER TABLE ARTMODGRP
       ADD CONSTRAINT R_183
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE ARTPRNGRP
       ADD CONSTRAINT R_159
              FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);


ALTER TABLE ARTPRNGRP
       ADD CONSTRAINT R_160
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE ARTSDEPT
       ADD CONSTRAINT R_13
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE ARTSDEPT
       ADD CONSTRAINT R_14
              FOREIGN KEY (SDEPTID)
                             REFERENCES SDEPT  (SDEPTID);


ALTER TABLE BACKREQUESTITEMS
       ADD CONSTRAINT R_271B
              FOREIGN KEY (SAREAID, SYSTEMID, REQUESTID)
                             REFERENCES BACKREQUEST  (SAREAID, 
              SYSTEMID, REQUESTID)
                             ON DELETE CASCADE;


ALTER TABLE BINPROPERTY
       ADD CONSTRAINT R_166
              FOREIGN KEY (BINARYDATAID)
                             REFERENCES BINARYDATA  (BINARYDATAID);


ALTER TABLE BINPROPERTY
       ADD CONSTRAINT R_167
              FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;


ALTER TABLE CASHIER
       ADD CONSTRAINT R_46
              FOREIGN KEY (CASHIERGRPID)
                             REFERENCES CASHIERGRP  (CASHIERGRPID);


ALTER TABLE CASHIERPVG
       ADD CONSTRAINT R_47
              FOREIGN KEY (CASHIERGRPID)
                             REFERENCES CASHIERGRP  (CASHIERGRPID)
                             ON DELETE CASCADE;


ALTER TABLE CASHIO
       ADD CONSTRAINT FK_CASHIO_SESS
              FOREIGN KEY (SESSID, SYSTEMID, SAREAID)
                             REFERENCES SESS  (SESSID, SYSTEMID, 
              SAREAID);


ALTER TABLE CASHPROFILE
       ADD CONSTRAINT R_116
              FOREIGN KEY (SYSLOGPROFILEID)
                             REFERENCES SYSLOGPROFILE  (
              SYSLOGPROFILEID);


ALTER TABLE CASHPROFILEBPVG
       ADD CONSTRAINT R_175
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE CASHPROFILECOLOR
       ADD CONSTRAINT R_56
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE CASHPROFILEKEY
       ADD CONSTRAINT R_57
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE CASHPROFILEPVG
       ADD CONSTRAINT R_50
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE CASHPROFILESPVG
       ADD CONSTRAINT R_96
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE CLNT
       ADD CONSTRAINT R_307
              FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID);


ALTER TABLE CLNT
       ADD CONSTRAINT R_258
              FOREIGN KEY (COMPANYID)
                             REFERENCES COMPANY  (COMPANYID);


ALTER TABLE CLNT
       ADD CONSTRAINT R_30
              FOREIGN KEY (CLNTGRPID)
                             REFERENCES CLNTGRP  (CLNTGRPID);


ALTER TABLE CLNTFORMITEMS
       ADD CONSTRAINT R_281
              FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTFORMPROPERTY
       ADD CONSTRAINT R_288
              FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTFORMPROPERTY
       ADD CONSTRAINT R_290
              FOREIGN KEY (CLNTFORMID, CLNTFORMITEMID)
                             REFERENCES CLNTFORMITEMS  (CLNTFORMID, 
              CLNTFORMITEMID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTFORMRESULTITEMS
       ADD CONSTRAINT FK_CLNTFORMRESITEMS_CLNTFORMRE
              FOREIGN KEY (SAREAID, SYSTEMID, CLNTFORMRESULTID)
                             REFERENCES CLNTFORMRESULT  (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTGRP
       ADD CONSTRAINT R_253
              FOREIGN KEY (BONUSID)
                             REFERENCES BONUS  (BONUSID);


ALTER TABLE CLNTGRP
       ADD CONSTRAINT R_32
              FOREIGN KEY (DISCID)
                             REFERENCES DISC  (DISCID);


ALTER TABLE CLNTPROPERTY
       ADD CONSTRAINT R_286
              FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTSUM
       ADD CONSTRAINT R_287
              FOREIGN KEY (LOYALTYCLUBID)
                             REFERENCES LOYALTYCLUB  (LOYALTYCLUBID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTSUM
       ADD CONSTRAINT R_285
              FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID)
                             ON DELETE CASCADE;


ALTER TABLE CLNTSUM
       ADD CONSTRAINT R_262
              FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;


ALTER TABLE COMPANY
       ADD CONSTRAINT R_266
              FOREIGN KEY (PURCHPRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE COMPANY
       ADD CONSTRAINT R_176
              FOREIGN KEY (COMPANYGRPID)
                             REFERENCES COMPANYGRP  (COMPANYGRPID);


ALTER TABLE COMPOSINGR
       ADD CONSTRAINT R_267
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID)
                             ON DELETE SET NULL;


ALTER TABLE COMPOSINGR
       ADD CONSTRAINT R_261
              FOREIGN KEY (COMPOSCARDID)
                             REFERENCES COMPOSCARD  (COMPOSCARDID);


ALTER TABLE DATAPUMPCFG
       ADD CONSTRAINT R_67
              FOREIGN KEY (PROFILEID)
                             REFERENCES PUMPPROFILE  (PROFILEID);


ALTER TABLE DATASYNCSERVERCFG
       ADD CONSTRAINT R_66
              FOREIGN KEY (PROFILEID)
                             REFERENCES SYNCPROFILE  (PROFILEID);


ALTER TABLE DCARD
       ADD CONSTRAINT R_31
              FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID);


ALTER TABLE DOCHEADER
       ADD CONSTRAINT R_149
              FOREIGN KEY (SAREAID, SYSTEMID, DOCID)
                             REFERENCES DOC  (SAREAID, SYSTEMID, 
              DOCID)
                             ON DELETE CASCADE;


ALTER TABLE DOCITEMS
       ADD CONSTRAINT R_150
              FOREIGN KEY (SAREAID, SYSTEMID, DOCID)
                             REFERENCES DOC  (SAREAID, SYSTEMID, 
              DOCID)
                             ON DELETE CASCADE;


ALTER TABLE DOCREQUEST
       ADD CONSTRAINT R_170
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE DOCREQUESTHEADER
       ADD CONSTRAINT R_151
              FOREIGN KEY (SAREAID, DOCID)
                             REFERENCES DOCREQUEST  (SAREAID, DOCID)
                             ON DELETE CASCADE;


ALTER TABLE DOCREQUESTITEMS
       ADD CONSTRAINT R_140
              FOREIGN KEY (SAREAID, DOCID)
                             REFERENCES DOCREQUEST  (SAREAID, DOCID)
                             ON DELETE CASCADE;


ALTER TABLE DOCREQUESTITEMS
       ADD CONSTRAINT R_141
              FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE EXBARC
       ADD CONSTRAINT R_7
              FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE EXTGRP
       ADD CONSTRAINT R_187
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE FIRM
       ADD CONSTRAINT R_275
              FOREIGN KEY (LOYALTYCLUBID)
                             REFERENCES LOYALTYCLUB  (LOYALTYCLUBID);


ALTER TABLE FIRM
       ADD CONSTRAINT R_274
              FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);


ALTER TABLE FIRMWAREHOUSE
       ADD CONSTRAINT R_294
              FOREIGN KEY (FIRMID)
                             REFERENCES FIRM  (FIRMID)
                             ON DELETE CASCADE;


ALTER TABLE FIRMWAREHOUSE
       ADD CONSTRAINT R_295
              FOREIGN KEY (WAREHOUSEID)
                             REFERENCES WAREHOUSE  (WAREHOUSEID)
                             ON DELETE CASCADE;


ALTER TABLE GRP
       ADD CONSTRAINT R_43
              FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);


ALTER TABLE HALL
       ADD CONSTRAINT R_201
              FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);


ALTER TABLE HALL
       ADD CONSTRAINT R_190
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE LOCALCLNTFORMRESULTITEMS
       ADD CONSTRAINT FK_LOCALCLNTFORMRESITEMS_CLNTF
              FOREIGN KEY (SAREAID, SYSTEMID, CLNTFORMRESULTID)
                             REFERENCES LOCALCLNTFORMRESULT  (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID)
                             ON DELETE CASCADE;


ALTER TABLE LOCALREQUESTITEMS
       ADD CONSTRAINT R_271
              FOREIGN KEY (SAREAID, SYSTEMID, REQUESTID)
                             REFERENCES LOCALREQUEST  (SAREAID, 
              SYSTEMID, REQUESTID)
                             ON DELETE CASCADE;


ALTER TABLE LOYALTYCLUB
       ADD CONSTRAINT R_306
              FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID);


ALTER TABLE LOYALTYCLUB
       ADD CONSTRAINT R_276
              FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);


ALTER TABLE LOYALTYCLUB
       ADD CONSTRAINT R_277
              FOREIGN KEY (BONUSACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);


ALTER TABLE LOYALTYCLUB
       ADD CONSTRAINT R_278
              FOREIGN KEY (ACCUMACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);


ALTER TABLE MSGSUB
       ADD CONSTRAINT R_301
              FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID);


ALTER TABLE MSGSUBPARAM
       ADD CONSTRAINT R_300
              FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID)
                             ON DELETE CASCADE;


ALTER TABLE NUMPROPERTY
       ADD CONSTRAINT R_84
              FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;


ALTER TABLE NUMPROPERTY
       ADD CONSTRAINT R_103
              FOREIGN KEY (NUMBERID)
                             REFERENCES NUMBERS  (NUMBERID);


ALTER TABLE OFFER
       ADD CONSTRAINT R_263
              FOREIGN KEY (SALEOFFERID)
                             REFERENCES SALEOFFER  (SALEOFFERID);


ALTER TABLE OFFER
       ADD CONSTRAINT R_255
              FOREIGN KEY (BONUSOFFERID)
                             REFERENCES BONUSOFFER  (BONUSOFFERID);


ALTER TABLE OFFER
       ADD CONSTRAINT R_33
              FOREIGN KEY (DISCOFFERID)
                             REFERENCES DISCOFFER  (DISCOFFERID);


ALTER TABLE PACK
       ADD CONSTRAINT R_6
              FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE PACK
       ADD CONSTRAINT R_9
              FOREIGN KEY (BARCID)
                             REFERENCES BARC  (BARCID);


ALTER TABLE PACK
       ADD CONSTRAINT R_10
              FOREIGN KEY (TAREID)
                             REFERENCES TARE  (TAREID);


ALTER TABLE PACK
       ADD CONSTRAINT R_45
              FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);


ALTER TABLE PACK
       ADD CONSTRAINT R_69
              FOREIGN KEY (UNITID)
                             REFERENCES UNIT  (UNITID);


ALTER TABLE PACK
       ADD CONSTRAINT R_108
              FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID);


ALTER TABLE PACKPRC
       ADD CONSTRAINT R_241
              FOREIGN KEY (TRFSCHEMEID)
                             REFERENCES TRFSCHEME  (TRFSCHEMEID);


ALTER TABLE PACKPRC
       ADD CONSTRAINT R_15
              FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE PACKPRC
       ADD CONSTRAINT R_16
              FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE PAYMENTSCHEMEITEMS
       ADD CONSTRAINT R_214
              FOREIGN KEY (PAYMENTSCHEMEID)
                             REFERENCES PAYMENTSCHEME  (
              PAYMENTSCHEMEID);


ALTER TABLE PAYMENTSCHEMEITEMS
       ADD CONSTRAINT R_215
              FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);


ALTER TABLE PAYMENTSCHEMEITEMS
       ADD CONSTRAINT R_269
              FOREIGN KEY (ACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);


ALTER TABLE PCREQUESTITEMSSYNC
       ADD CONSTRAINT R_271C
              FOREIGN KEY (SAREAID, SYSTEMID, REQUESTID)
                             REFERENCES PCREQUESTSYNC  (SAREAID, 
              SYSTEMID, REQUESTID)
                             ON DELETE CASCADE;


ALTER TABLE PLACE
       ADD CONSTRAINT R_200
              FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);


ALTER TABLE PLACE
       ADD CONSTRAINT R_162
              FOREIGN KEY (HALLID)
                             REFERENCES HALL  (HALLID);


ALTER TABLE PRNGRPPRNSCHEME
       ADD CONSTRAINT R_203
              FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);


ALTER TABLE PRNGRPPRNSCHEME
       ADD CONSTRAINT R_202
              FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);


ALTER TABLE PRNPRNGRP
       ADD CONSTRAINT R_180
              FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);


ALTER TABLE PRNPRNGRP
       ADD CONSTRAINT R_181
              FOREIGN KEY (PRNID)
                             REFERENCES PRN  (PRNID);


ALTER TABLE REST
       ADD CONSTRAINT R_296
              FOREIGN KEY (WAREHOUSEID)
                             REFERENCES WAREHOUSE  (WAREHOUSEID)
                             ON DELETE CASCADE;


ALTER TABLE REST
       ADD CONSTRAINT R_197
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE REST
       ADD CONSTRAINT R_193
              FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE SALES
       ADD CONSTRAINT FK_SALES_SESS
              FOREIGN KEY (SESSID, SYSTEMID, SAREAID)
                             REFERENCES SESS  (SESSID, SYSTEMID, 
              SAREAID);


ALTER TABLE SALESEXT
       ADD CONSTRAINT FK_SALESEXT_SALES
              FOREIGN KEY (SAREAID, SYSTEMID, SESSID, SALESNUM)
                             REFERENCES SALES  (SAREAID, SYSTEMID, 
              SESSID, SALESNUM)
                             ON DELETE CASCADE;


ALTER TABLE SAMCLNTFORMRESULTITEMS
       ADD CONSTRAINT FK_SAMCLNTFORMRESITEMS_CLNTFOR
              FOREIGN KEY (SAREAID, SYSTEMID, CLNTFORMRESULTID)
                             REFERENCES SAMCLNTFORMRESULT  (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID)
                             ON DELETE CASCADE;


ALTER TABLE SAMGRACTIONFIELDS
       ADD CONSTRAINT R_65
              FOREIGN KEY (ACTIONID)
                             REFERENCES SAMGRACTION  (ACTIONID)
                             ON DELETE CASCADE;


ALTER TABLE SAMREQUESTITEMSSYNC
       ADD CONSTRAINT R_292
              FOREIGN KEY (SAREAID, SYSTEMID, REQUESTID)
                             REFERENCES SAMREQUESTSYNC  (SAREAID, 
              SYSTEMID, REQUESTID)
                             ON DELETE CASCADE;


ALTER TABLE SAREA
       ADD CONSTRAINT R_273
              FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_205
              FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_196
              FOREIGN KEY (WAREHOUSEID)
                             REFERENCES WAREHOUSE  (WAREHOUSEID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_17
              FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_26
              FOREIGN KEY (ARTHOTKEYSETID)
                             REFERENCES ARTHOTKEYSET  (ARTHOTKEYSETID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_28
              FOREIGN KEY (FIRMID)
                             REFERENCES FIRM  (FIRMID);


ALTER TABLE SAREA
       ADD CONSTRAINT R_52
              FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID);


ALTER TABLE SAREACASHIER
       ADD CONSTRAINT R_48
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREACASHIER
       ADD CONSTRAINT R_49
              FOREIGN KEY (CASHIERID)
                             REFERENCES CASHIER  (CASHIERID);


ALTER TABLE SAREACLNTFORM
       ADD CONSTRAINT R_282
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID)
                             ON DELETE CASCADE;


ALTER TABLE SAREACLNTFORM
       ADD CONSTRAINT R_283
              FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID)
                             ON DELETE CASCADE;


ALTER TABLE SAREACLNTGRP
       ADD CONSTRAINT R_254
              FOREIGN KEY (BONUSID)
                             REFERENCES BONUS  (BONUSID);


ALTER TABLE SAREACLNTGRP
       ADD CONSTRAINT R_36
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREACLNTGRP
       ADD CONSTRAINT R_38
              FOREIGN KEY (DISCID)
                             REFERENCES DISC  (DISCID);


ALTER TABLE SAREACLNTGRP
       ADD CONSTRAINT R_42
              FOREIGN KEY (CLNTGRPID)
                             REFERENCES CLNTGRP  (CLNTGRPID);


ALTER TABLE SAREAMSGSUB
       ADD CONSTRAINT R_302
              FOREIGN KEY (MSGSUBID)
                             REFERENCES MSGSUB  (MSGSUBID);


ALTER TABLE SAREAMSGSUB
       ADD CONSTRAINT R_303
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREAMSGSUB
       ADD CONSTRAINT R_305
              FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT R_264
              FOREIGN KEY (SALEOFFERID)
                             REFERENCES SALEOFFER  (SALEOFFERID);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT R_251
              FOREIGN KEY (BONUSOFFERID)
                             REFERENCES BONUSOFFER  (BONUSOFFERID);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT R_34
              FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT R_35
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREAOFFER
       ADD CONSTRAINT R_39
              FOREIGN KEY (DISCOFFERID)
                             REFERENCES DISCOFFER  (DISCOFFERID);


ALTER TABLE SAREAPRC
       ADD CONSTRAINT R_18
              FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE SAREAPRC
       ADD CONSTRAINT R_19
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREASAUSER
       ADD CONSTRAINT R_169
              FOREIGN KEY (SAUSERID)
                             REFERENCES SAUSER  (SAUSERID);


ALTER TABLE SAREASAUSER
       ADD CONSTRAINT R_171
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREATXTBIN
       ADD CONSTRAINT R_112
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SAREATXTBIN
       ADD CONSTRAINT R_113
              FOREIGN KEY (TXTBINID)
                             REFERENCES TXTBIN  (TXTBINID);


ALTER TABLE SAUSER
       ADD CONSTRAINT R_95
              FOREIGN KEY (SAUSERPROFILEID)
                             REFERENCES SAUSERPROFILE  (
              SAUSERPROFILEID);


ALTER TABLE SAUSERPVG
       ADD CONSTRAINT R_94
              FOREIGN KEY (SAUSERPROFILEID)
                             REFERENCES SAUSERPROFILE  (
              SAUSERPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE SDEPT
       ADD CONSTRAINT R_72
              FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SESS
       ADD CONSTRAINT FK_SESS_WORKDAY
              FOREIGN KEY (WORKDAYID, SYSTEMID, SAREAID)
                             REFERENCES WORKDAY  (WORKDAYID, SYSTEMID, 
              SAREAID);


ALTER TABLE SESSEND
       ADD CONSTRAINT FK_SESSEND_SESS
              FOREIGN KEY (SESSID, SYSTEMID, SAREAID)
                             REFERENCES SESS  (SESSID, SYSTEMID, 
              SAREAID)
                             ON DELETE CASCADE;


ALTER TABLE STRPROPERTY
       ADD CONSTRAINT R_83
              FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;


ALTER TABLE STRPROPERTY
       ADD CONSTRAINT R_105
              FOREIGN KEY (STRINGID)
                             REFERENCES STRINGS  (STRINGID);


ALTER TABLE SYSLOGEVENT
       ADD CONSTRAINT R_114
              FOREIGN KEY (SYSLOGPROFILEID)
                             REFERENCES SYSLOGPROFILE  (
              SYSLOGPROFILEID)
                             ON DELETE CASCADE;


ALTER TABLE TAX
       ADD CONSTRAINT R_3
              FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);


ALTER TABLE TRFDAY
       ADD CONSTRAINT R_235
              FOREIGN KEY (TRFSCHEMEID)
                             REFERENCES TRFSCHEME  (TRFSCHEMEID);


ALTER TABLE TRFDAYTRFTIME
       ADD CONSTRAINT R_238
              FOREIGN KEY (TRFTIMEID)
                             REFERENCES TRFTIME  (TRFTIMEID);


ALTER TABLE TRFDAYTRFTIME
       ADD CONSTRAINT R_236
              FOREIGN KEY (TRFDAYOFWEEK, TRFSCHEMEID)
                             REFERENCES TRFDAY  (TRFDAYOFWEEK, 
              TRFSCHEMEID);


ALTER TABLE WORKDAYEND
       ADD CONSTRAINT FK_WORKDAYEND_WORKDAY
              FOREIGN KEY (WORKDAYID, SYSTEMID, SAREAID)
                             REFERENCES WORKDAY  (WORKDAYID, SYSTEMID, 
              SAREAID)
                             ON DELETE CASCADE;


ALTER TABLE ZREP
       ADD CONSTRAINT FK_ZREP_WORKDAY
              FOREIGN KEY (WORKDAYID, SYSTEMID, SAREAID)
                             REFERENCES WORKDAY  (WORKDAYID, SYSTEMID, 
              SAREAID);



alter table SALESEXT drop constraint FK_SALESEXT_SALES;
alter table SALES drop constraint FK_SALES_SESS;
alter table SESS drop constraint FK_SESS_WORKDAY;
alter table WORKDAYEND drop constraint FK_WORKDAYEND_WORKDAY;
alter table ZREP drop constraint FK_ZREP_WORKDAY;
alter table CASHIO drop constraint FK_CASHIO_SESS;



