CREATE SEQUENCE SYSLOGSEQ_GEN INCREMENT BY 1 START WITH 1 CACHE 20;

CREATE TABLE ART (
       ARTID                INTEGER NOT NULL,
       GRPID                INTEGER NOT NULL,
       OFFERID              INTEGER NULL,
       TAXGRPID             INTEGER NOT NULL,
       MODGRPID             INTEGER NULL,
       ARTCODE              INTEGER NOT NULL,
       COMPOSCARDID         INTEGER NULL,
       ARTNAME              character varying(50) NOT NULL,
       ARTSNAME             character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE UNIQUE INDEX XAK1ART ON ART
(
       ARTCODE                        ASC
);

CREATE INDEX IDX_ART_UN ON ART
(
       UPDATENUM                      ASC
);


ALTER TABLE ART
       ADD PRIMARY KEY (ARTID);


CREATE TABLE ARTSDEPT (
       ARTID                INTEGER NOT NULL,
       SDEPTID              INTEGER NOT NULL,
       ARTNUM               INTEGER NULL,
       KEYID                INTEGER NULL,
       PACKSHELFLIFE        INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_ARTSDEPT_UN ON ARTSDEPT
(
       UPDATENUM                      ASC
);


ALTER TABLE ARTSDEPT
       ADD PRIMARY KEY (ARTID, SDEPTID);


CREATE TABLE BARC (
       BARCID               INTEGER NOT NULL,
       BARCNAME             character varying(50) NULL,
       BARCMASK             character varying(30) NOT NULL,
       PREFIXLEN            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE UNIQUE INDEX XAK1BARC ON BARC
(
       BARCMASK                       ASC
);


ALTER TABLE BARC
       ADD PRIMARY KEY (BARCID);


CREATE TABLE DATAPUMPCFG (
       CFGKEY               character varying(50) NOT NULL,
       PROFILEID            INTEGER NOT NULL,
       CFGVALUE             character varying(100) NOT NULL
);


ALTER TABLE DATAPUMPCFG
       ADD PRIMARY KEY (CFGKEY, PROFILEID);


CREATE TABLE DATAPUMPDIRS (
       DIRNAME              character varying(50) NOT NULL,
       SOURCETYPE           INTEGER NOT NULL,
       PUMPDIR              INTEGER NOT NULL,
       UPDATETIME           character varying(14) NULL,
       PUMPPRIORITY         INTEGER NOT NULL,
       PUMPUPDATENUM        INTEGER NOT NULL
);


ALTER TABLE DATAPUMPDIRS
       ADD PRIMARY KEY (DIRNAME, SOURCETYPE);


CREATE TABLE DATASYNCCLNT (
       CLNTKEY              character varying(50) NOT NULL,
       CLNTVALUE            character varying(100) NULL
);


ALTER TABLE DATASYNCCLNT
       ADD PRIMARY KEY (CLNTKEY);


CREATE TABLE DATASYNCDIRS (
       DIRNAME              character varying(50) NOT NULL,
       SYNCDIR              INTEGER NOT NULL,
       UPDATENUM            INTEGER NOT NULL,
       SYNCPRIORITY         INTEGER NOT NULL
);


ALTER TABLE DATASYNCDIRS
       ADD PRIMARY KEY (DIRNAME);


CREATE TABLE EVENTS (
       EVENTCODE            INTEGER NOT NULL,
       EVENTLENG            INTEGER NOT NULL,
       EVENTCONTENT         character varying(1024) NOT NULL
);


ALTER TABLE EVENTS
       ADD PRIMARY KEY (EVENTCODE, EVENTLENG);


CREATE TABLE FIRM (
       FIRMID               INTEGER NOT NULL,
       LOYALTYCLUBID        INTEGER NULL,
       FIRMNAME             character varying(100) NOT NULL,
       CURRENCYID           INTEGER NULL,
       FIRMADDR             character varying(100) NULL,
       DOCPREFIX            character varying(30) NULL,
       CERTIFICATENUM       character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       MAILADDR             character varying(100) NULL,
       UPDATENUM            INTEGER NOT NULL,
       PHONES               character varying(50) NULL,
       REGISTRYNUM          character varying(50) NULL,
       TAXIDENTNUM          character varying(50) NULL,
       ASKPINCODE           SMALLINT NULL
);


ALTER TABLE FIRM
       ADD PRIMARY KEY (FIRMID);


CREATE TABLE GRP (
       GRPID                INTEGER NOT NULL,
       OFFERID              INTEGER NULL,
       PARENTGRPID          INTEGER NULL,
       GRPNAME              character varying(50) NOT NULL,
       GRPPICTURE           bytea NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE GRP
       ADD PRIMARY KEY (GRPID);


CREATE TABLE MPDBINFO (
       INFOKEY              character varying(30) NOT NULL,
       INFOVAL              character varying(100) NULL
);


ALTER TABLE MPDBINFO
       ADD PRIMARY KEY (INFOKEY);


CREATE TABLE PACK (
       PACKID               INTEGER NOT NULL,
       ARTID                INTEGER NOT NULL,
       BARCID               INTEGER NULL,
       TAREID               INTEGER NULL,
       OFFERID              INTEGER NULL,
       UNITID               INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NULL,
       PACKNAME             character varying(50) NULL,
       PACKQUANT            INTEGER NOT NULL,
       QUANTMASK            INTEGER NOT NULL,
       PACKDTYPE            INTEGER NOT NULL,
       PACKSHELFLIFE        INTEGER NOT NULL,
       ISDEFAULT            SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PACK_UN ON PACK
(
       UPDATENUM                      ASC
);

CREATE INDEX PACK_ARTID ON PACK
(
       ARTID                          ASC
);


ALTER TABLE PACK
       ADD PRIMARY KEY (PACKID);


CREATE TABLE PACKPRC (
       PACKID               INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       TRFSCHEMEID          INTEGER NULL,
       PACKPRICE            DECIMAL(18,6) NOT NULL,
       PACKMINPRICE         DECIMAL(18,6) NOT NULL,
       PACKBONUSMINPRICE    DECIMAL(18,6) NOT NULL,
       PACKEXTMINPRICE      DECIMAL(18,6) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PACKPRC_UN ON PACKPRC
(
       UPDATENUM                      ASC
);


ALTER TABLE PACKPRC
       ADD PRIMARY KEY (PACKID, PRCLEVELID);


CREATE TABLE PKHOLDER (
       TABLENAME            character varying(50) NOT NULL,
       FIELDNAME            character varying(50) NOT NULL,
       LASTPK               INTEGER NOT NULL
);


ALTER TABLE PKHOLDER
       ADD PRIMARY KEY (TABLENAME, FIELDNAME);


CREATE TABLE PRCLEVEL (
       PRCLEVELID           INTEGER NOT NULL,
       PRCLEVELNAME         character varying(50) NOT NULL,
       PRCLEVELKEY          INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE PRCLEVEL
       ADD PRIMARY KEY (PRCLEVELID);


CREATE TABLE PROPERTYGRP (
       PROPERTYGRPID        INTEGER NOT NULL,
       PROPERTYGRPNAME      character varying(50) NOT NULL,
       PROPERTYGRPTYPE      INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_PROPERTYGRP_UN ON PROPERTYGRP
(
       UPDATENUM                      ASC
);


ALTER TABLE PROPERTYGRP
       ADD PRIMARY KEY (PROPERTYGRPID);


CREATE TABLE PUMPPROFILE (
       PROFILEID            INTEGER NOT NULL,
       PROFILENAME          character varying(30) NOT NULL
);


ALTER TABLE PUMPPROFILE
       ADD PRIMARY KEY (PROFILEID);


CREATE TABLE SAMGRACTION (
       ACTIONID             INTEGER NOT NULL,
       ACTIONNAME           character varying(50) NOT NULL,
       ISACTIVE             SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAMGRACTION
       ADD PRIMARY KEY (ACTIONID);


CREATE TABLE SAMGRACTIONFIELDS (
       ACTIONID             INTEGER NOT NULL,
       DIRNAME              character varying(30) NOT NULL,
       FIELDNAME            character varying(30) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAMGRACTIONFIELDS
       ADD PRIMARY KEY (ACTIONID, DIRNAME, FIELDNAME);


CREATE TABLE SAREA (
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       CASHPROFILEID        INTEGER NOT NULL,
       ARTHOTKEYSETID       INTEGER NULL,
       FIRMID               INTEGER NOT NULL,
       WAREHOUSEID          INTEGER NULL,
       PRNSCHEMEID          INTEGER NULL,
       CURRENCYID           INTEGER NULL,
       SAREANAME            character varying(50) NOT NULL,
       SAREAADDR            character varying(100) NULL,
       DELFLAG              SMALLINT NOT NULL,
       ASKPINCODE           SMALLINT NULL,
       RECEIPTHEADER        character varying(100) NULL,
       RECEIPTFOOTER        character varying(100) NULL,
       UPDATENUM            INTEGER NOT NULL,
       RECEIPTFIRSTHEADER   character varying(100) NULL,
       RECEIPTENDFOOTER     character varying(100) NULL
);


ALTER TABLE SAREA
       ADD PRIMARY KEY (SAREAID);


CREATE TABLE SAREACLNTCFG (
       CFGKEY               character varying(30) NOT NULL,
       CFGVALUE             character varying(100) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREACLNTCFG
       ADD PRIMARY KEY (CFGKEY);


CREATE TABLE SAREAPRC (
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SAREAPRC
       ADD PRIMARY KEY (SAREAID, PRCLEVELID);


CREATE TABLE SCALE (
       SCALEID              INTEGER NOT NULL,
       SDEPTID              INTEGER NULL,
       SCALENAME            character varying(50) NOT NULL,
       SCALEMODEL           character varying(50) NOT NULL,
       PORTTYPE             character varying(30) NOT NULL,
       PORTNUMBER           INTEGER NOT NULL,
       PORTADDRESS          character varying(50) NULL,
       SCALESTATUS          INTEGER NOT NULL,
       ERRORNUM             INTEGER NOT NULL,
       SCALEERROR           character varying(2000) NULL,
       ISACTIVE             SMALLINT NOT NULL,
       LASTSYNCTIME         character varying(14) NOT NULL
);

CREATE INDEX IDX_SCALE_SDEPTID ON SCALE
(
       SDEPTID                        ASC
);


ALTER TABLE SCALE
       ADD PRIMARY KEY (SCALEID);


CREATE TABLE SCALEACTIVITY (
       SAREAID              INTEGER NOT NULL,
       SYSTEMID             INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       SCALENAME            character varying(50) NOT NULL,
       SCALEFRIENDLYNAME    character varying(50) NOT NULL,
       ERRORNUM             INTEGER NOT NULL,
       ERRORMSG             character varying(2000) NULL,
       ISACTIVE             SMALLINT NOT NULL,
       LASTSYNCTIME         character varying(14) NULL,
       LASTPINGTIME         character varying(14) NULL,
       UPDATENUM            INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALEACTIVITY
       ADD PRIMARY KEY (SAREAID, SYSTEMID, SCALEID);


CREATE TABLE SCALEART (
       ARTCODE              INTEGER NOT NULL,
       TAREID               INTEGER NULL,
       PROPERTYGRPID        INTEGER NULL,
       ARTID                INTEGER NOT NULL,
       PACKID               INTEGER NOT NULL,
       ARTNAME              character varying(50) NOT NULL,
       ARTSNAME             character varying(50) NULL,
       PACKDTYPE            INTEGER NOT NULL,
       PACKSHELFLIFE        INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE UNIQUE INDEX XAK1SCALEART ON SCALEART
(
       ARTID                          ASC
);

CREATE INDEX IDX_SCALEART_TAREID ON SCALEART
(
       TAREID                         ASC
);

CREATE INDEX IDX_SCALEART_PROPERTYGRPID ON SCALEART
(
       PROPERTYGRPID                  ASC
);


ALTER TABLE SCALEART
       ADD PRIMARY KEY (ARTCODE);


CREATE TABLE SCALEARTEX (
       ARTCODE              INTEGER NOT NULL,
       SDEPTID              INTEGER NOT NULL,
       PACKPRICE            DECIMAL(18,6) NOT NULL,
       ARTNUM               INTEGER NOT NULL,
       PACKSHELFLIFE        INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE INDEX IDX_SCALEARTEX_ARTNUM ON SCALEARTEX
(
       ARTNUM                         ASC
);


ALTER TABLE SCALEARTEX
       ADD PRIMARY KEY (ARTCODE, SDEPTID);


CREATE TABLE SCALEARTMAP (
       ARTCODE              INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       DIRTY                SMALLINT NOT NULL
);


ALTER TABLE SCALEARTMAP
       ADD PRIMARY KEY (ARTCODE, SCALEID);


CREATE TABLE SCALEDIRS (
       DIRNAME              character varying(30) NOT NULL,
       DIRUPDATENUM         INTEGER NOT NULL
);


ALTER TABLE SCALEDIRS
       ADD PRIMARY KEY (DIRNAME);


CREATE TABLE SCALEETXT (
       STRINGID             INTEGER NOT NULL,
       ETXTTEXT             character varying(1024) NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALEETXT
       ADD PRIMARY KEY (STRINGID);


CREATE TABLE SCALEETXTEX (
       STRINGID             INTEGER NOT NULL,
       SDEPTID              INTEGER NOT NULL,
       ETXTNUM              INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE INDEX IDX_SCALEETXTEX_ETXTNUM ON SCALEETXTEX
(
       ETXTNUM                        ASC
);


ALTER TABLE SCALEETXTEX
       ADD PRIMARY KEY (STRINGID, SDEPTID);


CREATE TABLE SCALEETXTMAP (
       STRINGID             INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       DIRTY                SMALLINT NOT NULL
);


ALTER TABLE SCALEETXTMAP
       ADD PRIMARY KEY (STRINGID, SCALEID);


CREATE TABLE SCALEFIXEDKEYSMAP (
       KEYID                INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       ARTCODE              INTEGER NOT NULL,
       DIRTY                SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE INDEX IDX_KEYMAP_ARTCODE ON SCALEFIXEDKEYSMAP
(
       ARTCODE                        ASC
);


ALTER TABLE SCALEFIXEDKEYSMAP
       ADD PRIMARY KEY (KEYID, SCALEID);


CREATE TABLE SCALEMANAGERCFG (
       CFGKEY               INTEGER NOT NULL,
       CFGVALUE             character varying(1024) NULL
);


ALTER TABLE SCALEMANAGERCFG
       ADD PRIMARY KEY (CFGKEY);


CREATE TABLE SCALEPARAM (
       SCALEID              INTEGER NOT NULL,
       PARAMKEY             INTEGER NOT NULL,
       PARAMVALUE           character varying(100) NOT NULL
);


ALTER TABLE SCALEPARAM
       ADD PRIMARY KEY (SCALEID, PARAMKEY);


CREATE TABLE SCALEPROPERTYGRP (
       PROPERTYGRPID        INTEGER NOT NULL,
       STRINGID             INTEGER NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE INDEX IDX_PROPERTYGRP_STRINGID ON SCALEPROPERTYGRP
(
       STRINGID                       ASC
);


ALTER TABLE SCALEPROPERTYGRP
       ADD PRIMARY KEY (PROPERTYGRPID);


CREATE TABLE SCALESAREA (
       SAREAID              INTEGER NOT NULL,
       PRCLEVELID           INTEGER NOT NULL,
       SAREANAME            character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALESAREA
       ADD PRIMARY KEY (SAREAID);


CREATE TABLE SCALESDEPT (
       SDEPTID              INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SDEPTNAME            character varying(50) NOT NULL,
       ARTFORCENUM          INTEGER NOT NULL,
       RELOADDATA           INTEGER NOT NULL,
       UPDATESNUM           SMALLINT NOT NULL,
       KEYSSETTYPE          INTEGER NOT NULL,
       UPDATEKEYS           SMALLINT NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALESDEPT
       ADD PRIMARY KEY (SDEPTID);


CREATE TABLE SCALETARE (
       TAREID               INTEGER NOT NULL,
       TARENAME             character varying(50) NOT NULL,
       TAREWEIGHT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);


ALTER TABLE SCALETARE
       ADD PRIMARY KEY (TAREID);


CREATE TABLE SCALETAREEX (
       TAREID               INTEGER NOT NULL,
       SDEPTID              INTEGER NOT NULL,
       TARENUM              INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL
);

CREATE INDEX IDX_SCALETAREEX_TARENUM ON SCALETAREEX
(
       TARENUM                        ASC
);


ALTER TABLE SCALETAREEX
       ADD PRIMARY KEY (TAREID, SDEPTID);


CREATE TABLE SCALETAREMAP (
       TAREID               INTEGER NOT NULL,
       SCALEID              INTEGER NOT NULL,
       DIRTY                SMALLINT NOT NULL
);


ALTER TABLE SCALETAREMAP
       ADD PRIMARY KEY (TAREID, SCALEID);


CREATE TABLE SDEPT (
       SDEPTID              INTEGER NOT NULL,
       SAREAID              INTEGER NOT NULL,
       SDEPTNAME            character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE SDEPT
       ADD PRIMARY KEY (SDEPTID);


CREATE TABLE STRINGS (
       STRINGID             INTEGER NOT NULL,
       STRINGVALUE          character varying(1024) NULL,
       STRINGNAME           character varying(50) NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_STRINGS_UN ON STRINGS
(
       UPDATENUM                      ASC
);


ALTER TABLE STRINGS
       ADD PRIMARY KEY (STRINGID);


CREATE TABLE STRPROPERTY (
       STRPROPERTYKEY       INTEGER NOT NULL,
       PROPERTYGRPID        INTEGER NOT NULL,
       STRINGID             INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE STRPROPERTY
       ADD PRIMARY KEY (STRPROPERTYKEY, PROPERTYGRPID);


CREATE TABLE SYSLOG (
       SYSTEMID             INTEGER NOT NULL,
       SEQ                  INTEGER NOT NULL DEFAULT nextval('SYSLOGSEQ_GEN'),
       SAREAID              INTEGER NOT NULL,
       CASHIERID            INTEGER NULL,
       EVENTTIME            character varying(14) NULL,
       EVENTCODE            INTEGER NULL,
       EVENTDATA            character varying(2000) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX XIE1SYSLOG ON SYSLOG
(
       UPDATENUM                      ASC
);

CREATE INDEX XIE2SYSLOG ON SYSLOG
(
       EVENTTIME                      ASC
);

CREATE INDEX XIE3SYSLOG ON SYSLOG
(
       EVENTCODE                      ASC
);


ALTER TABLE SYSLOG
       ADD PRIMARY KEY (SYSTEMID, SEQ, SAREAID);


CREATE TABLE TARE (
       TAREID               INTEGER NOT NULL,
       TARENAME             character varying(50) NULL,
       TAREWEIGHT           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);

CREATE INDEX IDX_TARE_UN ON TARE
(
       UPDATENUM                      ASC
);


ALTER TABLE TARE
       ADD PRIMARY KEY (TAREID);


CREATE TABLE TAX (
       TAXID                INTEGER NOT NULL,
       TAXGRPID             INTEGER NOT NULL,
       TAXNAME              character varying(50) NULL,
       TAXRATE              INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TAX
       ADD PRIMARY KEY (TAXID);


CREATE TABLE TAXGRP (
       TAXGRPID             INTEGER NOT NULL,
       TAXGRPNAME           character varying(50) NULL,
       TAXGRPRATE           INTEGER NOT NULL,
       TAXGRPTYPE           INTEGER NOT NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE TAXGRP
       ADD PRIMARY KEY (TAXGRPID);


CREATE TABLE UNIT (
       UNITID               INTEGER NOT NULL,
       UNITNAME             character varying(50) NOT NULL,
       UNITFULLNAME         character varying(50) NULL,
       DELFLAG              SMALLINT NOT NULL,
       UPDATENUM            INTEGER NOT NULL
);


ALTER TABLE UNIT
       ADD PRIMARY KEY (UNITID);


ALTER TABLE ART
       ADD FOREIGN KEY (GRPID)
                             REFERENCES GRP  (GRPID);


ALTER TABLE ART
       ADD FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);


ALTER TABLE ARTSDEPT
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE ARTSDEPT
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SDEPT  (SDEPTID);


ALTER TABLE DATAPUMPCFG
       ADD FOREIGN KEY (PROFILEID)
                             REFERENCES PUMPPROFILE  (PROFILEID);


ALTER TABLE PACK
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);


ALTER TABLE PACK
       ADD FOREIGN KEY (BARCID)
                             REFERENCES BARC  (BARCID);


ALTER TABLE PACK
       ADD FOREIGN KEY (TAREID)
                             REFERENCES TARE  (TAREID);


ALTER TABLE PACK
       ADD FOREIGN KEY (UNITID)
                             REFERENCES UNIT  (UNITID);


ALTER TABLE PACK
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID);


ALTER TABLE PACKPRC
       ADD FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);


ALTER TABLE PACKPRC
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE SAMGRACTIONFIELDS
       ADD FOREIGN KEY (ACTIONID)
                             REFERENCES SAMGRACTION  (ACTIONID)
                             ON DELETE CASCADE;


ALTER TABLE SAREA
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE SAREA
       ADD FOREIGN KEY (FIRMID)
                             REFERENCES FIRM  (FIRMID);


ALTER TABLE SAREAPRC
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);


ALTER TABLE SAREAPRC
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE SCALE
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SCALESDEPT  (SDEPTID)
                             ON DELETE SET NULL;


ALTER TABLE SCALEART
       ADD FOREIGN KEY (TAREID)
                             REFERENCES SCALETARE  (TAREID);


ALTER TABLE SCALEART
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES SCALEPROPERTYGRP  (
              PROPERTYGRPID);


ALTER TABLE SCALEARTEX
       ADD FOREIGN KEY (ARTCODE)
                             REFERENCES SCALEART  (ARTCODE)
                             ON DELETE CASCADE;


ALTER TABLE SCALEARTEX
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SCALESDEPT  (SDEPTID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEARTMAP
       ADD FOREIGN KEY (ARTCODE)
                             REFERENCES SCALEART  (ARTCODE)
                             ON DELETE CASCADE;


ALTER TABLE SCALEARTMAP
       ADD FOREIGN KEY (SCALEID)
                             REFERENCES SCALE  (SCALEID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEETXTEX
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SCALESDEPT  (SDEPTID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEETXTEX
       ADD FOREIGN KEY (STRINGID)
                             REFERENCES SCALEETXT  (STRINGID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEETXTMAP
       ADD FOREIGN KEY (SCALEID)
                             REFERENCES SCALE  (SCALEID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEETXTMAP
       ADD FOREIGN KEY (STRINGID)
                             REFERENCES SCALEETXT  (STRINGID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEFIXEDKEYSMAP
       ADD FOREIGN KEY (SCALEID)
                             REFERENCES SCALE  (SCALEID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEFIXEDKEYSMAP
       ADD FOREIGN KEY (ARTCODE)
                             REFERENCES SCALEART  (ARTCODE);


ALTER TABLE SCALEPARAM
       ADD FOREIGN KEY (SCALEID)
                             REFERENCES SCALE  (SCALEID)
                             ON DELETE CASCADE;


ALTER TABLE SCALEPROPERTYGRP
       ADD FOREIGN KEY (STRINGID)
                             REFERENCES SCALEETXT  (STRINGID);


ALTER TABLE SCALESDEPT
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SCALESAREA  (SAREAID);


ALTER TABLE SCALETAREEX
       ADD FOREIGN KEY (TAREID)
                             REFERENCES SCALETARE  (TAREID)
                             ON DELETE CASCADE;


ALTER TABLE SCALETAREEX
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SCALESDEPT  (SDEPTID)
                             ON DELETE CASCADE;


ALTER TABLE SCALETAREMAP
       ADD FOREIGN KEY (TAREID)
                             REFERENCES SCALETARE  (TAREID)
                             ON DELETE CASCADE;


ALTER TABLE SCALETAREMAP
       ADD FOREIGN KEY (SCALEID)
                             REFERENCES SCALE  (SCALEID)
                             ON DELETE CASCADE;


ALTER TABLE SDEPT
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);


ALTER TABLE STRPROPERTY
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;


ALTER TABLE STRPROPERTY
       ADD FOREIGN KEY (STRINGID)
                             REFERENCES STRINGS  (STRINGID);


ALTER TABLE TAX
       ADD FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);



