/*
 * Decompiled with CFR 0.152.
 */
package com.github.sardine;

import com.github.sardine.model.Creationdate;
import com.github.sardine.model.Displayname;
import com.github.sardine.model.Getcontentlanguage;
import com.github.sardine.model.Getcontentlength;
import com.github.sardine.model.Getcontenttype;
import com.github.sardine.model.Getetag;
import com.github.sardine.model.Getlastmodified;
import com.github.sardine.model.Propstat;
import com.github.sardine.model.Report;
import com.github.sardine.model.Resourcetype;
import com.github.sardine.model.Response;
import com.github.sardine.model.SupportedReport;
import com.github.sardine.model.SupportedReportSet;
import com.github.sardine.util.SardineUtil;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import javax.xml.namespace.QName;
import org.apache.http.ParseException;
import org.apache.http.message.BasicLineParser;
import org.w3c.dom.Element;

public class DavResource {
    private static final Logger log = Logger.getLogger(DavResource.class.getName());
    public static final String DEFAULT_CONTENT_TYPE = "application/octet-stream";
    public static final long DEFAULT_CONTENT_LENGTH = -1L;
    public static final String HTTPD_UNIX_DIRECTORY_CONTENT_TYPE = "httpd/unix-directory";
    public static final int DEFAULT_STATUS_CODE = 200;
    private static final String SEPARATOR = "/";
    private final URI href;
    private final int status;
    private final DavProperties props;

    protected DavResource(String href, Date creation, Date modified, String contentType, Long contentLength, String etag, String displayName, List<QName> resourceTypes, String contentLanguage, List<QName> supportedReports, Map<QName, String> customProps) throws URISyntaxException {
        this.href = new URI(href);
        this.status = 200;
        this.props = new DavProperties(creation, modified, contentType, contentLength, etag, displayName, resourceTypes, contentLanguage, supportedReports, customProps);
    }

    public DavResource(Response response) throws URISyntaxException {
        this.href = new URI(response.getHref().get(0));
        this.status = this.getStatusCode(response);
        this.props = new DavProperties(response);
    }

    private int getStatusCode(Response response) {
        String status = response.getStatus();
        if (status == null || status.isEmpty()) {
            return 200;
        }
        try {
            return BasicLineParser.parseStatusLine(response.getStatus(), null).getStatusCode();
        }
        catch (ParseException e) {
            log.warning(String.format("Failed to parse status line: %s", status));
            return -1;
        }
    }

    private String getModifiedDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getlastmodified glm;
            if (propstat.getProp() == null || (glm = propstat.getProp().getGetlastmodified()) == null || glm.getContent().size() != 1) continue;
            return glm.getContent().get(0);
        }
        return null;
    }

    private String getCreationDate(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Creationdate gcd;
            if (propstat.getProp() == null || (gcd = propstat.getProp().getCreationdate()) == null || gcd.getContent().size() != 1) continue;
            return gcd.getContent().get(0);
        }
        return null;
    }

    private String getContentType(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && resourcetype.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontenttype gtt = propstat.getProp().getGetcontenttype();
            if (gtt == null || gtt.getContent().size() != 1) continue;
            return gtt.getContent().get(0);
        }
        return DEFAULT_CONTENT_TYPE;
    }

    private long getContentLength(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return -1L;
        }
        for (Propstat propstat : list) {
            Getcontentlength gcl;
            if (propstat.getProp() == null || (gcl = propstat.getProp().getGetcontentlength()) == null || gcl.getContent().size() != 1) continue;
            try {
                return Long.parseLong(gcl.getContent().get(0));
            }
            catch (NumberFormatException e) {
                log.warning(String.format("Failed to parse content length %s", gcl.getContent().get(0)));
            }
        }
        return -1L;
    }

    private String getEtag(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Getetag e;
            if (propstat.getProp() == null || (e = propstat.getProp().getGetetag()) == null || e.getContent().size() != 1) continue;
            return e.getContent().get(0);
        }
        return null;
    }

    private String getContentLanguage(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            Resourcetype resourcetype = propstat.getProp().getResourcetype();
            if (resourcetype != null && resourcetype.getCollection() != null) {
                return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE;
            }
            Getcontentlanguage gtl = propstat.getProp().getGetcontentlanguage();
            if (gtl == null || gtl.getContent().size() != 1) continue;
            return gtl.getContent().get(0);
        }
        return null;
    }

    private String getDisplayName(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        for (Propstat propstat : list) {
            Displayname dn;
            if (propstat.getProp() == null || (dn = propstat.getProp().getDisplayname()) == null || dn.getContent().size() != 1) continue;
            return dn.getContent().get(0);
        }
        return null;
    }

    private List<QName> getResourceTypes(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QName> resourceTypes = new ArrayList<QName>();
        for (Propstat propstat : list) {
            Resourcetype rt;
            if (propstat.getProp() == null || (rt = propstat.getProp().getResourcetype()) == null) continue;
            if (rt.getCollection() != null) {
                resourceTypes.add(SardineUtil.createQNameWithDefaultNamespace("collection"));
            }
            if (rt.getPrincipal() != null) {
                resourceTypes.add(SardineUtil.createQNameWithDefaultNamespace("principal"));
            }
            for (Element element : rt.getAny()) {
                resourceTypes.add(SardineUtil.toQName(element));
            }
        }
        return resourceTypes;
    }

    private List<QName> getSupportedReports(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<QName> supportedReports = new ArrayList<QName>();
        for (Propstat propstat : list) {
            SupportedReportSet srs;
            if (propstat.getProp() == null || (srs = propstat.getProp().getSupportedReportSet()) == null) continue;
            for (SupportedReport sr : srs.getSupportedReport()) {
                Report report = sr.getReport();
                if (report == null || report.getAny() == null) continue;
                supportedReports.add(SardineUtil.toQName(report.getAny()));
            }
        }
        return supportedReports;
    }

    private Map<QName, String> getCustomProps(Response response) {
        List<Propstat> list = response.getPropstat();
        if (list.isEmpty()) {
            return null;
        }
        HashMap<QName, String> customPropsMap = new HashMap<QName, String>();
        for (Propstat propstat : list) {
            if (propstat.getProp() == null) continue;
            List<Element> props = propstat.getProp().getAny();
            for (Element element : props) {
                customPropsMap.put(SardineUtil.toQName(element), element.getTextContent());
            }
        }
        return customPropsMap;
    }

    public int getStatusCode() {
        return this.status;
    }

    public Date getCreation() {
        return this.props.creation;
    }

    public Date getModified() {
        return this.props.modified;
    }

    public String getContentType() {
        return this.props.contentType;
    }

    public Long getContentLength() {
        return this.props.contentLength;
    }

    public String getEtag() {
        return this.props.etag;
    }

    public String getContentLanguage() {
        return this.props.contentLanguage;
    }

    public String getDisplayName() {
        return this.props.displayName;
    }

    public List<QName> getResourceTypes() {
        return this.props.resourceTypes;
    }

    public List<QName> getSupportedReports() {
        return this.props.supportedReports;
    }

    public boolean isDirectory() {
        return HTTPD_UNIX_DIRECTORY_CONTENT_TYPE.equals(this.props.contentType);
    }

    public Map<String, String> getCustomProps() {
        HashMap<String, String> local = new HashMap<String, String>();
        Map<QName, String> properties = this.getCustomPropsNS();
        for (QName key : properties.keySet()) {
            local.put(key.getLocalPart(), properties.get(key));
        }
        return local;
    }

    public Map<QName, String> getCustomPropsNS() {
        return this.props.customProps;
    }

    public URI getHref() {
        return this.href;
    }

    public String getName() {
        String path = this.href.getPath();
        try {
            if (path.endsWith(SEPARATOR)) {
                path = path.substring(0, path.length() - 1);
            }
            return path.substring(path.lastIndexOf(47) + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            log.warning(String.format("Failed to parse name from path %s", path));
            return null;
        }
    }

    public String getPath() {
        return this.href.getPath();
    }

    public String toString() {
        return this.getPath();
    }

    private class DavProperties {
        final Date creation;
        final Date modified;
        final String contentType;
        final String etag;
        final String displayName;
        final List<QName> resourceTypes;
        final String contentLanguage;
        final Long contentLength;
        final List<QName> supportedReports;
        final Map<QName, String> customProps;

        DavProperties(Date creation, Date modified, String contentType, Long contentLength, String etag, String displayName, List<QName> resourceTypes, String contentLanguage, List<QName> supportedReports, Map<QName, String> customProps) {
            this.creation = creation;
            this.modified = modified;
            this.contentType = contentType;
            this.contentLength = contentLength;
            this.etag = etag;
            this.displayName = displayName;
            this.resourceTypes = resourceTypes;
            this.contentLanguage = contentLanguage;
            this.supportedReports = supportedReports;
            this.customProps = customProps;
        }

        DavProperties(Response response) {
            this.creation = SardineUtil.parseDate(DavResource.this.getCreationDate(response));
            this.modified = SardineUtil.parseDate(DavResource.this.getModifiedDate(response));
            this.contentType = DavResource.this.getContentType(response);
            this.contentLength = DavResource.this.getContentLength(response);
            this.etag = DavResource.this.getEtag(response);
            this.displayName = DavResource.this.getDisplayName(response);
            this.resourceTypes = DavResource.this.getResourceTypes(response);
            this.contentLanguage = DavResource.this.getContentLanguage(response);
            this.supportedReports = DavResource.this.getSupportedReports(response);
            this.customProps = DavResource.this.getCustomProps(response);
        }
    }
}

