package by.avest.edoc.examples;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.UnrecoverableKeyException;
import java.security.cert.CertificateException;

import by.avest.edoc.client.PersonalKeyManager;

/**
 * Класс для выбора контейнера личного ключа из запроса пароля к ключу
 * 
 */
public class KeyInteractiveSelector extends PersonalKeyManager {

	public KeyInteractiveSelector(KeyStore ks) {
		super(ks);
	}

	public KeyInteractiveSelector() throws UnrecoverableKeyException, KeyStoreException, NoSuchAlgorithmException,
			CertificateException, IOException {
		super(getDefaultKS());
	}

	private static KeyStore getDefaultKS()
			throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
		KeyStore ks = KeyStore.getInstance("AvPersonal");
		ks.load(null, null);
		return ks;
	}

	@Override
	public char[] promptPassword(String alias) throws IOException {
		// command line interface could be replaced with GUI
		String request = "Введите пароль для ключа \"" + alias + "\": ";
		return promptPasswordInternal(request);
	}

	private char[] promptPasswordInternal(String request) throws IOException {
		char[] answer = promptForPassword(request);
		// validate entered password
		if ((answer != null) && (answer.length >= 8)) {
			return answer;
		} else {
			return promptPasswordInternal("Минимальная длина пароля 8 символов, повторите ввод пароля: ");
		}
	}

	private char[] promptForPassword(String request) throws IOException {
		System.out.print(request);
		// read password frm standard input
		BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
		String line = bufferedReader.readLine();
		return line == null ? null : line.toCharArray();
	}

	@Override
	public String chooseAlias(String[] aliases) throws IOException {
		System.out.println("Список ключей:");
		for (int i = 0; i < aliases.length; i++) {
			System.out.println((i + 1) + ": " + aliases[i]);
		}

		return aliases[promptAliasIndex(aliases)];
	}

	private int promptAliasIndex(String[] aliases) throws IOException {
		System.out.print("Введите номер ключа: ");
		return Integer.parseInt(promptAliasIndexInternal(aliases)) - 1;
	}

	private String promptAliasIndexInternal(String[] aliases) throws IOException {
		BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(System.in));
		String line = bufferedReader.readLine();
		if (isAliasValid(line, aliases)) {
			return line;
		} else {
			if (line == null || line.isEmpty()) {
				System.out.println("Не выбран номер ключа. Введите номер ключа от 1 до " + aliases.length + ": ");

			} else {
				System.out.println("Неверный номер \"" + (line) + "\". Повторно введите номер ключа от 1 до "
						+ aliases.length + ": ");
			}
			return promptAliasIndexInternal(aliases);
		}
	}

	private boolean isAliasValid(String line, String[] aliases) {
		try {
			int index = Integer.parseInt(line);
			return (index > 0) && (index <= aliases.length);
		} catch (NumberFormatException e) {
			return false;
		}
	}

}
