package by.avest.edoc.examples;

import java.io.IOException;
import java.security.Security;

import by.avest.certstore.AvCertStoreProvider;
import by.avest.crypto.pkcs11.provider.ProviderFactory;
import by.avest.edoc.client.EVatService;
import by.avest.net.tls.AvTLSProvider;

public class Login {

	public static void main(String[] args) {
		boolean isVerbose = true;

		try {
			// Регистрация провайдера AvJceProv
			ProviderFactory.addAvUniversalProvider();
			Security.addProvider(new AvTLSProvider());
			Security.addProvider(new AvCertStoreProvider());

			// Получение параметров командной строки
			if (args.length < 4) {
				printUsage("[ОШИБКА] не указаны входные параметры");
				return;
			}

			String serviceUrl = args[0];
			String userUnp = args[1];
			String pubkeyid = args[2];
			String password = args[3];

			// Создание экземпляра класса доступа к порталу
			EVatService service = new EVatService(serviceUrl, new KeyInteractiveSelector());

			// Авторизация, выбор ключа и ввода пароля выполняется интерактивно
			// при помощи класса KeyInteractiveSelector
			String loginstr = "UNP=" + userUnp;
			if (password != null) {
				loginstr += ";PASSWORD_KEY=" + password;
			}
			service.login(loginstr);
			System.out.println("[" + loginstr + "] Пользователь авторизовался. Данные из сертификата:");
			prinUserInfo(service);

			// Подключение к автоматизированному сервису портала
			service.connect();
			System.out.println("[" + loginstr + "] Пользователь подключился к сервису.");

			// Завершение работы с сервисом
			service.disconnect();

			// Завершение авторизованной сессии
			service.logout();

			// Using public key id
			loginstr = "PUB_KEY_ID=" + pubkeyid;
			if (password != null) {
				loginstr += ";PASSWORD_KEY=" + password;
			}
			service.login(loginstr);
			System.out.println("[" + loginstr + "] Пользователь авторизовался.");

			// Подключение к автоматизированному сервису портала
			service.connect();
			System.out.println("[" + loginstr + "] Пользователь подключился к сервису.");

			// Завершение работы с сервисом
			service.disconnect();

			// Завершение авторизованной сессии
			service.logout();
		} catch (Exception e) {
			System.err.println("[ОШИБКА] " + e.getMessage() + ".");
			if (isVerbose) {
				e.printStackTrace();
			}
			System.exit(1);
		}
	}

	private static void prinUserInfo(EVatService service) throws IOException {
		printOid(service, EVatService.OID_ORGANIZATION_UNP_GOSSUOK);
		printOid(service, EVatService.OID_ORGANIZATION_UNP_RUPIIC);
		printOid(service, EVatService.OID_COMMON_NAME);
		printOid(service, EVatService.OID_ORGANIZATION_NAME);
		printOid(service, EVatService.OID_SURNAME);
		printOid(service, EVatService.OID_NAME);
		printOid(service, EVatService.OID_COUNTRY_NAME);
		printOid(service, EVatService.OID_STATE_OR_PROVINCE_NAME);
		printOid(service, EVatService.OID_LOCALITY_NAME);
		printOid(service, EVatService.OID_STREET_ADDRESS);
		printOid(service, EVatService.OID_COMMON_NAME);
		printOid(service, EVatService.OID_EMAIL_ADDRESS);
		printOid(service, EVatService.OID_DATE_OF_BIRTH);
		printOid(service, EVatService.OID_ORGANIZATIONAL_UNIT_NAME);
		printOid(service, EVatService.OID_TITLE);
		printOid(service, EVatService.OID_PLACE_OF_EMPLOYMENT);
		printOid(service, EVatService.OID_IDENTITY_INFO);
	}

	private static void printOid(EVatService service, String oid) throws IOException {
		String value = service.getMyCertProperty(oid);
		System.out.println("\t" + oid + " = " + value);
	}

	/**
	 * Отображение справки по параметрам командной строки
	 */
	private static void printUsage(String message) {
		System.out.println("ListAndGet: " + message);
		System.out.println("Использование:");
		System.out.println("java Login [URL сервиса] [UNP] <publicKeyId> <password>");

	}
}
