 ' SendEDocument.vbs -    - 

 ' :
 ' "cscript SendEDocument.vbs <url  > < > [< >] ..."

  Dim EVatService 
  Dim InvVatXml
  Dim res 
  Dim xsd
  Dim url

    
  set objArgs = WScript.Arguments
  if objArgs.count < 2 then
	 WScript.Echo "   - "
     WScript.Echo ":"
     WScript.Echo "cscript SendEDocument.vbs <url  > < > [< >] ..."
     WScript.Quit
  end if

  url = objArgs(0)
  
  ' COM object   
  Set oFSO = CreateObject("Scripting.FileSystemObject")
  
  ' COM object EInvVatService.Connector
  set EVatService = CreateObject("EInvVatService.Connector")
 
  if EVatService.Login("", 0) = 0 then
     WScript.Echo " "
  else
     WScript.Echo " : " + EVatService.LastError
     WScript.Quit
  end if

  WScript.Echo "  " + url
  if EVatService.Connect(url) = 0 then
     WScript.Echo " "
  else
     WScript.Echo " : " + EVatService.LastError
     WScript.Quit
  end if
  
  for i = 1 to objArgs.count - 1
	SignSendFile(objArgs(i))
  next
    
  if EVatService.Disconnect <> 0 then
     WScript.Echo "      "
  end if
  
  if EVatService.Logout <> 0 then
     WScript.Echo "    "
  end if  
  
'     
 sub SignSendFile(FileName)
    dim InvVatTicket
    dim InvVatNumber
    dim TicketIssuerUri
    dim fn
	
    WScript.Echo
    WScript.Echo "  " + FileName

    set InvVatXml = EVatService.CreateEDoc

    if InvVatXml.Document.LoadFromFile(FileName) <> 0 then
       WScript.Echo "  : " + EVatService.LastError
	   exit sub
    end if
	
	InvVatType = InvVatXml.Document.GetXmlNodeValue("issuance/general/documentType")
	WScript.Echo " " + InvVatXml.Document.GetXmlNodeValue("issuance/general/number") + ",   " + InvVatType

	select case InvVatType
	 case "ORIGINAL"
	   xsd = "MNSATI_original.xsd"
	 case  "FIXED"
	   xsd = "MNSATI_fixed.xsd"
	 case  "ADDITIONAL"
	   xsd = "MNSATI_additional.xsd"
	 case  "ADD_NO_REFERENCE"
	   xsd = "MNSATI_original.xsd"
	 case else
	  WScript.Echo " " & FileName & "    "	  
	  exit sub
	end select
	
	res = InvVatXml.Document.ValidateXML(".\xsd\" & xsd, 0)
	
	if res <> 0 then
	  WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
	  WScript.Echo "     xsd"
	  exit sub
	end if

	'   
	res = InvVatXml.Sign(0)
	if res <> 0 then
	   WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
	   exit sub
	end if
	
	WScript.Echo " "

    fn = FileName + ".edoc.xml"
 	res = InvVatXml.SaveToFile( fn )
	if res <> 0 then
	   WScript.Echo "   : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
	   exit sub
	end if

	res = EVatService.SendEDoc(InvVatXml)
	if res <> 0 then
	   WScript.Echo " : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
	   exit sub
	end if
	
	WScript.Echo " "
	  
	set InvVatTicket = EVatService.Ticket
	if InvVatTicket.Accepted <> 0 then
		WScript.Echo " :      " + InvVatTicket.Message
        fn = FileName + ".ticket.error.xml"
    else
        TicketIssuerUri = InvVatTicket.Document.GetXmlNodeAttribute("ticket/issuer/URI")
        WScript.Echo " :     " + TicketIssuerUri
        fn = FileName + ".ticket.xml"
	end if
    
 	res = InvVatTicket.SaveToFile( fn )
	if res <> 0 then
	   WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
	   exit sub
	end if
    WScript.Echo "  " + fn + " "

    res = InvVatTicket.Document.SaveToFile( fn & ".ticket.text.xml" )
    if res <> 0 then
       WScript.Echo "   : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
       exit sub
    end if      
	 
 end sub
