 ' ListEDocuments.vbs -    - 
  dim oFSO
  dim EVatService 
  dim res
  dim FolderName
  dim f
  dim content
  dim fromDate
  dim toDate
  dim lines
  dim line 
  dim i
  dim ForReading
  dim ForWriting 
  dim service_cert_cn
  
  ForReading = 1
  ForWriting = 2
  service_cert_cn="    "
  
  set objArgs = WScript.Arguments
  if objArgs.count < 2 then
	 WScript.Echo "   - "
     WScript.Echo ":"
     WScript.Echo "cscript ListEDocuments.vbs <url  > <   >"
     WScript.Quit
  end if

  url = objArgs(0)
  FolderName = objArgs(1)
  
  ' COM object EInvVatService.Connector
  set EVatService = CreateObject("EInvVatService.Connector")
  
  ' COM object   
  Set oFSO = CreateObject("Scripting.FileSystemObject")
  
  '           
  filename = oFSO.BuildPath(FolderName, "ListEDocuments.dat")    
  if oFSO.FileExists(filename) then
     Set f = oFSO.OpenTextFile(filename, ForReading, True)  
     If Not f.AtEndOfStream Then 
        content = f.ReadAll()  
     else
       content = ""
     end if
     f.close   
  else
     content = ""
  end if
  if Len(content) > 0 then
    content = Replace(content, Chr(13), "")
    lines = Split(content, Chr(10))
	for i = LBound(lines) to UBound(lines)
		line = Split(lines(i), "=")
		if (UBound(line) + 1) = 2 then
		   if line(LBound(line)) = "fromDate" then
		     fromDate = line(LBound(line) + 1)
		   end if
		end if
	next
  else
    '    ,   30 
	fromDate = FormatDate(DateAdd("d", -31, Now))
  end if  
  
   
  if EVatService.Login("", 0) = 0 then
     WScript.Echo " "
  else
     WScript.Echo " : " + EVatService.LastError
     WScript.Quit
  end if

  WScript.Echo "  " + url
  if EVatService.Connect(url) = 0 then
     WScript.Echo " "
  else
     WScript.Echo " : " + EVatService.LastError
     WScript.Quit
  end if 
  
  res = ListDocuments(fromDate)
  ' 
  if res = 0 then  
	  Set f = oFSO.OpenTextFile(filename, ForWriting, True)	  
	  line = "fromDate=" + toDate
	  f.Write(line)  
	  f.close  
  end if	 
    
  if EVatService.Disconnect <> 0 then
     WScript.Echo "      "
  end if
  
  if EVatService.Logout <> 0 then
     WScript.Echo "    "
  end if  
  
'   
 function ListDocuments(fromDate)
	dim i	
    dim InvVatTicket
    dim InvVatNumber
    dim fn	
    dim InvList	

     WScript.Echo "     " & fromDate
	
    set InvList = EVatService.GetList(fromDate)
	if InvList is Nothing then
	   WScript.Echo "   : " + EVatService.LastError
	   ListDocuments = 1
	   exit function
	end if
	
	toDate = InvList.ToDate
		
	for i = 0 to InvList.Count - 1
	
		InvVatNumber = InvList.GetItemAttribute(i, "document/number")
	
		set InvVatXml = EVatService.GetEDoc(InvVatNumber)
        if InvVatXml is Nothing then
			WScript.Echo "    " & InvVatNumber & ": " + EVatService.LastError
            ListDocuments = 1
            exit function
        end if
            
		fn = oFSO.BuildPath(FolderName, "invoice-" + InvVatNumber + "-received.xml.edoc.xml")
		
        ' 
        res = VerifyDocumentSign(InvVatXml)
        if res <> 0 then
            if res <> 1 then                
                WScript.Echo "    : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
            else
                WScript.Echo "    "
            end if
            fn = oFSO.BuildPath(FolderName, "invoice-" & InvVatNumber & ".sgn.error.xml")
            res = InvVatXml.SaveToFile( fn )                    
            ListDocuments = res
            exit function
        else
            res = InvVatXml.SaveToFile( fn )			
        end if				
        
        if res <> 0 then
           WScript.Echo "   : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
           ListDocuments = res
           exit function
        end if	

        fn2 = oFSO.BuildPath(FolderName, "invoice-" & InvVatNumber & ".xml")
        res = InvVatXml.Document.SaveToFile( fn2 )
        if res <> 0 then
           WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
           exit function
        end if           
		
        WScript.Echo " " + fn + " "
	next

    if InvList.Count = 0 then
        WScript.Echo "    "
    end if
	
	ListDocuments = 0
	 
 end function

 
 Function FormatDate(myDate)
    d = WhatEver(Day(myDate))
    m = WhatEver(Month(myDate))    
    y = Year(myDate)
	h = WhatEver(Hour(myDate))
	min = WhatEver(Minute(myDate))
	s = WhatEver(Second(myDate))
    FormatDate= y & "-" & m & "-" & d & "T" & h & ":" & min & ":" & s
End Function

Function WhatEver(num)
    If(Len(num)=1) Then
        WhatEver="0" & num
    Else
        WhatEver = num
    End If
End Function

function IsASSign(InvVatXml, n)
    dim oid
	oid = "2.5.4.3" '(commonName)
	str = InvVatXml.GetSignProperty(n, oid, 0)
    if str <> service_cert_cn then
       IsASSign = 0
       exit function
    end if
    
    IsASSign = 1
end function
 
function VerifyDocumentSign(InvVatXml)
   if VerifyASServerSign(InvVatXml) = 0 then
      VerifyDocumentSign = 0
      exit function
   end if
   
   VerifyDocumentSign = VerifyAllSigns(InvVatXml)
end function

function VerifyASServerSign(InvVatXml)
	dim i, signCount
	dim InvVatNumber

	InvVatNumber = InvVatXml.Document.GetXmlNodeValue("issuance/general/number")
	
	signCount = InvVatXml.GetSignCount
	
	if signCount = 0 then
	   VerifyASServerSign = 1
	   exit function
	end if
	
	for i = 0 to signCount - 1
        if IsASSign(InvVatXml, i) = 1 then
            oid = "2.5.4.3" '(commonName)
            str = InvVatXml.GetSignProperty(i, oid, 0)
            WScript.Echo " ,  '" & str & "'"
		
            res = InvVatXml.VerifySign(i, 0)
            if res <> 0 then
               WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
            else
               WScript.Echo " .  : " & InvVatXml.GetSignProperty(i, "SIGNDATE", 0)
               VerifyASServerSign = 0
               exit function
            end if
        end if
	next
	
	VerifyASServerSign = 1
end function 
 
function VerifyAllSigns(InvVatXml)
	dim i, signCount
	dim InvVatNumber

    InvVatNumber = InvVatXml.Document.GetXmlNodeValue("issuance/general/number")
	
	signCount = InvVatXml.GetSignCount
	
	if signCount = 0 then
	   WScript.Echo ":  " & InvVatNumber &  "   "
	   VerifyAllSigns = 1
	   exit function
	end if
	
	for i = 0 to signCount - 1
		oid = "2.5.4.3" '(commonName)
		str = InvVatXml.GetSignProperty(i, oid, 0)
		WScript.Echo " ,  '" & str & "'"
		
		res = InvVatXml.VerifySign(i, 0)
		if res <> 0 then
		   WScript.Echo "  : " & EVatService.LastError & " ( 0x" & Hex(res) & ")"
		   VerifyAllSigns = 2
		   exit function
		else
		   WScript.Echo " .  : " & InvVatXml.GetSignProperty(i, "SIGNDATE", 0)
		end if				
	next
	
	VerifyAllSigns = 0	
end function
