unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, Grids, DBGrids, StdCtrls, DBCtrls, Mask, dbcgrids, Buttons,
  Vcl.ExtCtrls, DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh,
  EhLibVCL, GridsEh, DBAxisGridsEh, DBGridEh, MemTableDataEh, DataDriverEh,
  MemTableEh, Vcl.Menus;

type
  TfrmMain = class(TForm)
    MDBConnection: TADOConnection;
    SelGroupMemTableDS: TDataSource;
    SelGroup: TADOQuery;
    UpdateNull: TADOQuery;
    GroupsDBGridEh: TDBGridEh;
    SelGroupNameGr: TStringField;
    SelGroupNameVid: TStringField;
    SelGroupNamePGr: TStringField;
    SelGroupKodVED: TStringField;
    SelGroupMemTable: TMemTableEh;
    SelGroupDSDE: TDataSetDriverEh;
    SelGroupMemTableNameGr: TStringField;
    SelGroupMemTableNameVid: TStringField;
    SelGroupMemTableNamePGr: TStringField;
    SelGroupMemTableKodVED: TStringField;
    MainMenu: TMainMenu;
    DeleteNullMMBtn: TMenuItem;
    procedure FormCreate(Sender: TObject);
    procedure GroupsDBGridEhSortMarkingChanged(Sender: TObject);
    procedure SelGroupMemTableKodVEDChange(Sender: TField);
    procedure DeleteNullMMBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure MultiSorting(DBGridEh: TDBGridEh);
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.MultiSorting(DBGridEh: TDBGridEh);
var
  i: Integer;
  s: WideString;
begin
  //    
  with DBGridEh.SortMarkedColumns do
  begin
    if Count = 0 then
      Exit;

    s := DBGridEh.Columns[Items[0].Index].FieldName;

    if Items[0].Title.SortMarker = smUpEh then
      s := s + ' ASC'
    else
      s := s + ' DESC';

    try
      for i := 1 to Count - 1 do
      begin
        s := s + ', ' + DBGridEh.Columns[Items[i].Index].FieldName;

        if Items[i].Title.SortMarker = smUpEh then
          s := s + ' ASC'
        else
          s := s + ' DESC';
      end;
    except
    end;
  end;

  SelGroupMemTable.SortByFields(s);
end;

procedure TfrmMain.DeleteNullMMBtnClick(Sender: TObject);
begin
  UpdateNull.ExecSQL;
  ShowMessage('  ');

  SelGroupMemTable.Close;

  SelGroup.Close;
  SelGroup.Open;

  SelGroupMemTable.Open;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var
  F: TextFile;
  S: string;
begin
  if FileExists('MdbConnect.ini') = False then
  begin
    ShowMessage('  MdbConnect.ini');
    Application.Terminate;
    Exit;
  end;

  AssignFile(F, ExtractFilePath(Application.ExeName) + 'MdbConnect.ini');
  Reset(F);
  Read(F, S);
  CloseFile(F);

  MDBConnection.ConnectionString := S;
  MDBConnection.Connected := True;

  SelGroupMemTable.Close;

  SelGroup.Close;
  SelGroup.Open;

  SelGroupMemTable.Open;
end;

procedure TfrmMain.SelGroupMemTableKodVEDChange(Sender: TField);
begin
  if SelGroupMemTable.State in [dsEdit] then
    SelGroupMemTable.Post;
end;

procedure TfrmMain.GroupsDBGridEhSortMarkingChanged(Sender: TObject);
begin
  if SelGroupMemTable.IsEmpty then
    Exit;

  MultiSorting(TDBGridEh(Sender));
  SelGroupMemTable.First;
end;

end.

