unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, DB, ADODB, Grids, DBGrids, StdCtrls, DBGridEhGrouping,
  ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, GridsEh, DBAxisGridsEh,
  DBGridEh, EhLibVCL, Vcl.ExtCtrls, System.UITypes;

type
  TfrmMain = class(TForm)
    BuhConnection: TADOConnection;
    SprSchet: TADOQuery;
    SFSverka: TADOQuery;
    AddGB: TGroupBox;
    AddCBDT: TComboBox;
    AddCBKT: TComboBox;
    AddBtn: TButton;
    AddDTLbl: TLabel;
    AddKTLbl: TLabel;
    DeleteGB: TGroupBox;
    DeleteBtn: TButton;
    EditGB: TGroupBox;
    EditDTLbl: TLabel;
    EditKTLbl: TLabel;
    EditCBDT: TComboBox;
    EditCBKT: TComboBox;
    EditBtn: TButton;
    ProvDBGridEh: TDBGridEh;
    SFSverkaDS: TDataSource;
    UPDSFSverka: TADOQuery;
    INSSFSverka: TADOQuery;
    SFSverkaDTid: TIntegerField;
    SFSverkaKTid: TIntegerField;
    SFSverkaDT: TStringField;
    SFSverkaKT: TStringField;
    SFSverkaprizn: TBooleanField;
    SFSverkaidSFSverka: TAutoIncField;
    SFSverkaPriznak: TStringField;
    DELSFSverka: TADOQuery;
    SFSverkakodSchetDT: TSmallintField;
    SFSverkakodSubSchetDT: TIntegerField;
    SFSverkakodSchetKT: TSmallintField;
    SFSverkakodSubSchetKT: TIntegerField;
    SprSchetkodSchet: TSmallintField;
    SprSchetkodSubSchet: TIntegerField;
    SprSchetidSchetSubSchet: TAutoIncField;
    AddPriznRG: TRadioGroup;
    EditPriznRG: TRadioGroup;
    procedure FormCreate(Sender: TObject);
    procedure AddBtnClick(Sender: TObject);
    procedure EditBtnClick(Sender: TObject);
    procedure SFSverkaCalcFields(DataSet: TDataSet);
    procedure DeleteBtnClick(Sender: TObject);
    procedure ProvDBGridEhSortMarkingChanged(Sender: TObject);
  private
    { Private declarations }
    EditMode: Boolean;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;


implementation

{$R *.dfm}

procedure MultiSorting(DBGridEh:TDBGridEh);
var
   i:Integer;
   s:WideString;
begin
  //    
  with DBGridEh.SortMarkedColumns do
  begin
    if Count = 0 then Exit;

    s := DBGridEh.Columns[Items[0].Index].FieldName;

    if Items[0].Title.SortMarker = smUpEh then
      s := S + ' ASC'
    else
      s := s + ' DESC';

    try
      for i:=1 to Count - 1 do
      begin
        s := s + ', '+ DBGridEh.Columns[Items[i].Index].FieldName;

        if Items[i].Title.SortMarker = smUpEh then
          s := s + ' ASC'
        else
          s := s + ' DESC';
      end;
    except
    end;
  end;

  //SSDT.kodSchet,  SSDT.kodSubSchet, SSKT.kodSchet,  SSKT.kodSubSchet
  s := StringReplace(s, 'DT', 'kodSchetDT,  kodSubSchetDT', [rfReplaceAll]);
  s := StringReplace(s, 'KT', 'kodSchetKT,  kodSubSchetKT', [rfReplaceAll]);
  s := StringReplace(s, 'Priznak', 'prizn', [rfReplaceAll]);
  TADOQuery(DBGridEh.DataSource.DataSet).Sort := s;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var F: TextFile;
    S: String;
begin
  AssignFile(F, ExtractFilePath(Application.ExeName)+'BuhConnect.ini');
  Reset(F);
  Read(F,S);
  CloseFile(F);

  BuhConnection.ConnectionString := S;
  try
    BuhConnection.Open
  except
    MessageDlg('      BUH', mtError,[mbOK],0);
    Close
  end;

  EditMode := False;

  SFSverka.Close;
  SFSverka.Open;

  SprSchet.Close;
  SprSchet.Open;

  AddCBDT.Clear;
  AddCBKT.Clear;

  SprSchet.First;

  while not SprSchet.Eof do
  begin
    AddCBDT.Items.Add(SprSchetkodSchet.AsString+'.'+SprSchetkodSubSchet.AsString);
    AddCBKT.Items.Add(SprSchetkodSchet.AsString+'.'+SprSchetkodSubSchet.AsString);
    EditCBDT.Items.Add(SprSchetkodSchet.AsString+'.'+SprSchetkodSubSchet.AsString);
    EditCBKT.Items.Add(SprSchetkodSchet.AsString+'.'+SprSchetkodSubSchet.AsString);
    SprSchet.Next;
  end;
end;

procedure TfrmMain.AddBtnClick(Sender: TObject);
begin
  if (AddCBDT.Text<>'') and (AddCBKT.Text<>'') and (AddPriznRG.ItemIndex in [0, 1]) then
    begin
      try
        SprSchet.RecNo := AddCBDT.ItemIndex + 1;
        INSSFSverka.Parameters.ParamByName('SubSchetDT').Value := SprSchetidSchetSubSchet.AsString;

        SprSchet.RecNo := AddCBKT.ItemIndex + 1;
        INSSFSverka.Parameters.ParamByName('SubSchetKT').Value := SprSchetidSchetSubSchet.AsString;

        INSSFSverka.Parameters.ParamByName('Prizn').Value := AddPriznRG.ItemIndex;
        INSSFSverka.ExecSQL;
      except
        ShowMessage('  ');
      end;

      SFSverka.Close;
      SFSverka.Open;
      AddCBDT.Text:='';
      AddCBKT.Text:='';
      AddPriznRG.ItemIndex := -1;
    end
  else ShowMessage('   ');
end;

procedure TfrmMain.EditBtnClick(Sender: TObject);
begin
  if not EditMode then
  begin
    SprSchet.Locate('idSchetSubSchet', SFSverkaDTid.AsInteger, []);
    EditCBDT.ItemIndex := SprSchet.RecNo - 1;
    SprSchet.Locate('idSchetSubSchet', SFSverkaKTid.AsInteger, []);
    EditCBKT.ItemIndex := SprSchet.RecNo - 1;

    EditPriznRG.ItemIndex := StrToInt(BoolToStr(SFSverkaprizn.AsBoolean))*-1;

    EditMode := True;
    EditCBDT.Enabled := True;
    EditCBKT.Enabled := True;
    EditPriznRG.Enabled := True;
    ProvDBGridEh.Enabled := False;
  end
  else
  begin
    EditCBDT.Enabled:=False;
    EditCBKT.Enabled:=False;
    EditPriznRG.Enabled:=False;
    EditMode := False;

    SprSchet.RecNo := EditCBDT.ItemIndex + 1;
    UPDSFSverka.Parameters.ParamByName('SubSchetDT').Value := SprSchetidSchetSubSchet.AsString;

    SprSchet.RecNo := EditCBKT.ItemIndex + 1;
    UPDSFSverka.Parameters.ParamByName('SubSchetKT').Value := SprSchetidSchetSubSchet.AsString;

    UPDSFSverka.Parameters.ParamByName('Prizn').Value := EditPriznRG.ItemIndex;
    UPDSFSverka.Parameters.ParamByName('id').Value := SFSverka.FieldByName('idSFSverka').Value;
    UPDSFSverka.ExecSQL;

    SFSverka.Close;
    SFSverka.Open;

    EditCBDT.ItemIndex := -1;
    EditCBKT.ItemIndex := -1;

    ProvDBGridEh.Enabled:=True;
  end;
end;

procedure TfrmMain.SFSverkaCalcFields(DataSet: TDataSet);
begin
  case StrToInt(BoolToStr(SFSverkaprizn.AsBoolean))*-1 of
    0: SFSverkaPriznak.Value:='';
    1: SFSverkaPriznak.Value:='';
  end;
end;

procedure TfrmMain.DeleteBtnClick(Sender: TObject);
begin
  DELSFSverka.Parameters.ParamByName('id').Value:=SFSverka.FieldByName('idSFSverka').Value;
  DELSFSverka.ExecSQL;

  SFSverka.Close;
  SFSverka.Open;
end;

procedure TfrmMain.ProvDBGridEhSortMarkingChanged(Sender: TObject);
var bm: TBookmark;
begin
  if SFSverka.IsEmpty then Exit;

  bm := SFSverka.GetBookmark;
  MultiSorting(TDBGridEh(Sender));
  SFSverka.GotoBookmark(bm);
end;

end.
