unit uReestr;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls, DBCtrls, ComCtrls, Buttons, DateUtils,
  CheckLst, Grids, DBGrids, Menus, ADODb, frxClass, frxDBSet, frxExportXLS,
  frxExportRTF, DB, StrUtils, GridsEh, DBGridEh, DBGridEhImpExp,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh,
  frxExportBaseDialog, EhLibVCL, DBAxisGridsEh, MemTableDataEh, DataDriverEh,
  MemTableEh, System.UITypes, PrnDbgeh, Vcl.ImgList;

type
  TfrmReestr = class(TForm)
    TopPanel: TPanel;
    Label3: TLabel;
    Label4: TLabel;
    Label7: TLabel;
    FirstPicker: TDateTimePicker;
    SecPicker: TDateTimePicker;
    PredprComBox: TDBLookupComboBox;
    BottomPanel: TPanel;
    ReestrDBGridEh: TDBGridEh;
    SelectNastrQ: TADOQuery;
    dsNPredpr: TDataSource;
    qNPredpr: TADOQuery;
    Dataset1: TfrxDBDataset;
    Report1: TfrxReport;
    frxRTFExport1: TfrxRTFExport;
    frxXLSExport1: TfrxXLSExport;
    BuhConnection: TADOConnection;
    SelectInvoices: TADOQuery;
    SelectInvoicesDS: TDataSource;
    SelectInvoicesIdPredpr: TSmallintField;
    SelectInvoicesNumDoc: TStringField;
    SelectInvoicesDateDoc: TDateTimeField;
    SelectInvoicesDateTransaction: TDateTimeField;
    SelectInvoicesUNN: TStringField;
    SelectInvoicesIdPlat: TSmallintField;
    SelectInvoicesNamePredpr: TStringField;
    SelectInvoicesSumBezNDSsf: TBCDField;
    SelectInvoicesSumNDSsf: TBCDField;
    SelectInvoicesSumSNDSsf: TBCDField;
    SelectInvoicesNSF: TStringField;
    SelectInvoicesinvStatus: TWordField;
    SelectInvoicesStatusDate: TDateTimeField;
    SelectInvoicesMem: TMemTableEh;
    SelectInvoicesDataSetDriverEh: TDataSetDriverEh;
    SelectInvoicesdocumentType: TWordField;
    SelectInvoicesMemIdPredpr: TSmallintField;
    SelectInvoicesMemNumDoc: TStringField;
    SelectInvoicesMemDateDoc: TDateTimeField;
    SelectInvoicesMemDateTransaction: TDateTimeField;
    SelectInvoicesMemUNN: TStringField;
    SelectInvoicesMemIdPlat: TSmallintField;
    SelectInvoicesMemNamePredpr: TStringField;
    SelectInvoicesMemSumBezNDSsf: TBCDField;
    SelectInvoicesMemSumNDSsf: TBCDField;
    SelectInvoicesMemSumSNDSsf: TBCDField;
    SelectInvoicesMemNSF: TStringField;
    SelectInvoicesMeminvStatus: TWordField;
    SelectInvoicesMemStatusDate: TDateTimeField;
    SelectInvoicesMemdocumentType: TWordField;
    SelectInvoicesMemStatus: TStringField;
    SelectInvoicesMeminvtype: TStringField;
    SelectInvoicesdopUNN: TIntegerField;
    SelectInvoicesMemdopUNN: TIntegerField;
    SelectInvoicessv: TBooleanField;
    SelectInvoicesdatesv: TDateTimeField;
    SelectInvoicesMemsv: TBooleanField;
    SelectInvoicesMemdatesv: TDateTimeField;
    PrintReestrGridEh: TPrintDBGridEh;
    SelectInvoicesStatus: TStringField;
    ImageList_16: TImageList;
    ImageList_24: TImageList;
    FindBtn: TButton;
    FormBtn: TButton;
    ExportInExcelBtn: TButton;
    OldPrintBtn: TButton;
    NewPrintBtn: TButton;
    XlsSaveDialog: TSaveDialog;
    StatusCheckLB: TCheckListBox;
    SetFilterBtn: TButton;
    FiltersBtn: TButton;
    FiltersPanel: TPanel;
    StatusFilterGB: TGroupBox;
    InvoiceRecipientRG: TRadioGroup;
    SelectNastrQNastrId: TIntegerField;
    SelectNastrQOblId: TAutoIncField;
    SelectNastrQNastrDopUnn: TIntegerField;
    procedure FormBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormKeyPress(Sender: TObject; var Key: Char);
    procedure FormBtnKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure PredprComBoxKeyDown(Sender: TObject; var Key: Word;
      Shift: TShiftState);
    procedure FindBtnClick(Sender: TObject);
    procedure ExportInExcelBtnClick(Sender: TObject);
    procedure OldPrintBtnClick(Sender: TObject);
    procedure SelectInvoicesMemCalcFields(DataSet: TDataSet);
    procedure ReestrDBGridEhSortMarkingChanged(Sender: TObject);
    procedure SelectInvoicesCalcFields(DataSet: TDataSet);
    procedure NewPrintBtnClick(Sender: TObject);
    procedure PrintReestrGridEhAfterPrint(Sender: TObject);
    procedure SetFilterBtnClick(Sender: TObject);
    procedure FiltersBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure MultiSorting(DBGridEh:TDBGridEh);
  public
    { Public declarations }
  end;

var
  frmReestr: TfrmReestr;

implementation

{$R *.dfm}

uses uSearch;

procedure TfrmReestr.MultiSorting(DBGridEh:TDBGridEh);
var
   i:Integer;
   s:WideString;
begin
  //    
  with DBGridEh.SortMarkedColumns do
  begin
    if Count = 0 then Exit;

    s := DBGridEh.Columns[Items[0].Index].FieldName;

    if Items[0].Title.SortMarker = smUpEh then
      s := S + ' ASC'
    else
      s := s + ' DESC';

    try
      for i:=1 to Count - 1 do
      begin
        s := s + ', '+ DBGridEh.Columns[Items[i].Index].FieldName;

        if Items[i].Title.SortMarker = smUpEh then
          s := s + ' ASC'
        else
          s := s + ' DESC';
      end;
    except
    end;
  end;

  s := StringReplace(s, 'Status', '[invStatus]', [rfReplaceAll]);
  s := StringReplace(s, 'fullvendor', '[vendorId], [vendorYear], [vendorNumber]',
                     [rfReplaceAll]);
  s := StringReplace(s, 'invtype', '[documentType]', [rfReplaceAll]);
//  TMemTableEh(DBGridEh.DataSource.DataSet).SortOrder := s;
  TMemTableEh(DBGridEh.DataSource.DataSet).SortByFields(s);
end;

procedure TfrmReestr.NewPrintBtnClick(Sender: TObject);
var title: string;
begin
  ReestrDBGridEh.DataGrouping.GroupLevels[0].ExpandNodes;
  PrintReestrGridEh.Title.Clear;
  title := '     '+DateToStr(FirstPicker.Date)+'  '+
           DateToStr(SecPicker.Date);
  PrintReestrGridEh.Title.Text := title;
  PrintReestrGridEh.Preview;
end;

procedure TfrmReestr.FormBtnClick(Sender: TObject);
begin
  if (FirstPicker.Date>SecPicker.Date) then
  begin
    MessageDlg('  !', mtWarning, [mbOk], 0);
    Exit;
  end;

  with SelectInvoices do
  begin
    SelectInvoicesMem.Active := False;

    Close;
    Parameters.ParamByName('FirstDate').Value:=DateToStr(FirstPicker.Date);
    Parameters.ParamByName('SecDate').Value:=DateToStr(SecPicker.Date);
    Parameters.ParamByName('IdPlat').Value:=PredprComBox.KeyValue;
    Parameters.ParamByName('MyIdPlat').Value:=SelectNastrQNastrId.AsInteger;
    Parameters.ParamByName('MyDopUNN').Value:=SelectNastrQNastrDopUnn.AsInteger;
    Parameters.ParamByName('OblId').Value:=SelectNastrQOblId.AsInteger;
    Open;

    SelectInvoicesMem.Active := True;
  end;

  SelectInvoicesMem.First;

  ExportInExcelBtn.Enabled := not SelectInvoices.IsEmpty;
  OldPrintBtn.Enabled := not SelectInvoices.IsEmpty;
  NewPrintBtn.Enabled := not SelectInvoices.IsEmpty;
  SetFilterBtn.Enabled := not SelectInvoices.IsEmpty;
end;

procedure TfrmReestr.FormCreate(Sender: TObject);
Var F: TextFile;
    S:string;
begin
  AssignFile(F, ExtractFilePath(Application.ExeName)+'BuhConnect.ini');
  Reset(F);
  Read(F,S);
  CloseFile(F);

  with BuhConnection do
  begin
    Close();
    ConnectionString := S;
    Open();
  end;

  FirstPicker.Date:=now();
  SecPicker.Date:=now();

  qNPredpr.Close;
  qNPredpr.Open;

  SelectNastrQ.Close;
  SelectNastrQ.Open;

  if SelectNastrQNastrDopUnn.AsInteger=1 then
    InvoiceRecipientRG.Enabled := False;
end;

procedure TfrmReestr.FormKeyPress(Sender: TObject; var Key: Char);
begin
  if key=#13 then SelectNext(ActiveControl as TWincontrol,true,true);
end;

procedure TfrmReestr.FormBtnKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  FormBtnClick(FormBtn);
end;

procedure TfrmReestr.PredprComBoxKeyDown(Sender: TObject; var Key: Word;
  Shift: TShiftState);
begin
  if key=46 then PredprComBox.KeyValue:=null;
end;

procedure TfrmReestr.PrintReestrGridEhAfterPrint(Sender: TObject);
begin
  ReestrDBGridEh.DataGrouping.GroupLevels[0].CollapseNodes;
end;

procedure TfrmReestr.SelectInvoicesCalcFields(DataSet: TDataSet);
begin
  CASE SelectInvoicesinvStatus.AsInteger OF
    0 : SelectInvoicesStatus.AsString := ' ';
    1 : SelectInvoicesStatus.AsString := ' ';
    2 : SelectInvoicesStatus.AsString := ' .';
    3 : SelectInvoicesStatus.AsString := '';
    4 : SelectInvoicesStatus.AsString := ' ';
    5 : SelectInvoicesStatus.AsString := '.';
    6 : SelectInvoicesStatus.AsString := '';
    7 : SelectInvoicesStatus.AsString := '.';
    8 : SelectInvoicesStatus.AsString := ' ';
    9 : SelectInvoicesStatus.AsString := '';
  END;
end;

procedure TfrmReestr.SelectInvoicesMemCalcFields(DataSet: TDataSet);
begin
  CASE SelectInvoicesMeminvStatus.AsInteger OF
    0 : SelectInvoicesMemStatus.AsString := ' ';
    1 : SelectInvoicesMemStatus.AsString := ' ';
    2 : SelectInvoicesMemStatus.AsString := ' .';
    3 : SelectInvoicesMemStatus.AsString := '';
    4 : SelectInvoicesMemStatus.AsString := ' ';
    5 : SelectInvoicesMemStatus.AsString := '.';
    6 : SelectInvoicesMemStatus.AsString := '';
    7 : SelectInvoicesMemStatus.AsString := '.';
    8 : SelectInvoicesMemStatus.AsString := ' ';
    9 : SelectInvoicesMemStatus.AsString := '';
  END;

  case SelectInvoicesMemdocumentType.AsInteger of
    1 : SelectInvoicesMeminvtype.AsString := '';
    2 : SelectInvoicesMeminvtype.AsString := '';
    3 : SelectInvoicesMeminvtype.AsString := '';
    4 : SelectInvoicesMeminvtype.AsString := '.  ';
  end;
end;

procedure TfrmReestr.SetFilterBtnClick(Sender: TObject);
var i:Integer;
    Status: string;
begin
  Status := '(';

  with SelectInvoicesMem do
  begin
    Filtered:=False;

    case InvoiceRecipientRG.ItemIndex of
      0: Filter:='';
      1: Filter:='(dopUnn='+SelectNastrQNastrDopUnn.AsString+')';
    end;

    for i:=0 to StatusCheckLB.Count-1 do
      if StatusCheckLB.Checked[i] then
        Status:=Status+' (invStatus='+InttoStr(i)+') OR';

    if Length(Status)>1 then
    begin
      Status:=Copy(Status,1,Length(Status)-3)+')';

      if Length(Filter)>0 then
        Filter := Filter + ' AND '+ Status
      else
        Filter := Status;
    end;

    Filtered:=True;
  end;
end;

procedure TfrmReestr.FiltersBtnClick(Sender: TObject);
begin
  if FiltersPanel.Visible then
  begin
    FiltersBtn.Caption := ' ';
    FiltersBtn.ImageIndex := 4;
    FiltersPanel.Visible := False;
  end
  else
  begin
    FiltersBtn.Caption := ' ';
    FiltersBtn.ImageIndex := 5;
    FiltersPanel.Visible := True;
  end;
end;

procedure TfrmReestr.FindBtnClick(Sender: TObject);
begin
  frmSearch := TfrmSearch.Create(Self, PredprComBox);
  frmSearch.ShowModal;
  frmSearch.Free;
end;

procedure TfrmReestr.ExportInExcelBtnClick(Sender: TObject);
begin
  if XlsSaveDialog.Execute then
  begin
    SaveDbGridEhToExportFile(TDBGridEhExportAsXLS, ReestrDBGridEh,
                             XlsSaveDialog.FileName, true);
    MessageDlg('  Excel .', mtInformation, [mbOk], 0);
  end;
end;

procedure TfrmReestr.OldPrintBtnClick(Sender: TObject);
begin
  Report1.Variables['FirstDate']:=QuotedStr(DateToStr(FirstPicker.Date));
  Report1.Variables['SecDate']:=QuotedStr(DateToStr(SecPicker.Date));
  Report1.ShowReport();
end;

procedure TfrmReestr.ReestrDBGridEhSortMarkingChanged(Sender: TObject);
var number: string;
begin
  if SelectInvoicesMem.IsEmpty then Exit;

  number := SelectInvoicesMemNSF.AsString;
  MultiSorting(TDBGridEh(Sender));
  SelectInvoicesMem.Locate('NSF', number, []);
end;

end.
