unit uAddUpdComeralSigner;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  Vcl.ExtCtrls, Vcl.StdCtrls, System.UITypes;

type
  TfrmAddUpdComeralSigner = class(TForm)
    TopPanel: TPanel;
    BottomPanel: TPanel;
    FilialEdit: TLabeledEdit;
    FIOEdit: TLabeledEdit;
    SaveBtn: TButton;
    CancelBtn: TButton;
    procedure SaveBtnClick(Sender: TObject);
  private
    { Private declarations }
    idRecord: Integer;
    Update: Boolean;
  public
    { Public declarations }
    constructor Create(AOwner: TComponent); overload; override;
    constructor Create(AOwner: TComponent; idRecord: Integer; filial: SmallInt;
      fio: string); reintroduce; overload;
  end;

var
  frmAddUpdComeralSigner: TfrmAddUpdComeralSigner;

implementation

uses
  uCompDM;

{$R *.dfm}

constructor TfrmAddUpdComeralSigner.Create(AOwner: TComponent);
begin
  inherited Create(AOwner);

  Self.Caption := ' ';
  Self.Update := False;
end;

constructor TfrmAddUpdComeralSigner.Create(AOwner: TComponent; idRecord: Integer;
  filial: SmallInt; fio: string);
begin
  inherited Create(AOwner);

  Self.Caption := ' ';
  Self.Update := True;
  Self.idRecord := idRecord;

  FilialEdit.Text := IntToStr(filial);
  FIOEdit.Text := fio;
end;

procedure TfrmAddUpdComeralSigner.SaveBtnClick(Sender: TObject);
begin
  if Length(Trim(FilialEdit.Text)) = 0 then
  begin
    MessageDlg('  ', mtWarning, [mbOK], 0);
    Exit;
  end;

  if Length(Trim(FIOEdit.Text)) = 0 then
  begin
    MessageDlg('  ', mtWarning, [mbOK], 0);
    Exit;
  end;

  with CompDM do
  try
    if not Self.Update then
      InsertComeralSigner(StrToInt(Trim(FilialEdit.Text)), Trim(FIOEdit.Text))
    else
      UpdateComeralSigner(Self.idRecord, StrToInt(Trim(FilialEdit.Text)), Trim(FIOEdit.Text));

    ModalResult := mrOk;
  except
    on EDB: EDBOperationException do
      MessageDlg(EDB.Message, mtError, [mbOK], 0);
    on E: Exception do
      MessageDlg('   : ' + E.Message, mtError, [mbOK], 0);
  end;
end;

end.

