unit uBaseCompThread;

interface

uses
  System.Classes, System.UITypes, Vcl.ComCtrls, Vcl.StdCtrls, Vcl.Dialogs,
  Vcl.ExtCtrls, Vcl.Menus;

type
  TBaseCompThread = class(TThread)
  private
    ProgressBar: TProgressBar;
    StatusBar: TStatusBar;
    LoadExcelFileBtn: TButton;
    UpdateBtn: TButton;
    PageControl: TPageControl;
    InsPanel: TPanel;
    MainMenu: TMainMenu;
  protected
    PBStyle: TProgressBarStyle;
    StatusText: string;
    Enabled: Boolean;
    DialogMessage: string;

    procedure SetProgressBarStyle;
    procedure SetStatusBarText;
    procedure ChangeControlAvailability;
    procedure ShowErrorDialog;
    procedure ShowInfoDialog;
  public
    constructor Create(CreateSuspended: Boolean; ProgressBar: TProgressBar;
      StatusBar: TStatusBar; PageControl: TPageControl; LoadExcelFileBtn,
      UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu); overload;
  end;

implementation

// TBaseCompThread
//   

constructor TBaseCompThread.Create(CreateSuspended: Boolean; ProgressBar:
  TProgressBar; StatusBar: TStatusBar; PageControl: TPageControl;
  LoadExcelFileBtn, UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu);
begin
  inherited Create(CreateSuspended);

  Self.ProgressBar := ProgressBar;
  Self.StatusBar := StatusBar;
  Self.LoadExcelFileBtn := LoadExcelFileBtn;
  Self.UpdateBtn := UpdateBtn;
  Self.PageControl := PageControl;
  Self.InsPanel := InsPanel;
  Self.MainMenu := MainMenu;
end;

procedure TBaseCompThread.ChangeControlAvailability;
var item: TMenuItem;
begin
  //       Enabled
  Self.LoadExcelFileBtn.Enabled := Self.Enabled;
  Self.UpdateBtn.Enabled := Self.Enabled;
  Self.PageControl.Enabled := Self.Enabled;
  Self.InsPanel.Enabled := Self.Enabled;

  for item in Self.MainMenu.Items do
    item.Enabled := Self.Enabled;
end;

procedure TBaseCompThread.SetStatusBarText;
begin
  //    StatusBar
  StatusBar.SimpleText := StatusText;
end;

procedure TBaseCompThread.SetProgressBarStyle;
begin
  //   ProgressBar
  ProgressBar.Style := PBStyle;
end;

procedure TBaseCompThread.ShowErrorDialog;
begin
  //    
  MessageDlg(Self.DialogMessage, mtError, [mbOK], 0);
end;

procedure TBaseCompThread.ShowInfoDialog;
begin
  //    
  MessageDlg(Self.DialogMessage, mtInformation, [mbOK], 0);
end;

end.

