unit uCompDM;

interface

uses
  System.SysUtils, System.Classes, Data.DB, Data.Win.ADODB, System.IniFiles,
  System.Generics.Collections, Vcl.ImgList, Vcl.Controls, MemTableDataEh,
  MemTableEh, DataDriverEh, ADODataDriverEh;

type
  EDBOperationException = class(Exception);

  EConnectException = class(EDBOperationException);

  EInsExcelTempException = class(EDBOperationException);

  EInsSvodDuplesException = class(EDBOperationException);

  EInsSvodInvException = class(EDBOperationException);

  EInsSprProvException = class(EDBOperationException);

  EInsTmpComeralInvException = class(EDBOperationException);

  EInsTmpComeralProvException = class(EDBOperationException);

  EDelTmpComeralInvException = class(EDBOperationException);

  EInsComeralSigner = class(EDBOperationException);

  EUpdComeralSigner = class(EDBOperationException);

  EDelComeralSigner = class(EDBOperationException);

  EInsZeroExclude = class(EDBOperationException);

  EUpdZeroExclude = class(EDBOperationException);

  EDelZeroExclude = class(EDBOperationException);

type
  TCompDM = class(TDataModule)
    SvodMDBConnection: TADOConnection;
    SelectPlatPredpr: TADOQuery;
    SelectPlatPredprDS: TDataSource;
    ImageList_16: TImageList;
    ImageList_24: TImageList;
    CompareMemTableEh: TMemTableEh;
    CompareMemTableEhDS: TDataSource;
    CrExcelTemp: TADOQuery;
    InsExcelTempQ: TADOQuery;
    SelectSvodInvDSDEh: TDataSetDriverEh;
    ObjMDBConnection: TADOConnection;
    InsInvProvData: TADOQuery;
    SelectInvProvData: TADOQuery;
    SelectDuplicateProv: TADOQuery;
    CrSvodDuples: TADOQuery;
    CrSvodInv: TADOQuery;
    CrInvProv: TADOQuery;
    InsSvodDuplesQ: TADOQuery;
    SelectInvProvDatafullName: TStringField;
    SelectInvProvDatadocumentType: TWordField;
    SelectInvProvDatainvStatus: TSmallintField;
    SelectInvProvDatadocNumber: TStringField;
    SelectInvProvDatadocDate: TDateTimeField;
    SelectInvProvDatasprSum: TBCDField;
    SelectInvProvDatatotalVat: TBCDField;
    SelectInvProvDatatotalCost: TBCDField;
    SelectInvProvDatadopUnn: TSmallintField;
    SelectInvProvDataNumBuhSpr: TStringField;
    SelectInvProvDataidPredpr: TIntegerField;
    SelectInvProvDataglobalcode: TLargeintField;
    SelectDuplicateProvNumBuhSpr: TStringField;
    SelectDuplicateProvdocNumber: TStringField;
    SelectDuplicateProvdocDate: TDateTimeField;
    SelectDuplicateProvsprSum: TBCDField;
    SelectDuplicateProvnumBuhinv: TStringField;
    SelectDuplicateProvfullName: TStringField;
    SelectDuplicateProvtotalVat: TBCDField;
    SelectDuplicateProvnamePredpr: TStringField;
    SelectDuplicateProvdopUNN: TSmallintField;
    SelectInvProvDatadateTrans: TDateTimeField;
    SelectInvProvDatatotalCostVat: TBCDField;
    InsSvodInvQ: TADOQuery;
    SelectInvProvDataSvplace: TStringField;
    SelectSvodDuplesFilial: TADOQuery;
    SelectSvodDuplesDS: TDataSource;
    SelectSvodInv: TADOQuery;
    SelectSvodDuplesFilialnumbuhdup: TStringField;
    SelectSvodDuplesFilialdocnumberdup: TStringField;
    SelectSvodDuplesFilialdocdatedup: TDateTimeField;
    SelectSvodDuplesFilialsumdup: TBCDField;
    SelectSvodDuplesFilialnumbuhsv: TStringField;
    SelectSvodDuplesFilialinvfullname: TStringField;
    SelectSvodDuplesFilialinvtotalvat: TBCDField;
    SelectSvodDuplesFilialnamepredpr: TStringField;
    SelectSvodDuplesFilialdopUNN: TSmallintField;
    SelectSvodInvidPredpr: TLargeintField;
    SelectSvodInvinvoicefullname: TStringField;
    SelectSvodInvdatetrans: TDateTimeField;
    SelectSvodInvstatus: TWordField;
    SelectSvodInvnamepredpr: TStringField;
    SelectSvodInvdocnumber: TStringField;
    SelectSvodInvdocdate: TDateTimeField;
    SelectSvodInvndsexcel: TBCDField;
    SelectSvodInvndsspr: TBCDField;
    SelectSvodInvndsinvoice: TBCDField;
    SelectSvodInvtotalcostinv: TBCDField;
    SelectSvodInvtotalcostvatinv: TBCDField;
    SelectSvodInvfilial: TSmallintField;
    SelectSvodInvsvplace: TStringField;
    CompareMemTableEhidPredpr: TLargeintField;
    CompareMemTableEhinvoicefullname: TStringField;
    CompareMemTableEhdatetrans: TDateTimeField;
    CompareMemTableEhstatus: TWordField;
    CompareMemTableEhnamepredpr: TStringField;
    CompareMemTableEhdocnumber: TStringField;
    CompareMemTableEhdocdate: TDateTimeField;
    CompareMemTableEhndsexcel: TBCDField;
    CompareMemTableEhndsspr: TBCDField;
    CompareMemTableEhndsinvoice: TBCDField;
    CompareMemTableEhtotalcostinv: TBCDField;
    CompareMemTableEhtotalcostvatinv: TBCDField;
    CompareMemTableEhfilial: TSmallintField;
    CompareMemTableEhsvplace: TStringField;
    CompareMemTableEhStatusText: TStringField;
    SelectSprProvQ: TADOQuery;
    SelectSprProvDS: TDataSource;
    InsSprProvQ: TADOQuery;
    CrSprProv: TADOQuery;
    SelectSprProvObj: TADOQuery;
    SelectSprProvObjSumm: TBCDField;
    SelectSprProvObjDataDoc: TDateTimeField;
    SelectSprProvObjNumDoc: TStringField;
    SelectSprProvObjnumDocPart: TStringField;
    SelectSprProvObjNumBuhSpr: TStringField;
    SelectSprProvObjglobalcode: TStringField;
    SelectSprProvObjdopUNN: TSmallintField;
    SelectInvProvDataNumDocPart: TStringField;
    SelectSvodInvnumbuhspr: TStringField;
    SelectSvodInvnumdocpart: TStringField;
    CompareMemTableEhnumbuhspr: TStringField;
    CompareMemTableEhnumdocpart: TStringField;
    SelectSprProvObjNSF: TStringField;
    SelectSvodDuplesOblpo: TADOQuery;
    SelectSvodDuplesOblpoDS: TDataSource;
    SelectSvodDuplesOblpoidPredpr: TLargeintField;
    SelectSvodDuplesOblpoinvoicefullname: TStringField;
    SelectSvodDuplesOblpodatetrans: TDateTimeField;
    SelectSvodDuplesOblpostatus: TWordField;
    SelectSvodDuplesOblponamePredpr: TStringField;
    SelectSvodDuplesOblpodocnumber: TStringField;
    SelectSvodDuplesOblpodocdate: TDateTimeField;
    SelectSvodDuplesOblpondsspr: TBCDField;
    SelectSvodDuplesOblpondsinvoice: TBCDField;
    SelectSvodDuplesOblpototalcostinv: TBCDField;
    SelectSvodDuplesOblpototalcostvatinv: TBCDField;
    SelectSvodDuplesOblpofilial: TSmallintField;
    SelectSvodDuplesOblponumbuhspr: TStringField;
    SelectSvodDuplesOblponumdocpart: TStringField;
    SelectOblDopUnn: TADOQuery;
    CompareMemTableEhndsdiff: TBCDField;
    SelectSvodInvrecipientname: TStringField;
    SelectSvodInvsignerfio: TStringField;
    CompareMemTableEhrecipientname: TStringField;
    CompareMemTableEhsignerfio: TStringField;
    TmpComeralInvMemTableEh: TMemTableEh;
    TmpComeralInvMemTableEhDS: TDataSource;
    SelectTmpComeralInvDSDEh: TDataSetDriverEh;
    SelectTmpComeralInv: TADOQuery;
    SelectTmpComeralInvidRecord: TAutoIncField;
    SelectTmpComeralInvidPredpr: TLargeintField;
    SelectTmpComeralInvinvoicefullname: TStringField;
    SelectTmpComeralInvdatetrans: TDateTimeField;
    SelectTmpComeralInvstatus: TWordField;
    SelectTmpComeralInvrecipientname: TStringField;
    SelectTmpComeralInvsignerfio: TStringField;
    SelectTmpComeralInvnamepredpr: TStringField;
    SelectTmpComeralInvdocnumber: TStringField;
    SelectTmpComeralInvdocdate: TDateTimeField;
    SelectTmpComeralInvndsexcel: TBCDField;
    SelectTmpComeralInvndsspr: TBCDField;
    SelectTmpComeralInvndsinvoice: TBCDField;
    SelectTmpComeralInvtotalcostinv: TBCDField;
    SelectTmpComeralInvtotalcostvatinv: TBCDField;
    SelectTmpComeralInvfilial: TSmallintField;
    SelectTmpComeralInvsvplace: TStringField;
    SelectTmpComeralInvnumbuhspr: TStringField;
    SelectTmpComeralInvnumdocpart: TStringField;
    SelectTmpComeralInvhide: TBooleanField;
    TmpComeralInvMemTableEhidRecord: TAutoIncField;
    TmpComeralInvMemTableEhhide: TBooleanField;
    SelectTmpComeralProvDS: TDataSource;
    SelectTmpComeralProv: TADOQuery;
    TmpComeralInvMemTableEhidPredpr: TLargeintField;
    TmpComeralInvMemTableEhinvoicefullname: TStringField;
    TmpComeralInvMemTableEhdatetrans: TDateTimeField;
    TmpComeralInvMemTableEhstatus: TWordField;
    TmpComeralInvMemTableEhrecipientname: TStringField;
    TmpComeralInvMemTableEhsignerfio: TStringField;
    TmpComeralInvMemTableEhnamepredpr: TStringField;
    TmpComeralInvMemTableEhdocnumber: TStringField;
    TmpComeralInvMemTableEhdocdate: TDateTimeField;
    TmpComeralInvMemTableEhndsexcel: TBCDField;
    TmpComeralInvMemTableEhndsspr: TBCDField;
    TmpComeralInvMemTableEhndsinvoice: TBCDField;
    TmpComeralInvMemTableEhtotalcostinv: TBCDField;
    TmpComeralInvMemTableEhtotalcostvatinv: TBCDField;
    TmpComeralInvMemTableEhfilial: TSmallintField;
    TmpComeralInvMemTableEhsvplace: TStringField;
    TmpComeralInvMemTableEhnumbuhspr: TStringField;
    TmpComeralInvMemTableEhnumdocpart: TStringField;
    TmpComeralInvMemTableEhStatusText: TStringField;
    InsTmpComeralInvQ: TADOQuery;
    InsTmpComeralProvQ: TADOQuery;
    RewriteInsTmpComeralProv: TADOQuery;
    DelTmpComeralInvQ: TADOQuery;
    TmpComeralInvMemTableEhndsdiff: TBCDField;
    SelectSvodDuplesFilialmes: TDateTimeField;
    SelectDuplicateProvmes: TDateTimeField;
    SelectSprProvObjmes: TDateTimeField;
    SelectTmpComeralProvnumbuhspr: TStringField;
    SelectTmpComeralProvmes: TDateTimeField;
    SelectTmpComeralProvdatadoc: TDateTimeField;
    SelectTmpComeralProvnumdoc: TStringField;
    SelectTmpComeralProvnumdocpart: TStringField;
    SelectTmpComeralProvsumm: TBCDField;
    SelectTmpComeralProvglobalcode: TStringField;
    SelectTmpComeralProvfilial: TSmallintField;
    SelectTmpComeralProvNSF: TStringField;
    SelectSprProvQnumbuhspr: TStringField;
    SelectSprProvQdatadoc: TDateTimeField;
    SelectSprProvQnumdoc: TStringField;
    SelectSprProvQnumdocpart: TStringField;
    SelectSprProvQsumm: TBCDField;
    SelectSprProvQglobalcode: TStringField;
    SelectSprProvQfilial: TSmallintField;
    SelectSprProvQNSF: TStringField;
    SelectSprProvQmes: TDateTimeField;
    ExcSumQ: TADOQuery;
    SprSumQ: TADOQuery;
    SelectComeralSingersQ: TADOQuery;
    InsertComeralSingersQ: TADOQuery;
    UpdateComeralSingersQ: TADOQuery;
    DeleteComeralSingersQ: TADOQuery;
    SelectComeralSingersDS: TDataSource;
    SelectComeralSingersQidRecord: TAutoIncField;
    SelectComeralSingersQfilial: TSmallintField;
    SelectComeralSingersQfio: TStringField;
    SelectSignersByFilialQ: TADOQuery;
    CheckComeralSignersDuplesQ: TADOQuery;
    SelectSvodDuplesInvoiceNumbersDS: TDataSource;
    SelectSvodDuplesInvoiceNumbers: TADOQuery;
    StringField1: TStringField;
    SelectSvodDuplesInvoiceNumbersdatetrans: TDateTimeField;
    SelectSvodDuplesInvoiceNumbersfilial: TSmallintField;
    SelectZeroExcludeQ: TADOQuery;
    InsertZeroExcludeQ: TADOQuery;
    UpdateZeroExcludeQ: TADOQuery;
    DeleteZeroExcludeQ: TADOQuery;
    SelectZeroExcludeDS: TDataSource;
    SelectZeroExcludeQidRecord: TAutoIncField;
    SelectZeroExcludeQfilial: TSmallintField;
    SelectZeroExcludeQinvoice: TStringField;
    procedure DataModuleCreate(Sender: TObject);
    procedure CompareMemTableEhCalcFields(DataSet: TDataSet);
    procedure TmpComeralInvMemTableEhCalcFields(DataSet: TDataSet);
  private
    { Private declarations }
    function GetStatusText(Index: SmallInt): string;
  public
    { Public declarations }
    IsFilial: Boolean;
    Filial: string;
    ObjectsDict: TDictionary<string, string>;
    procedure ConnectToObject(server: string);
    function UpdateDecimalSeparator(const s: string): string;
    procedure InsertExcelTemp(idPredpr: int64; namePredpr, invoicefullname,
      docnumber, svplace, recipientname, signerfio: string; datetrans: TDateTime;
      status: SmallInt; ndsexcel, totalcostinv, totalcostvatinv: Currency; docdate, dopunn: Variant);
    procedure InsertSvodDuples(numbuhdup, docnumberdup, numbuhsv, invfullname,
      namepredpr: string; mes, docdatedup: TDateTime; sumdup, invtotalvat: Currency; dopUNN: SmallInt);
    procedure InsertSvodInv(idPredpr, invoicefullname, datetrans, status, ndsspr,
      ndsinvoice, totalcostinv, totalcostvatinv, svplace, numbuhspr, numdocpart,
      docnumber, docdate, filial: Variant);
    procedure InsertSprProv(numbuhspr, numdoc, numdocpart, NSF: string; mes,
      datadoc: TDateTime; summ: Currency; globalcode: Variant; filial: SmallInt);
    procedure SelectSprProv(Query: TADOQuery; numdoc, numdocpart, numbuhspr,
      globalcode, invfullname: string; datadoc: TDateTime; filial: SmallInt);
    procedure InsertTmpComeralInv(idPredpr, invoicefullname, datetrans, status,
      recipientname, signerfio, namepredpr, docnumber, docdate, ndsexcel, ndsspr,
      ndsinvoice, totalcostinv, totalcostvatinv, filial, svplace, numbuhspr, numdocpart: Variant);
    procedure InsertTpmComeralProv(numbuhspr, mes, numdoc, numdocpart, NSF,
      datadoc, summ, globalcode, filial: Variant);
    procedure InsertComeralSigner(filial: SmallInt; fio: string);
    procedure UpdateComeralSigner(idRecord: Integer; filial: SmallInt; fio: string);
    procedure DeleteComeralSigner(idRecord: Integer);
    procedure InsertZeroExclude(filial: SmallInt; invoice: string);
    procedure UpdateZeroExclude(idRecord: Integer; filial: SmallInt; invoice: string);
    procedure DeleteZeroExclude(idRecord: Integer);
    function GetSignersByFilial(filial: Variant): string;
    function CheckComeralSignersDuplicates(out fios: string): Boolean;
  end;

const
  connstr = 'Provider=SQLOLEDB.1;Password=transpass;Persist Security Info=True;User ID=transport;';
  //    :
  // True -    ,
  // Flase -      
//  DEBUG = True;
  DEBUG = False;

var
  CompDM: TCompDM;

implementation

{%CLASSGROUP 'Vcl.Controls.TControl'}

{$R *.dfm}

procedure TCompDM.ConnectToObject(server: string);
begin
  //   
  try
    with ObjMDBConnection do
    begin
      Close;
      ConnectionString := connstr + 'Initial Catalog=MainDataBase;Data Source=' + server;
      Open;
    end;
  except
    on e: Exception do
      raise EConnectException.Create(e.Message);
  end;
end;

function TCompDM.CheckComeralSignersDuplicates(out fios: string): Boolean;
begin
  with CheckComeralSignersDuplesQ do
  begin
    Close;
    Open;

    if not IsEmpty then
    begin
      fios := '';

      First;
      while not Eof do
      begin
        fios := fios + ' ' + FieldByName('fio').AsString;
        Next;
      end;
    end;

    Result := not IsEmpty;
  end;
end;

function TCompDM.GetSignersByFilial(filial: Variant): string;
var
  signers: string;
begin
  with SelectSignersByFilialQ do
  begin
    Close;
    Parameters.ParamByName('filial').Value := filial;
    Open;

    if not IsEmpty then
    begin
      signers := '';

      First;

      while not Eof do
      begin
        signers := signers + QuotedStr(FieldByName('fio').AsString) + ',';

        Next;
      end;

      Result := Copy(signers, 1, Length(signers) - 1);
    end
    else
      Result := '';
  end;
end;

procedure TCompDM.InsertZeroExclude(filial: SmallInt; invoice: string);
begin
  with InsertZeroExcludeQ do
  try
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('invoice').Value := invoice;
    ExecSQL;
  except
    on E: Exception do
      raise EInsZeroExclude.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.UpdateZeroExclude(idRecord: Integer; filial: SmallInt; invoice: string);
begin
  with UpdateZeroExcludeQ do
  try
    Parameters.ParamByName('idRecord').Value := idRecord;
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('invoice').Value := invoice;
    ExecSQL;
  except
    on E: Exception do
      raise EUpdZeroExclude.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.DeleteZeroExclude(idRecord: Integer);
begin
  with DeleteZeroExcludeQ do
  try
    Parameters.ParamByName('idRecord').Value := idRecord;
    ExecSQL;
  except
    on E: Exception do
      raise EDelZeroExclude.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.InsertComeralSigner(filial: SmallInt; fio: string);
begin
  with InsertComeralSingersQ do
  try
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('fio').Value := fio;
    ExecSQL;
  except
    on E: Exception do
      if Pos('duplicate key', E.Message) > 0 then
        raise EInsComeralSigner.Create('     .')
      else
        raise EInsComeralSigner.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.UpdateComeralSigner(idRecord: Integer; filial: SmallInt; fio: string);
begin
  with UpdateComeralSingersQ do
  try
    Parameters.ParamByName('idRecord').Value := idRecord;
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('fio').Value := fio;
    ExecSQL;
  except
    on E: Exception do
      if Pos('duplicate key', E.Message) > 0 then
        raise EUpdComeralSigner.Create('     .')
      else
        raise EUpdComeralSigner.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.DeleteComeralSigner(idRecord: Integer);
begin
  with DeleteComeralSingersQ do
  try
    Parameters.ParamByName('idRecord').Value := idRecord;
    ExecSQL;
  except
    on E: Exception do
      raise EDelComeralSigner.Create('    : ' + e.Message);
  end;
end;

procedure TCompDM.SelectSprProv(Query: TADOQuery; numdoc, numdocpart, numbuhspr,
  globalcode, invfullname: string; datadoc: TDateTime; filial: SmallInt);
begin
  //     
  with Query do
  begin
    Close;
    Parameters.ParamByName('numdoc').Value := numdoc;
    Parameters.ParamByName('numdocpart').Value := numdocpart;
    Parameters.ParamByName('datadoc').Value := datadoc;
    Parameters.ParamByName('numbuhspr').Value := numbuhspr;
    Parameters.ParamByName('globalcode').Value := globalcode;
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('invfullname').Value := invfullname;
    Open;
  end;
end;

procedure TCompDM.TmpComeralInvMemTableEhCalcFields(DataSet: TDataSet);
begin
  TmpComeralInvMemTableEhStatusText.AsString := GetStatusText(TmpComeralInvMemTableEhStatus.AsInteger);
  TmpComeralInvMemTableEhndsdiff.Value := TmpComeralInvMemTableEhndsexcel.AsCurrency
    - TmpComeralInvMemTableEhndsspr.AsCurrency;
end;

procedure TCompDM.InsertExcelTemp(idPredpr: int64; namePredpr, invoicefullname,
  docnumber, svplace, recipientname, signerfio: string; datetrans: TDateTime;
  status: SmallInt; ndsexcel, totalcostinv, totalcostvatinv: Currency; docdate, dopunn: Variant);
begin
  //      #svexceltmp
  with InsExcelTempQ do
  try
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    Parameters.ParamByName('namePredpr').Value := namePredpr;
    Parameters.ParamByName('invoicefullname').Value := invoicefullname;
    Parameters.ParamByName('docnumber').Value := docnumber;
    Parameters.ParamByName('svplace').Value := svplace;
    Parameters.ParamByName('datetrans').Value := datetrans;
    Parameters.ParamByName('docdate').Value := docdate;
    Parameters.ParamByName('status').Value := status;
    Parameters.ParamByName('recipientname').Value := recipientname;
    Parameters.ParamByName('dopunn').Value := dopunn;
    Parameters.ParamByName('signerfio').Value := signerfio;
    Parameters.ParamByName('ndsexcel').Value := ndsexcel;
    Parameters.ParamByName('totalcostinv').Value := totalcostinv;
    Parameters.ParamByName('totalcostvatinv').Value := totalcostvatinv;
    ExecSQL;
  except
    on E: Exception do
      raise EInsExcelTempException.Create('     ' +
        '    ' + ': ' + E.Message);
  end;
end;

procedure TCompDM.InsertSvodDuples(numbuhdup, docnumberdup, numbuhsv,
  invfullname, namepredpr: string; mes, docdatedup: TDateTime; sumdup,
  invtotalvat: Currency; dopUNN: SmallInt);
begin
  //      #svod_duples
  with InsSvodDuplesQ do
  try
    Parameters.ParamByName('numbuhdup').Value := numbuhdup;
    Parameters.ParamByName('docnumberdup').Value := docnumberdup;
    Parameters.ParamByName('mes').Value := mes;
    Parameters.ParamByName('docdatedup').Value := docdatedup;
    Parameters.ParamByName('sumdup').Value := sumdup;
    Parameters.ParamByName('numbuhsv').Value := numbuhsv;
    Parameters.ParamByName('invfullname').Value := invfullname;
    Parameters.ParamByName('invtotalvat').Value := invtotalvat;
    Parameters.ParamByName('namepredpr').Value := namepredpr;
    Parameters.ParamByName('dopUNN').Value := dopUNN;
    ExecSQL;
  except
    on E: Exception do
      raise EInsSvodDuplesException.Create('    '
        + '  #svod_duples  : ' + e.Message);
  end;
end;

procedure TCompDM.InsertSvodInv(idPredpr, invoicefullname, datetrans, status,
  ndsspr, ndsinvoice, totalcostinv, totalcostvatinv, svplace, numbuhspr,
  numdocpart, docnumber, docdate, filial: Variant);
begin
  //      #svod_inv
  with InsSvodInvQ do
  try
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    Parameters.ParamByName('invoicefullname').Value := invoicefullname;
    Parameters.ParamByName('datetrans').Value := datetrans;
    Parameters.ParamByName('status').Value := status;
    Parameters.ParamByName('docnumber').Value := docnumber;
    Parameters.ParamByName('docdate').Value := docdate;
    Parameters.ParamByName('ndsspr').Value := ndsspr;
    Parameters.ParamByName('ndsinvoice').Value := ndsinvoice;
    Parameters.ParamByName('totalcostinv').Value := totalcostinv;
    Parameters.ParamByName('totalcostvatinv').Value := totalcostvatinv;
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('svplace').Value := svplace;
    Parameters.ParamByName('numbuhspr').Value := numbuhspr;
    Parameters.ParamByName('numdocpart').Value := numdocpart;
    ExecSQL;
  except
    on e: Exception do
      raise EInsSvodInvException.Create('    ' +
        '  #svod_inv  : ' + e.Message);
  end;
end;

procedure TCompDM.InsertTmpComeralInv(idPredpr, invoicefullname, datetrans,
  status, recipientname, signerfio, namepredpr, docnumber, docdate, ndsexcel,
  ndsspr, ndsinvoice, totalcostinv, totalcostvatinv, filial, svplace, numbuhspr, numdocpart: Variant);
begin
  //     tmpComeralInv
  with InsTmpComeralInvQ do
  try
    Parameters.ParamByName('idPredpr').Value := idPredpr;
    Parameters.ParamByName('invoicefullname').Value := invoicefullname;
    Parameters.ParamByName('datetrans').Value := datetrans;
    Parameters.ParamByName('status').Value := status;
    Parameters.ParamByName('recipientname').Value := recipientname;
    Parameters.ParamByName('signerfio').Value := signerfio;
    Parameters.ParamByName('namepredpr').Value := namepredpr;
    Parameters.ParamByName('docnumber').Value := docnumber;
    Parameters.ParamByName('docdate').Value := docdate;
    Parameters.ParamByName('ndsexcel').Value := ndsexcel;
    Parameters.ParamByName('ndsspr').Value := ndsspr;
    Parameters.ParamByName('ndsinvoice').Value := ndsinvoice;
    Parameters.ParamByName('totalcostinv').Value := totalcostinv;
    Parameters.ParamByName('totalcostvatinv').Value := totalcostvatinv;
    Parameters.ParamByName('filial').Value := filial;
    Parameters.ParamByName('svplace').Value := svplace;
    Parameters.ParamByName('numbuhspr').Value := numbuhspr;
    Parameters.ParamByName('numdocpart').Value := numdocpart;
    ExecSQL;
  except
    on e: Exception do
      raise EInsTmpComeralInvException.Create('   ' +
        '  tmpComeralInv  : ' + e.Message);
  end;
end;

procedure TCompDM.InsertSprProv(numbuhspr, numdoc, numdocpart, NSF: string; mes,
  datadoc: TDateTime; summ: Currency; globalcode: Variant; filial: SmallInt);
begin
  //      #svod_prov
  with InsSprProvQ do
  try
    Parameters.ParamByName('numbuhspr').Value := numbuhspr;
    Parameters.ParamByName('mes').Value := mes;
    Parameters.ParamByName('numdoc').Value := numdoc;
    Parameters.ParamByName('numdocpart').Value := numdocpart;
    Parameters.ParamByName('NSF').Value := NSF;
    Parameters.ParamByName('datadoc').Value := datadoc;
    Parameters.ParamByName('summ').Value := summ;
    Parameters.ParamByName('globalcode').Value := globalcode;
    Parameters.ParamByName('filial').Value := filial;
    ExecSQL;
  except
    on e: Exception do
      raise EInsSprProvException.Create('    ' +
        '  #svod_prov  : ' + e.Message);
  end;
end;

procedure TCompDM.InsertTpmComeralProv(numbuhspr, mes, numdoc, numdocpart, NSF,
  datadoc, summ, globalcode, filial: Variant);
begin
  //     tmpComeralProv
  with InsTmpComeralProvQ do
  try
    Parameters.ParamByName('numbuhspr').Value := numbuhspr;
    Parameters.ParamByName('mes').Value := mes;
    Parameters.ParamByName('numdoc').Value := numdoc;
    Parameters.ParamByName('numdocpart').Value := numdocpart;
    Parameters.ParamByName('NSF').Value := NSF;
    Parameters.ParamByName('datadoc').Value := datadoc;
    Parameters.ParamByName('summ').Value := summ;
    Parameters.ParamByName('globalcode').Value := globalcode;
    Parameters.ParamByName('filial').Value := filial;
    ExecSQL;
  except
    on e: Exception do
      raise EInsTmpComeralProvException.Create('   ' +
        '  tmpComeralProv  : ' + e.Message);
  end;
end;

function TCompDM.UpdateDecimalSeparator(const s: string): string;
var
  no_spaces: string;
begin
  //          
  // 
  if Length(s) = 0 then
    Result := '0'
  else
    with FormatSettings do
    begin
      no_spaces := StringReplace(s, ' ', '', [rfReplaceAll]);

      case DecimalSeparator of
        ',':
          Result := StringReplace(no_spaces, '.', DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);
        '.':
          Result := StringReplace(no_spaces, ',', DecimalSeparator, [rfReplaceAll, rfIgnoreCase]);
      end;
    end;
end;

function TCompDM.GetStatusText(Index: SmallInt): string;
begin
  case Index of
    0:
      Result := ' ';
    1:
      Result := ' ';
    2:
      Result := ' . ';
    3:
      Result := '';
    4:
      Result := ' ';
    5:
      Result := '. ';
    6:
      Result := '';
    7:
      Result := '. ';
    8:
      Result := ' ';
    9:
      Result := '';
  else
    Result := ' ';
  end;
end;

procedure TCompDM.CompareMemTableEhCalcFields(DataSet: TDataSet);
begin
  CompareMemTableEhStatusText.AsString := GetStatusText(CompareMemTableEhStatus.AsInteger);
  CompareMemTableEhndsdiff.Value := CompareMemTableEhndsexcel.AsCurrency - CompareMemTableEhndsspr.AsCurrency;
end;

procedure TCompDM.DataModuleCreate(Sender: TObject);
var
  iniFile: TIniFile;
  SvodIp, item, iniPath: string;
  ObjConnections: TStringList;
  DelimPos: Byte;
begin
  iniPath := ExtractFilePath(ParamStr(0)) + 'Config.ini';

  if not FileExists(iniPath) then
    Exit;

  iniFile := TIniFile.Create(iniPath);
  ObjectsDict := TDictionary<string, string>.Create;
  ObjConnections := TStringList.Create;

  //     ini  
  try
    SvodIp := iniFile.ReadString('svodconnection', 'ip', '');
    Self.Filial := iniFile.ReadString('svodconnection', 'filial', '');
    Self.IsFilial := Length(Self.Filial) > 0;
    iniFile.ReadSectionValues('objectsconnection', ObjConnections);

    for item in ObjConnections do
    begin
      DelimPos := Pos('=', item);
      ObjectsDict.Add(Copy(item, 1, DelimPos - 1), Copy(item, DelimPos + 1, Length(item) - DelimPos));
    end;
  finally
    iniFile.Free;
    ObjConnections.Free;
  end;

  with SvodMDBConnection do
  begin
    Close;
    ConnectionString := connstr + 'Initial Catalog=maindatabase;Data Source=' + SvodIp;
    if DEBUG then
      ConnectionString :=
        'Provider=SQLOLEDB.1;Password=transpass;Persist Security Info=True;User ID=transport;Initial Catalog=maindatabase_s;Data Source=.';
    Open;
  end;
end;

end.

