unit uCompareDataThread;

interface

uses
  System.Classes, System.SysUtils, Vcl.ComCtrls, Vcl.StdCtrls, Vcl.ExtCtrls,
  Data.DB, uBaseCompThread, DBGridEh, Vcl.Menus;

type
  TCompareData = class(TBaseCompThread)
  private
    FirstDate: TDateTime;
    SecondDate: TDateTime;
    idPredpr: Int64;
    excFooter, sprFooter, diffFooter: TColumnFooterEh;
    selfProv: Boolean;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; idPredpr: int64; FirstDate,
      SecondDate: TDateTime; selfProv: Boolean; ProgressBar: TProgressBar;
      StatusBar: TStatusBar; PageControl: TPageControl; LoadExcelFileBtn,
      UpdateBtn: TButton; InsPanel: TPanel; MainMenu: TMainMenu; excFooter,
      sprFooter, diffFooter: TColumnFooterEh); overload;
  end;

var
  CompareData: TCompareData;


implementation

uses
  uCompDM;

// TCompareData
//       

constructor TCompareData.Create(CreateSuspended: Boolean; idPredpr: int64;
  FirstDate, SecondDate: TDateTime; selfProv: Boolean; ProgressBar: TProgressBar;
  StatusBar: TStatusBar; PageControl: TPageControl; LoadExcelFileBtn, UpdateBtn:
  TButton; InsPanel: TPanel; MainMenu: TMainMenu; excFooter, sprFooter, diffFooter: TColumnFooterEh);
begin
  inherited Create(CreateSuspended, ProgressBar, StatusBar, PageControl,
    LoadExcelFileBtn, UpdateBtn, InsPanel, MainMenu);

  Self.idPredpr := idPredpr;
  Self.FirstDate := FirstDate;
  Self.SecondDate := SecondDate;
  Self.excFooter := excFooter;
  Self.sprFooter := sprFooter;
  Self.diffFooter := diffFooter;
  Self.selfProv := selfProv;
end;

procedure TCompareData.Execute;
var
  item: string;
begin
  with CompDM do
  try
    //   
    Synchronize(CompareMemTableEh.DisableControls);
    CompareMemTableEh.Active := False;

    Synchronize(SelectSvodDuplesFilial.DisableControls);
    Synchronize(SelectSvodDuplesOblpo.DisableControls);

    Self.Enabled := False;
    Synchronize(ChangeControlAvailability);

    Self.StatusText := '    ...';
    Synchronize(SetStatusBarText);

    try
      //   
      CrSvodInv.ExecSQL;
      CrSvodDuples.ExecSQL;
      CrSprProv.ExecSQL;

      Self.PBStyle := pbstMarquee;
      Synchronize(SetProgressBarStyle);

      //   
      for item in ObjectsDict.Keys do
      begin
        //   
        ConnectToObject(ObjectsDict.Items[item]);

        Self.StatusText := '      - ' + item;
        Synchronize(SetStatusBarText);

        //           
        CrInvProv.ExecSQL;

        with InsInvProvData do
        begin
          Parameters.ParamByName('FirstDate').Value := DateToStr(Self.FirstDate);
          Parameters.ParamByName('SecondDate').Value := DateToStr(Self.SecondDate);
          Parameters.ParamByName('delSelfProv').Value := Self.selfProv;

          if Self.idPredpr > 0 then
            SQL[SQL.Count - 2] :=
              'AND ISNULL(ISNULL(spr.globalcode, inv.globalcode),' + QuotedStr('') + ')=' +
              QuotedStr(IntToStr(Self.idPredpr))
          else
            SQL[SQL.Count - 2] := '--   ';

          ExecSQL;
        end;

        Self.StatusText := '   - ' + item;
        Synchronize(SetStatusBarText);

        //   
        with SelectSprProvObj do
        begin
          Close;
          Parameters.ParamByName('FirstDate').Value := DateToStr(Self.FirstDate);
          Parameters.ParamByName('SecondDate').Value := DateToStr(Self.SecondDate);
          Parameters.ParamByName('delSelfProv').Value := Self.selfProv;

          if Self.idPredpr > 0 then
            SQL[SQL.Count - 1] := 'AND ISNULL(pred.globalcode, ' + QuotedStr('')
              + ')=' + QuotedStr(IntToStr(Self.idPredpr))
          else
            SQL[SQL.Count - 1] := '--   ';

          Open;
        end;

        //     
        if not SelectSprProvObj.IsEmpty then
        begin
          SelectSprProvObj.First;

          while not SelectSprProvObj.Eof do
          begin
            InsertSprProv(SelectSprProvObjNumBuhSpr.AsString,
              SelectSprProvObjNumDoc.AsString, SelectSprProvObjnumDocPart.AsString,
              SelectSprProvObjNSF.AsString, SelectSprProvObjmes.AsDateTime,
              SelectSprProvObjDataDoc.AsDateTime, SelectSprProvObjSumm.AsCurrency,
              SelectSprProvObjglobalcode.AsVariant, SelectSprProvObjdopUNN.AsInteger);

            SelectSprProvObj.Next;
          end;
        end;

        Self.StatusText := '   - ' + item;
        Synchronize(SetStatusBarText);

        SelectDuplicateProv.Close;
        SelectDuplicateProv.Open;

        //      
        if not SelectDuplicateProv.IsEmpty then
        begin
          SelectDuplicateProv.First;

          while not SelectDuplicateProv.Eof do
          begin
            InsertSvodDuples(SelectDuplicateProvNumBuhSpr.AsString,
              SelectDuplicateProvdocNumber.AsString, SelectDuplicateProvnumBuhinv.AsString,
              SelectDuplicateProvfullName.AsString,
              SelectDuplicateProvnamePredpr.AsString, SelectDuplicateProvmes.AsDateTime,
              SelectDuplicateProvdocDate.AsDateTime, SelectDuplicateProvsprSum.AsCurrency,
              SelectDuplicateProvtotalVat.AsCurrency, SelectDuplicateProvdopUNN.AsInteger);

            SelectDuplicateProv.Next;
          end;
        end;

        Self.StatusText := '   - ' + item;
        Synchronize(SetStatusBarText);

        SelectInvProvData.Close;
        SelectInvProvData.Open;

        //      
        if not SelectInvProvData.IsEmpty then
        begin
          SelectInvProvData.First;

          while not SelectInvProvData.Eof do
          begin
            InsertSvodInv(SelectInvProvDataglobalcode.AsVariant,
              SelectInvProvDatafullName.AsVariant, SelectInvProvDatadateTrans.AsVariant,
              SelectInvProvDatainvStatus.AsVariant, SelectInvProvDatasprSum.AsVariant,
              SelectInvProvDatatotalVat.AsVariant, SelectInvProvDatatotalCost.AsVariant,
              SelectInvProvDatatotalCostVat.AsVariant, SelectInvProvDataSvplace.AsVariant,
              SelectInvProvDataNumBuhSpr.AsVariant, SelectInvProvDataNumDocPart.AsVariant,
              SelectInvProvDatadocNumber.AsVariant, SelectInvProvDatadocDate.AsVariant,
              SelectInvProvDatadopUnn.AsVariant);

            SelectInvProvData.Next;
          end;
        end;
      end;

      Self.StatusText := '    ...';
      Synchronize(SetStatusBarText);

      with SelectSvodInv do
      begin
        Close;
        Parameters.ParamByName('FirstDate').Value := DateToStr(Self.FirstDate);
        Parameters.ParamByName('SecondDate').Value := DateToStr(Self.SecondDate);
        Parameters.ParamByName('isFilial').Value := IsFilial;

        if Self.idPredpr > 0 then
          SQL[SQL.Count - 2] := 'AND ISNULL(inv.idPredpr, exc.idPredpr)=' + QuotedStr(IntToStr(Self.idPredpr))
        else
          SQL[SQL.Count - 2] := '--  ';

        if IsFilial then
          SQL[SQL.Count - 3] := 'AND ISNULL(ISNULL(inv.filial,csig.filial), exc.dopunn)=' + Filial
        else
          SQL[SQL.Count - 3] := '--  ';

        Open;
      end;

      Self.StatusText := '  ...';
      Synchronize(SetStatusBarText);

      //      
      SelectSvodDuplesFilial.Close;
      SelectSvodDuplesFilial.Open;

      CompareMemTableEh.Active := True;
      CompareMemTableEh.SortByFields('namepredpr,invoicefullname');
      CompareMemTableEh.First;

      SelectSvodDuplesOblpo.Close;
      SelectSvodDuplesOblpo.Open;

      SelectSvodDuplesInvoiceNumbers.Close;
      SelectSvodDuplesInvoiceNumbers.Open;

      //      
      with ExcSumQ do
      begin
        Close;

        if IsFilial then
          SQL[SQL.Count - 1] := 'WHERE ISNULL(csig.filial,exc.dopunn)=' + Filial
        else
          SQL[SQL.Count - 1] := '--  ';

        Open;
      end;

      //      
      SprSumQ.Close;
      SprSumQ.Open;

      Self.excFooter.Value := ExcSumQ.FieldByName('excsum').AsString;
      Self.sprFooter.Value := SprSumQ.FieldByName('sprsum').AsString;
      Self.diffFooter.Value := CurrToStr(ExcSumQ.FieldByName('excsum').AsCurrency
        - SprSumQ.FieldByName('sprsum').AsCurrency);

      Self.StatusText := ' .  : ' +
        IntToStr(SelectSvodInv.RecordCount) + '.' + '  : ' +
        IntToStr(SelectSvodDuplesFilial.RecordCount) + '.';
      Synchronize(SetStatusBarText);
    except
      on econ: EConnectException do
      begin
        Self.DialogMessage := '      ' +
          item + '  : ' + econ.Message;
        Synchronize(ShowErrorDialog);
        Self.StatusText := '    : ' + item;
        Synchronize(SetStatusBarText);
      end;
      on edb: EDBOperationException do
      begin
        Self.DialogMessage := ': ' + item + #13#10 + edb.Message;
        Synchronize(ShowErrorDialog);
        Self.StatusText := '     : ' + item;
        Synchronize(SetStatusBarText);
      end;
      on e: Exception do
      begin
        Self.DialogMessage := '     : ' + e.Message;
        Synchronize(ShowErrorDialog);
        Self.StatusText := '   ';
        Synchronize(SetStatusBarText);
      end;
    end;
  finally
    Self.Enabled := True;
    Synchronize(ChangeControlAvailability);

    Self.PBStyle := pbstNormal;
    Synchronize(SetProgressBarStyle);

    Synchronize(SelectSvodDuplesFilial.EnableControls);
    Synchronize(CompareMemTableEh.EnableControls);
    Synchronize(SelectSvodDuplesOblpo.EnableControls);
  end;
end;

end.

