unit uFilterSettings;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, Vcl.ComCtrls,
  EhLibVCL, GridsEh, DBAxisGridsEh, DBGridEh, Vcl.ToolWin, Vcl.Menus,
  Vcl.StdCtrls, Data.DB, System.UITypes;

type
  TfrmFilterSettings = class(TForm)
    FilterSettingsToolBar: TToolBar;
    FilterSettingsDBGridEh: TDBGridEh;
    FilterSettingPM: TPopupMenu;
    AddPMBtn: TMenuItem;
    EditPMBtn: TMenuItem;
    DeletePMBtn: TMenuItem;
    DeleteToolBtn: TButton;
    EditToolBtn: TButton;
    AddToolBtn: TButton;
    FillSprToolBtn: TButton;
    ToolButton1: TToolButton;
    procedure AddPMBtnClick(Sender: TObject);
    procedure EditPMBtnClick(Sender: TObject);
    procedure DeletePMBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddToolBtnClick(Sender: TObject);
    procedure EditToolBtnClick(Sender: TObject);
    procedure DeleteToolBtnClick(Sender: TObject);
    procedure FillSprToolBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure RefreshSigners();
  public
    { Public declarations }
  end;

var
  frmFilterSettings: TfrmFilterSettings;

implementation

uses
  uCompDM, uAddUpdComeralSigner;

{$R *.dfm}

procedure TfrmFilterSettings.RefreshSigners();
begin
  with CompDM do
    with SelectComeralSingersQ do
    begin
      Close;
      Open;

      if not IsFilial then
      begin
        EditToolBtn.Enabled := not IsEmpty;
        DeleteToolBtn.Enabled := not IsEmpty;
        EditPMBtn.Enabled := not IsEmpty;
        DeletePMBtn.Enabled := not IsEmpty;
      end;
    end;
end;

procedure TfrmFilterSettings.AddPMBtnClick(Sender: TObject);
begin
  AddToolBtn.Click;
end;

procedure TfrmFilterSettings.AddToolBtnClick(Sender: TObject);
begin
  frmAddUpdComeralSigner := TfrmAddUpdComeralSigner.Create(Self);

  if frmAddUpdComeralSigner.ShowModal = mrOk then
    RefreshSigners;

  frmAddUpdComeralSigner.Free;
end;

procedure TfrmFilterSettings.DeletePMBtnClick(Sender: TObject);
begin
  DeleteToolBtn.Click;
end;

procedure TfrmFilterSettings.DeleteToolBtnClick(Sender: TObject);
begin
  if Application.MessageBox('    ?',
    ' ', MB_YESNO + MB_ICONQUESTION) = IDYES then
    with CompDM do
    try
      DeleteComeralSigner(SelectComeralSingersQidRecord.AsInteger);
      RefreshSigners;
    except
      on EDB: EDBOperationException do
        MessageDlg(EDB.Message, mtWarning, [mbOK], 0);
    end;
end;

procedure TfrmFilterSettings.EditPMBtnClick(Sender: TObject);
begin
  EditToolBtn.Click;
end;

procedure TfrmFilterSettings.EditToolBtnClick(Sender: TObject);
begin
  with CompDM do
    frmAddUpdComeralSigner := TfrmAddUpdComeralSigner.Create(Self,
      SelectComeralSingersQidRecord.AsInteger, SelectComeralSingersQfilial.AsInteger,
      SelectComeralSingersQfio.AsString);

  if frmAddUpdComeralSigner.ShowModal = mrOk then
    RefreshSigners;

  frmAddUpdComeralSigner.Free;
end;

procedure TfrmFilterSettings.FillSprToolBtnClick(Sender: TObject);
begin
  with CompDM do
    with SelectTmpComeralInv do
    begin
      Close;
      Open;

      First;

      while not Eof do
      begin
        if (not SelectTmpComeralInvfilial.IsNull) and (Length(SelectTmpComeralInvsignerfio.AsString) > 0) then
        try
          InsertComeralSigner(SelectTmpComeralInvfilial.AsInteger, SelectTmpComeralInvsignerfio.AsString);
        except
        end;

        Next;
      end;
    end;

  RefreshSigners;
  MessageDlg(' ', mtInformation, [mbOK], 0);
end;

procedure TfrmFilterSettings.FormCreate(Sender: TObject);
begin
  with CompDM do
  begin
    AddToolBtn.Enabled := not IsFilial;
    EditToolBtn.Enabled := not IsFilial;
    DeleteToolBtn.Enabled := not IsFilial;
    FillSprToolBtn.Enabled := not IsFilial;
    AddPMBtn.Enabled := not IsFilial;
    EditPMBtn.Enabled := not IsFilial;
    DeletePMBtn.Enabled := not IsFilial;
  end;

  RefreshSigners;
end;

end.

