unit uZeroExcludeSettings;

interface

uses
  Winapi.Windows, Winapi.Messages, System.SysUtils, System.Variants,
  System.Classes, Vcl.Graphics, Vcl.Controls, Vcl.Forms, Vcl.Dialogs,
  DBGridEhGrouping, ToolCtrlsEh, DBGridEhToolCtrls, DynVarsEh, Vcl.ComCtrls,
  EhLibVCL, GridsEh, DBAxisGridsEh, DBGridEh, Vcl.ToolWin, Vcl.Menus,
  Vcl.StdCtrls, Data.DB, System.UITypes;

type
  TfrmZeroExcludeSettings = class(TForm)
    FilterSettingsToolBar: TToolBar;
    ZeroExcludeDBGridEh: TDBGridEh;
    FilterSettingPM: TPopupMenu;
    AddPMBtn: TMenuItem;
    EditPMBtn: TMenuItem;
    DeletePMBtn: TMenuItem;
    DeleteToolBtn: TButton;
    EditToolBtn: TButton;
    AddToolBtn: TButton;
    procedure AddPMBtnClick(Sender: TObject);
    procedure EditPMBtnClick(Sender: TObject);
    procedure DeletePMBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure AddToolBtnClick(Sender: TObject);
    procedure EditToolBtnClick(Sender: TObject);
    procedure DeleteToolBtnClick(Sender: TObject);
  private
    { Private declarations }
    procedure RefreshZeroExclude;
  public
    { Public declarations }
  end;

var
  frmZeroExcludeSettings: TfrmZeroExcludeSettings;

implementation

uses
  uCompDM, uAddUpdZeroExclude;

{$R *.dfm}

procedure TfrmZeroExcludeSettings.RefreshZeroExclude;
begin
  with CompDM do
    with SelectZeroExcludeQ do
    begin
      Close;
      Open;

      if not IsFilial then
      begin
        EditToolBtn.Enabled := not IsEmpty;
        DeleteToolBtn.Enabled := not IsEmpty;
        EditPMBtn.Enabled := not IsEmpty;
        DeletePMBtn.Enabled := not IsEmpty;
      end;
    end;
end;

procedure TfrmZeroExcludeSettings.AddPMBtnClick(Sender: TObject);
begin
  AddToolBtn.Click;
end;

procedure TfrmZeroExcludeSettings.AddToolBtnClick(Sender: TObject);
begin
  frmAddUpdZeroExclude := TfrmAddUpdZeroExclude.Create(Self);

  if frmAddUpdZeroExclude.ShowModal = mrOk then
    RefreshZeroExclude;

  frmAddUpdZeroExclude.Free;
end;

procedure TfrmZeroExcludeSettings.DeletePMBtnClick(Sender: TObject);
begin
  DeleteToolBtn.Click;
end;

procedure TfrmZeroExcludeSettings.DeleteToolBtnClick(Sender: TObject);
begin
  if Application.MessageBox('    ?',
    ' ', MB_YESNO + MB_ICONQUESTION) = IDYES then
    with CompDM do
    try
      DeleteZeroExclude(SelectZeroExcludeQidRecord.AsInteger);
      RefreshZeroExclude;
    except
      on EDB: EDBOperationException do
        MessageDlg(EDB.Message, mtWarning, [mbOK], 0);
    end;
end;

procedure TfrmZeroExcludeSettings.EditPMBtnClick(Sender: TObject);
begin
  EditToolBtn.Click;
end;

procedure TfrmZeroExcludeSettings.EditToolBtnClick(Sender: TObject);
begin
  with CompDM do
    frmAddUpdZeroExclude := TfrmAddUpdZeroExclude.Create(Self,
      SelectZeroExcludeQidRecord.AsInteger, SelectZeroExcludeQfilial.AsInteger,
      SelectZeroExcludeQinvoice.AsString);

  if frmAddUpdZeroExclude.ShowModal = mrOk then
    RefreshZeroExclude;

  frmAddUpdZeroExclude.Free;
end;

procedure TfrmZeroExcludeSettings.FormCreate(Sender: TObject);
begin
  with CompDM do
  begin
    AddToolBtn.Enabled := not IsFilial;
    EditToolBtn.Enabled := not IsFilial;
    DeleteToolBtn.Enabled := not IsFilial;
    AddPMBtn.Enabled := not IsFilial;
    EditPMBtn.Enabled := not IsFilial;
    DeletePMBtn.Enabled := not IsFilial;
  end;

  RefreshZeroExclude;
end;

end.

