unit uBaseThread;

interface

uses
  System.Classes, System.UITypes, Vcl.ComCtrls, Vcl.StdCtrls, Vcl.Dialogs,
  Vcl.ExtCtrls, Vcl.Menus, DBGridEh;

type
  TBaseThread = class(TThread)
  private
    ProgressBar: TProgressBar;
    StatusBar: TStatusBar;
    TopPanel: TPanel;
    BottomPanel: TPanel;
    Grid: TDBGridEh;
  protected
    PBStyle: TProgressBarStyle;
    StatusText: string;
    Enabled: Boolean;
    DialogMessage: string;
    procedure SetProgressBarStyle;
    procedure SetStatusBarText;
    procedure ChangeControlAvailability;
    procedure ShowErrorDialog;
    procedure ShowInfoDialog;
  public
    constructor Create(CreateSuspended: Boolean; ProgressBar: TProgressBar;
      StatusBar: TStatusBar; TopPanel, BottomPanel: TPanel; Grid: TDBGridEh); overload;
  end;

implementation

// TBaseCompThread
//   

constructor TBaseThread.Create(CreateSuspended: Boolean; ProgressBar:
  TProgressBar; StatusBar: TStatusBar; TopPanel, BottomPanel: TPanel; Grid: TDBGridEh);
begin
  inherited Create(CreateSuspended);

  Self.ProgressBar := ProgressBar;
  Self.StatusBar := StatusBar;
  Self.TopPanel := TopPanel;
  Self.BottomPanel := BottomPanel;
  Self.Grid := Grid;
end;

procedure TBaseThread.ChangeControlAvailability;
begin
  //       Enabled
  Self.TopPanel.Enabled := Self.Enabled;
  Self.BottomPanel.Enabled := Self.Enabled;
  Self.Grid.Enabled := Self.Enabled;
end;

procedure TBaseThread.SetStatusBarText;
begin
  //    StatusBar
  StatusBar.SimpleText := StatusText;
end;

procedure TBaseThread.SetProgressBarStyle;
begin
  //   ProgressBar
  ProgressBar.Style := PBStyle;
end;

procedure TBaseThread.ShowErrorDialog;
begin
  //    
  MessageDlg(Self.DialogMessage, mtError, [mbOK], 0);
end;

procedure TBaseThread.ShowInfoDialog;
begin
  //    
  MessageDlg(Self.DialogMessage, mtInformation, [mbOK], 0);
end;

end.

