unit uClearTrashThread;

interface

uses
  System.Classes, uBaseThread, System.SysUtils, Vcl.ComCtrls;

type
  TClearTrashThread = class(TBaseThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

var
  ClearTrashThread: TClearTrashThread;

implementation

uses
  uSVDM;

{ TSaveComeralState }

procedure TClearTrashThread.Execute;
begin
  Self.Enabled := False;
  Synchronize(ChangeControlAvailability);

  Self.PBStyle := pbstMarquee;
  Synchronize(SetProgressBarStyle);

  Self.StatusText := '  ""';
  Synchronize(SetStatusBarText);

  with SVDM do
  try
    BuhConnection.BeginTrans;
    with qMusor do
    begin
      Close;
      Open;

      BuhConnection.CommitTrans;

      Self.DialogMessage := ' ""   .' + #10#13 +
        '   - ' + FieldByName('RowT').AsString + #10#13
        + '  . - ' + FieldByName('RowS').AsString;
      Synchronize(ShowInfoDialog);
    end
  except
    on E: exception do
    begin
      BuhConnection.RollbackTrans;
      Self.DialogMessage := '   "": ' + E.Message;
      Synchronize(ShowErrorDialog);
    end;
  end;

  Self.StatusText := ' ';
  Synchronize(SetStatusBarText);

  Self.PBStyle := pbstNormal;
  Synchronize(SetProgressBarStyle);

  Self.Enabled := True;
  Synchronize(ChangeControlAvailability);
end;

end.

