unit uCompareThread;

interface

uses
  System.Classes, uBaseThread, System.SysUtils, Vcl.ComCtrls, DBGridEh, Vcl.ExtCtrls, uAct1N;

type
  TCompareThread = class(TBaseThread)
  private
    { Private declarations }
  protected
    procedure Execute; override;
  end;

var
  CompareThread: TCompareThread;

implementation

uses
  uSVDM;

{ TSaveComeralState }

procedure TCompareThread.Execute;
begin
  Self.Enabled := False;
  Synchronize(ChangeControlAvailability);

  Self.PBStyle := pbstMarquee;
  Synchronize(SetProgressBarStyle);

  Self.StatusText := '   ...';
  Synchronize(SetStatusBarText);

  with SVDM do
  try
    if qSF.Active then
      qSF.Active := false;

    if frmAct1N.CrT then
      qDropT.ExecSQL;

    qCrT.ExecSQL;
    frmAct1N.CrT := true;

    qNPlat.Close;
    qNPlat.Parameters.ParamByName('IdPredpr').Value := frmAct1N.PredprComBox.KeyValue;
    qNPlat.Open;

    with qSFVib do
    begin
      Close;
      Parameters.ParamByName('FirstDate').Value := DateToStr(frmAct1N.FirstPicker.Date);
      Parameters.ParamByName('SecDate').Value := DateToStr(frmAct1N.SecPicker.Date);
      Parameters.ParamByName('IdPlat').Value := frmAct1N.PredprComBox.KeyValue;
      Parameters.ParamByName('NDSZero').Value := frmAct1N.ZeroNDSChB.Checked;
      Parameters.ParamByName('PrVib').Value := frmAct1N.SelectTypeRG.ItemIndex;
      Parameters.ParamByName('InclNDS').Value := frmAct1N.DiffSprAndTovChB.Checked;
      Parameters.ParamByName('IsklTara').Value := frmAct1N.RemoveTaraChB.Checked;
      Open;

      if FieldByName('Tara').IsNull then
        frmAct1N.Tara := 0
      else
        frmAct1N.Tara := FieldByName('Tara').Value;
//   qSF
    end;

    qFormItog.ExecSQL;

    Self.StatusText := ' ';
    Synchronize(SetStatusBarText);
  except
    on E: exception do
    begin
      Self.DialogMessage := '   : ' + E.Message;
      Synchronize(ShowErrorDialog);

      Self.StatusText := Self.DialogMessage;
      Synchronize(SetStatusBarText);
    end;
  end;

  Self.PBStyle := pbstNormal;
  Synchronize(SetProgressBarStyle);

  Self.Enabled := True;
  Synchronize(ChangeControlAvailability);

  Synchronize(frmAct1N.FilterOnOff);
end;

end.

