unit StatusUpdater;

interface

uses
  Forms, SysUtils, ComObj, Dialogs, Classes, ComCtrls, StdCtrls, Buttons,
  UtilUnit, XMLIntf, XMLDoc, ActiveX, System.UITypes, System.AnsiStrings;

type
  EAuthException = class(Exception);

  EConnectException = class(Exception);

type
  TConfig = record
    UNP: string;
    dopUNP: string;
    ProxyIp: string;
    ProxySocket: string;
    ProxyLogin: string;
    ProxyPassword: string;
    filetype: Byte;
  end;

  TThreadStatus = class(TThread)
  private
    StartNumber, EndNumber: Int64;
    Progress, Count, Error: integer;
    Name, Status, InvName, ErrorMessageText, Year, FilePath: string;
    EVatService, InvVatStatus: OleVariant;
    ProgressBar: TProgressBar;
    Memo: TMemo;
    GB: TGroupBox;
    Flag: Boolean;
    XMLDocument: IXMLDocument;
    config: TConfig;
    procedure SetProgress;
    procedure WriteStatus;
    procedure MessageSend;
    procedure EnableButtons;
    procedure ErrorMessage;
  protected
    procedure Execute; override;
  public
    constructor Create(CreateSuspended: Boolean; Progress: TProgressBar; Memo:
      TMemo; GB: TGroupBox; Year, FilePath: string; StartNumber, EndNumber: Int64; config: TConfig); overload;
    constructor Create(CreateSuspended: Boolean; Progress: TProgressBar; Memo:
      TMemo; GB: TGroupBox; FilePath: string; config: TConfig); overload;
  end;

implementation

var
  StausArray: array[0..9] of string[20] = ('NULL', 'IN_PROGRESS',
    'IN_PROGRESS_ERROR', 'COMPLETED', 'ON_AGREEMENT', 'COMPLETED_SIGNED',
    'CANCELLED', 'ON_AGREEMENT_CANCEL', 'NOT_FOUND', 'ERROR'); // 

constructor TThreadStatus.Create(CreateSuspended: Boolean; Progress:
  TProgressBar; Memo: TMemo; GB: TGroupBox; Year, FilePath: string; StartNumber,
  EndNumber: Int64; config: TConfig);
begin
  inherited Create(CreateSuspended);

  Self.ProgressBar := Progress;
  Self.Memo := Memo;
  Self.GB := GB;
  Self.Year := Year;
  Self.FilePath := FilePath;
  Self.StartNumber := StartNumber;
  Self.EndNumber := EndNumber;
  Self.config := config;

  XMLDocument := TXMLDocument.Create(Application);
end;

constructor TThreadStatus.Create(CreateSuspended: Boolean; Progress:
  TProgressBar; Memo: TMemo; GB: TGroupBox; FilePath: string; config: TConfig);
begin
  inherited Create(CreateSuspended);

  Self.ProgressBar := Progress;
  Self.Memo := Memo;
  Self.GB := GB;
  Self.FilePath := FilePath;
  Self.config := config;

  XMLDocument := TXMLDocument.Create(Application);
end;

function GetStatusId(Status: string): Byte; //   
begin
  Result := IndexStr(Status, ['IN_PROGRESS', 'IN_PROGRESS_ERROR', 'COMPLETED',
    'ON_AGREEMENT', 'COMPLETED_SIGNED', 'CANCELLED', 'ON_AGREEMENT_CANCEL', 'NOT_FOUND', 'ERROR']) + 1;
end;

procedure TThreadStatus.SetProgress;
begin
  ProgressBar.Position := Progress;
end;

procedure TThreadStatus.WriteStatus;
begin
  Memo.Lines.Add(Name + ' - ' + Status);
end;

procedure TThreadStatus.ErrorMessage;
begin
  MessageDlg(ErrorMessageText, mtInformation, [mbOK], 0);
end;

procedure TThreadStatus.MessageSend;
begin
  MessageDlg('  .  : ' + IntToStr(Count
    - Error) + '  ' + IntToStr(Count), mtInformation, [mbOK], 0);
end;

procedure TThreadStatus.EnableButtons; //   
begin
  GB.Enabled := Flag;
end;

procedure TThreadStatus.Execute; //     EInvVatService
var
  res, err: Integer;
  i: int64;
  indi, indj: Integer;
  IListSenders, IListInvoices: IXMLNodeList;
  INodeSenders, INodeInvoices: IXMLNode;
begin
  err := 0;
  Flag := False;
  Synchronize(EnableButtons);
  CoInitialize(nil);

  try
    try
      EVatService := CreateOleObject('EInvVatService.Connector');

      if EVatService.Login['', 0] <> 0 then
        raise EAuthException.Create('    .');

      if (Length(Trim(config.ProxyIp)) <> 0) and (Length(Trim(config.ProxySocket)) <> 0) then
        EVatService.SetProxy[config.ProxyIp, config.ProxySocket, config.ProxyLogin,
          config.ProxyPassword, '1'];

      if EVatService.Connect['https://ws.vat.gov.by/InvoicesWS/services/InvoicesPort'] <> 0 then
        raise EConnectException.Create('    .');

      case Self.config.filetype of
        0:
          begin
            ProgressBar.Max := EndNumber - StartNumber + 1;
            i := StartNumber;

            with XMLDocument do
            begin
              XML.Clear;
              Active := True;
              Version := '1.0';
              Options := XMLDocument.Options + [doNodeAutoIndent];

              with AddChild('root') do
              begin
                with AddChild('invoices') do
                begin
                  with AddChild('sender') do
                  begin
                    Attributes['senderunn'] := Self.config.UNP;
                    Attributes['senderdopunn'] := Self.config.dopUNP;

                    while i <= EndNumber do
                    begin
                      Progress := i - StartNumber + 1;
                      Synchronize(Setprogress);

                      InvName := Self.config.UNP + '-' + Year + '-' + IntToStrWithZeros(i, 10);

                      InvVatStatus := EVatService.GetStatus[InvName];
                      try
                        res := InvVatStatus.Verify;
                        if res <> 0 then
                        begin
                          ErrorMessageText := EVatService.LastError;
                          Synchronize(ErrorMessage);
                          Break;
                        end
                        else
                        begin
                          Name := InvName;
                          Status := InvVatStatus.status;
                          Synchronize(WriteStatus);

                          with AddChild('invoice') do
                          begin
                            Attributes['compilingYear'] := Self.Year;
                            Attributes['number'] := IntToStrWithZeros(i, 10);
                            Attributes['invstatus'] := GetStatusId(Status);
                            Attributes['statusdate'] := DateTimeToStr(Now());
                          end;

                        end;
                      except
                        on EAccessViolation do
                          Inc(err);
                      end;
                      Inc(i);
                    end;
                  end;
                end;
              end;

              XML.SaveToFile(FilePath);
              XML.Clear;
            end;
          end;
        1:
          begin
            XMLDocument.XML.Clear;
            XMLDocument.FileName := FilePath;
            XMLDocument.Active := True;

            with XMLDocument.DocumentElement do
            begin
              IListSenders := ChildNodes['invoices'].ChildNodes;
              ProgressBar.Max := IListSenders.Count - 1;

              for indi := 0 to IListSenders.Count - 1 do
              begin
                if IListSenders[indi].NodeName = 'sender' then
                begin
                  INodeSenders := IListSenders[indi];
                  IListInvoices := INodeSenders.ChildNodes;

                  for indj := 0 to IListInvoices.Count - 1 do
                  begin
                    if IListInvoices[indj].NodeName = 'invoice' then
                    begin
                      INodeInvoices := IListInvoices[indj];

                      InvName := INodeSenders.Attributes['senderunn'] + '-' +
                        INodeInvoices.Attributes['compilingYear'] + '-' +
                        IntToStrWithZeros(INodeInvoices.Attributes['number'], 10);
                      InvVatStatus := EVatService.GetStatus[InvName];

                      try
                        res := InvVatStatus.Verify;
                        if res <> 0 then
                        begin
                          ErrorMessageText := EVatService.LastError;
                          Synchronize(ErrorMessage);
                          Break;
                        end
                        else
                        begin
                          Name := InvName;
                          Status := InvVatStatus.status;
                          Synchronize(WriteStatus);

                          INodeInvoices.Attributes['invstatus'] := GetStatusId(Status);
                          INodeInvoices.Attributes['statusdate'] := DateTimeToStr(Now());
                        end;
                      except
                        on EAccessViolation do
                          Inc(err);
                      end;
                    end;
                  end;
                end;

                Progress := indi;
                Synchronize(Setprogress);
              end;
            end;

            XMLDocument.XML.SaveToFile(FilePath);
            XMLDocument.XML.Clear;
          end;
      end;
    except
      on e: Exception do
      begin
        ErrorMessageText := e.Message;
        Synchronize(ErrorMessage);
      end;
    end;
  finally
    CoUninitialize;
  end;

  Flag := True;
  Synchronize(EnableButtons);
  Count := ProgressBar.Max;
  Error := err;
  Synchronize(MessageSend);
end;

end.

