unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ComCtrls, IniFiles, StatusUpdater, DateUtils,
  System.UITypes;

type
  TfrmMain = class(TForm)
    ResultMemo: TMemo;
    SettingsGB: TGroupBox;
    ProgressBar1: TProgressBar;
    UNPEdit: TEdit;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    StartNum: TEdit;
    Label4: TLabel;
    EndNum: TEdit;
    UpdateNumberBtn: TBitBtn;
    XMLSave: TSaveDialog;
    YearCB: TComboBox;
    UpdateFileBtn: TBitBtn;
    XMLOpen: TOpenDialog;
    procedure UpdateNumberBtnClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure UpdateFileBtnClick(Sender: TObject);
  private
    { Private declarations }
    config : TConfig;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;

implementation

{$R *.dfm}

procedure TfrmMain.UpdateNumberBtnClick(Sender: TObject);
var ThreadStatus: TThreadStatus;
begin
  if StrToInt64(StartNum.Text)>StrToInt64(EndNum.Text) then
  begin
    MessageDlg('      .',mtWarning, [mbOK],0);
    Exit;
  end;

  if not XMLSave.Execute then
  begin
    MessageDlg('   .',mtWarning, [mbOK],0);
    Exit;
  end;

  Self.config.filetype := 0;
  ResultMemo.Clear;
  ThreadStatus:=TThreadStatus.Create(true,ProgressBar1,ResultMemo,SettingsGB,
                                     YearCB.Text, XMLSave.FileName, StrToInt64(StartNum.Text),
                                     StrToInt64(EndNum.Text), Self.config);
  ThreadStatus.FreeOnTerminate:=true;
  ThreadStatus.Priority:=tpNormal;
  ThreadStatus.Start;
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var Ini: Tinifile;
    CurrYear : Word;
begin
  Ini:=TiniFile.Create(extractfilepath(paramstr(0))+'Config.ini');
  XMLSave.InitialDir :=Ini.ReadString('Path','Path','');
  XMLSave.FileName :=DateToStr(Now());
  XMLOpen.InitialDir := XMLSave.InitialDir;
  XMLOpen.FileName := XMLSave.FileName;
  config.ProxyIp:=Ini.ReadString('Proxy','Ip','');
  config.ProxySocket:=Ini.ReadString('Proxy','Socket','');
  config.ProxyLogin:=Ini.ReadString('Proxy','Login','');
  config.ProxyPassword:=Ini.ReadString('Proxy','Password','');
  config.UNP:=Ini.ReadString('Predpr','UNN','');
  config.dopUNP:=Ini.ReadString('Predpr','dopUNN','');
  StartNum.Text := Ini.ReadString('Numbers','Start','');
  Ini.Free;

  EndNum.Text := StartNum.Text;
  UNPEdit.Text := config.UNP;
  CurrYear := YearOf(Now());

  YearCB.Clear;
  YearCB.Items.Add(IntToStr(CurrYear-1));
  YearCB.Items.Add(IntToStr(CurrYear));
  YearCB.ItemIndex := 1;
end;

procedure TfrmMain.UpdateFileBtnClick(Sender: TObject);
var ThreadStatus: TThreadStatus;
begin
  if not XMLOpen.Execute then
  begin
    MessageDlg('   .',mtWarning, [mbOK],0);
    Exit;
  end;

  Self.config.filetype := 1;
  ResultMemo.Clear;
  ThreadStatus:=TThreadStatus.Create(true,ProgressBar1,ResultMemo,SettingsGB,
                                     XMLOpen.FileName, Self.config);
  ThreadStatus.FreeOnTerminate:=true;
  ThreadStatus.Priority:=tpNormal;
  ThreadStatus.Start;
end;

end.
