unit uMain;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, xmldom, XMLIntf, msxmldom, XMLDoc, DB, ADODB, Grids,
  DBGrids, ComCtrls, ShellApi, Menus, CLIPBrd, Buttons, System.Types,
  Vcl.ExtCtrls, System.AnsiStrings, System.UITypes, Vcl.ImgList;

type
  TfrmMain = class(TForm)
    LogLB: TListBox;
    MDBConnection: TADOConnection;
    InvoiceXMLDocument: TXMLDocument;
    SelectVariousPredprs: TADOQuery;
    ParseInvoicesBtn: TButton;
    ConsignorsInsert: TADOQuery;
    ConsigneesInsert: TADOQuery;
    DocumentsInsert: TADOQuery;
    InvoicesInsert: TADOQuery;
    RosterInsert: TADOQuery;
    DescriptionsInsert: TADOQuery;
    MainProgressBar: TProgressBar;
    GetInvoicesBtn: TButton;
    DelZero: TADOQuery;
    Check: TADOQuery;
    DocCheck: TADOQuery;
    FindSkl: TADOQuery;
    FindOriginal: TADOQuery;
    UpdateOldGB: TGroupBox;
    UpdateOldFiles: TButton;
    UpdateSendingFiles: TButton;
    EnableUpdateOldCB: TCheckBox;
    UpdateOldInDBCB: TCheckBox;
    DeleteInvoice: TADOQuery;
    ListPopup: TPopupMenu;
    N1: TMenuItem;
    N2: TMenuItem;
    SearchEdit: TEdit;
    SelNastr: TADOQuery;
    SelNastrUNN: TStringField;
    SelPredprByUnn: TADOQuery;
    SelPredprByUnnidPredpr: TAutoIncField;
    UpdateAsComplete: TADOQuery;
    ButtonsImageList_24: TImageList;
    SearchOrganizationBtn: TButton;
    ButtonsImageList_16: TImageList;
    SearchBtn: TButton;
    SortBtn: TButton;
    CopyErrorsBtn: TButton;
    procedure FormCreate(Sender: TObject);
    procedure ParseInvoicesBtnClick(Sender: TObject);
    procedure GetInvoicesBtnClick(Sender: TObject);
    procedure UpdateOldFilesClick(Sender: TObject);
    procedure UpdateSendingFilesClick(Sender: TObject);
    procedure EnableUpdateOldCBClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure ListPopupPopup(Sender: TObject);
    procedure LogLBMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure N2Click(Sender: TObject);
    procedure SearchEditKeyPress(Sender: TObject; var Key: Char);
    procedure SearchBtnClick(Sender: TObject);
    procedure SortBtnClick(Sender: TObject);
    procedure SearchOrganizationBtnClick(Sender: TObject);
    procedure CopyErrorsBtnClick(Sender: TObject);
  private
    { Private declarations }
    path: string;

    procedure FindFileInFolder(path, ext: string; update : Boolean);
    function Recycle(FileName: string): Boolean;
    function GetDescriptionIndex(value: string): Byte;
    function GetProviderStatusIndex(value: string): Byte;
    function GetRecipientStatusIndex(value: string): Byte;
    function GetDocumentTypeIndex(value: string): Byte;
    function GetRateTypeIndex(value: string): Byte;
  public
    { Public declarations }
  end;

var
  frmMain: TfrmMain;


implementation

{$R *.dfm}

function TfrmMain.GetDescriptionIndex(value: string): Byte;
begin
  Result := IndexStr(value, ['DEDUCTION_IN_FULL', 'VAT_EXEMPTION', 'OUTSIDE_RB',
                             'IMPORT_VAT', 'EXCISE_MARK', 'CONTROL_MARK',
                             'CUSTOMS_EXCISE', 'IDENTIFIED_MARK',
                             'ANALYZED_DEAL'])+1;
end;

function TfrmMain.GetProviderStatusIndex(value: string): Byte;
begin
  Result := IndexStr(value, ['SELLER', 'CONSIGNOR', 'COMMISSIONAIRE',
                             'TRUSTEE', 'TAX_DEDUCTION_PAYER',
                             'FOREIGN_ORGANIZATION', 'AGENT', 'DEVELOPER'])+1;
end;

function TfrmMain.GetRecipientStatusIndex(value: string): Byte;
begin
  Result := IndexStr(value, ['CUSTOMER', 'CONSIGNOR', 'COMMISSIONAIRE',
                             'CONSUMER', 'TAX_DEDUCTION_RECIPIENT',
                             'FOREIGN_ORGANIZATION_BUYER'])+1;
end;

function TfrmMain.GetDocumentTypeIndex(value: string): Byte;
begin
  Result := IndexStr(value, ['ORIGINAL', 'ADDITIONAL', 'FIXED',
                             'ADD_NO_REFERENCE'])+1;
end;

function TfrmMain.GetRateTypeIndex(value: string): Byte;
begin
  Result := IndexStr(value, ['DECIMAL', 'ZERO', 'NO_VAT', 'CALCULATED'])+1;
end;

function TfrmMain.Recycle(FileName: string): Boolean; //   
var FileOp: TSHFileOpStruct;
begin
  FillChar(FileOp, SizeOf(FileOp), 0);
  FileOp.Wnd := Application.Handle;
  FileOp.wFunc := FO_DELETE;
  FileOp.pFrom := PChar(FileName);
  FileOp.fFlags := FOF_NOERRORUI or FOF_NOCONFIRMATION;
  FileOp.fAnyOperationsAborted:=true;
  Result := (SHFileOperation(FileOp) = 0);
end;

procedure TfrmMain.FindFileInFolder(path, ext: string; update : Boolean);
Var SR : TSearchRec;
    Res : Integer;
begin
  Res := FindFirst(path+ext, faAnyFile, SR);
  while Res = 0 do
  begin
    if update then LogLB.Items.Add(Sr.Name)
    else LogLB.Items.Add(path+Sr.Name);
    Res := FindNext(SR);
  end;
  FindClose(SR);
end;

procedure TfrmMain.FormCreate(Sender: TObject);
var F: TextFile;
    conn: String;
begin
  if not FileExists('MdbConnect.ini') then
  begin
    ShowMessage('  MdbConnect.ini');
    Application.Terminate;
    Exit;
  end;

  AssignFile(F, ExtractFilePath(Application.ExeName)+'MdbConnect.ini');
  Reset(F);
  Readln(F,conn);
  Readln(F,path);
  CloseFile(F);

  MDBConnection.ConnectionString := conn;
  MDBConnection.Open;

  SelNastr.Close;
  SelNastr.Open;

  if (SelNastrUNN.AsString = '600037767') then
    GetInvoicesBtn.Enabled := False
  else
    GetInvoicesBtn.Enabled := True;

  DelZero.ExecSQL;
end;

procedure TfrmMain.ParseInvoicesBtnClick(Sender: TObject);
var i, j, keypar, key : Integer;
    param: TCollectionItem;
    {IListConsignor, IListConsignee,} IListDoc, IListRost, IListDesc : IXMLNodeList;
    {INodeConsignor, INodeConsignee,} INodeDoc, INodeRost, INodeDesc : IXMLNode;
    idPredpr, compilingYear, number, err, dopUNN : string;
    Find : Boolean;
begin
  LogLB.Clear;
  FindFileInFolder(path, '*.xml',False);
  MainProgressBar.Position:=0;

  if LogLB.Count=0 then
  begin
    MessageDlg('   .', mtWarning, [mbOk], 0);
    Exit;
  end;

  MainProgressBar.Max:=LogLB.Count-1;

  for key:=0 to LogLB.Count-1 do
  begin
    InvoiceXMLDocument.FileName:=LogLB.Items[key];
    MainProgressBar.Position:=key;

    //======================================= invoices  ======================================================
    InvoiceXMLDocument.Active:=True;
    idPredpr:=InvoiceXMLDocument.DocumentElement.Attributes['sender'];

    try
      with InvoiceXMLDocument.DocumentElement do
      begin
        for keypar:=0 to InvoicesInsert.Parameters.Count-1 do
          InvoicesInsert.Parameters.Items[keypar].Value:=NULL;

        for keypar:=0 to RosterInsert.Parameters.Count-1 do
          RosterInsert.Parameters.Items[keypar].Value:=NULL;

        for keypar:=0 to DocumentsInsert.Parameters.Count-1 do
          DocumentsInsert.Parameters.Items[keypar].Value:=NULL;

        if ChildNodes['general'].ChildNodes['documentType'].Text='ADDITIONAL' then
        begin
          SelectVariousPredprs.Close;
          SelectVariousPredprs.SQL.Clear;
          SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');
          SelectVariousPredprs.SQL.Add('where (idPredpr=idPlat or idPlat is NULL) and UNN='+QuotedStr(idPredpr));
          SelectVariousPredprs.Open;
          Find:=False;

          if not SelectVariousPredprs.IsEmpty then
          begin
            SelectVariousPredprs.First;
            while not SelectVariousPredprs.Eof do
            begin
              FindOriginal.Close;
              FindOriginal.Parameters.ParamByName('idSender').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
              FindOriginal.Parameters.ParamByName('compilingYear').Value:=Copy(ChildNodes['general'].ChildNodes['invoice'].Text,11,4);
              FindOriginal.Parameters.ParamByName('number').Value:=Copy(ChildNodes['general'].ChildNodes['invoice'].Text,16,10);
              FindOriginal.Open;

              if not FindOriginal.IsEmpty then
              begin
                Find:=True;
                Break;
              end;

              SelectVariousPredprs.Next;
            end;
          end;

          if (not Find) then
          begin
            LogLB.Items[key]:=InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text+
                              ' -     - '+ChildNodes['general'].ChildNodes['invoice'].Text;
            LogLB.ItemIndex := key;
            Continue;
          end;
        end
        else
        begin
          SelectVariousPredprs.Close;
          SelectVariousPredprs.SQL.Clear;
          SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');

          if (not ChildNodes['provider'].ChildNodes['branchCode'].HasChildNodes) or (ChildNodes['provider'].ChildNodes['branchCode'].Text='') then
            SelectVariousPredprs.SQL.Add('where (idPredpr=idPlat or idPlat is NULL) and (DopUNN=1 or DopUNN is NULL) and UNN='+QuotedStr(idPredpr))
          else
            SelectVariousPredprs.SQL.Add('where (idPredpr=idPlat or idPlat is NULL) and DopUNN='+ChildNodes['provider'].ChildNodes['branchCode'].Text+' and UNN='+QuotedStr(idPredpr));

          SelectVariousPredprs.Open;
        end;

        if SelectVariousPredprs.IsEmpty then
        begin
          if (not ChildNodes['provider'].ChildNodes['branchCode'].HasChildNodes) then dopUNN:=''
          else dopUNN:=ChildNodes['provider'].ChildNodes['branchCode'].Text;

          LogLB.Items[key]:=InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text+
                            ' -      - '+ChildNodes['provider'].ChildNodes['unp'].Text+' -  ( ) - '+dopUNN;
          LogLB.ItemIndex := key;
          Continue;
        end
        else InvoicesInsert.Parameters.ParamByName('idProvider').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;

        compilingYear:=Copy(ChildNodes['general'].ChildNodes['number'].Text,11,4);
        number:=Copy(ChildNodes['general'].ChildNodes['number'].Text,16,10);

        err:='';
        err:=SelectVariousPredprs.FieldByName('idPredpr').AsString;

        if UpdateOldInDBCB.Checked then
        begin
          DeleteInvoice.Parameters.ParamByName('idSender').Value := SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
          DeleteInvoice.Parameters.ParamByName('compilingYear').Value := compilingYear;
          DeleteInvoice.Parameters.ParamByName('number').Value := number;
          DeleteInvoice.ExecSQL;
        end;

        InvoicesInsert.Parameters.ParamByName('idSender').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
        InvoicesInsert.Parameters.ParamByName('compilingYear').Value:=compilingYear;
        InvoicesInsert.Parameters.ParamByName('number').Value:=number;
        InvoicesInsert.Parameters.ParamByName('invoice').Value:=ChildNodes['general'].ChildNodes['invoice'].Text;
        if ChildNodes['general'].ChildNodes['dateCancelled'].HasChildNodes then
          InvoicesInsert.Parameters.ParamByName('dateCancelled').Value:=ChildNodes['general'].ChildNodes['dateCancelled'].Text;
        InvoicesInsert.Parameters.ParamByName('documentType').Value := GetDocumentTypeIndex(ChildNodes['general'].ChildNodes['documentType'].Text);
        InvoicesInsert.Parameters.ParamByName('dateTransaction').Value:=Copy(ChildNodes['general'].ChildNodes['dateTransaction'].Text,1,10);

        if ChildNodes['general'].ChildNodes['documentType'].Text<>'ADDITIONAL' then
        begin
          with ChildNodes['deliveryCondition'].ChildNodes['contract'] do
          if (not ChildNodes['documents'].HasChildNodes)
              or ((ChildNodes['documents'].ChildNodes['document'].ChildNodes['docType'].ChildNodes['code'].Text='600')
                  and (Length(ChildNodes['documents'].ChildNodes['document'].ChildNodes['number'].Text)=0)) then
          Begin
            LogLB.Items[key]:='  - '+InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text+' -    .';
            LogLB.ItemIndex := key;
            Continue;
          end;

          //    
          with ChildNodes['provider'] do
          begin
            InvoicesInsert.Parameters.ParamByName('providerStatus').Value := GetProviderStatusIndex(ChildNodes['providerStatus'].Text);

            if ChildNodes['specialDealGoods'].Text='true' then InvoicesInsert.Parameters.ParamByName('specialDealGoods').Value:=1
            else InvoicesInsert.Parameters.ParamByName('specialDealGoods').Value:=0;

            if ChildNodes['principal'].HasChildNodes then
            begin
              SelPredprByUnn.Close;
              SelPredprByUnn.Parameters.ParamByName('UNN').Value := QuotedStr(Copy(ChildNodes['principal'].ChildNodes['number'].Text,1,9));
              SelPredprByUnn.Open;

              if SelPredprByUnn.IsEmpty then
                InvoicesInsert.Parameters.ParamByName('principalId').Value := null
              else
                InvoicesInsert.Parameters.ParamByName('principalId').Value := SelPredprByUnnidPredpr.AsInteger;

              InvoicesInsert.Parameters.ParamByName('principalYear').Value := Copy(ChildNodes['principal'].ChildNodes['number'].Text,11,4);
              InvoicesInsert.Parameters.ParamByName('principalNumber').Value := Copy(ChildNodes['principal'].ChildNodes['number'].Text,16,10);

              if ChildNodes['principal'].ChildNodes['date'].HasChildNodes then
                InvoicesInsert.Parameters.ParamByName('principalDate').Value:=ChildNodes['principal'].ChildNodes['date'].Text;
            end;

            if ChildNodes['vendor'].HasChildNodes then
            begin
              SelPredprByUnn.Close;
              SelPredprByUnn.Parameters.ParamByName('UNN').Value := QuotedStr(Copy(ChildNodes['vendor'].ChildNodes['number'].Text,1,9));
              SelPredprByUnn.Open;

              if SelPredprByUnn.IsEmpty then
                InvoicesInsert.Parameters.ParamByName('vendorId').Value:=null
              else
                InvoicesInsert.Parameters.ParamByName('vendorId').Value := SelPredprByUnnidPredpr.AsInteger;

              InvoicesInsert.Parameters.ParamByName('vendorYear').Value := Copy(ChildNodes['vendor'].ChildNodes['number'].Text,11,4);
              InvoicesInsert.Parameters.ParamByName('vendorNumber').Value := Copy(ChildNodes['vendor'].ChildNodes['number'].Text,16,10);

              if ChildNodes['vendor'].ChildNodes['date'].HasChildNodes then
                InvoicesInsert.Parameters.ParamByName('vendorDate').Value:=ChildNodes['vendor'].ChildNodes['date'].Text;
            end;

            if ChildNodes['declaration'].HasChildNodes then
              InvoicesInsert.Parameters.ParamByName('pDeclaration').Value:=ChildNodes['declaration'].Text;
            if ChildNodes['dateRelease'].HasChildNodes then
              InvoicesInsert.Parameters.ParamByName('dateRelease').Value:=ChildNodes['dateRelease'].Text;
            if ChildNodes['dateActualExport'].HasChildNodes then
              InvoicesInsert.Parameters.ParamByName('dateActualExport').Value:=ChildNodes['dateActualExport'].Text;

            if ChildNodes['taxes'].HasChildNodes then
            begin
              InvoicesInsert.Parameters.ParamByName('pTaxesNumber').Value:=ChildNodes['taxes'].ChildNodes['number'].Text;

              if ChildNodes['taxes'].ChildNodes['date'].HasChildNodes then
                InvoicesInsert.Parameters.ParamByName('pTaxesDate').Value:=ChildNodes['taxes'].ChildNodes['date'].Text;
            end;
          end;

          //    
          with ChildNodes['recipient'] do
          begin
            //       = 8000
            if (SelNastrUNN.AsString = '600037767') or (SelNastrUNN.AsString = '391855888') then
              dopUNN := '8000'
            else
              dopUNN := '1';

            SelectVariousPredprs.Close;
            SelectVariousPredprs.SQL.Clear;
            SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');

            if (not ChildNodes['branchCode'].HasChildNodes) or (ChildNodes['branchCode'].Text='') then
              SelectVariousPredprs.SQL.Add('where (idPredpr=idPlat or idPlat is NULL) and (DopUNN='+dopUNN+' or DopUNN is NULL) and UNN='+QuotedStr(ChildNodes['unp'].Text))
            else
              SelectVariousPredprs.SQL.Add('where (idPredpr=idPlat or idPlat is NULL) and DopUNN='+ChildNodes['branchCode'].Text+' and UNN='+QuotedStr(ChildNodes['unp'].Text));

            SelectVariousPredprs.Open;

            if SelectVariousPredprs.IsEmpty then
            begin
              if (not ChildNodes['branchCode'].HasChildNodes) then dopUNN:=''
              else dopUNN:=ChildNodes['branchCode'].Text;

              LogLB.Items[key]:=InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text+
                                ' -      - '+ChildNodes['unp'].Text+' -  ( ) - '+dopUNN;
              LogLB.ItemIndex := key;
              Continue;
            end
            else InvoicesInsert.Parameters.ParamByName('idRecipient').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;

            InvoicesInsert.Parameters.ParamByName('recipientStatus').Value := GetRecipientStatusIndex(ChildNodes['recipientStatus'].Text);

            if ChildNodes['declaration'].HasChildNodes then InvoicesInsert.Parameters.ParamByName('rDeclaration').Value:=ChildNodes['declaration'].Text;

            if ChildNodes['taxes'].HasChildNodes then
            begin
              InvoicesInsert.Parameters.ParamByName('rTaxesNumber').Value:=ChildNodes['taxes'].ChildNodes['number'].Text;
              if ChildNodes['taxes'].ChildNodes['date'].HasChildNodes then InvoicesInsert.Parameters.ParamByName('rTaxesDate').Value:=ChildNodes['taxes'].ChildNodes['date'].Text;
            end;

            if ChildNodes['dateImport'].HasChildNodes then InvoicesInsert.Parameters.ParamByName('dateImport').Value:=ChildNodes['dateImport'].Text;
          end;

          with ChildNodes['deliveryCondition'].ChildNodes['contract'] do
          begin
            InvoicesInsert.Parameters.ParamByName('contractNumber').Value:=Trim(ChildNodes['number'].Text);
            if ChildNodes['date'].HasChildNodes then InvoicesInsert.Parameters.ParamByName('contractDate').Value:=Copy(Trim(ChildNodes['date'].Text),1,10);;
          end;

          if ChildNodes['deliveryCondition'].ChildNodes['description'].HasChildNodes then InvoicesInsert.Parameters.ParamByName('description').Value:=ChildNodes['deliveryCondition'].ChildNodes['description'].Text;
        end;

        InvoicesInsert.Parameters.ParamByName('totalCostVat').Value:=StringReplace(ChildNodes['roster'].Attributes['totalCostVat'],'.',',',[rfReplaceAll]);
        InvoicesInsert.Parameters.ParamByName('totalExcise').Value:=StringReplace(ChildNodes['roster'].Attributes['totalExcise'],'.',',',[rfReplaceAll]);
        InvoicesInsert.Parameters.ParamByName('totalVat').Value:=StringReplace(ChildNodes['roster'].Attributes['totalVat'],'.',',',[rfReplaceAll]);
        InvoicesInsert.Parameters.ParamByName('totalCost').Value:=StringReplace(ChildNodes['roster'].Attributes['totalCost'],'.',',',[rfReplaceAll]); 

        InvoicesInsert.ExecSQL;
        {
  //======================================= consignors  ======================================================
        IListConsignor := ChildNodes['senderReceiver'].ChildNodes['consignors'].ChildNodes;
        for i := 0 to IListConsignor.Count - 1 do
         if IListConsignor[i].NodeName = 'consignor' then
          begin 
            INodeConsignor:=IListConsignor[i];
            SelectVariousPredprs.Close;
            SelectVariousPredprs.SQL.Clear;
            SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');
            SelectVariousPredprs.SQL.Add('where UNN='+INodeConsignor.ChildNodes['unp'].Text);
            SelectVariousPredprs.Open;

            ConsignorsInsert.Parameters.ParamByName('idSender').Value:=InvoicesInsert.Parameters.ParamByName('idSender').Value;
            ConsignorsInsert.Parameters.ParamByName('compilingYear').Value:=InvoicesInsert.Parameters.ParamByName('compilingYear').Value;
            ConsignorsInsert.Parameters.ParamByName('number').Value:=InvoicesInsert.Parameters.ParamByName('number').Value;
            ConsignorsInsert.Parameters.ParamByName('idPredpr').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
            ConsignorsInsert.ExecSQL;
          end;

   //======================================= consignees ======================================================
        IListConsignee := ChildNodes['senderReceiver'].ChildNodes['consignees'].ChildNodes;
         for i := 0 to IListConsignee.Count - 1 do
          if IListConsignee[i].NodeName = 'consignee' then
           begin
            INodeConsignee:=IListConsignee[i];
            SelectVariousPredprs.Close;
            SelectVariousPredprs.SQL.Clear;
            SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');
            SelectVariousPredprs.SQL.Add('where UNN='+INodeConsignee.ChildNodes['unp'].Text);
            SelectVariousPredprs.Open;

            ConsigneesInsert.Parameters.ParamByName('idSender').Value:=InvoicesInsert.Parameters.ParamByName('idSender').Value;
            ConsigneesInsert.Parameters.ParamByName('compilingYear').Value:=InvoicesInsert.Parameters.ParamByName('compilingYear').Value;
            ConsigneesInsert.Parameters.ParamByName('number').Value:=InvoicesInsert.Parameters.ParamByName('number').Value;
            ConsigneesInsert.Parameters.ParamByName('idPredpr').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
            ConsigneesInsert.ExecSQL;
           end;
           }

    //======================================= roster ==========================================================
        IListRost := ChildNodes['roster'].ChildNodes;

        for i := 0 to IListRost.Count - 1 do
          if IListRost[i].NodeName = 'rosterItem' then
          begin
            INodeRost:=IListRost[i];

            RosterInsert.Close;
            RosterInsert.Parameters.ParamByName('idSender').Value:=InvoicesInsert.Parameters.ParamByName('idSender').Value;
            RosterInsert.Parameters.ParamByName('compilingYear').Value:=InvoicesInsert.Parameters.ParamByName('compilingYear').Value;
            RosterInsert.Parameters.ParamByName('number').Value:=InvoicesInsert.Parameters.ParamByName('number').Value;
            RosterInsert.Parameters.ParamByName('pnt').Value:=null;

            if INodeRost.ChildNodes['number'].HasChildNodes then RosterInsert.Parameters.ParamByName('itemNumber').Value:=INodeRost.ChildNodes['number'].Text;

            RosterInsert.Parameters.ParamByName('[name]').Value:=Trim(INodeRost.ChildNodes['name'].Text);
            RosterInsert.Parameters.ParamByName('code').Value:=INodeRost.ChildNodes['code'].Text;
            RosterInsert.Parameters.ParamByName('code_oced').Value:=INodeRost.ChildNodes['code_oced'].Text;
            RosterInsert.Parameters.ParamByName('units').Value:=null;
            if INodeRost.ChildNodes['count'].HasChildNodes then RosterInsert.Parameters.ParamByName('[count]').Value:=StringReplace(INodeRost.ChildNodes['count'].Text,'.',',',[rfReplaceAll]);
            if INodeRost.ChildNodes['price'].HasChildNodes then RosterInsert.Parameters.ParamByName('price').Value:=StringReplace(INodeRost.ChildNodes['price'].Text,'.',',',[rfReplaceAll]);
            RosterInsert.Parameters.ParamByName('cost').Value:=StringReplace(INodeRost.ChildNodes['cost'].Text,'.',',',[rfReplaceAll]);
            if INodeRost.ChildNodes['summaExcise'].HasChildNodes then RosterInsert.Parameters.ParamByName('summaExcise').Value:=StringReplace(INodeRost.ChildNodes['summaExcise'].Text,'.',',',[rfReplaceAll]);
            RosterInsert.Parameters.ParamByName('rate').Value:=StringReplace(INodeRost.ChildNodes['vat'].ChildNodes['rate'].Text,'.',',',[rfReplaceAll]);
            RosterInsert.Parameters.ParamByName('idRateType').Value:=GetRateTypeIndex(INodeRost.ChildNodes['vat'].ChildNodes['rateType'].Text);
            RosterInsert.Parameters.ParamByName('summaVat').Value:=StringReplace(INodeRost.ChildNodes['vat'].ChildNodes['summaVat'].Text,'.',',',[rfReplaceAll]);
            RosterInsert.Parameters.ParamByName('costVat').Value:=StringReplace(INodeRost.ChildNodes['costVat'].Text,'.',',',[rfReplaceAll]);
            RosterInsert.Open;

            if INodeRost.ChildNodes['descriptions'].HasChildNodes then
            begin
              IListDesc := INodeRost.ChildNodes['descriptions'].ChildNodes;
              for j := 0 to IListDesc.Count - 1 do
                if IListDesc[j].NodeName = 'description' then
                begin
                  INodeDesc:= IListDesc[j];
                  DescriptionsInsert.Parameters.ParamByName('idDesc').Value:= GetDescriptionIndex(INodeDesc.Text);
                  DescriptionsInsert.Parameters.ParamByName('idStr').Value:=RosterInsert.FieldByName('IdentValue').AsInteger;
                  DescriptionsInsert.ExecSQL;
                end;
            end;
          end;

   //======================================= documents  ======================================================
        DocCheck.Close;
        DocCheck.Parameters.ParamByName('idSen').Value:=err;
        DocCheck.Parameters.ParamByName('Year').Value:=compilingYear;
        DocCheck.Parameters.ParamByName('numb').Value:=number;//strtoint64(number);
        DocCheck.Open;

        if (DocCheck.IsEmpty) and (ChildNodes['general'].ChildNodes['documentType'].Text<>'ADDITIONAL') then
        begin
          IListDoc := ChildNodes['deliveryCondition'].ChildNodes['contract'].ChildNodes['documents'].ChildNodes;
          for i := 0 to IListDoc.Count - 1 do
            if IListDoc[i].NodeName = 'document' then
            begin
              INodeDoc:=IListDoc[i];
              DocumentsInsert.Parameters.ParamByName('idSender').Value:=InvoicesInsert.Parameters.ParamByName('idSender').Value;
              DocumentsInsert.Parameters.ParamByName('compilingYear').Value:=InvoicesInsert.Parameters.ParamByName('compilingYear').Value;
              DocumentsInsert.Parameters.ParamByName('number').Value:=InvoicesInsert.Parameters.ParamByName('number').Value;

              DocumentsInsert.Parameters.ParamByName('code').Value:=INodeDoc.ChildNodes['docType'].ChildNodes['code'].Text;
              if INodeDoc.ChildNodes['date'].HasChildNodes then DocumentsInsert.Parameters.ParamByName('docDate').Value:=Copy(INodeDoc.ChildNodes['date'].Text,1,10);;
              DocumentsInsert.Parameters.ParamByName('blankCode').Value:=Trim(INodeDoc.ChildNodes['blankCode'].Text);
              DocumentsInsert.Parameters.ParamByName('seria').Value:=Trim(INodeDoc.ChildNodes['seria'].Text);
              DocumentsInsert.Parameters.ParamByName('docNumber').Value:=INodeDoc.ChildNodes['number'].Text;

              if idPredpr = SelNastrUNN.AsString then
              begin
                FindSkl.Close;

                if InvoicesInsert.Parameters.ParamByName('documentType').Value=1 then DocumentsInsert.Parameters.ParamByName('vidDoc').Value:=2
                else DocumentsInsert.Parameters.ParamByName('vidDoc').Value:=1;

                FindSkl.Parameters.ParamByName('DocNumber').Value:=INodeDoc.ChildNodes['number'].Text;
                FindSkl.Parameters.ParamByName('VidDoc').Value:=DocumentsInsert.Parameters.ParamByName('vidDoc').Value;

                if INodeDoc.ChildNodes['date'].HasChildNodes then
                  FindSkl.Parameters.ParamByName('DocDate').Value:=DocumentsInsert.Parameters.ParamByName('docDate').Value
                else FindSkl.Parameters.ParamByName('DocDate').Value:=NULL;

                FindSkl.Open;
                DocumentsInsert.Parameters.ParamByName('kodSkl').Value:=FindSkl.FieldByName('KodSkl').Value;

                SelectVariousPredprs.Close;
                SelectVariousPredprs.SQL.Clear;
                SelectVariousPredprs.SQL.Add('Select idPredpr from tbPredpr');
                SelectVariousPredprs.SQL.Add('where UNN='+QuotedStr(ChildNodes['senderReceiver'].ChildNodes['consignees'].ChildNodes['consignee'].ChildNodes['unp'].Text));
                SelectVariousPredprs.Open;
                DocumentsInsert.Parameters.ParamByName('idPredpr').Value:=SelectVariousPredprs.FieldByName('idPredpr').AsInteger;
              end
              else
              begin
                DocumentsInsert.Parameters.ParamByName('vidDoc').Value:=1;
                DocumentsInsert.Parameters.ParamByName('kodSkl').Value:=null;
                DocumentsInsert.Parameters.ParamByName('idPredpr').Value:=null;
              end;
              DocumentsInsert.ExecSQL;

              Break; //17.01.2020      
            end;
        end;
      end;

      compilingYear:=Copy(InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text,11,4);
      number:=Copy(InvoiceXMLDocument.DocumentElement.ChildNodes['general'].ChildNodes['number'].Text,16,10);

      UpdateAsComplete.Parameters.ParamByName('idSender').Value := InvoicesInsert.Parameters.ParamByName('idSender').Value;
      UpdateAsComplete.Parameters.ParamByName('compilingYear').Value := compilingYear;
      UpdateAsComplete.Parameters.ParamByName('number').Value := number;
      UpdateAsComplete.ExecSQL;

      if (deleteFile(LogLB.Items[key])) then LogLB.Items[key]:='   - ';
    except
      if (err<>'') or (err<>'NULL') then
      begin
        Check.Parameters.ParamByName('idSen').Value:=err;
        Check.Parameters.ParamByName('Year').Value:=compilingYear;
        Check.Parameters.ParamByName('numb').Value:=StrToInt64(number);
        Check.Open;

        if Check.FieldByName('completed').AsBoolean then
        Begin
          if (deleteFile(LogLB.Items[key])) then  LogLB.Items[key]:='  - ';
        end;

        Check.Close;
      end;
    end;

    LogLB.ItemIndex := key;
  end;

  MessageDlg(' .', mtInformation, [mbOk], 0);

  SortBtn.Enabled := LogLB.Count > 0;
  CopyErrorsBtn.Enabled := SortBtn.Enabled;
end;

procedure TfrmMain.GetInvoicesBtnClick(Sender: TObject);
begin
  WinExec('receive2Dir.bat', SW_SHOW);
end;

procedure TfrmMain.UpdateOldFilesClick(Sender: TObject);
begin
  Recycle(ExtractFilePath(paramstr(0))+'recv\*.xml');
  GetInvoicesBtn.Click;
end;

procedure TfrmMain.UpdateSendingFilesClick(Sender: TObject);
var key : Integer;
begin
  LogLB.Clear;
  FindFileInFolder(ExtractFilePath(paramstr(0))+'recv3\', '*.xml',true);

  if LogLB.Count<>0 then MainProgressBar.Max:=LogLB.Count-1
  else
  begin
    ShowMessage('   ');
    Exit;
  end;
  
  for key:=0 to LogLB.Count-1 do
  begin
    MainProgressBar.Position:=key;

    if FileExists(ExtractFilePath(paramstr(0))+'recv\' + LogLB.Items[key]) then
    begin
      if CopyFile(PChar(ExtractFilePath(paramstr(0))+'recv\' + LogLB.Items[key]),PChar(ExtractFilePath(paramstr(0))+'recv3\' + LogLB.Items[key]),false) then
      begin
        DeleteFile(ExtractFilePath(paramstr(0))+'recv\' + LogLB.Items[key]);
        LogLB.Items[key]:=LogLB.Items[key]+' - '
      end
      else LogLB.Items[key]:=LogLB.Items[key]+' -  ';
    end
    else LogLB.Items[key]:=LogLB.Items[key]+' -  ';
  end;
end;

procedure TfrmMain.CopyErrorsBtnClick(Sender: TObject);
begin
  Clipboard.AsText := LogLB.Items.Text;
end;

procedure TfrmMain.EnableUpdateOldCBClick(Sender: TObject);
begin
  UpdateOldFiles.Enabled := EnableUpdateOldCB.Checked;
  UpdateSendingFiles.Enabled := EnableUpdateOldCB.Checked;
  UpdateOldInDBCB.Enabled := EnableUpdateOldCB.Checked;
end;

procedure TfrmMain.N1Click(Sender: TObject);
begin
  Clipboard.AsText := Copy(LogLB.Items[LogLB.ItemIndex],1,25);
end;

procedure TfrmMain.ListPopupPopup(Sender: TObject);
begin
  if LogLB.Items.Count > 0 then
  begin
    ListPopup.Items[0].Enabled := True;

    if Pos('    ', LogLB.Items[LogLB.ItemIndex])>0 then
      ListPopup.Items[1].Enabled := True
    else
      ListPopup.Items[1].Enabled := False;
  end
  else
  begin
    ListPopup.Items[0].Enabled := False;
    ListPopup.Items[1].Enabled := False;
  end;
end;

procedure TfrmMain.LogLBMouseDown(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  LogLB.ItemIndex:=LogLB.ItemAtPos(Point(X,Y), false);
end;

procedure TfrmMain.N2Click(Sender: TObject);
begin
  Clipboard.AsText := Copy(LogLB.Items[LogLB.ItemIndex], Pos('    ', LogLB.Items[LogLB.ItemIndex])+31,9);
end;

procedure TfrmMain.SearchEditKeyPress(Sender: TObject; var Key: Char);
begin
  if not CharInSet(Key, ['0'..'9', #8]) then Key:=#0;
end;

procedure TfrmMain.SearchOrganizationBtnClick(Sender: TObject);
begin
  ShellExecute(handle, 'open', 'https://kartoteka.by/features', nil, nil, SW_SHOW);
end;

procedure TfrmMain.SearchBtnClick(Sender: TObject);
var i: Integer;
begin
  if LogLB.Items.Count = 0 then
  begin
    ShowMessage(' ');
    Exit;
  end;

  for i:= 0 to LogLB.Items.Count-1 do
  begin
    if Pos(SearchEdit.Text, LogLB.Items[i])>0 then
    begin
      LogLB.ItemIndex := i;
      Break;
    end;  
  end;  
end;

procedure TfrmMain.SortBtnClick(Sender: TObject);
var original, unp, error : TStringList;
    i : integer;
begin
  original := TStringList.Create;
  unp := TStringList.Create;
  error := TStringList.Create;

  for i:= 0 to LogLB.Count-1 do
  begin
    if Pos('    ', LogLB.Items[i])>0 then
      unp.Add(LogLB.Items[i])
    else
      if Pos('   ', LogLB.Items[i])>0 then
        original.Add(LogLB.Items[i])
      else
        error.Add(LogLB.Items[i]);
  end;

  LogLB.Clear;

  for i:=0 to unp.Count-1 do
    LogLB.Items.Add(unp[i]);

  for i:=0 to original.Count-1 do
    LogLB.Items.Add(original[i]);

  for i:=0 to error.Count-1 do
    LogLB.Items.Add(error[i]);

  unp.Free;
  original.Free;
  error.Free;
end;

end.
