library NaklPrj;

{ Important note about DLL memory management: ShareMem must be the
  first unit in your library's USES clause AND your project's (select
  Project-View Source) USES clause if your DLL exports any procedures or
  functions that pass strings as eters or function results. This
  applies to all strings passed to and from your DLL--even those that
  are nested in records and classes. ShareMem is the interface unit to
  the BORLNDMM.DLL shared memory manager, which must be deployed along
  with your DLL. To avoid using BORLNDMM.DLL, pass string information
  using PChar or ShortString parameters. }

uses
  SysUtils,
  Classes,
  Forms,
  Windows,
  Variants,
  Dialogs,
  StdCtrls,
  DBTables,
  NaklUnit in 'NaklUnit.pas' {NaklForm};

{$R *.res}

var
   DllApp : TApplication;
   NaklForm:TNaklForm;
   
Procedure DllEntryPoint(Reason : Integer);
Begin
   if Reason = DLL_PROCESS_DETACH then
   begin
      try
         if Assigned(NaklForm) then
         begin
            NaklForm.Free;
            NaklForm:=nil;
         end;
      finally
         if Assigned(DllApp) then
            Application := DllApp;
      end;
   end;
End;

Procedure ShowBegRepForm(App : TApplication;
                         MyforReturnTypeTrPredpr:Boolean;
                         MyforOtpRaz:String;
                         FormyTrCheckBox:Boolean;
                         MyforSumNDS_1:Boolean;
                         MyforVsegoSNDS_1:Boolean;
                         MyforVesTrEdit:String;
                         MyforTTNEdit:String;
                         MyforNumDoc:String;
                         MyforSeria:String;
                         MyforPogr:String;
                         MyforRazg:String;
                         MyforVidPer:String;
                         MyforPrim:String;
                         MyforStoimost:Boolean;
                         MyforStoimost2_1:Boolean;
                         MyforStoimost2_2:Boolean;
                         MyforCheckNastrGrTov:Boolean;
                         MyforPr_CenPriobr:Boolean;
                         MyforPr_CenTr:Boolean;
                         MyforPr_ProcTr:Boolean;
                         MyforPr_CenWNal:Boolean;
                         MyforPRAll:String;
                         MyforIdDoc:Integer;
                         MyforAliasName:String;
                         MyforLogin:String;
                         MyforPassword:String;
                         MyforCopyEdit:String;
                         MyforFace3:Boolean;
                         MyforDateDov:String;
                         MyforVlTr:String;
                         MyforSposPogr:String;
                         MyforSposRazgr:String;
                         MyforVrPrib:String;
                         MyforVrUb:String;
                         MyforVrProst:String;
                         MyforMOLGruzPoluch:String;
                         MyforNomPric:String;
                         AAgreement:String);

Begin
   if NaklForm <> nil then
      exit;
   if not Assigned(DllApp) then
   begin
      DllApp := Application;
      Application := App;
   end;
   try
      NaklForm := TNaklForm.Create(Application.MainForm);
      LockWindowUpdate(DllApp.Handle);

      with NaklForm do
      begin
         forReturnTypeTrPredpr.Checked:=MyforReturnTypeTrPredpr;
         forOtpRaz.Text:=MyforOtpRaz;
         TrCheckBox.Checked:=FormyTrCheckBox;
         forSumNDS_1.Checked:=MyforSumNDS_1;
         forVsegoSNDS_1.Checked:=MyforVsegoSNDS_1;
         forVesTrEdit.Text:=MyforVesTrEdit;
         forTTNEdit.Text:=MyforTTNEdit;
         forNumDoc.Text:=MyforNumDoc;
         forSeria.Text:=MyforSeria;
         forPogr.Text:=MyforPogr;
         forRazg.Text:=MyforRazg;
         forVidPer.Text:=MyforVidPer;
         forPrim.Text:=MyforPrim;
         forStoimost.Checked:=MyforStoimost;
         forStoimost2_1.Checked:=MyforStoimost2_1;
         forStoimost2_2.Checked:=MyforStoimost2_2;
         forCheckNastrGrTov.Checked:=MyforCheckNastrGrTov;
         forPr_CenPriobr.Checked:=MyforPr_CenPriobr;
         forPr_CenTr.Checked:=MyforPr_CenTr;
         forPr_ProcTr.Checked:=MyforPr_ProcTr;
         forPr_CenWNal.Checked:=MyforPr_CenWNal;
         forPRAll.Text:=MyforPRAll;
         forIdDoc.Text:=IntToStr(MyforIdDoc);
         frxReport1.PrintOptions.Copies:=StrToInt(MyforCopyEdit);
         frxReport2.PrintOptions.Copies:=StrToInt(MyforCopyEdit);
         forFace3.Checked:=MyforFace3;
         forDateDov.Text:=MyforDateDov;
         forVlTr.Text:=MyforVlTr;
         forSposPogr.Text:=MyforSposPogr;
         forSposRazgr.Text:=MyforSposRazgr;
         forVrPrib.Text:=MyforVrPrib;
         forVrUb.Text:=MyforVrUb;
         forVrProst.Text:=MyforVrProst;
         forMOLGruzPoluch.Text:=MyforMOLGruzPoluch;
         forNomPric.Text:=MyforNomPric;
         Agreement := AAgreement;
      end;

      //Con:=MyforConnect;
      {with NaklForm.mdb do begin
      Connected := false;
      Params.Clear;
      Params.AddStrings(con^.Params);
      //ShowMessage(Params.Values['PASSWORD']);
      if (Params.Values['USER NAME'] <>'')and(Params.Values['PASSWORD'] <>'') then
      LoginPrompt:=false
      else
      LoginPrompt:=true;
      connected:=true;
      end;}
      with  NaklForm.mdb do
      begin
         Connected:=False;
         //AliasName:=Con^.AliasName;
         //Params.AddStrings(AParamsConnect);
         AliasName:=MyforAliasName;
         Params.Strings[0]:= MyforLogin;
         Params.Strings[1]:= MyforPassword;

         //Params.Strings[0]:= con^.Params.Strings[0];
         //Params.Strings[1]:= con^.Params.Strings[1];

         //Params.Values['USER NAME'] := MyforLogin;
         //Params.Values['PASSWORD'] := MyforPassword;
         LoginPrompt:=False;
         Connected:=True;
      end;
      NaklForm.Run();
      //NaklForm.Show;
   except
      on E : Exception do
      ShowMessage(E.ClassName+'    : '+E.Message);
   end;
End;

exports
   ShowBegRepForm;

begin
   DllProc := @DllEntryPoint;
end.
