﻿using Npgsql;
using System;
using System.Data;
using System.Globalization;
using System.IO;
using System.Text;
using System.Windows.Forms;

namespace OS
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();

            conn = new NpgsqlConnection("Server=" + Server_textBox1.Text + ";" + "Port=" + Port_textBox1.Text + ";" + "User Id=" + User_textBox1.Text + ";" + "Password=" + Password_textBox1.Text + ";" + "Database=" + Database_textBox1.Text + ";");
        }

        private void Conn_button1_Click(object sender, EventArgs e)
        {
            try
            {
                conn = new NpgsqlConnection("Server=" + Server_textBox1.Text + ";" + "Port=" + Port_textBox1.Text + ";" + "User Id=" + User_textBox1.Text + ";" + "Password=" + Password_textBox1.Text + ";" + "Database=" + Database_textBox1.Text + ";");
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private DataTable datatable;

        private NpgsqlConnection conn;

        private void Parse_file_button1_Click(object sender, EventArgs e)
        {
            try
            {
                using (var openFileDialog = new OpenFileDialog())
                {
                    openFileDialog.Filter = "*.txt | *.txt";
                    if (openFileDialog.ShowDialog() == DialogResult.OK)
                        Parse_file_textBox1.Text = (openFileDialog.FileName);
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Parse_file_button2_Click(object sender, EventArgs e)
        {
            try
            {
                datatable = new DataTable();
                StreamReader streamreader = new StreamReader(Parse_file_textBox1.Text, Encoding.GetEncoding(1251)); // path and encoding
                char[] delimiter = new char[] { '\t' };
                string[] columnheaders = streamreader.ReadLine().Split(delimiter);
                foreach (string columnheader in columnheaders)
                {
                    datatable.Columns.Add(columnheader); // I've added the column headers here.
                }

                while (streamreader.Peek() > 0)
                {
                    DataRow datarow = datatable.NewRow();
                    datarow.ItemArray = streamreader.ReadLine().Split(delimiter);
                    datatable.Rows.Add(datarow);
                }

                Parse_file_richTextBox1.Clear();
                if (Show_RE_checkBox1.Checked == true)
                    foreach (DataRow row in datatable.Rows)
                    {
                        if (datatable.Rows.IndexOf(row) == 0)
                            Parse_file_richTextBox1.AppendText("                                ----Row No: " + datatable.Rows.IndexOf(row) + "----");
                        else
                            Parse_file_richTextBox1.AppendText("\r\n" + "                               ----Row No: " + datatable.Rows.IndexOf(row) + "----");

                        foreach (DataColumn column in datatable.Columns)
                        {
                            //check what columns you need
                            //if (column.ColumnName == "" ||
                            //column.ColumnName == "")
                            //{
                            Parse_file_richTextBox1.AppendText("\r\n" + column.ColumnName + ": " + row[column].ToString());
                            //}
                        }
                    }

                streamreader.Close();
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Test_data_button1_Click(object sender, EventArgs e)
        {
            Test_data_richTextBox1.Clear();

            Test_CodePodr_DB_1();
            Test_CodePodr_DB_2();
            Test_Ninv_DB();
            Test_Ninv_FILE();
            Test_Shifr_DB();
            Repair_NormSrok_DB();
            Test_Norma_FILE();
            Test_Datavv_FILE();
            Test_StoimAm_FILE();
            Test_TN_DB();
            Test_PriznNach_FILE();
            Test_CodeOpP_DB();
        }

        private void Test_CodePodr_DB_1()
        {
            try
            {
                conn.Open();

                NpgsqlCommand command = new NpgsqlCommand
                (
                    "SELECT " +
                        "COUNT(*) " +
                    "FROM \"OS\".tbpodr " +
                    "WHERE " + "unp ='" + UNP_textBox1.Text + "' AND " + "unp_dop ='" + UNP_dop_textBox1.Text + "' AND " + "codepodr =" + CodePodr_textBox1.Text
                , conn
                );

                NpgsqlDataReader dr = command.ExecuteReader();

                while (dr.Read())
                    if (Convert.ToInt32(dr[0]) == 1)
                        Test_data_richTextBox1.AppendText("0. Проверка CodePodr в базе из программы -> ОК...\n");
                    else
                        Test_data_richTextBox1.AppendText("0. Проверка CodePodr в базе из программы -> ОШИБКА...\n");

                //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                conn.Close();
            }
            catch (Exception Ex)
            {
                MessageBox.Show("0. Проверка CodePodr в базе из программы -> ОШИБКА...\n" + Ex.ToString());
            }
        }

        private void Test_CodePodr_DB_2()
        {
            try
            {
                Test_data_richTextBox1.AppendText("1. Проверка CodePodr в базе из файла -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    string UNP = "-666";
                    string UNP_dop = "-666";
                    int CodePodr = -666;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "UNP")
                            UNP = row[column].ToString();

                        if (column.ColumnName == "UNP_dop")
                            UNP_dop = row[column].ToString();

                        if (column.ColumnName == "CodePodr")
                            CodePodr = Convert.ToInt32(row[column]);

                        if (UNP != "-666" && UNP_dop != "-666" && CodePodr != -666)
                        {
                            conn.Open();

                            NpgsqlCommand command = new NpgsqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM \"OS\".tbpodr " +
                                "WHERE " + "unp ='" + UNP + "' AND " + "unp_dop ='" + UNP_dop + "' AND " + "codepodr =" + CodePodr
                            , conn
                            );

                            NpgsqlDataReader dr = command.ExecuteReader();

                            while (dr.Read())
                                if (Convert.ToInt32(dr[0]) != 1)
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " != 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                            //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                            conn.Close();

                            UNP = "-666";
                            UNP_dop = "-666";
                            CodePodr = -666;
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("1. Проверка CodePodr в базе из файла -> ...\n" + Ex.ToString());
            }
        }

        private void Test_Ninv_DB()
        {
            try
            {
                Test_data_richTextBox1.AppendText("2. Проверка Ninv в базе -> ...\n");

                Random random = new Random();

                foreach (DataRow row in datatable.Rows)
                {
                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "Ninv")
                        {
                            conn.Open();

                            NpgsqlCommand command = new NpgsqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM \"OS\".tbobjos " +
                                "WHERE " + "unp ='" + UNP_textBox1.Text + "' AND " + "unp_dop ='" + UNP_dop_textBox1.Text + "' AND " + "ninv ='" + row[column].ToString() + "'"
                            , conn
                            );

                            NpgsqlDataReader dr = command.ExecuteReader();

                            while (dr.Read())
                                if (Convert.ToInt32(dr[0]) > 0)
                                {
                                    Test_data_richTextBox1.AppendText("                                -> -> " + row[column].ToString() + " > 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                    if (Repair_Ninv_checkBox1.Checked == true)
                                    {
                                        string Ninv_OLD = row[column].ToString();

                                        int random_value = random.Next(999999);

                                        while (true)
                                            //if (Convert.ToDouble(row[column]) == random_value)
                                            if (row[column].ToString() == random_value.ToString())
                                                random.Next(999999);
                                            else
                                            {
                                                row[column] = random_value;

                                                break;
                                            }

                                        string Ninv_New = row[column].ToString();

                                        Load_data_richTextBox1.AppendText("Repair_Ninv_DB: " + Ninv_OLD + " ->-> " + Ninv_New + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");
                                    }
                                }
                            //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                            conn.Close();
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("2. Проверка Ninv в базе -> ...\n" + Ex.ToString());
            }
        }

        private void Test_Ninv_FILE()
        {
            try
            {
                for (int i = 0; i <= 5; i++)
                {
                    Test_data_richTextBox1.AppendText("  2.1 Проверка Ninv в файле -> ...\n");

                    //double oldValue = -666;
                    string oldValue = "-666";

                    Random random = new Random();

                    DataView dataview = datatable.DefaultView;
                    dataview.Sort = "Ninv ASC";
                    datatable = dataview.ToTable();

                    foreach (DataRow row in datatable.Rows)
                    {
                        foreach (DataColumn column in datatable.Columns)
                        {
                            if (column.ColumnName == "Ninv")
                            {
                                double dbl;
                                bool isDouble = double.TryParse(row[column].ToString(), out dbl);
                                if (!isDouble && Rr_Ninv_isDouble_checkBox1.Checked == true)
                                {
                                    int random_value = random.Next(999999);

                                    Load_data_richTextBox1.AppendText("Repair_Ninv_FILE: " + row[column].ToString() + " ->-> " + random_value.ToString() + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                    row[column] = random_value;
                                }

                                //if (Convert.ToDouble(row[column]) == oldValue)
                                if (row[column].ToString() == oldValue.ToString())
                                {
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " > 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                    if (Repair_Ninv_checkBox1.Checked == true)
                                    {
                                        int random_value = random.Next(999999);

                                        while (true)
                                            //if (Convert.ToDouble(row[column]) == random_value)
                                            if (row[column].ToString() == random_value.ToString())
                                                random.Next(999999);
                                            else
                                            {
                                                row[column] = random_value;

                                                break;
                                            }

                                        Load_data_richTextBox1.AppendText("Repair_Ninv_FILE: " + oldValue.ToString() + " ->-> " + row[column].ToString() + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");
                                    }

                                    //oldValue = Convert.ToDouble(row[column]);
                                    oldValue = row[column].ToString();
                                }
                                else
                                    //oldValue = Convert.ToDouble(row[column]);
                                    oldValue = row[column].ToString();

                                if (row[column].ToString().Length > 10)
                                {
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " > 10 символов (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                    if (Repair_Ninv_checkBox1.Checked == true)
                                    {
                                        int random_value = random.Next(999999);

                                        while (true)
                                            //if (Convert.ToDouble(row[column]) == random_value)
                                            if (row[column].ToString() == random_value.ToString())
                                                random.Next(999999);
                                            else
                                            {
                                                row[column] = random_value;

                                                break;
                                            }

                                        Load_data_richTextBox1.AppendText("Repair_Ninv_FILE: " + oldValue.ToString() + " ->-> " + row[column].ToString() + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");
                                    }

                                    //oldValue = Convert.ToDouble(row[column]);
                                    oldValue = row[column].ToString();
                                }
                                else
                                    //oldValue = Convert.ToDouble(row[column]);
                                    oldValue = row[column].ToString();
                            }
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("  2.1 Проверка Ninv в файле -> ...\n" + Ex.ToString());
            }
        }

        private void Test_Shifr_DB()
        {
            try
            {
                Test_data_richTextBox1.AppendText("3 Проверка Shifr в базе -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "Shifr")
                        {
                            conn.Open();

                            NpgsqlCommand command = new NpgsqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM \"OS\".tbgrvidos " +
                                "WHERE " + "shifr ='" + row[column].ToString() + "'"
                            , conn
                            );

                            NpgsqlDataReader dr = command.ExecuteReader();

                            while (dr.Read())
                                if (Convert.ToInt32(dr[0]) != 1)
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " != 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                            //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                            conn.Close();
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("3 Проверка Shifr в базе -> ...\n" + Ex.ToString());
            }
        }

        private void Repair_NormSrok_DB()
        {
            try
            {
                if (Repair_NormSrok_checkBox1.Checked == true)
                {
                    Test_data_richTextBox1.AppendText("4 Восстановление NormSrok в базе -> ...\n");

                    foreach (DataRow row in datatable.Rows)
                    {
                        double NormSrok = -666;

                        foreach (DataColumn column in datatable.Columns)
                        {
                            if (column.ColumnName == "Shifr")
                            {
                                conn.Open();

                                NpgsqlCommand command = new NpgsqlCommand
                                (
                                    "SELECT " +
                                        "normsrok " +
                                    "FROM \"OS\".tbgrvidos " +
                                    "WHERE " + "shifr ='" + row[column].ToString() + "'"
                                , conn
                                );

                                NpgsqlDataReader dr = command.ExecuteReader();

                                if (dr.Read())
                                    NormSrok = (Convert.ToDouble(dr[0]));
                                else
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " != 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                                conn.Close();
                            }

                            if (NormSrok != -666)
                                if (column.ColumnName == "NormSrok")
                                    row[column] = NormSrok;
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("4 Восстановление NormSrok в базе -> ...\n" + Ex.ToString());
            }
        }

        private void Test_Norma_FILE()
        {
            try
            {
                Test_data_richTextBox1.AppendText("5 Проверка Norma в файле -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    double Norma = -666;
                    double NormSrok = -666;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "Norma")
                            Norma = Convert.ToDouble(row[column]);

                        if (column.ColumnName == "NormSrok")
                            NormSrok = Convert.ToDouble(row[column]);

                        if (Norma != -666 && NormSrok != -666)
                        {
                            if (Math.Round(100 / NormSrok, 6) != Norma)
                            {
                                Test_data_richTextBox1.AppendText("                                -> -> стоит " + Norma.ToString() + " вместо " + Math.Round(100 / NormSrok, 6) + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                if (Repair_Norma_checkBox1.Checked == true)
                                    row["Norma"] = Math.Round(100 / NormSrok, 6);
                            }

                            Norma = -666;
                            NormSrok = -666;
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("5 Проверка Norma в файле -> ...\n" + Ex.ToString());
            }
        }

        private void Test_Datavv_FILE()
        {
            try
            {
                Test_data_richTextBox1.AppendText("6 Проверка Datavv в файле -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "Datavv")
                        {
                            string format = "dd.MM.yyyy";
                            DateTime dateTime;
                            if (!DateTime.TryParseExact(row[column].ToString(), format, CultureInfo.InvariantCulture,
                                DateTimeStyles.None, out dateTime))
                            {
                                Test_data_richTextBox1.AppendText("                                -> -> ошибка даты (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");
                            }
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("6 Проверка Datavv в файле -> ...\n" + Ex.ToString());
            }
        }

        private void Test_StoimAm_FILE()
        {
            try
            {
                Test_data_richTextBox1.AppendText("7 Проверка StoimAm в файле -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    double StoimV = -666;
                    double StoimAm = -666;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "StoimV")
                            StoimV = Convert.ToDouble(row[column]);

                        if (column.ColumnName == "StoimAm")
                            StoimAm = Convert.ToDouble(row[column]);

                        if (StoimV != -666 && StoimAm != -666)
                        {
                            if (StoimV != StoimAm)
                                Test_data_richTextBox1.AppendText("                                -> -> StoimV != StoimAm (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                            StoimV = -666;
                            StoimAm = -666;
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("7 Проверка StoimAm в файле -> ...\n" + Ex.ToString());
            }
        }

        private void Test_TN_DB()
        {
            try
            {
                Test_data_richTextBox1.AppendText("8 Проверка TN в базе -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "TN")
                        {
                            conn.Open();

                            NpgsqlCommand command = new NpgsqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM \"OS\".tbmol " +
                                "WHERE " + "unp ='" + UNP_textBox1.Text + "' AND " + "unp_dop ='" + UNP_dop_textBox1.Text + "' AND " + "tn =" + row[column].ToString()
                            , conn
                            );

                            NpgsqlDataReader dr = command.ExecuteReader();

                            while (dr.Read())
                                if (Convert.ToInt32(dr[0]) != 1)
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " != 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                            //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                            conn.Close();
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("8 Проверка TN в базе -> ...\n" + Ex.ToString());
            }
        }

        private void Test_PriznNach_FILE()
        {
            try
            {
                Test_data_richTextBox1.AppendText("9 Проверка PriznNach в файле -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    double StoimV = -666;
                    double SumIznos = -666;
                    int PriznNach = -666;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "StoimV")
                            StoimV = Convert.ToDouble(row[column]);

                        if (column.ColumnName == "SumIznos")
                            SumIznos = Convert.ToDouble(row[column]);

                        if (column.ColumnName == "PriznNach")
                            PriznNach = Convert.ToInt32(row[column]);

                        if (StoimV != -666 && SumIznos != -666 && PriznNach != -666)
                        {
                            if (StoimV <= SumIznos && PriznNach == 1)
                            {
                                Test_data_richTextBox1.AppendText("                                -> -> " + "StoimV <= SumIznos && PriznNach == 1" + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                if (Repair_PriznNach_checkBox1.Checked == true)
                                    row[column] = 0;
                            }
                            if (StoimV > SumIznos && PriznNach == 0)
                            {
                                Test_data_richTextBox1.AppendText("                                -> -> " + "StoimV > SumIznos && PriznNach == 0" + " (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                                if (Repair_PriznNach_checkBox1.Checked == true)
                                    row[column] = 1;
                            }
                            StoimV = -666;
                            SumIznos = -666;
                            PriznNach = -666;
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("9 Проверка PriznNach в файле -> ...\n" + Ex.ToString());
            }
        }

        private void Test_CodeOpP_DB()
        {
            try
            {
                Test_data_richTextBox1.AppendText("10 Проверка CodeOpP в базе -> ...\n");

                foreach (DataRow row in datatable.Rows)
                {
                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "CodeOpP")
                        {
                            conn.Open();

                            NpgsqlCommand command = new NpgsqlCommand
                            (
                                "SELECT " +
                                    "COUNT(*) " +
                                "FROM \"OS\".tbkop " +
                                "WHERE code =" + row[column]
                            , conn
                            );

                            NpgsqlDataReader dr = command.ExecuteReader();

                            while (dr.Read())
                                if (Convert.ToInt32(dr[0]) != 1)
                                    Test_data_richTextBox1.AppendText("                                  -> -> " + row[column].ToString() + " != 1 (" + datatable.Rows.IndexOf(row) + " строка)" + "\n");

                            //Console.Write("{0}\t{1} \n", dr[0], dr[1]); Console.Write("{0} \n", dr[0]);

                            conn.Close();
                        }
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show("10 Проверка CodeOpP в базе -> ...\n" + Ex.ToString());
            }
        }

        private void Load_data_button1_Click(object sender, EventArgs e)
        {
            Load_tbobjos();
            Load_tbamortos();
        }

        private void Load_tbobjos()
        {
            string query = "";
            try
            {
                foreach (DataRow row in datatable.Rows)
                {
                    query = "";
                    string unp1 = "";
                    string unp_dop1 = "";
                    string ninv1 = "";
                    string dpost1 = "";
                    double zoloto = 0;
                    double serebro = 0;
                    double platina = 0;
                    double palladii = 0;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        
                        if (column.ColumnName == "UNP")
                        {
                            query += "'" + row[column].ToString() + "'" + ",";
                            unp1 = row[column].ToString();
                        }

                        
                        if (column.ColumnName == "UNP_dop")
                        {
                            query += "'" + row[column].ToString() + "'" + ",";
                            unp_dop1 = row[column].ToString();
                        }
                            

                        if (column.ColumnName == "CodePodr")
                            query += Convert.ToInt32(row[column]) + ",";

                        
                        if (column.ColumnName == "Ninv")
                        {
                            query += "'" + row[column].ToString() + "'" + ",";
                            ninv1 = row[column].ToString();
                        }
                            

                        if (column.ColumnName == "Naim")
                            query += "'" + row[column].ToString().Substring(0, Math.Min(row[column].ToString().Length, 50)) + "'" + ",";

                        if (column.ColumnName == "Shifr")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "Norma")
                            query += Convert.ToDouble(row[column]) + ",";

                        
                        if (column.ColumnName == "Datavv")
                        {
                            query += "'" + row[column].ToString() + "'" + ",";
                            dpost1 = row[column].ToString();
                        }
                            

                        if (column.ColumnName == "StoimV")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "StoimAm")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "StoimVM")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "StoimAmM")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "SumIznos")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "TN")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "Metod")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "KoefPoprav")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "KoefUskor")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "Mesto")
                            query += "'" + row[column].ToString() + "'" + ",";

                        
                        if (column.ColumnName == "Dpostr")
                            query += "'" + row[column].ToString() + "'" + ",";
                            

                        if (column.ColumnName == "NormSrok")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "PriznNach")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "Status")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "KS")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "KZ")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "Leasing")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "CodeOpP")
                            query += Convert.ToInt32(row[column]);

                        
                        if (column.ColumnName == "Zoloto")
                        {
                            //query += Convert.ToDouble(row[column]) + ",";
                            zoloto = Convert.ToDouble(row[column]);
                        }
                        
                        if (column.ColumnName == "Serebro")
                        {
                            //query += Convert.ToDouble(row[column]) + ",";
                            serebro = Convert.ToDouble(row[column]);
                        }
                       
                        if (column.ColumnName == "Platina")
                        {
                            //query += Convert.ToDouble(row[column]) + ",";
                            platina = Convert.ToDouble(row[column]);
                        }
                        
                        if (column.ColumnName == "Palladii")
                        {
                            //query += Convert.ToDouble(row[column]) + ",";
                            palladii = Convert.ToDouble(row[column]);
                        }



                        

                    }

                    if (zoloto != 0)
                    {

                        //золото 1
                        //serebro 2
                        //platina 3
                        //palladii 4


                        string qry = "";
                        qry += "'" + unp1 + "'" + ",";
                        qry += "'" + unp_dop1 + "'" + ",";
                        qry += "'" + ninv1 + "'" + ",";
                        qry += "'" + 1 + "'" + ",";
                        qry += "'" + zoloto + "'" + ",";
                        qry += "'" + dpost1 + "'";


                        conn.Open();

                        NpgsqlCommand command11 = new NpgsqlCommand
                        (
                            "INSERT INTO tbdrmetobj " +
                            "(unp, unp_dop, ninv, code, massa, datapost) " +
                            "VALUES (" + qry + ")"
                        , conn
                        );

                        command11.ExecuteNonQuery();

                        conn.Close();
                    }

                    if (serebro != 0)
                    {

                        //золото 1
                        //serebro 2
                        //platina 3
                        //palladii 4


                        string qry = "";
                        qry += "'" + unp1 + "'" + ",";
                        qry += "'" + unp_dop1 + "'" + ",";
                        qry += "'" + ninv1 + "'" + ",";
                        qry += "'" + 2 + "'" + ",";
                        qry += "'" + serebro + "'" + ",";
                        qry += "'" + dpost1 + "'";


                        conn.Open();

                        NpgsqlCommand command11 = new NpgsqlCommand
                        (
                            "INSERT INTO tbdrmetobj " +
                            "(unp, unp_dop, ninv, code, massa, datapost) " +
                            "VALUES (" + qry + ")"
                        , conn
                        );

                        command11.ExecuteNonQuery();

                        conn.Close();
                    }
                    if (platina != 0)
                    {

                        //золото 1
                        //serebro 2
                        //platina 3
                        //palladii 4


                        string qry = "";
                        qry += "'" + unp1 + "'" + ",";
                        qry += "'" + unp_dop1 + "'" + ",";
                        qry += "'" + ninv1 + "'" + ",";
                        qry += "'" + 3 + "'" + ",";
                        qry += "'" + platina + "'" + ",";
                        qry += "'" + dpost1 + "'";


                        conn.Open();

                        NpgsqlCommand command11 = new NpgsqlCommand
                        (
                            "INSERT INTO tbdrmetobj " +
                            "(unp, unp_dop, ninv, code, massa, datapost) " +
                            "VALUES (" + qry + ")"
                        , conn
                        );

                        command11.ExecuteNonQuery();

                        conn.Close();
                    }
                    if (palladii != 0)
                    {

                        //золото 1
                        //serebro 2
                        //platina 3
                        //palladii 4


                        string qry = "";
                        qry += "'" + unp1 + "'" + ",";
                        qry += "'" + unp_dop1 + "'" + ",";
                        qry += "'" + ninv1 + "'" + ",";
                        qry += "'" + 4 + "'" + ",";
                        qry += "'" + palladii + "'" + ",";
                        qry += "'" + dpost1 + "'";


                        conn.Open();

                        NpgsqlCommand command11 = new NpgsqlCommand
                        (
                            "INSERT INTO tbdrmetobj " +
                            "(unp, unp_dop, ninv, code, massa, datapost) " +
                            "VALUES (" + qry + ")"
                        , conn
                        );

                        command11.ExecuteNonQuery();

                        conn.Close();
                    }

                    conn.Open();

                    NpgsqlCommand command = new NpgsqlCommand
                    (
                        "INSERT INTO tbobjos " +
                        "(unp, unp_dop, codepodr, ninv, naim, shifr, norma, datavv, stoimv, stoimam, stoimvm, stoimamm, sumiznos, tn, metod, koefpoprav, koefuskor, mesto, dpostr, normsrok, priznnach, status, ks, kz, leasing, codeopp) " +
                        "VALUES (" + query + ")"
                    , conn
                    );

                    command.ExecuteNonQuery();

                    conn.Close();
                }

                MessageBox.Show("Картотека объектов ОС - ёу!");
            }
            catch (Exception Ex)
            {
                MessageBox.Show("Картотека объектов ОС - упс!\n" + Ex.ToString());

                MessageBox.Show(query);
                MessageBox.Show(Ex.Data.ToString());
                MessageBox.Show(Ex.Message.ToString());

                conn.Close();
            }
        }

        private void Load_tbamortos()
        {
            try
            {
                double SumStoimV = 0;
                double SumStoimAmort = 0;

                foreach (DataRow row in datatable.Rows)
                {
                    string query = "";

                    double StoimV = 0;

                    double StoimAm = 0;

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "UNP")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "UNP_dop")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "CodePodr")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "Ninv")
                        {
                            query += "'" + row[column].ToString() + "'" + ",";

                            query += "'" + Data_textBox1.Text + "'" + ",";
                        }

                        if (column.ColumnName == "Norma")
                            query += Convert.ToDouble(row[column]) + ",";

                        if (column.ColumnName == "StoimV")
                        {
                            query += Convert.ToDouble(row[column]) + ",";

                            StoimV = Convert.ToDouble(row[column]);

                            SumStoimV += StoimV;
                        }

                        if (column.ColumnName == "StoimAm")
                        {
                            query += Convert.ToDouble(row[column]) + ",";

                            StoimAm = Convert.ToDouble(row[column]);

                            SumStoimAmort += StoimAm;
                        }

                        if (column.ColumnName == "SumIznos")
                        {
                            query += Convert.ToDouble(row[column]) + ",";

                            if (StoimV > 0)
                            {
                                query += Math.Round(Convert.ToDouble(row[column]) / StoimV * 100, 2) + ",";

                                query += Math.Round(StoimV - Convert.ToDouble(row[column]), 2) + ",";
                            }
                            else
                            {
                                query += 0 + ",";

                                query += 0 + ",";
                            }
                        }

                        if (column.ColumnName == "TN")
                            query += Convert.ToInt32(row[column]) + ",";

                        if (column.ColumnName == "KS")
                            query += "'" + row[column].ToString() + "'" + ",";

                        if (column.ColumnName == "KZ")
                            query += "'" + row[column].ToString() + "'";
                    }

                    conn.Open();

                    NpgsqlCommand command = new NpgsqlCommand
                    (
                        "INSERT INTO tbamortos " +
                        "(unp, unp_dop, codepodr, ninv, data, norma, stoimv, stoimamort, iznos, iznosperc, stoimost, tn, ks, kz)" +
                        "VALUES (" + query + ")"
                    , conn
                    );

                    command.ExecuteNonQuery();

                    conn.Close();
                }

                MessageBox.Show("Ведомость амортизации - ёу!");

                if (Show_SV_SA_checkBox1.Checked == true)
                    MessageBox.Show("SV = " + SumStoimV + ", SA = " + SumStoimAmort);
            }
            catch (Exception Ex)
            {
                MessageBox.Show("Ведомость амортизации - упс!\n" + Ex.ToString());

                conn.Close();
            }
        }

        private void Refresh_log_button1_Click(object sender, EventArgs e)
        {
            try
            {
                Parse_file_richTextBox1.Clear();
                foreach (DataRow row in datatable.Rows)
                {
                    if (datatable.Rows.IndexOf(row) == 0)
                        Parse_file_richTextBox1.AppendText("                                ----Row No: " + datatable.Rows.IndexOf(row) + "----");
                    else
                        Parse_file_richTextBox1.AppendText("\r\n" + "                               ----Row No: " + datatable.Rows.IndexOf(row) + "----");

                    foreach (DataColumn column in datatable.Columns)
                    {
                        //check what columns you need
                        //if (column.ColumnName == "" ||
                        //column.ColumnName == "")
                        //{
                        Parse_file_richTextBox1.AppendText("\r\n" + column.ColumnName + ": " + row[column].ToString());
                        //}
                    }
                }
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Clear_load_data_button1_Click(object sender, EventArgs e)
        {
            try
            {
                Load_data_richTextBox1.Clear();
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Update_Datavv_button1_Click(object sender, EventArgs e)
        {
            try
            {
                foreach (DataRow row in datatable.Rows)
                {
                    string Ninv = "";

                    string newDatavv = "";

                    foreach (DataColumn column in datatable.Columns)
                    {
                        if (column.ColumnName == "Ninv")
                            Ninv = row[column].ToString();

                        if (column.ColumnName == "Datavv")
                            newDatavv = row[column].ToString();
                    }

                    conn.Open();

                    NpgsqlCommand command = new NpgsqlCommand
                    (
                        "UPDATE tbobjos " +
                        "SET datavv='" + newDatavv + "' " +
                        "WHERE unp='" + UNP_textBox1.Text + "' AND unp_dop='" + UNP_dop_textBox1.Text + "' AND ninv='" + Ninv + "'"
                    , conn
                    );

                    command.ExecuteNonQuery();

                    conn.Close();
                }

                MessageBox.Show("Обновление даты ввода в эксплуатацию - ёу!");
            }
            catch (Exception Ex)
            {
                MessageBox.Show(Ex.ToString());

                conn.Close();
            }
        }
    }
}