﻿using System;
using System.Data;
using System.Data.SqlClient;
using System.Windows.Forms;

namespace TovExpImp
{
    public partial class TovExpImpForm : Form
    {
        private SqlConnection connOtkyda = new SqlConnection();
        private SqlConnection connKyda = new SqlConnection();
        private DataTable dataTableTovarsOtkyda = new DataTable();
        private DataTable dataTableNacenkiOtkyda = new DataTable();

        public TovExpImpForm()
        {
            InitializeComponent();

            tbxOtkydaIP.Text = Properties.Settings.Default.tbxOtkydaIP;
            tbxOtkydaPORT.Text = Properties.Settings.Default.tbxOtkydaPORT;
            tbxOtkydaUSER.Text = Properties.Settings.Default.tbxOtkydaUSER;
            tbxOtkydaPASS.Text = Properties.Settings.Default.tbxOtkydaPASS;
            tbxOtkydaDB.Text = Properties.Settings.Default.tbxOtkydaDB;
            tbxKydaIP.Text = Properties.Settings.Default.tbxKydaIP;
            tbxKydaPORT.Text = Properties.Settings.Default.tbxKydaPORT;
            tbxKydaUSER.Text = Properties.Settings.Default.tbxKydaUSER;
            tbxKydaPASS.Text = Properties.Settings.Default.tbxKydaPASS;
            tbxKydaDB.Text = Properties.Settings.Default.tbxKydaDB;

            connOtkyda.ConnectionString = "Data Source=" + tbxOtkydaIP.Text + "," + tbxOtkydaPORT.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + tbxOtkydaDB.Text + ";User ID =" + tbxOtkydaUSER.Text + ";Password=" + tbxOtkydaPASS.Text + ";";
            connKyda.ConnectionString = "Data Source=" + tbxKydaIP.Text + "," + tbxKydaPORT.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + tbxKydaDB.Text + ";User ID =" + tbxKydaUSER.Text + ";Password=" + tbxKydaPASS.Text + ";";

            tbxIDSklOtkyda.Text = Properties.Settings.Default.tbxIDSklOtkyda;
            tbxIDSklKyda.Text = Properties.Settings.Default.tbxIDSklKyda;
        }

        private void TovExpImpForm_FormClosing(object sender, FormClosingEventArgs e)
        {
            Properties.Settings.Default.tbxOtkydaIP = tbxOtkydaIP.Text;
            Properties.Settings.Default.tbxOtkydaPORT = tbxOtkydaPORT.Text;
            Properties.Settings.Default.tbxOtkydaUSER = tbxOtkydaUSER.Text;
            Properties.Settings.Default.tbxOtkydaPASS = tbxOtkydaPASS.Text;
            Properties.Settings.Default.tbxOtkydaDB = tbxOtkydaDB.Text;
            Properties.Settings.Default.tbxKydaIP = tbxKydaIP.Text;
            Properties.Settings.Default.tbxKydaPORT = tbxKydaPORT.Text;
            Properties.Settings.Default.tbxKydaUSER = tbxKydaUSER.Text;
            Properties.Settings.Default.tbxKydaPASS = tbxKydaPASS.Text;
            Properties.Settings.Default.tbxKydaDB = tbxKydaDB.Text;

            Properties.Settings.Default.tbxIDSklOtkyda = tbxIDSklOtkyda.Text;
            Properties.Settings.Default.tbxIDSklKyda = tbxIDSklKyda.Text;

            Properties.Settings.Default.Save();
        }

        private void BtnOtkydaTESTCon_Click(object sender, System.EventArgs e)
        {
            try
            {
                connOtkyda.ConnectionString = "Data Source=" + tbxOtkydaIP.Text + "," + tbxOtkydaPORT.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + tbxOtkydaDB.Text + ";User ID =" + tbxOtkydaUSER.Text + ";Password=" + tbxOtkydaPASS.Text + ";";
                connOtkyda.Open();
                MessageBox.Show("Соединение установлено!");
                connOtkyda.Close();
            }
            catch (Exception Ex)
            {
                connOtkyda.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void BtnKydaTESTCon_Click(object sender, System.EventArgs e)
        {
            try
            {
                connKyda.ConnectionString = "Data Source=" + tbxKydaIP.Text + "," + tbxKydaPORT.Text + ";Network Library=DBMSSOCN;Initial Catalog=" + tbxKydaDB.Text + ";User ID =" + tbxKydaUSER.Text + ";Password=" + tbxKydaPASS.Text + ";";
                connKyda.Open();
                MessageBox.Show("Соединение установлено!");
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();

                MessageBox.Show(Ex.ToString());
            }
        }

        private void BtnClearRtbxLOG_Click(object sender, EventArgs e)
        {
            rtbxLOG.Clear();
        }

        private void Btn_TovarsOtkyda_Load_Click(object sender, EventArgs e)
        {
            string query =
            @"
                    SELECT
	                    SprTovar.KodGr,
	                    SprGrup.NameGr,
	                    SprTovar.KodPGr,
	                    SprPGrup.NamePGr,
	                    SprTovar.KodVid,
	                    SprVid.NameVid,
	                    SprVid.KodVed,
	                    SprTovar.KodR1,
	                    SprRaz1.NameR1,
	                    SprTovar.KodR2,
	                    SprRaz2.NameR2,
                        SprTovar.GlKod,
	                    SprTovar.NameT,
	                    SprTovar.PNT,
	                    SprTovar.NameTov,
	                    SprTovar.NameTovDop,
	                    SprTovar.Art,
                        SprTovar.IDColor,
                        tbColor.NameColor,
                        SprTovar.Model,
	                    SprTovar.Sizes,
	                    SprTovar.Hight,
	                    SprTovar.Sort,
	                    SprTovar.EdIzID,
	                    SprEdIz.EdIz,
	                    SprEdIz.NameEdIzm,
	                    SprEdIz.ShortNameEdizm,
	                    SprTovar.Protkl,
	                    SprTovar.Sertif,
	                    SprTovar.Sertif1,
	                    SprTovar.MinUp,
	                    SprTovar.Ves,
                        SprTovar.VidUp,
	                    SprTovar.Fasov,
	                    SprTovar.IDCountry,
	                    tbCountry.NameCountry,
	                    tbCountry.NameCountryShort,
	                    tbCountry.KodCountry,
	                    tbCountry.PriznZarub,
	                    SprTovar.PNTTar1,
	                    SprTovar.PNTTar2,
	                    SprTovar.Cen$,
	                    SprTovar.CenIzg,
	                    SprTovar.CenPriobr,
	                    SprTovar.CenO,
	                    SprTovar.SkidPost,
	                    SprTovar.Izder,
	                    SprTovar.Rentab,
	                    SprTovar.DatePrih,
	                    SprTovar.SrokGodn,
	                    SprTovar.IDPriznNac,
	                    tbPriznNac.NamePriznNac,
                        SprTovar.NacPosr,
	                    SprTovar.NDS,
	                    SprTovar.NalProd,
	                    SprTovar.NalTr,
	                    SprTovar.PriznSyria,
	                    SprTovar.Kompl,
	                    SprTovar.Jirn,
	                    SprTovar.PrSocZ,
	                    SprTovar.KolPor,
	                    SprTovar.Vlajn,
	                    SprTovar.PrMenu,
	                    SprTovar.PrSyrja,
	                    SprTovar.IDSort,
	                    SprTovar.BarKod,
	                    SprTovar.BarKodR,
	                    SprTovar.Sertif2,
	                    SprTovar.PrizBlok,
	                    SprTovar.TKoeff,
	                    SprTovar.IDPrizLog,
	                    SprTovar.BonusPok,
	                    SprTovar.BonusPost,
	                    SprTovar.PNTTar3,
	                    SprTovar.PrLogBKS,
	                    SprTovar.NalAkc,
	                    SprTovar.NalTrPost,
	                    SprTovar.EstimatedTotalPrice
                    FROM
	                    SprTovar
                    LEFT JOIN
	                    SprGrup ON SprTovar.KodGr = SprGrup.KodGr
                    LEFT JOIN
	                    SprPGrup ON SprTovar.KodPGr = SprPGrup.KodPGr
		                    AND
	                    SprTovar.KodGr = SprPGrup.KodGr
                    LEFT JOIN
	                    SprVid ON SprTovar.KodVid = SprVid.KodVid
		                    AND
	                    SprTovar.KodGr = SprVid.KodGr
		                    AND
	                    SprTovar.KodPGr = SprVid.KodPGr
                    LEFT JOIN
	                    SprRaz1 ON SprTovar.KodR1 = SprRaz1.KodR1
		                    AND
	                    SprTovar.KodGr = SprRaz1.KodGr
		                    AND
	                    SprTovar.KodPGr = SprRaz1.KodPGr
                    LEFT JOIN
	                    SprRaz2 ON SprTovar.KodR2 = SprRaz2.KodR2
		                    AND
	                    SprTovar.KodGr = SprRaz2.KodGr
		                    AND
	                    SprTovar.KodPGr = SprRaz2.KodPGr
                    LEFT JOIN
	                    tbColor ON SprTovar.IDColor = tbColor.IDColor
                    LEFT JOIN
                        SprEdIz ON SprTovar.EdIzID = SprEdIz.EdIzID
                    LEFT JOIN
	                    tbCountry ON SprTovar.IDCountry = tbCountry.IDCountry
                    LEFT JOIN
	                    tbPriznNac ON SprTovar.IDPriznNac = tbPriznNac.IDPriznNac
                    WHERE
	                    SprTovar.PNT IN (
		                    SELECT
			                    DISTINCT
				                    DocString.PNT
		                    FROM
			                    DocString
		                    WHERE
			                    DocString.IDDoc IN (
				                    SELECT
					                    DocCaption.IDDoc
				                    FROM
					                    DocCaption
				                    WHERE
					                    DocCaption.KodSkl= " + tbxIDSklOtkyda.Text + @"
						                    AND
					                    DocCaption.VidDoc = 1
			                    )
	                    )
                ";
            try
            {
                connOtkyda.Open();
                SqlCommand sqlCommand = new SqlCommand(query, connOtkyda);
                dataTableTovarsOtkyda.Clear();
                dataTableTovarsOtkyda.Columns.Clear();
                dataTableTovarsOtkyda.Columns.Add("KodGr");
                dataTableTovarsOtkyda.Columns.Add("NameGr");
                dataTableTovarsOtkyda.Columns.Add("KodPGr");
                dataTableTovarsOtkyda.Columns.Add("NamePGr");
                dataTableTovarsOtkyda.Columns.Add("KodVid");
                dataTableTovarsOtkyda.Columns.Add("NameVid");
                dataTableTovarsOtkyda.Columns.Add("KodVed");
                dataTableTovarsOtkyda.Columns.Add("KodR1");
                dataTableTovarsOtkyda.Columns.Add("NameR1");
                dataTableTovarsOtkyda.Columns.Add("KodR2");
                dataTableTovarsOtkyda.Columns.Add("NameR2");
                dataTableTovarsOtkyda.Columns.Add("GlKod");
                dataTableTovarsOtkyda.Columns.Add("NameT");
                dataTableTovarsOtkyda.Columns.Add("PNT");
                dataTableTovarsOtkyda.Columns.Add("NameTov");
                dataTableTovarsOtkyda.Columns.Add("NameTovDop");
                dataTableTovarsOtkyda.Columns.Add("Art");
                dataTableTovarsOtkyda.Columns.Add("IDColor");
                dataTableTovarsOtkyda.Columns.Add("NameColor");
                dataTableTovarsOtkyda.Columns.Add("Model");
                dataTableTovarsOtkyda.Columns.Add("Sizes");
                dataTableTovarsOtkyda.Columns.Add("Hight");
                dataTableTovarsOtkyda.Columns.Add("Sort");
                dataTableTovarsOtkyda.Columns.Add("EdIzID");
                dataTableTovarsOtkyda.Columns.Add("EdIz");
                dataTableTovarsOtkyda.Columns.Add("NameEdIzm");
                dataTableTovarsOtkyda.Columns.Add("ShortNameEdizm");
                dataTableTovarsOtkyda.Columns.Add("Protkl");
                dataTableTovarsOtkyda.Columns.Add("Sertif");
                dataTableTovarsOtkyda.Columns.Add("Sertif1");
                dataTableTovarsOtkyda.Columns.Add("MinUp");
                dataTableTovarsOtkyda.Columns.Add("Ves");
                dataTableTovarsOtkyda.Columns.Add("VidUp");
                dataTableTovarsOtkyda.Columns.Add("Fasov");
                dataTableTovarsOtkyda.Columns.Add("IDCountry");
                dataTableTovarsOtkyda.Columns.Add("NameCountry");
                dataTableTovarsOtkyda.Columns.Add("NameCountryShort");
                dataTableTovarsOtkyda.Columns.Add("KodCountry");
                dataTableTovarsOtkyda.Columns.Add("PriznZarub");
                dataTableTovarsOtkyda.Columns.Add("PNTTar1");
                dataTableTovarsOtkyda.Columns.Add("PNTTar2");
                dataTableTovarsOtkyda.Columns.Add("Cen$");
                dataTableTovarsOtkyda.Columns.Add("CenIzg");
                dataTableTovarsOtkyda.Columns.Add("CenPriobr");
                dataTableTovarsOtkyda.Columns.Add("CenO");
                dataTableTovarsOtkyda.Columns.Add("SkidPost");
                dataTableTovarsOtkyda.Columns.Add("Izder");
                dataTableTovarsOtkyda.Columns.Add("Rentab");
                dataTableTovarsOtkyda.Columns.Add("DatePrih");
                dataTableTovarsOtkyda.Columns.Add("SrokGodn");
                dataTableTovarsOtkyda.Columns.Add("IDPriznNac");
                dataTableTovarsOtkyda.Columns.Add("NamePriznNac");
                dataTableTovarsOtkyda.Columns.Add("NacPosr");
                dataTableTovarsOtkyda.Columns.Add("NDS");
                dataTableTovarsOtkyda.Columns.Add("NalProd");
                dataTableTovarsOtkyda.Columns.Add("NalTr");
                dataTableTovarsOtkyda.Columns.Add("PriznSyria");
                dataTableTovarsOtkyda.Columns.Add("Kompl");
                dataTableTovarsOtkyda.Columns.Add("Jirn");
                dataTableTovarsOtkyda.Columns.Add("PrSocZ");
                dataTableTovarsOtkyda.Columns.Add("KolPor");
                dataTableTovarsOtkyda.Columns.Add("Vlajn");
                dataTableTovarsOtkyda.Columns.Add("PrMenu");
                dataTableTovarsOtkyda.Columns.Add("PrSyrja");
                dataTableTovarsOtkyda.Columns.Add("IDSort");
                dataTableTovarsOtkyda.Columns.Add("BarKod");
                dataTableTovarsOtkyda.Columns.Add("BarKodR");
                dataTableTovarsOtkyda.Columns.Add("Sertif2");
                dataTableTovarsOtkyda.Columns.Add("PrizBlok");
                dataTableTovarsOtkyda.Columns.Add("TKoeff");
                dataTableTovarsOtkyda.Columns.Add("IDPrizLog");
                dataTableTovarsOtkyda.Columns.Add("BonusPok");
                dataTableTovarsOtkyda.Columns.Add("BonusPost");
                dataTableTovarsOtkyda.Columns.Add("PNTTar3");
                dataTableTovarsOtkyda.Columns.Add("PrLogBKS");
                dataTableTovarsOtkyda.Columns.Add("NalAkc");
                dataTableTovarsOtkyda.Columns.Add("NalTrPost");
                dataTableTovarsOtkyda.Columns.Add("EstimatedTotalPrice");

                using (SqlDataReader sqlDataReader = sqlCommand.ExecuteReader())
                {
                    while (sqlDataReader.Read())
                    {
                        DataRow dataRow = dataTableTovarsOtkyda.NewRow();
                        dataRow["KodGr"] = sqlDataReader["KodGr"].ToString();
                        dataRow["NameGr"] = sqlDataReader["NameGr"].ToString();
                        dataRow["KodPGr"] = sqlDataReader["KodPGr"].ToString();
                        dataRow["NamePGr"] = sqlDataReader["NamePGr"].ToString();
                        dataRow["KodVid"] = sqlDataReader["KodVid"].ToString();
                        dataRow["NameVid"] = sqlDataReader["NameVid"].ToString();
                        dataRow["KodVed"] = sqlDataReader["KodVed"].ToString();
                        dataRow["KodR1"] = sqlDataReader["KodR1"].ToString();
                        dataRow["NameR1"] = sqlDataReader["NameR1"].ToString();
                        dataRow["KodR2"] = sqlDataReader["KodR2"].ToString();
                        dataRow["NameR2"] = sqlDataReader["NameR2"].ToString();
                        dataRow["GlKod"] = sqlDataReader["GlKod"].ToString();
                        dataRow["NameT"] = sqlDataReader["NameT"].ToString();
                        dataRow["PNT"] = sqlDataReader["PNT"].ToString();
                        dataRow["NameTov"] = sqlDataReader["NameTov"].ToString();
                        dataRow["NameTovDop"] = sqlDataReader["NameTovDop"].ToString();
                        dataRow["Art"] = sqlDataReader["Art"].ToString();
                        dataRow["IDColor"] = sqlDataReader["IDColor"].ToString();
                        dataRow["NameColor"] = sqlDataReader["NameColor"].ToString();
                        dataRow["Model"] = sqlDataReader["Model"].ToString();
                        dataRow["Sizes"] = sqlDataReader["Sizes"].ToString();
                        dataRow["Hight"] = sqlDataReader["Hight"].ToString();
                        dataRow["Sort"] = sqlDataReader["Sort"].ToString();
                        dataRow["EdIzID"] = sqlDataReader["EdIzID"].ToString();
                        dataRow["EdIz"] = sqlDataReader["EdIz"].ToString();
                        dataRow["NameEdIzm"] = sqlDataReader["NameEdIzm"].ToString();
                        dataRow["ShortNameEdizm"] = sqlDataReader["ShortNameEdizm"].ToString();
                        dataRow["Protkl"] = sqlDataReader["Protkl"].ToString();
                        dataRow["Sertif"] = sqlDataReader["Sertif"].ToString();
                        dataRow["Sertif1"] = sqlDataReader["Sertif1"].ToString();
                        dataRow["MinUp"] = sqlDataReader["MinUp"].ToString();
                        dataRow["Ves"] = sqlDataReader["Ves"].ToString();
                        dataRow["VidUp"] = sqlDataReader["VidUp"].ToString();
                        dataRow["Fasov"] = sqlDataReader["Fasov"].ToString();
                        dataRow["IDCountry"] = sqlDataReader["IDCountry"].ToString();
                        dataRow["NameCountry"] = sqlDataReader["NameCountry"].ToString();
                        dataRow["NameCountryShort"] = sqlDataReader["NameCountryShort"].ToString();
                        dataRow["KodCountry"] = sqlDataReader["KodCountry"].ToString();
                        dataRow["PriznZarub"] = sqlDataReader["PriznZarub"].ToString();
                        dataRow["PNTTar1"] = sqlDataReader["PNTTar1"].ToString();
                        dataRow["PNTTar2"] = sqlDataReader["PNTTar2"].ToString();
                        dataRow["Cen$"] = sqlDataReader["Cen$"].ToString();
                        dataRow["CenIzg"] = sqlDataReader["CenIzg"].ToString();
                        dataRow["CenPriobr"] = sqlDataReader["CenPriobr"].ToString();
                        dataRow["CenO"] = sqlDataReader["CenO"].ToString();
                        dataRow["SkidPost"] = sqlDataReader["SkidPost"].ToString();
                        dataRow["Izder"] = sqlDataReader["Izder"].ToString();
                        dataRow["Rentab"] = sqlDataReader["Rentab"].ToString();
                        dataRow["DatePrih"] = sqlDataReader["DatePrih"].ToString();
                        dataRow["SrokGodn"] = sqlDataReader["SrokGodn"].ToString();
                        dataRow["IDPriznNac"] = sqlDataReader["IDPriznNac"].ToString();
                        dataRow["NamePriznNac"] = sqlDataReader["NamePriznNac"].ToString();
                        dataRow["NacPosr"] = sqlDataReader["NacPosr"].ToString();
                        dataRow["NDS"] = sqlDataReader["NDS"].ToString();
                        dataRow["NalProd"] = sqlDataReader["NalProd"].ToString();
                        dataRow["NalTr"] = sqlDataReader["NalTr"].ToString();
                        dataRow["PriznSyria"] = sqlDataReader["PriznSyria"].ToString();
                        dataRow["Kompl"] = sqlDataReader["Kompl"].ToString();
                        dataRow["Jirn"] = sqlDataReader["Jirn"].ToString();
                        dataRow["PrSocZ"] = sqlDataReader["PrSocZ"].ToString();
                        dataRow["KolPor"] = sqlDataReader["KolPor"].ToString();
                        dataRow["Vlajn"] = sqlDataReader["Vlajn"].ToString();
                        dataRow["PrMenu"] = sqlDataReader["PrMenu"].ToString();
                        dataRow["PrSyrja"] = sqlDataReader["PrSyrja"].ToString();
                        dataRow["IDSort"] = sqlDataReader["IDSort"].ToString();
                        dataRow["BarKod"] = sqlDataReader["BarKod"].ToString();
                        dataRow["BarKodR"] = sqlDataReader["BarKodR"].ToString();
                        dataRow["Sertif2"] = sqlDataReader["Sertif2"].ToString();
                        dataRow["PrizBlok"] = sqlDataReader["PrizBlok"].ToString();
                        dataRow["TKoeff"] = sqlDataReader["TKoeff"].ToString();
                        dataRow["IDPrizLog"] = sqlDataReader["IDPrizLog"].ToString();
                        dataRow["BonusPok"] = sqlDataReader["BonusPok"].ToString();
                        dataRow["BonusPost"] = sqlDataReader["BonusPost"].ToString();
                        dataRow["PNTTar3"] = sqlDataReader["PNTTar3"].ToString();
                        dataRow["PrLogBKS"] = sqlDataReader["PrLogBKS"].ToString();
                        dataRow["NalAkc"] = sqlDataReader["NalAkc"].ToString();
                        dataRow["NalTrPost"] = sqlDataReader["NalTrPost"].ToString();
                        dataRow["EstimatedTotalPrice"] = sqlDataReader["EstimatedTotalPrice"].ToString();

                        dataTableTovarsOtkyda.Rows.Add(dataRow);
                    }
                }
                if (cbx_ENABLE_LOG.Checked == true)
                {
                    int i = 1;
                    rtbxLOG.Text += "ТОВАРЫ ОТКУДА" + Environment.NewLine;
                    foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
                    {
                        rtbxLOG.Text += "  [" + i + "] --- " +
                            dataRow["KodGr"].ToString() + " | " +
                            dataRow["NameGr"].ToString() + " | " +
                            dataRow["KodPGr"].ToString() + " | " +
                            dataRow["NamePGr"].ToString() + " | " +
                            dataRow["KodVid"].ToString() + " | " +
                            dataRow["NameVid"].ToString() + " | " +
                            dataRow["KodVed"].ToString() + " | " +
                            dataRow["KodR1"].ToString() + " | " +
                            dataRow["NameR1"].ToString() + " | " +
                            dataRow["KodR2"].ToString() + " | " +
                            dataRow["NameR2"].ToString() +
                            dataRow["GlKod"].ToString() + " | " +
                            dataRow["NameT"].ToString() + " | " +
                            dataRow["PNT"].ToString() + " | " +
                            dataRow["NameTov"].ToString() + " | " +
                            dataRow["NameTovDop"].ToString() + " | " +
                            dataRow["Art"].ToString() + " | " +
                            dataRow["IDColor"].ToString() + " | " +
                            dataRow["NameColor"].ToString() + " | " +
                            dataRow["Model"].ToString() + " | " +
                            dataRow["Sizes"].ToString() + " | " +
                            dataRow["Hight"].ToString() + " | " +
                            dataRow["Sort"].ToString() + " | " +
                            dataRow["EdIzID"].ToString() + " | " +
                            dataRow["EdIz"].ToString() + " | " +
                            dataRow["NameEdIzm"].ToString() + " | " +
                            dataRow["ShortNameEdizm"].ToString() + " | " +
                            dataRow["Protkl"].ToString() + " | " +
                            dataRow["Sertif"].ToString() + " | " +
                            dataRow["Sertif1"].ToString() + " | " +
                            dataRow["MinUp"].ToString() + " | " +
                            dataRow["Ves"].ToString() + " | " +
                            dataRow["VidUp"].ToString() + " | " +
                            dataRow["Fasov"].ToString() + " | " +
                            dataRow["IDCountry"].ToString() + " | " +
                            dataRow["NameCountry"].ToString() + " | " +
                            dataRow["NameCountryShort"].ToString() + " | " +
                            dataRow["KodCountry"].ToString() + " | " +
                            dataRow["PriznZarub"].ToString() + " | " +
                            dataRow["PNTTar1"].ToString() + " | " +
                            dataRow["PNTTar2"].ToString() + " | " +
                            dataRow["Cen$"].ToString() + " | " +
                            dataRow["CenIzg"].ToString() + " | " +
                            dataRow["CenPriobr"].ToString() + " | " +
                            dataRow["CenO"].ToString() + " | " +
                            dataRow["SkidPost"].ToString() + " | " +
                            dataRow["Izder"].ToString() + " | " +
                            dataRow["Rentab"].ToString() + " | " +
                            dataRow["DatePrih"].ToString() + " | " +
                            dataRow["SrokGodn"].ToString() + " | " +
                            dataRow["IDPriznNac"].ToString() + " | " +
                            dataRow["NamePriznNac"].ToString() + " | " +
                            dataRow["NacPosr"].ToString() + " | " +
                            dataRow["NDS"].ToString() + " | " +
                            dataRow["NalProd"].ToString() + " | " +
                            dataRow["NalTr"].ToString() + " | " +
                            dataRow["PriznSyria"].ToString() + " | " +
                            dataRow["Kompl"].ToString() + " | " +
                            dataRow["Jirn"].ToString() + " | " +
                            dataRow["PrSocZ"].ToString() + " | " +
                            dataRow["KolPor"].ToString() + " | " +
                            dataRow["Vlajn"].ToString() + " | " +
                            dataRow["PrMenu"].ToString() + " | " +
                            dataRow["PrSyrja"].ToString() + " | " +
                            dataRow["IDSort"].ToString() + " | " +
                            dataRow["BarKod"].ToString() + " | " +
                            dataRow["BarKodR"].ToString() + " | " +
                            dataRow["Sertif2"].ToString() + " | " +
                            dataRow["PrizBlok"].ToString() + " | " +
                            dataRow["TKoeff"].ToString() + " | " +
                            dataRow["IDPrizLog"].ToString() + " | " +
                            dataRow["BonusPok"].ToString() + " | " +
                            dataRow["BonusPost"].ToString() + " | " +
                            dataRow["PNTTar3"].ToString() + " | " +
                            dataRow["PrLogBKS"].ToString() + " | " +
                            dataRow["NalAkc"].ToString() + " | " +
                            dataRow["NalTrPost"].ToString() + " | " +
                            dataRow["EstimatedTotalPrice"].ToString() + Environment.NewLine;
                        i++;
                    }
                }
                connOtkyda.Close();
            }
            catch (Exception Ex)
            {
                connOtkyda.Close();
                MessageBox.Show(Ex.ToString());
            }

            query =
            @"
                    SELECT
	                    Nacenki.KodGr,
                        SprGrup.NameGr,
	                    Nacenki.KodPGr,
                        SprPGrup.NamePGr,
	                    Nacenki.IDPriznNac,
	                    tbPriznNac.NamePriznNac,
	                    Nacenki.IDPriznPartn,
	                    tbPriznPartn.NamePriznPartn,
	                    tbPriznPartn.PrPech,
	                    Nacenki.NacOpt,
	                    Nacenki.NacRozn,
	                    Nacenki.NacObpit,
	                    Nacenki.SkidPokup,
	                    Nacenki.NalAkc
                    FROM
	                    Nacenki
                    LEFT JOIN
	                    SprGrup ON Nacenki.KodGr = SprGrup.KodGr
                    LEFT JOIN
	                    SprPGrup ON Nacenki.KodPGr = SprPGrup.KodPGr
		                    AND
	                    Nacenki.KodGr = SprPGrup.KodGr
                    LEFT JOIN
	                    tbPriznNac ON Nacenki.IDPriznNac = tbPriznNac.IDPriznNac
                    LEFT JOIN
	                    tbPriznPartn ON Nacenki.IDPriznPartn = tbPriznPartn.IDPriznPartn
                    WHERE
	                    Nacenki.IDPriznNac IN (
		                    SELECT
			                    DISTINCT
				                    SprTovar.IDPriznNac
		                    FROM
			                    SprTovar
		                    WHERE
			                    SprTovar.PNT IN (
				                    SELECT
					                    DISTINCT
						                    DocString.PNT
				                    FROM
					                    DocString
				                    WHERE
					                    DocString.IDDoc IN (
						                    SELECT
							                    DocCaption.IDDoc
						                    FROM
							                    DocCaption
						                    WHERE
							                    DocCaption.KodSkl= " + tbxIDSklOtkyda.Text + @"
								                    AND
							                    DocCaption.VidDoc = 1
					                    )
			                    )
	                    )
                ";
            try
            {
                connOtkyda.Open();
                SqlCommand sqlCommand = new SqlCommand(query, connOtkyda);
                dataTableNacenkiOtkyda.Clear();
                dataTableNacenkiOtkyda.Columns.Clear();
                dataTableNacenkiOtkyda.Columns.Add("KodGr");
                dataTableNacenkiOtkyda.Columns.Add("NameGr");
                dataTableNacenkiOtkyda.Columns.Add("KodPGr");
                dataTableNacenkiOtkyda.Columns.Add("NamePGr");
                dataTableNacenkiOtkyda.Columns.Add("IDPriznNac");
                dataTableNacenkiOtkyda.Columns.Add("NamePriznNac");
                dataTableNacenkiOtkyda.Columns.Add("IDPriznPartn");
                dataTableNacenkiOtkyda.Columns.Add("NamePriznPartn");
                dataTableNacenkiOtkyda.Columns.Add("PrPech");
                dataTableNacenkiOtkyda.Columns.Add("NacOpt");
                dataTableNacenkiOtkyda.Columns.Add("NacRozn");
                dataTableNacenkiOtkyda.Columns.Add("NacObpit");
                dataTableNacenkiOtkyda.Columns.Add("SkidPokup");
                dataTableNacenkiOtkyda.Columns.Add("NalAkc");

                using (SqlDataReader sqlDataReader = sqlCommand.ExecuteReader())
                {
                    while (sqlDataReader.Read())
                    {
                        DataRow dataRow = dataTableNacenkiOtkyda.NewRow();
                        dataRow["KodGr"] = sqlDataReader["KodGr"].ToString();
                        dataRow["NameGr"] = sqlDataReader["NameGr"].ToString();
                        dataRow["KodPGr"] = sqlDataReader["KodPGr"].ToString();
                        dataRow["NamePGr"] = sqlDataReader["NamePGr"].ToString();
                        dataRow["IDPriznNac"] = sqlDataReader["IDPriznNac"].ToString();
                        dataRow["NamePriznNac"] = sqlDataReader["NamePriznNac"].ToString();
                        dataRow["IDPriznPartn"] = sqlDataReader["IDPriznPartn"].ToString();
                        dataRow["NamePriznPartn"] = sqlDataReader["NamePriznPartn"].ToString();
                        dataRow["PrPech"] = sqlDataReader["PrPech"].ToString();
                        dataRow["NacOpt"] = sqlDataReader["NacOpt"].ToString();
                        dataRow["NacRozn"] = sqlDataReader["NacRozn"].ToString();
                        dataRow["NacObpit"] = sqlDataReader["NacObpit"].ToString();
                        dataRow["SkidPokup"] = sqlDataReader["SkidPokup"].ToString();
                        dataRow["NalAkc"] = sqlDataReader["NalAkc"].ToString();

                        dataTableNacenkiOtkyda.Rows.Add(dataRow);
                    }
                }
                if (cbx_ENABLE_LOG.Checked == true)
                {
                    int i = 1;
                    rtbxLOG.Text += "НАЦЕНКИ ОТКУДА" + Environment.NewLine;
                    foreach (DataRow dataRow in dataTableNacenkiOtkyda.Rows)
                    {
                        rtbxLOG.Text += "  [" + i + "] --- " +
                            dataRow["KodGr"].ToString() + " | " +
                            dataRow["NameGr"].ToString() + " | " +
                            dataRow["KodPGr"].ToString() + " | " +
                            dataRow["NamePGr"].ToString() + " | " +
                            dataRow["IDPriznNac"].ToString() + " | " +
                            dataRow["NamePriznNac"].ToString() + " | " +
                            dataRow["IDPriznPartn"].ToString() + " | " +
                            dataRow["NamePriznPartn"].ToString() + " | " +
                            dataRow["PrPech"].ToString() + " | " +
                            dataRow["NacOpt"].ToString() + " | " +
                            dataRow["NacRozn"].ToString() + " | " +
                            dataRow["NacObpit"].ToString() + " | " +
                            dataRow["SkidPokup"].ToString() + " | " +
                            dataRow["NalAkc"].ToString() + Environment.NewLine;
                        i++;
                    }
                }
                connOtkyda.Close();
            }
            catch (Exception Ex)
            {
                connOtkyda.Close();
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Btn_info_skip_Click(object sender, EventArgs e)
        {
            MessageBox.Show("IDPredpr (пусто в Ушачах), EdIzDID (пусто в Ушачах), IDPost (пропустил), IDKoeff (пропустил) IN SprTovar." +
                           " tbPriznPartnPech (пусто в Ушачах)");
            MessageBox.Show("IDSpec (пусто везде) IN SprTovar." +
                           " tbSort (везде одинаково), " +
                           " SprPriznSyria (везде одинаково)");
            MessageBox.Show("Создание тары (пусто в Ушачах)");
        }

        private void Btn_Create_KodGr_SprGrup_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString());
            }
        }

        private string CreateAndGet_KodGr_SprGrup_Kyda(string NameGrIn)
        {
            string KodGr = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprGrup WHERE NameGr = '" + NameGrIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(KodGr) FROM SprGrup", connKyda
                    );
                    int KodGrMax = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ ГРУПП КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  KodGr = " + (KodGrMax + 1) + " | NameGr = " + NameGrIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprGrup (KodGr, NameGr) VALUES (" + (KodGrMax + 1) + ", '" + NameGrIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodGr FROM SprGrup WHERE NameGr = '" + NameGrIn + "'", connKyda
                    );
                    KodGr = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodGr FROM SprGrup WHERE NameGr = '" + NameGrIn + "'", connKyda
                    );
                    KodGr = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return KodGr;
        }

        private void Btn_Create_KodPGr_SprPGrup_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString());
            }
        }

        private string CreateAndGet_KodPGr_SprPGrup_Kyda(string KodGrIn, string NamePGrIn)
        {
            string KodPGr = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprPGrup WHERE KodGr = " + KodGrIn + " AND NamePGr = '" + NamePGrIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(KodPGr) FROM SprPGrup", connKyda
                    );
                    int KodPGrMax = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ ПОДГРУПП КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  KodGr = " + KodGrIn + " | KodPGr = " + (KodPGrMax + 1) + " | NamePGr = " + NamePGrIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprPGrup (KodGr, KodPGr, NamePGr) VALUES (" + KodGrIn + ", " + (KodPGrMax + 1) + ", '" + NamePGrIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodPGr FROM SprPGrup WHERE KodGr = " + KodGrIn + " AND NamePGr = '" + NamePGrIn + "'", connKyda
                    );
                    KodPGr = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodPGr FROM SprPGrup WHERE KodGr = " + KodGrIn + " AND NamePGr = '" + NamePGrIn + "'", connKyda
                    );
                    KodPGr = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return KodPGr;
        }

        private void Btn_Create_KodVid_SprVid_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_KodVid_SprVid_Kyda
                (
                    CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                    CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                    dataRow["NameVid"].ToString()
                );
            }
        }

        private string CreateAndGet_KodVid_SprVid_Kyda(string KodGrIn, string KodPGrIn, string NameVidIn)
        {
            string KodVid = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprVid WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameVid = '" + NameVidIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(KodVid) FROM SprVid", connKyda
                    );
                    int KodVidMax = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ ВИДОВ КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  KodGr = " + KodGrIn + " | KodPGr = " + KodPGrIn + " | KodVid = " + (KodVidMax + 1) + " | NameVid = " + NameVidIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprVid (KodGr, KodPGr, KodVid, NameVid) VALUES (" + KodGrIn + ", " + KodPGrIn + ", " + (KodVidMax + 1) + ", '" + NameVidIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodVid FROM SprVid WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameVid = '" + NameVidIn + "'", connKyda
                    );
                    KodVid = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodVid FROM SprVid WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameVid = '" + NameVidIn + "'", connKyda
                    );
                    KodVid = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return KodVid;
        }

        private void Btn_Create_KodR1_SprRaz1_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_KodR1_SprRaz1_Kyda
                (
                    CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                    CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                    dataRow["NameR1"].ToString()
                );
            }
        }

        private string CreateAndGet_KodR1_SprRaz1_Kyda(string KodGrIn, string KodPGrIn, string NameR1In)
        {
            string KodR1 = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprRaz1 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR1 = '" + NameR1In + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(KodR1) FROM SprRaz1", connKyda
                    );
                    int KodR1Max = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ RAZ1 КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  KodGr = " + KodGrIn + " | KodPGr = " + KodPGrIn + " | KodR1 = " + (KodR1Max + 1) + " | NameR1 = " + NameR1In + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprRaz1 (KodGr, KodPGr, KodR1, NameR1) VALUES (" + KodGrIn + ", " + KodPGrIn + ", " + (KodR1Max + 1) + ", '" + NameR1In + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodR1 FROM SprRaz1 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR1 = '" + NameR1In + "'", connKyda
                    );
                    KodR1 = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodR1 FROM SprRaz1 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR1 = '" + NameR1In + "'", connKyda
                    );
                    KodR1 = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return KodR1;
        }

        private void Btn_Create_KodR2_SprRaz2_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_KodR2_SprRaz2_Kyda
                (
                    CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                    CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                    dataRow["NameR2"].ToString()
                );
            }
        }

        private string CreateAndGet_KodR2_SprRaz2_Kyda(string KodGrIn, string KodPGrIn, string NameR2In)
        {
            string KodR2 = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprRaz2 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR2 = '" + NameR2In + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(KodR2) FROM SprRaz2", connKyda
                    );
                    int KodR2Max = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ RAZ2 КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  KodGr = " + KodGrIn + " | KodPGr = " + KodPGrIn + " | KodR2 = " + (KodR2Max + 1) + " | NameR2 = " + NameR2In + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprRaz2 (KodGr, KodPGr, KodR2, NameR2) VALUES (" + KodGrIn + ", " + KodPGrIn + ", " + (KodR2Max + 1) + ", '" + NameR2In + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodR2 FROM SprRaz2 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR2 = '" + NameR2In + "'", connKyda
                    );
                    KodR2 = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT KodR2 FROM SprRaz2 WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND NameR2 = '" + NameR2In + "'", connKyda
                    );
                    KodR2 = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return KodR2;
        }

        private void Btn_Create_IDColor_tbColor_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                CreateAndGet_IDColor_tbColor_Kyda(dataRow["NameColor"].ToString());
            }
        }

        private string CreateAndGet_IDColor_tbColor_Kyda(string NameColorIn)
        {
            string IDColor = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM tbColor WHERE NameColor = '" + NameColorIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    rtbxLOG.Text += "СОЗДАНИЕ ЦВЕТОВ КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  NameColor = " + NameColorIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO tbColor (NameColor) VALUES ('" + NameColorIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDColor FROM tbColor WHERE NameColor = '" + NameColorIn + "'", connKyda
                    );
                    IDColor = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDColor FROM tbColor WHERE NameColor = '" + NameColorIn + "'", connKyda
                    );
                    IDColor = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return IDColor;
        }

        private void Btn_Create_EdIzID_SprEdIz_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                Create_EdIzID_SprEdIz_Kyda(dataRow["EdIz"].ToString(), dataRow["NameEdIzm"].ToString(), dataRow["ShortNameEdizm"].ToString());
            }
        }

        private string Create_EdIzID_SprEdIz_Kyda(string EdIzIn, string NameEdIzmIn, string ShortNameEdizmIn)
        {
            string EdIzID = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprEdIz WHERE EdIz = '" + EdIzIn + "' AND NameEdIzm = '" + NameEdIzmIn + "' AND ShortNameEdizm = '" + ShortNameEdizmIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    sqlCommand = new SqlCommand
                    (
                       "SELECT MAX(EdIzID) FROM SprEdIz", connKyda
                    );
                    int EdIzIDMax = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                    rtbxLOG.Text += "СОЗДАНИЕ ЕДИНИЦЫ ИЗМЕРЕНИЙ КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  EdIzID = " + (EdIzIDMax + 1) + " | EdIz = " + EdIzIn + " | NameEdIzm = " + NameEdIzmIn + " | ShortNameEdizm = " + ShortNameEdizmIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO SprEdIz (EdIzID, EdIz, NameEdIzm, ShortNameEdizm) VALUES (" + (EdIzIDMax + 1) + ", '" + EdIzIn + "', '" + NameEdIzmIn + "', '" + ShortNameEdizmIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT EdIzID FROM SprEdIz WHERE EdIz = '" + EdIzIn + "' AND NameEdIzm = '" + NameEdIzmIn + "' AND ShortNameEdizm = '" + ShortNameEdizmIn + "'", connKyda
                    );
                    EdIzID = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT EdIzID FROM SprEdIz WHERE EdIz = '" + EdIzIn + "' AND NameEdIzm = '" + NameEdIzmIn + "' AND ShortNameEdizm = '" + ShortNameEdizmIn + "'", connKyda
                    );
                    EdIzID = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return EdIzID;
        }

        private void Btn_Create_IDCountry_tbCountry_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                Create_IDCountry_tbCountry_Kyda(dataRow["NameCountry"].ToString(), dataRow["NameCountryShort"].ToString(), dataRow["KodCountry"].ToString(), dataRow["PriznZarub"].ToString());
            }
        }

        private string Create_IDCountry_tbCountry_Kyda(string NameCountryIn, string NameCountryShortIn, string KodCountryIn, string PriznZarubIn)
        {
            string IDCountry = "";
            try
            {
                connKyda.Open();

                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "' AND PriznZarub = " + PriznZarubIn, connKyda
                );
                if (PriznZarubIn == "")
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT COUNT(*) FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "'", connKyda
                    );
                }
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    rtbxLOG.Text += "СОЗДАНИЕ СТРАН КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  NameCountry = " + NameCountryIn + " | NameCountryShort = " + NameCountryShortIn + " | KodCountry = " + KodCountryIn + " | PriznZarub = " + PriznZarubIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO tbCountry (NameCountry, NameCountryShort, KodCountry, PriznZarub) VALUES ('" + NameCountryIn + "', '" + NameCountryShortIn + "', '" + KodCountryIn + "', " + PriznZarubIn + ")", connKyda
                    );
                    if (PriznZarubIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                            "INSERT INTO tbCountry (NameCountry, NameCountryShort, KodCountry) VALUES ('" + NameCountryIn + "', '" + NameCountryShortIn + "', '" + KodCountryIn + "')", connKyda
                        );
                    }
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                         "SELECT IDCountry FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "' AND PriznZarub = " + PriznZarubIn, connKyda
                    );
                    if (PriznZarubIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                             "SELECT IDCountry FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "'", connKyda
                        );
                    }
                    IDCountry = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                         "SELECT IDCountry FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "' AND PriznZarub = " + PriznZarubIn, connKyda
                    );
                    if (PriznZarubIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                             "SELECT IDCountry FROM tbCountry WHERE NameCountry = '" + NameCountryIn + "' AND NameCountryShort = '" + NameCountryShortIn + "' AND KodCountry = '" + KodCountryIn + "'", connKyda
                        );
                    }
                    IDCountry = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return IDCountry;
        }

        private void Btn_Create_PNTTar1_SprTovar_Kyda_Click(object sender, EventArgs e)
        {
            int PNTTar1Count = 0;
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                if (dataRow["PNTTar1"].ToString() != "")
                {
                    PNTTar1Count++;
                }
            }
            MessageBox.Show(PNTTar1Count.ToString());
        }

        private void Btn_Create_PNTTar2_SprTovar_Kyda_Click(object sender, EventArgs e)
        {
            int PNTTar2Count = 0;
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                if (dataRow["PNTTar2"].ToString() != "")
                {
                    PNTTar2Count++;
                }
            }
            MessageBox.Show(PNTTar2Count.ToString());
        }

        private void Btn_Create_IDPriznNac_tbPriznNac_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                Create_IDPriznNac_tbPriznNac_Kyda(dataRow["NamePriznNac"].ToString());
            }
        }

        private string Create_IDPriznNac_tbPriznNac_Kyda(string NamePriznNacIn)
        {
            string IDPriznNac = "";
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM tbPriznNac WHERE NamePriznNac = '" + NamePriznNacIn + "'", connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    rtbxLOG.Text += "СОЗДАНИЕ IDPriznNac КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  NamePriznNac = " + NamePriznNacIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO tbPriznNac (NamePriznNac) VALUES ('" + NamePriznNacIn + "')", connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDPriznNac FROM tbPriznNac WHERE NamePriznNac = '" + NamePriznNacIn + "'", connKyda
                    );
                    IDPriznNac = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDPriznNac FROM tbPriznNac WHERE NamePriznNac = '" + NamePriznNacIn + "'", connKyda
                    );
                    IDPriznNac = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return IDPriznNac;
        }

        private void Btn_Create_IDPriznPartn_tbPriznPartn_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableNacenkiOtkyda.Rows)
            {
                Create_IDPriznPartn_tbPriznPartn_Kyda(dataRow["NamePriznPartn"].ToString(), dataRow["PrPech"].ToString());
            }
        }

        private string Create_IDPriznPartn_tbPriznPartn_Kyda(string NamePriznPartnIn, string PrPechIn)
        {
            string IDPriznPartn = "";

            if (PrPechIn == "True")
            {
                PrPechIn = "1";
            }
            if (PrPechIn == "False")
            {
                PrPechIn = "0";
            }
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "' AND PrPech = '" + PrPechIn + "'", connKyda
                );
                if (PrPechIn == "")
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT COUNT(*) FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "'", connKyda
                    );
                }
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    rtbxLOG.Text += "СОЗДАНИЕ IDPriznPartn КУДА" + Environment.NewLine;
                    rtbxLOG.Text += "  NamePriznPartn = " + NamePriznPartnIn + " | PrPech = " + PrPechIn + Environment.NewLine;
                    sqlCommand = new SqlCommand
                    (
                        "INSERT INTO tbPriznPartn (NamePriznPartn, PrPech) VALUES ('" + NamePriznPartnIn + "', '" + PrPechIn + "')", connKyda
                    );
                    if (PrPechIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                            "INSERT INTO tbPriznPartn (NamePriznPartn) VALUES ('" + NamePriznPartnIn + "')", connKyda
                        );
                    }
                    sqlCommand.ExecuteNonQuery();
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDPriznPartn FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "' AND PrPech = '" + PrPechIn + "'", connKyda
                    );
                    if (PrPechIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                            "SELECT IDPriznPartn FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "'", connKyda
                        );
                    }
                    IDPriznPartn = sqlCommand.ExecuteScalar().ToString();
                }
                else
                {
                    sqlCommand = new SqlCommand
                    (
                        "SELECT IDPriznPartn FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "' AND PrPech = '" + PrPechIn + "'", connKyda
                    );
                    if (PrPechIn == "")
                    {
                        sqlCommand = new SqlCommand
                        (
                            "SELECT IDPriznPartn FROM tbPriznPartn WHERE NamePriznPartn = '" + NamePriznPartnIn + "'", connKyda
                        );
                    }
                    IDPriznPartn = sqlCommand.ExecuteScalar().ToString();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
            return IDPriznPartn;
        }

        private void Btn_Create_Nacenki_Nacenki_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableNacenkiOtkyda.Rows)
            {
                Create_Nacenki_Nacenki_Kyda
                (
                    CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                    CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                    Create_IDPriznNac_tbPriznNac_Kyda(dataRow["NamePriznNac"].ToString()),
                    Create_IDPriznPartn_tbPriznPartn_Kyda(dataRow["NamePriznPartn"].ToString(), dataRow["PrPech"].ToString()),
                    dataRow["NacOpt"].ToString(),
                    dataRow["NacRozn"].ToString(),
                    dataRow["NacObpit"].ToString(),
                    dataRow["SkidPokup"].ToString(),
                    dataRow["NalAkc"].ToString()
                );
            }
        }

        private void Create_Nacenki_Nacenki_Kyda(string KodGrIn, string KodPGrIn, string IDPriznNacIn, string IDPriznPartnIn, string NacOptIn, string NacRoznIn, string NacObpitIn, string SkidPokupIn, string NalAkcIn)
        {
            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM Nacenki WHERE KodGr = " + KodGrIn + " AND KodPGr = " + KodPGrIn + " AND IDPriznNac = " + IDPriznNacIn + " AND IDPriznPartn = " + IDPriznPartnIn, connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    if (cbx_ENABLE_LOG.Checked == true)
                    {
                        rtbxLOG.Text += "СОЗДАНИЕ Nacenki КУДА" + Environment.NewLine;
                        rtbxLOG.Text += "  KodGr = " + KodGrIn + " | KodPGr = " + KodPGrIn + " | IDPriznNac = " + IDPriznNacIn + " | IDPriznPartn = " + IDPriznPartnIn + Environment.NewLine;
                    }
                    string queryColumns = "INSERT INTO Nacenki (KodGr, KodPGr, IDPriznNac, IDPriznPartn";
                    string queryValues = ") VALUES (" + KodGrIn + ", " + KodPGrIn + ", " + IDPriznNacIn + ", " + IDPriznPartnIn;
                    if (NacOptIn != "")
                    {
                        queryColumns += ", NacOpt";
                        queryValues += ", " + NacOptIn;
                    }
                    if (NacRoznIn != "")
                    {
                        queryColumns += ", NacRozn";
                        queryValues += ", " + NacRoznIn;
                    }
                    if (NacObpitIn != "")
                    {
                        queryColumns += ", NacObpit";
                        queryValues += ", " + NacObpitIn;
                    }
                    if (SkidPokupIn != "")
                    {
                        queryColumns += ", SkidPokup";
                        queryValues += ", " + SkidPokupIn;
                    }
                    if (NalAkcIn != "")
                    {
                        queryColumns += ", NalAkc";
                        queryValues += ", " + NalAkcIn;
                    }
                    string query = queryColumns + queryValues + ")";
                    sqlCommand = new SqlCommand
                    (
                        query, connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
        }

        private void Btn_Create_SprTovar_SprTovar_Kyda_Click(object sender, EventArgs e)
        {
            foreach (DataRow dataRow in dataTableTovarsOtkyda.Rows)
            {
                Create_SprTovar_SprTovar_Kyda
                (
                    dataRow["PNT"].ToString(),
                    CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                    CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                    CreateAndGet_KodVid_SprVid_Kyda
                    (
                        CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                        CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                        dataRow["NameVid"].ToString()
                    ),
                    CreateAndGet_KodR1_SprRaz1_Kyda
                    (
                        CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                        CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                        dataRow["NameR1"].ToString()
                    ),
                    CreateAndGet_KodR2_SprRaz2_Kyda
                    (
                        CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()),
                        CreateAndGet_KodPGr_SprPGrup_Kyda(CreateAndGet_KodGr_SprGrup_Kyda(dataRow["NameGr"].ToString()), dataRow["NamePGr"].ToString()),
                        dataRow["NameR2"].ToString()
                    ),
                    dataRow["GlKod"].ToString(),
                    dataRow["NameT"].ToString(),
                    dataRow["NameTov"].ToString(),
                    dataRow["NameTovDop"].ToString(),
                    dataRow["Art"].ToString(),
                    CreateAndGet_IDColor_tbColor_Kyda(dataRow["NameColor"].ToString()),
                    dataRow["Model"].ToString(),
                    dataRow["Sizes"].ToString(),
                    dataRow["Hight"].ToString(),
                    dataRow["Sort"].ToString(),
                    Create_EdIzID_SprEdIz_Kyda(dataRow["EdIz"].ToString(), dataRow["NameEdIzm"].ToString(), dataRow["ShortNameEdizm"].ToString()),
                    dataRow["Protkl"].ToString(),
                    dataRow["Sertif"].ToString(),
                    dataRow["Sertif1"].ToString(),
                    dataRow["MinUp"].ToString(),
                    dataRow["Ves"].ToString(),
                    dataRow["VidUp"].ToString(),
                    dataRow["Fasov"].ToString(),
                    Create_IDCountry_tbCountry_Kyda(dataRow["NameCountry"].ToString(), dataRow["NameCountryShort"].ToString(), dataRow["KodCountry"].ToString(), dataRow["PriznZarub"].ToString()),
                    dataRow["PNTTar1"].ToString(),
                    dataRow["PNTTar2"].ToString(),
                    dataRow["Cen$"].ToString(),
                    dataRow["CenIzg"].ToString(),
                    dataRow["CenPriobr"].ToString(),
                    dataRow["CenO"].ToString(),
                    dataRow["SkidPost"].ToString(),
                    dataRow["Izder"].ToString(),
                    dataRow["Rentab"].ToString(),
                    dataRow["DatePrih"].ToString(),
                    dataRow["SrokGodn"].ToString(),
                    Create_IDPriznNac_tbPriznNac_Kyda(dataRow["NamePriznNac"].ToString()),
                    dataRow["NacPosr"].ToString(),
                    dataRow["NDS"].ToString(),
                    dataRow["NalProd"].ToString(),
                    dataRow["NalTr"].ToString(),
                    dataRow["PriznSyria"].ToString(),
                    dataRow["Kompl"].ToString(),
                    dataRow["Jirn"].ToString(),
                    dataRow["PrSocZ"].ToString(),
                    dataRow["KolPor"].ToString(),
                    dataRow["Vlajn"].ToString(),
                    dataRow["PrMenu"].ToString(),
                    dataRow["PrSyrja"].ToString(),
                    dataRow["IDSort"].ToString(),
                    dataRow["BarKod"].ToString(),
                    dataRow["BarKodR"].ToString(),
                    dataRow["Sertif2"].ToString(),
                    dataRow["PrizBlok"].ToString(),
                    dataRow["TKoeff"].ToString(),
                    dataRow["IDPrizLog"].ToString(),
                    dataRow["BonusPok"].ToString(),
                    dataRow["BonusPost"].ToString(),
                    dataRow["PNTTar3"].ToString(),
                    dataRow["PrLogBKS"].ToString(),
                    dataRow["NalAkc"].ToString(),
                    dataRow["NalTrPost"].ToString(),
                    dataRow["EstimatedTotalPrice"].ToString()
                 );
            }
        }

        private void Create_SprTovar_SprTovar_Kyda
            (
                string PNTIn,
                string KodGrIn,
                string KodPGrIn,
                string KodVidIn,
                string KodR1In,
                string KodR2In,
                string GlKodIn,
                string NameTIn,
                string NameTovIn,
                string NameTovDopIn,
                string ArtIn,
                string IDColorIn,
                string ModelIn,
                string SizesIn,
                string HightIn,
                string SortIn,
                string EdIzIDIn,
                string ProtklIn,
                string SertifIn,
                string Sertif1In,
                string MinUpIn,
                string VesIn,
                string VidUpIn,
                string FasovIn,
                string IDCountryIn,
                string PNTTar1In,
                string PNTTar2In,
                string CenIn,
                string CenIzgIn,
                string CenPriobrIn,
                string CenOIn,
                string SkidPostIn,
                string IzderIn,
                string RentabIn,
                string DatePrihIn,
                string SrokGodnIn,
                string IDPriznNacIn,
                string NacPosrIn,
                string NDSIn,
                string NalProdIn,
                string NalTrIn,
                string PriznSyriaIn,
                string KomplIn,
                string JirnIn,
                string PrSocZIn,
                string KolPorIn,
                string VlajnIn,
                string PrMenuIn,
                string PrSyrjaIn,
                string IDSortIn,
                string BarKodIn,
                string BarKodRIn,
                string Sertif2In,
                string PrizBlokIn,
                string TKoeffIn,
                string IDPrizLogIn,
                string BonusPokIn,
                string BonusPostIn,
                string PNTTar3In,
                string PrLogBKSIn,
                string NalAkcIn,
                string NalTrPostIn,
                string EstimatedTotalPriceIn
            )
        {
            PNTIn = (Convert.ToInt32(PNTIn) + 6000000).ToString();
            if (PNTTar1In != "")
            {
                PNTTar1In = (Convert.ToInt32(PNTTar1In) + 6000000).ToString();
            }
            if (PNTTar2In != "")
            {
                PNTTar2In = (Convert.ToInt32(PNTTar2In) + 6000000).ToString();
            }
            if (PrMenuIn == "True")
            {
                PrMenuIn = "1";
            }
            if (PrMenuIn == "False")
            {
                PrMenuIn = "0";
            }
            if (PrizBlokIn == "True")
            {
                PrizBlokIn = "1";
            }
            if (PrizBlokIn == "False")
            {
                PrizBlokIn = "0";
            }

            try
            {
                connKyda.Open();
                SqlCommand sqlCommand = new SqlCommand
                (
                    "SELECT COUNT(*) FROM SprTovar WHERE PNT = " + PNTIn, connKyda
                );
                int count = Convert.ToInt32(sqlCommand.ExecuteScalar().ToString());
                if (count == 0)
                {
                    if (cbx_ENABLE_LOG.Checked == true)
                    {
                        rtbxLOG.Text += "СОЗДАНИЕ SprTovar КУДА" + Environment.NewLine;
                        rtbxLOG.Text += "  PNT = " + PNTIn + Environment.NewLine;
                    }
                    string queryColumns = "set identity_insert sprTovar on; INSERT INTO SprTovar (KodGr, KodPGr, KodVid, KodR1, KodR2";
                    string queryValues = ") VALUES (" + KodGrIn + ", " + KodPGrIn + ", " + KodVidIn + ", " + KodR1In + ", " + KodR2In;
                    if (GlKodIn != "")
                    {
                        queryColumns += ", GlKod";
                        queryValues += ", '" + GlKodIn.Replace("'", "\"") + "'";
                    }
                    if (NameTIn != "")
                    {
                        queryColumns += ", NameT";
                        queryValues += ", '" + NameTIn.Replace("'", "\"") + "'";
                    }
                    queryColumns += ", PNT";
                    queryValues += ", " + PNTIn;
                    if (NameTovIn != "")
                    {
                        queryColumns += ", NameTov";
                        queryValues += ", '" + NameTovIn.Replace("'", "\"") + "'";
                    }
                    if (NameTovDopIn != "")
                    {
                        queryColumns += ", NameTovDop";
                        queryValues += ", '" + NameTovDopIn.Replace("'", "\"") + "'";
                    }
                    if (ArtIn != "")
                    {
                        queryColumns += ", Art";
                        queryValues += ", '" + ArtIn.Replace("'", "\"") + "'";
                    }
                    if (IDColorIn != "")
                    {
                        queryColumns += ", IDColor";
                        queryValues += ", " + IDColorIn;
                    }
                    if (ModelIn != "")
                    {
                        queryColumns += ", Model";
                        queryValues += ", '" + ModelIn.Replace("'", "\"") + "'";
                    }
                    if (SizesIn != "")
                    {
                        queryColumns += ", Sizes";
                        queryValues += ", '" + SizesIn.Replace("'", "\"") + "'";
                    }
                    if (HightIn != "")
                    {
                        queryColumns += ", Hight";
                        queryValues += ", '" + HightIn.Replace("'", "\"") + "'";
                    }
                    if (SortIn != "")
                    {
                        queryColumns += ", Sort";
                        queryValues += ", '" + SortIn.Replace("'", "\"") + "'";
                    }
                    queryColumns += ", EdIzID";
                    queryValues += ", " + EdIzIDIn;
                    if (ProtklIn != "")
                    {
                        queryColumns += ", Protkl";
                        queryValues += ", '" + ProtklIn.Replace("'", "\"") + "'";
                    }
                    if (SertifIn != "")
                    {
                        queryColumns += ", Sertif";
                        queryValues += ", '" + SertifIn.Replace("'", "\"") + "'";
                    }
                    if (Sertif1In != "")
                    {
                        queryColumns += ", Sertif1";
                        queryValues += ", '" + Sertif1In.Replace("'", "\"") + "'";
                    }
                    if (MinUpIn != "")
                    {
                        queryColumns += ", MinUp";
                        queryValues += ", " + MinUpIn;
                    }
                    if (VesIn != "")
                    {
                        queryColumns += ", Ves";
                        queryValues += ", " + VesIn;
                    }
                    if (VidUpIn != "")
                    {
                        queryColumns += ", VidUp";
                        queryValues += ", '" + VidUpIn.Replace("'", "\"") + "'";
                    }
                    if (FasovIn != "")
                    {
                        queryColumns += ", Fasov";
                        queryValues += ", " + FasovIn;
                    }
                    if (IDCountryIn != "")
                    {
                        queryColumns += ", IDCountry";
                        queryValues += ", " + IDCountryIn;
                    }
                    if (PNTTar1In != "")
                    {
                        queryColumns += ", PNTTar1";
                        queryValues += ", " + PNTTar1In;
                    }
                    if (PNTTar2In != "")
                    {
                        queryColumns += ", PNTTar2";
                        queryValues += ", " + PNTTar2In;
                    }
                    if (CenIn != "")
                    {
                        queryColumns += ", Cen$";
                        queryValues += ", " + CenIn;
                    }
                    if (CenIzgIn != "")
                    {
                        queryColumns += ", CenIzg";
                        queryValues += ", " + CenIzgIn;
                    }
                    if (CenPriobrIn != "")
                    {
                        queryColumns += ", CenPriobr";
                        queryValues += ", " + CenPriobrIn;
                    }
                    if (CenOIn != "")
                    {
                        queryColumns += ", CenO";
                        queryValues += ", " + CenOIn;
                    }
                    if (SkidPostIn != "")
                    {
                        queryColumns += ", SkidPost";
                        queryValues += ", " + SkidPostIn;
                    }
                    if (IzderIn != "")
                    {
                        queryColumns += ", Izder";
                        queryValues += ", " + IzderIn;
                    }
                    if (RentabIn != "")
                    {
                        queryColumns += ", Rentab";
                        queryValues += ", " + RentabIn;
                    }
                    if (DatePrihIn != "")
                    {
                        DateTime dateTimeDatePrihIn = Convert.ToDateTime(DatePrihIn);
                        queryColumns += ", DatePrih";
                        queryValues += ", '" + dateTimeDatePrihIn.ToString("yyyy-MM-dd HH:mm:ss") + "'";
                    }
                    if (SrokGodnIn != "")
                    {
                        queryColumns += ", SrokGodn";
                        queryValues += ", " + SrokGodnIn;
                    }
                    if (IDPriznNacIn != "")
                    {
                        queryColumns += ", IDPriznNac";
                        queryValues += ", " + IDPriznNacIn;
                    }
                    if (NacPosrIn != "")
                    {
                        queryColumns += ", NacPosr";
                        queryValues += ", " + NacPosrIn;
                    }
                    if (NDSIn != "")
                    {
                        queryColumns += ", NDS";
                        queryValues += ", " + NDSIn;
                    }
                    if (NalProdIn != "")
                    {
                        queryColumns += ", NalProd";
                        queryValues += ", " + NalProdIn;
                    }
                    if (NalTrIn != "")
                    {
                        queryColumns += ", NalTr";
                        queryValues += ", " + NalTrIn;
                    }
                    if (PriznSyriaIn != "")
                    {
                        queryColumns += ", PriznSyria";
                        queryValues += ", '" + PriznSyriaIn.Replace("'", "\"") + "'";
                    }
                    if (KomplIn != "")
                    {
                        queryColumns += ", Kompl";
                        queryValues += ", " + KomplIn;
                    }
                    if (JirnIn != "")
                    {
                        queryColumns += ", Jirn";
                        queryValues += ", " + JirnIn;
                    }
                    if (PrSocZIn != "")
                    {
                        queryColumns += ", PrSocZ";
                        queryValues += ", '" + PrSocZIn.Replace("'", "\"") + "'";
                    }
                    if (KolPorIn != "")
                    {
                        queryColumns += ", KolPor";
                        queryValues += ", " + KolPorIn;
                    }
                    if (VlajnIn != "")
                    {
                        queryColumns += ", Vlajn";
                        queryValues += ", " + VlajnIn;
                    }
                    if (PrMenuIn != "")
                    {
                        queryColumns += ", PrMenu";
                        queryValues += ", " + PrMenuIn;
                    }
                    if (PrSyrjaIn != "")
                    {
                        queryColumns += ", PrSyrja";
                        queryValues += ", " + PrSyrjaIn;
                    }
                    if (IDSortIn != "")
                    {
                        queryColumns += ", IDSort";
                        queryValues += ", " + IDSortIn;
                    }
                    if (BarKodIn != "")
                    {
                        queryColumns += ", BarKod";
                        queryValues += ", '" + BarKodIn.Replace("'", "\"") + "'";
                    }
                    if (BarKodRIn != "")
                    {
                        queryColumns += ", BarKodR";
                        queryValues += ", '" + BarKodRIn.Replace("'", "\"") + "'";
                    }
                    if (Sertif2In != "")
                    {
                        queryColumns += ", Sertif2";
                        queryValues += ", '" + Sertif2In.Replace("'", "\"") + "'";
                    }
                    queryColumns += ", PrizBlok";
                    queryValues += ", " + PrizBlokIn;
                    if (TKoeffIn != "")
                    {
                        queryColumns += ", TKoeff";
                        queryValues += ", " + TKoeffIn;
                    }
                    if (IDPrizLogIn != "")
                    {
                        queryColumns += ", IDPrizLog";
                        queryValues += ", " + IDPrizLogIn;
                    }
                    if (BonusPokIn != "")
                    {
                        queryColumns += ", BonusPok";
                        queryValues += ", " + BonusPokIn;
                    }
                    if (BonusPostIn != "")
                    {
                        queryColumns += ", BonusPost";
                        queryValues += ", " + BonusPostIn;
                    }
                    if (PNTTar3In != "")
                    {
                        queryColumns += ", PNTTar3";
                        queryValues += ", " + PNTTar3In;
                    }
                    if (PrLogBKSIn != "")
                    {
                        queryColumns += ", PrLogBKS";
                        queryValues += ", " + PrLogBKSIn;
                    }
                    if (NalAkcIn != "")
                    {
                        queryColumns += ", NalAkc";
                        queryValues += ", " + NalAkcIn;
                    }
                    queryColumns += ", NalTrPost";
                    queryValues += ", " + NalTrPostIn;
                    if (EstimatedTotalPriceIn != "")
                    {
                        queryColumns += ", EstimatedTotalPrice";
                        queryValues += ", " + EstimatedTotalPriceIn;
                    }

                    string query = queryColumns + queryValues + "); set identity_insert sprTovar off";
                    sqlCommand = new SqlCommand
                    (
                        query, connKyda
                    );
                    sqlCommand.ExecuteNonQuery();
                }
                connKyda.Close();
            }
            catch (Exception Ex)
            {
                connKyda.Close();
                MessageBox.Show(Ex.ToString());
            }
        }
    }
}