// common masks for all start and end dates
$(function() {
    //$('#id_start_date').mask('99.99.9999');
    //$('#id_end_date').mask('99.99.9999');
    $(".bfh-datepicker-toggle").children('input').mask('99.99.9999');
});

function soato_monitoring(){
    var old_soato = '';
    soato_int = setInterval(function(){
            if($('#id_soato').val() != old_soato && $('#id_soato').val().length == 10){
                $.get("/core/soato-suggest/",
                    {'soato': $('#id_soato').val()},
                    function(result){
                        $('p#id_soato_text').html(result[0].name);
                        old_soato = $('#id_soato').val();
                    }
                )
            }
        }
        , 500);
}

document.onkeypress = function (e) {
    if (e.keyCode == 13) {
        if ($(':focus').is('input[type=text]')){
            return false;
        }
    }
};

function show_message(message, message_type, time_fade) {
    if (message) {
        message_type = message_type || 'success';
        time_fade = time_fade || 4000;

        var mes_html_code = '<div style="position:fixed; z-index:1000000;top:52px; left:0;width: 100%;opacity:0.9">' +
                                '<div class="container"><div class="row"><div class="col-lg-8 col-lg-offset-2">' +
                                    '<div id="custom-message" class="alert alert-' + message_type + '">' +
                                        '<button type="button" class="close" data-dismiss="alert" aria-hidden="true">' +
                                            '&times;' +
                                        '</button>' +
                                        message +
                                    '</div>' +
                                '</div>' +
                            '</div>';

        $('#message_block').html(mes_html_code);
        setTimeout(function() {
           $('#custom-message').fadeOut();
        }, time_fade);
    }
}

function show_modal_window(result) {
    if(result.length){
        $('#modal_block').html(result).modal('show');
    }
}

$(document).ready(function(){
    function NumberMask (element, options_) {
        var thousand_separator = options_.thousandSeparator || ' ';
        var float_count = parseInt(options_.floatCount) || 0;

        if (float_count > 0) {
            var float_separator = options_.float_separator || '.';

            function CreateMaskForRealNumber(val, event) {
                if (~val.indexOf(float_separator)) {
                    var mask_sep =  (event === undefined)?  float_separator: 'D'; // При первом запуске, если задано не
                    // целое число по умолчанию в поле, то MaskHandler не будет запущен и собранная маска с символом 'D'
                    // исковеркает принятое число. В описанном случае принимаем разделитель равным float_separator
                    var expr = new RegExp(thousand_separator + '|\\' + float_separator + '\\d*', 'g'); // Оставляет
                    var clean_val = val.replace(expr, '');                  // только целую часть числа без пробелов
                    var mask1part = '0';
                    for (var i = 2; i < clean_val.length + 1; i++) {
                        if (i % 3 == 1) {
                            mask1part = thousand_separator + mask1part;
                        }
                        mask1part = '0' + mask1part;
                    }

                    var mask2part = '9' + mask_sep + '9';
                    for (var j = 2; j <= float_count; j++) {    // Сбор маски вида 9{n}D9{n}, где D - это float_separator,
                        mask2part = '9' + mask2part + '9';      // а n = float_count.
                    }
                    mask2part = '999' + mask2part; // Добавление возможности удаления/добавления символов в целой части зажатием клавиши на float_count + 3 символа
                    return mask1part + mask2part;
                }
                else {
                    return '0D0D0D 0D0D0D 0D0D0D 0D0D0D';
                }
            }

            var MaskHandler = {
                onChange: function (val, e, field, options) {
                    if (val[0] == float_separator) {
                        val = val.slice(1)
                    }

                    var thousand_separator_expr = new RegExp(thousand_separator, 'g');
                    var clean_val = val.replace(thousand_separator_expr, '');
                    var prev_value = field.data('prev_value');

                    if (clean_val.indexOf(float_separator) != -1 &&
                        clean_val.length - clean_val.indexOf(float_separator) - 1 > float_count) {
                        // После разделителя целой и дробной части стоит больше цифр, чем нужно. Отбросим лишние.
                        val = clean_val.slice(0, clean_val.indexOf(float_separator) + float_count + 1);
                        clean_val = val;
                    }

                    if (prev_value !== undefined && ~prev_value.indexOf(float_separator) &&
                        ~clean_val.indexOf(float_separator) && prev_value.length - clean_val.length > 1) {
                        // Была удалена цифра до разделителя целой и дробной части.
                        // Маска в данном случае удалила еще и разделитель. Вернем его на место руками.
                        var right_position_dot = prev_value.length - prev_value.indexOf(float_separator) - 1;
                        var pos_dot_in_new_str = clean_val.length - right_position_dot;
                        clean_val = clean_val.slice(0, pos_dot_in_new_str) + float_separator + clean_val.slice(pos_dot_in_new_str);
                        val = clean_val;
                    }

                    field.data('prev_value', clean_val).val(clean_val);
                    var val_is_float = val.indexOf(float_separator) == -1;
                    var expr = new RegExp('[' + float_separator + ']');
                    options['translation'] = {'D': {pattern: expr, optional: val_is_float}};
                    options['reverse'] = val_is_float;
                    field.mask(CreateMaskForRealNumber.apply({}, arguments), options);
                }
            };

            var e = $.Event("keyup", {keyCode: 64}); // Нажатие на пробел
            $(element).mask(CreateMaskForRealNumber, MaskHandler).trigger(e); // Имитация нажатия нужна для вызова MaskHandler
        }
        else {
            var mask_pattern = '000';
            for (var i = 1; i < 5; i++) {
                mask_pattern += thousand_separator + '000';
            }
            $(element).mask(mask_pattern, {'reverse': true});
        }
    };

    $("[data-class='NumberConcatenate']").each(function(){
        NumberMask(this, $(this).data());
    });
});
