﻿CREATE SEQUENCE SYSLOGSEQ_GEN INCREMENT BY 1 START WITH 1 CACHE 20;

CREATE TABLE ACCOUNTTYPE (
       ACCOUNTTYPEID        integer NOT NULL,
       ACCOUNTTYPENAME      character varying(50) NOT NULL,
       ACCOUNTTYPEVALUE     integer NOT NULL,
       ACCOUNTKINDVALUE     integer NOT NULL,
       MAXCREDIT            numeric(18, 6) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 ALTER TABLE ACCOUNTTYPE
        ADD  PRIMARY KEY(ACCOUNTTYPEID);


 CREATE TABLE ART (
       ARTID                integer NOT NULL,
       GRPID                integer NOT NULL,
       OFFERID              integer,
       TAXGRPID             integer NOT NULL,
       MODGRPID             integer,
       ARTNAME              character varying(50) NOT NULL,
       COMPOSCARDID         integer,
       ARTSNAME             character varying(50),
       ARTCODE              integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);






 CREATE UNIQUE INDEX XAK1ART ON ART
(
       ARTCODE                        
);



 ALTER TABLE ART
        ADD  PRIMARY KEY(ARTID );



 CREATE TABLE ARTEXTGRP (
       ARTID                integer NOT NULL,
       EXTGRPID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTEXTGRP
        ADD   PRIMARY KEY(ARTID , EXTGRPID );



 CREATE TABLE ARTHOTKEY (
       ARTHOTKEYID          integer NOT NULL,
       ARTHOTKEYSETID       integer NOT NULL,
       PACKID               integer,
       ARTHOTKEYSTROKE      character varying(30) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTHOTKEY
        ADD   PRIMARY KEY(ARTHOTKEYID );



 CREATE TABLE ARTHOTKEYSET (
       ARTHOTKEYSETID       integer NOT NULL,
       ARTHOTKEYSETNAME     character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTHOTKEYSET
        ADD   PRIMARY KEY(ARTHOTKEYSETID );



 CREATE TABLE ARTMODGRP (
       ARTID                integer NOT NULL,
       MODGRPID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTMODGRP
        ADD   PRIMARY KEY(ARTID , MODGRPID );



 CREATE TABLE ARTPRNGRP (
       ARTID                integer NOT NULL,
       PRNGRPID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTPRNGRP
        ADD   PRIMARY KEY(ARTID , PRNGRPID );



 CREATE TABLE ARTSDEPT (
       ARTID                integer NOT NULL,
       SDEPTID              integer NOT NULL,
       ARTNUM               integer,
       KEYID                integer,
       PACKSHELFLIFE        integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE ARTSDEPT
        ADD   PRIMARY KEY(ARTID , SDEPTID );



 CREATE TABLE BARC (
       BARCID               integer NOT NULL,
       BARCNAME             character varying(50),
       BARCMASK             character varying(30) NOT NULL,
       PREFIXLEN            integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE UNIQUE INDEX XAK1BARC ON BARC
(
       BARCMASK                       
);



 ALTER TABLE BARC
        ADD   PRIMARY KEY(BARCID );



 CREATE TABLE BINARYDATA (
       BINARYDATAID         integer NOT NULL,
       BINARYDATAVALUE      bytea,
       BYNARYDATANAME       character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE BINARYDATA
        ADD   PRIMARY KEY(BINARYDATAID );



 CREATE TABLE BINPROPERTY (
       BINPROPERTYKEY       integer NOT NULL,
       PROPERTYGRPID        integer NOT NULL,
       BINARYDATAID         integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE BINPROPERTY
        ADD   PRIMARY KEY(BINPROPERTYKEY , PROPERTYGRPID );



 CREATE TABLE BONUS (
       BONUSID              integer NOT NULL,
       BONUSNAME            character varying(50) NOT NULL,
       BONUSVAL             character varying(512) NOT NULL,
       BONUSCOND            character varying(512),
       BONUSTIME            character varying(512),
       BONUSDATE            character varying(512),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE BONUS
        ADD   PRIMARY KEY(BONUSID );



 CREATE TABLE BONUSOFFER (
       BONUSOFFERID         integer NOT NULL,
       BONUSOFFERNAME       character varying(50) NOT NULL,
       BONUSOFFERVAL        character varying(512) NOT NULL,
       BONUSOFFERCOND       character varying(512),
       BONUSOFFERTIME       character varying(512),
       BONUSOFFERDATE       character varying(512),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE BONUSOFFER
        ADD   PRIMARY KEY(BONUSOFFERID );



 CREATE TABLE CASHIER (
       CASHIERID            integer NOT NULL,
       CASHIERGRPID         integer NOT NULL,
       CASHIERKEY           character varying(50) NOT NULL,
       CASHIERNAME          character varying(50) NOT NULL,
       CASHIERDISABLED      smallint,
       CASHIERSAREACONTROL  smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE UNIQUE INDEX XAK1CASHIER ON CASHIER
(
       CASHIERKEY                     
);



 ALTER TABLE CASHIER
        ADD   PRIMARY KEY(CASHIERID );



 CREATE TABLE CASHIERGRP (
       CASHIERGRPID         integer NOT NULL,
       CASHIERGRPNAME       character varying(50) NOT NULL,
       CASHIERGRPDISABLED   smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHIERGRP
        ADD   PRIMARY KEY(CASHIERGRPID );



 CREATE TABLE CASHIERPVG (
       CASHIERPVGKEY        integer NOT NULL,
       CASHIERGRPID         integer NOT NULL,
       CASHIERPVGVALUE      smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHIERPVG
        ADD   PRIMARY KEY(CASHIERPVGKEY , CASHIERGRPID );



 CREATE TABLE CASHPROFILE (
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILENAME      character varying(50) NOT NULL,
       SYSLOGPROFILEID      integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILE
        ADD   PRIMARY KEY(CASHPROFILEID );



 CREATE TABLE CASHPROFILEBPVG (
       CASHPROFILEBPVGKEY   integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILEBPVGVALUE bytea,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILEBPVG
        ADD   PRIMARY KEY(CASHPROFILEBPVGKEY , 
              CASHPROFILEID );



 CREATE TABLE CASHPROFILECOLOR (
       CASHPROFILECOLORKEY  integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILECOLORVALUE integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILECOLOR
        ADD   PRIMARY KEY(CASHPROFILECOLORKEY , 
              CASHPROFILEID );



 CREATE TABLE CASHPROFILEKEY (
       CASHPROFILEKEYKEY    integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILEKEYVALUE  integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILEKEY
        ADD   PRIMARY KEY(CASHPROFILEKEYKEY , 
              CASHPROFILEID );



 CREATE TABLE CASHPROFILEPVG (
       CASHPROFILEPVGKEY    integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILEPVGVALUE  integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILEPVG
        ADD   PRIMARY KEY(CASHPROFILEPVGKEY , 
              CASHPROFILEID );



 CREATE TABLE CASHPROFILESPVG (
       CASHPROFILESPVGKEY   integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       CASHPROFILESPVGVALUE character varying(100),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CASHPROFILESPVG
        ADD   PRIMARY KEY(CASHPROFILESPVGKEY , 
              CASHPROFILEID );



 CREATE TABLE CLNT (
       CLNTID               integer NOT NULL,
       CLNTGRPID            integer NOT NULL,
       COMPANYID            integer,
       PROPERTYGRPID        integer,
       CLNTNAME             character varying(50) NOT NULL,
       CLNTBIRTHDAY         character varying(14),
       LOCKED               smallint,
       DELFLAG              smallint,
       PRIMARYEMAIL         character varying(50),
       UPDATENUM            integer NOT NULL,
       PRIMARYPHONE         character varying(50)
);



 ALTER TABLE CLNT
        ADD   PRIMARY KEY(CLNTID );



 CREATE TABLE CLNTFORM (
       CLNTFORMID           integer NOT NULL,
       CLNTFORMNAME         character varying(50) NOT NULL,
       ORDERNUM             integer NOT NULL,
       USESAREA             smallint,
       ACTIVEFROM           character varying(14),
       ACTIVETO             character varying(14),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTFORM
        ADD   PRIMARY KEY(CLNTFORMID );



 CREATE TABLE CLNTFORMITEMS (
       CLNTFORMID           integer NOT NULL,
       CLNTFORMITEMID       integer NOT NULL,
       CLNTFORMITEM         character varying(100) NOT NULL,
       ORDERNUM             integer NOT NULL,
       ISREQUIRED           smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTFORMITEMS
        ADD   PRIMARY KEY(CLNTFORMID , CLNTFORMITEMID );



 CREATE TABLE CLNTFORMPROPERTY (
       CLNTID               integer NOT NULL,
       CLNTFORMID           integer NOT NULL,
       CLNTFORMITEMID       integer NOT NULL,
       CLNTPROPERTYVAL      character varying(1024),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTFORMPROPERTY
        ADD   PRIMARY KEY(CLNTID , CLNTFORMID , 
              CLNTFORMITEMID );



 CREATE TABLE CLNTGRP (
       CLNTGRPID            integer NOT NULL,
       DISCID               integer,
       BONUSID              integer,
       CLNTGRPNAME          character varying(50) NOT NULL,
       CLNTGRPMANUAL        smallint,
       CLNTGRPTYPE          integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTGRP
        ADD   PRIMARY KEY(CLNTGRPID );



 CREATE TABLE CLNTPROPERTY (
       CLNTID               integer NOT NULL,
       CLNTPROPERTYKEY      integer NOT NULL,
       CLNTPROPERTYVAL      character varying(1024),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTPROPERTY
        ADD   PRIMARY KEY(CLNTID , CLNTPROPERTYKEY );



 CREATE TABLE CLNTSUM (
       CLNTID               integer NOT NULL,
       CURRENCYID           integer NOT NULL,
       LOYALTYCLUBID        integer NOT NULL,
       CLNTSUM              numeric(18, 6) NOT NULL,
       CLNTBONUS            numeric(18, 6) NOT NULL,
       DELFLAG              smallint,
       UPDATETIME           character varying(14) NOT NULL,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CLNTSUM
        ADD   PRIMARY KEY(CLNTID , CURRENCYID , 
              LOYALTYCLUBID );



 CREATE TABLE COMPANY (
       COMPANYID            integer NOT NULL,
       COMPANYGRPID         integer NOT NULL,
       PURCHPRCLEVELID      integer,
       COMPANYNAME          character varying(100) NOT NULL,
       COMPANYSNAME         character varying(100),
       CERTIFICATENUM       character varying(100),
       MAILADDR             character varying(100),
       JURIDICALADDR        character varying(100),
       PHONES               character varying(50),
       REGISTRYNUM          character varying(50),
       TAXIDENTNUM          character varying(50),
       PAYVAT               smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE COMPANY
        ADD   PRIMARY KEY(COMPANYID );



 CREATE TABLE COMPANYGRP (
       COMPANYGRPID         integer NOT NULL,
       COMPANYGRPNAME       character varying(50) NOT NULL,
       PARENTCOMPANYGRPID   integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE COMPANYGRP
        ADD   PRIMARY KEY(COMPANYGRPID );



 CREATE TABLE COMPOSCARD (
       COMPOSCARDID         integer NOT NULL,
       TASTE                text,
       APPEARANCE           text,
       NORMMB               text,
       NORMFX               text,
       COMPOSCARDNUM        character varying(50) NOT NULL,
       CARDCOMMENT          text,
       PRODUCTION           text,
       FEATURE              text,
       MENUWEIGHT           character varying(30),
       COMPOSCARDDATE       character varying(14) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE COMPOSCARD
        ADD   PRIMARY KEY(COMPOSCARDID );



 CREATE TABLE COMPOSINGR (
       COMPOSINGRID         integer NOT NULL,
       COMPOSCARDID         integer NOT NULL,
       ARTID                integer,
       NETWEIGHT            integer NOT NULL,
       GROSSWEIGHT          integer NOT NULL,
       WEIGHT               integer NOT NULL,
       PURCHPRICE           numeric(18, 6) NOT NULL,
       COMPOSINGRDATE       character varying(14) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE COMPOSINGR
        ADD   PRIMARY KEY(COMPOSINGRID , COMPOSCARDID );



 CREATE TABLE CURRENCY (
       CURRENCYID           integer NOT NULL,
       CURRENCYNAME         character varying(50) NOT NULL,
       CURRENCYSNAME        character varying(50),
       CURRENCYRATE         numeric(18, 6) NOT NULL,
       CURRENCYABBR         character varying(30),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE CURRENCY
        ADD   PRIMARY KEY(CURRENCYID );



 CREATE TABLE DATAPUMP (
       DIRNAME              character varying(50) NOT NULL,
       RECORDNUM            integer NOT NULL
);



 ALTER TABLE DATAPUMP
        ADD   PRIMARY KEY(DIRNAME );



 CREATE TABLE DATASYNCDIRS (
       DIRNAME              character varying(50) NOT NULL,
       SYNCDIR              integer NOT NULL,
       UPDATENUM            integer NOT NULL,
       SYNCPRIORITY         integer NOT NULL
);



 ALTER TABLE DATASYNCDIRS
        ADD   PRIMARY KEY(DIRNAME );



 CREATE TABLE DCARD (
       DCARDID              character varying(30) NOT NULL,
       CLNTID               integer NOT NULL,
       DCARDCODE            character varying(30) NOT NULL,
       DCARDNAME            character varying(50),
       ISPAYMENT            smallint,
       DELFLAG              smallint,
       PINCODE              character varying(256) ,
       UPDATENUM            integer NOT NULL,
       LOCKED               smallint
);


 CREATE UNIQUE INDEX XAK1DCARD ON DCARD
(
       DCARDCODE                      
);



 ALTER TABLE DCARD
        ADD   PRIMARY KEY(DCARDID );



 CREATE TABLE DISC (
       DISCID               integer NOT NULL,
       DISCNAME             character varying(50) NOT NULL,
       DISCVAL              character varying(512) NOT NULL,
       DISCCOND             character varying(512),
       DISCTIME             character varying(512),
       DISCDATE             character varying(512),
       DISCMANUALINP        smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE DISC
        ADD   PRIMARY KEY(DISCID );



 CREATE TABLE DISCOFFER (
       DISCOFFERID          integer NOT NULL,
       DISCOFFERNAME        character varying(50) NOT NULL,
       DISCOFFERVAL         character varying(512) NOT NULL,
       DISCOFFERCOND        character varying(512),
       DISCOFFERTIME        character varying(512),
       DISCOFFERDATE        character varying(512),
       DISCOFFERMANUALINP   smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE DISCOFFER
        ADD   PRIMARY KEY(DISCOFFERID );



 CREATE TABLE EVENTS (
       EVENTCODE            integer NOT NULL,
       EVENTLENG            integer NOT NULL,
       EVENTCONTENT         character varying(1024) NOT NULL
);



 ALTER TABLE EVENTS
        ADD   PRIMARY KEY(EVENTCODE , EVENTLENG );



 CREATE TABLE EXBARC (
       EXBARCID             integer NOT NULL,
       PACKID               integer NOT NULL,
       EXBARCTYPE           character varying(30) NOT NULL,
       EXBARCBODY           character varying(30) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE INDEX XIE1EXBARC ON EXBARC
(
       EXBARCBODY                     
);



 ALTER TABLE EXBARC
        ADD   PRIMARY KEY(EXBARCID );



 CREATE TABLE EXTGRP (
       EXTGRPID             integer NOT NULL,
       SAREAID              integer NOT NULL,
       PARENTEXTGRPID       integer,
       EXTGRPNAME           character varying(50) NOT NULL,
       EXTGRPPICTURE        bytea,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE EXTGRP
        ADD   PRIMARY KEY(EXTGRPID );



 CREATE TABLE FIRM (
       FIRMID               integer NOT NULL,
       LOYALTYCLUBID        integer,
       FIRMNAME             character varying(100) NOT NULL,
       CURRENCYID           integer,
       FIRMADDR             character varying(100),
       DOCPREFIX            character varying(30),
       CERTIFICATENUM       character varying(100),
       DELFLAG              smallint,
       MAILADDR             character varying(100),
       UPDATENUM            integer NOT NULL,
       PHONES               character varying(50),
       REGISTRYNUM          character varying(50),
       TAXIDENTNUM          character varying(50),
       ASKPINCODE           smallint NULL
);



 ALTER TABLE FIRM
        ADD   PRIMARY KEY(FIRMID );



 CREATE TABLE FIRMWAREHOUSE (
       FIRMID               integer NOT NULL,
       WAREHOUSEID          integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE FIRMWAREHOUSE
        ADD   PRIMARY KEY(FIRMID , WAREHOUSEID );



 CREATE TABLE GRP (
       GRPID                integer NOT NULL,
       OFFERID              integer,
       PARENTGRPID          integer,
       GRPNAME              character varying(50) NOT NULL,
       GRPPICTURE           bytea,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE GRP
        ADD   PRIMARY KEY(GRPID );



 CREATE TABLE HALL (
       HALLID               integer NOT NULL,
       SAREAID              integer NOT NULL,
       PRNSCHEMEID          integer,
       HALLNAME             character varying(50) NOT NULL,
       HALLPICTURE          bytea,
       HALLMINIPICTURE      bytea,
       HALLSORTKEY          integer,
       HALLFASTKEY          character varying(30),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE HALL
        ADD   PRIMARY KEY(HALLID );



 CREATE TABLE IMPORTCLNTFORMLOG (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       CLIENTFORMRESULTID   integer NOT NULL,
       ERRORCODE            integer NOT NULL,
       LOGMESSAGE           character varying(2048),
       TIMEPARSED           character(14) NOT NULL
);



 ALTER TABLE IMPORTCLNTFORMLOG
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              CLIENTFORMRESULTID );



 CREATE TABLE IMPORTREQUESTLOG (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       REQUESTID            integer NOT NULL,
       ERRORCODE            integer NOT NULL,
       LOGMESSAGE           character varying(2048),
       TIMEPARSED           character(14) NOT NULL
);



 ALTER TABLE IMPORTREQUESTLOG
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              REQUESTID );



 CREATE TABLE LOCALSAMGRDEVICE (
       LOCALSAMGRDEVICEID   integer NOT NULL,
       DEVICENAME           character varying(50) NOT NULL,
       DEVICETYPE           character varying(50) NOT NULL,
       PORTTYPE             character varying(50) NOT NULL,
       PORTNUMBER           integer NOT NULL,
       PORTADDRESS          character varying(50)
);



 ALTER TABLE LOCALSAMGRDEVICE
        ADD   PRIMARY KEY(LOCALSAMGRDEVICEID );



 CREATE TABLE LOCALSAMGRDEVICEPARAM (
       LOCALSAMGRDEVICEID   integer NOT NULL,
       LOCALSAMGRDEVICEPARAMKEY integer NOT NULL,
       LOCALSAMGRDEVICEPARAMVALUE character varying(50)
);



 ALTER TABLE LOCALSAMGRDEVICEPARAM
        ADD   PRIMARY KEY(LOCALSAMGRDEVICEID , 
              LOCALSAMGRDEVICEPARAMKEY );



 CREATE TABLE LOYALTYCLUB (
       LOYALTYCLUBID        integer NOT NULL,
       CURRENCYID           integer NOT NULL,
       ACCUMACCOUNTTYPEID   integer NOT NULL,
       BONUSACCOUNTTYPEID   integer NOT NULL,
       CLNTFORMID           integer,
       LOYALTYCLUBNAME      character varying(50) NOT NULL,
       ASKPINCODE           smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE LOYALTYCLUB
        ADD   PRIMARY KEY(LOYALTYCLUBID );



 CREATE TABLE MODGRP (
       MODGRPID             integer NOT NULL,
       MODGRPNAME           character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE MODGRP
        ADD   PRIMARY KEY(MODGRPID );



 CREATE TABLE MPDBINFO (
       INFOKEY              character varying(30) NOT NULL,
       INFOVAL              character varying(100)
);



 ALTER TABLE MPDBINFO
        ADD   PRIMARY KEY(INFOKEY );



 CREATE TABLE MSGSUB (
       MSGSUBID             character varying (36) NOT NULL,
       MSGSUBCONDID         integer,
       ISACTIVE             smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE MSGSUB
        ADD   PRIMARY KEY(MSGSUBID );



 CREATE TABLE MSGSUBCOND (
       MSGSUBCONDID         integer NOT NULL,
       MSGSUBCONDNAME       character varying(50) NOT NULL,
       MSGSUBTYPE           character varying (36) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE MSGSUBCOND
        ADD   PRIMARY KEY(MSGSUBCONDID );



 CREATE TABLE MSGSUBPARAM (
       MSGSUBPARAMID        integer NOT NULL,
       MSGSUBCONDID         integer NOT NULL,
       CASHMSGSUBID         character varying(50),
       PARAMCOND            character varying(512),
       PARAMTEXT            character varying(512),
       ISACTIVE             smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE MSGSUBPARAM
        ADD   PRIMARY KEY(MSGSUBPARAMID , MSGSUBCONDID );



 CREATE TABLE NUMBERS (
       NUMBERID             integer NOT NULL,
       NUMBERVALUE          numeric(18, 6) NOT NULL,
       NUMBERNAME           character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE NUMBERS
        ADD   PRIMARY KEY(NUMBERID );



 CREATE TABLE NUMPROPERTY (
       NUMPROPERTYKEY       integer NOT NULL,
       PROPERTYGRPID        integer NOT NULL,
       NUMBERID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE NUMPROPERTY
        ADD   PRIMARY KEY(NUMPROPERTYKEY , PROPERTYGRPID );



 CREATE TABLE OFFER (
       OFFERID              integer NOT NULL,
       DISCOFFERID          integer,
       BONUSOFFERID         integer,
       OFFERNAME            character varying(50) NOT NULL,
       SALEOFFERID          integer,
       OFFERCODE            character varying(50),
       OFFERAUTOASSIGN      smallint,
       OFFERMANUAL          smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE OFFER
        ADD   PRIMARY KEY(OFFERID );



 CREATE TABLE PACK (
       PACKID               integer NOT NULL,
       ARTID                integer NOT NULL,
       BARCID               integer,
       TAREID               integer,
       OFFERID              integer,
       UNITID               integer NOT NULL,
       PROPERTYGRPID        integer,
       PACKNAME             character varying(50),
       PACKQUANT            integer NOT NULL,
       QUANTMASK            integer NOT NULL,
       PACKDTYPE            integer NOT NULL,
       PACKSHELFLIFE        integer NOT NULL,
       ISDEFAULT            smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PACK
        ADD   PRIMARY KEY(PACKID );



 CREATE TABLE PACKPRC (
       PACKID               integer NOT NULL,
       PRCLEVELID           integer NOT NULL,
       TRFSCHEMEID          integer,
       PACKPRICE            numeric(18, 6) NOT NULL,
       PACKMINPRICE         numeric(18, 6) NOT NULL,
       PACKBONUSMINPRICE    numeric(18, 6) NOT NULL,
       PACKEXTMINPRICE      numeric(18, 6),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PACKPRC
        ADD   PRIMARY KEY(PACKID , PRCLEVELID );



 CREATE TABLE PAYMENTSCHEME (
       PAYMENTSCHEMEID      integer NOT NULL,
       PAYMENTSCHEMENAME    character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PAYMENTSCHEME
        ADD   PRIMARY KEY(PAYMENTSCHEMEID );



 CREATE TABLE PAYMENTSCHEMEITEMS (
       PAYMENTSCHEMEID      integer NOT NULL,
       CURRENCYID           integer NOT NULL,
       ACCOUNTTYPEID        integer NOT NULL,
       ORDERKEY             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PAYMENTSCHEMEITEMS
        ADD   PRIMARY KEY(PAYMENTSCHEMEID , CURRENCYID , 
              ACCOUNTTYPEID );



 CREATE TABLE PKHOLDER (
       TABLENAME            character varying(50) NOT NULL,
       FIELDNAME            character varying(50) NOT NULL,
       LASTPK               integer NOT NULL
);



 ALTER TABLE PKHOLDER
        ADD   PRIMARY KEY(TABLENAME , FIELDNAME );



 CREATE TABLE PLACE (
       PLACEID              integer NOT NULL,
       HALLID               integer NOT NULL,
       PRNSCHEMEID          integer,
       PLACENAME            character varying(50) NOT NULL,
       PLACEX               integer NOT NULL,
       PLACEY               integer NOT NULL,
       PLACESIZEX           integer NOT NULL,
       PLACESIZEY           integer NOT NULL,
       PLACEVIEWTYPE        integer NOT NULL,
       PLACEPICTURE         bytea,
       PLACECOLOR           integer,
       PLACEFONTCOLOR       integer,
       PLACEFONTSIZE        integer NOT NULL,
       DELFLAG              smallint,
       PLACEFONTBACKCOLOR   integer,
       PLACETARIFF          integer,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PLACE
        ADD   PRIMARY KEY(PLACEID , HALLID );



 CREATE TABLE PRCLEVEL (
       PRCLEVELID           integer NOT NULL,
       PRCLEVELNAME         character varying(50) NOT NULL,
       PRCLEVELKEY          integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRCLEVEL
        ADD   PRIMARY KEY(PRCLEVELID );



 CREATE TABLE PRN (
       PRNID                integer NOT NULL,
       PRNNAME              character varying(50) NOT NULL,
       PRNSRVNAME           character varying(50) NOT NULL,
       PRNSRVPORT           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRN
        ADD   PRIMARY KEY(PRNID );



 CREATE TABLE PRNGRP (
       PRNGRPID             integer NOT NULL,
       PRNGRPNAME           character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRNGRP
        ADD   PRIMARY KEY(PRNGRPID );



 CREATE TABLE PRNGRPPRNSCHEME (
       PRNGRPID             integer NOT NULL,
       PRNSCHEMEID          integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRNGRPPRNSCHEME
        ADD   PRIMARY KEY(PRNGRPID , PRNSCHEMEID );



 CREATE TABLE PRNPRNGRP (
       PRNID                integer NOT NULL,
       PRNGRPID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRNPRNGRP
        ADD   PRIMARY KEY(PRNID , PRNGRPID );



 CREATE TABLE PRNSCHEME (
       PRNSCHEMEID          integer NOT NULL,
       PRNSCHEMENAME        character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PRNSCHEME
        ADD   PRIMARY KEY(PRNSCHEMEID );



 CREATE TABLE PROPERTYGRP (
       PROPERTYGRPID        integer NOT NULL,
       PROPERTYGRPNAME      character varying(50) NOT NULL,
       PROPERTYGRPTYPE      integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE PROPERTYGRP
        ADD   PRIMARY KEY(PROPERTYGRPID );



 CREATE TABLE SALEOFFER (
       SALEOFFERID          integer NOT NULL,
       SALEOFFERNAME        character varying(50) NOT NULL,
       SALEOFFERVAL         character varying(512) NOT NULL,
       SALEOFFERCOND        character varying(512),
       SALEOFFERTIME        character varying(512),
       SALEOFFERDATE        character varying(512),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SALEOFFER
        ADD   PRIMARY KEY(SALEOFFERID );



 CREATE TABLE SAMCLNTFORMRESULT (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       CLNTFORMRESULTID     integer NOT NULL,
       CLNTFORMID           integer NOT NULL,
       ITEMSCOUNT           integer NOT NULL,
       FILLTIME             character varying(14) NOT NULL,
       CLNTID               integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE INDEX XIE1SAMCLNTFORMRESULT ON SAMCLNTFORMRESULT
(
       UPDATENUM                      
);



 ALTER TABLE SAMCLNTFORMRESULT
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              CLNTFORMRESULTID );



 CREATE TABLE SAMCLNTFORMRESULTITEMS (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       CLNTFORMRESULTID     integer NOT NULL,
       CLNTFORMITEMID       integer NOT NULL,
       CLNTFORMITEMVAL      character varying(1024),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE INDEX XIE1SAMCLNTFORMRESULTITEMS ON SAMCLNTFORMRESULTITEMS
(
       UPDATENUM                      
);



 ALTER TABLE SAMCLNTFORMRESULTITEMS
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              CLNTFORMRESULTID , CLNTFORMITEMID );



 CREATE TABLE SAMGRACTION (
       ACTIONID             integer NOT NULL,
       ACTIONNAME           character varying(50) NOT NULL,
       ISACTIVE             smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAMGRACTION
        ADD   PRIMARY KEY(ACTIONID );



 CREATE TABLE SAMGRACTIONFIELDS (
       ACTIONID             integer NOT NULL,
       DIRNAME              character varying(30) NOT NULL,
       FIELDNAME            character varying(30) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAMGRACTIONFIELDS
        ADD   PRIMARY KEY(ACTIONID , DIRNAME , 
              FIELDNAME );



 CREATE TABLE SAMGRCFG (
       CFGKEY               character varying(30) NOT NULL,
       CFGVALUE             character varying(100)
);



 ALTER TABLE SAMGRCFG
        ADD   PRIMARY KEY(CFGKEY );



 CREATE TABLE SAMREQUESTITEMSSYNC (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       REQUESTID            integer NOT NULL,
       REQUESTKEY           integer NOT NULL,
       REQUESTVAL           character varying(1024),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAMREQUESTITEMSSYNC
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              REQUESTID , REQUESTKEY );



 CREATE TABLE SAMREQUESTSERVERCFG (
       CFGKEY               integer NOT NULL,
       CFGVALUE             character varying(1024)
);



 ALTER TABLE SAMREQUESTSERVERCFG
        ADD   PRIMARY KEY(CFGKEY );



 CREATE TABLE SAMREQUESTSYNC (
       SAREAID              integer NOT NULL,
       SYSTEMID             integer NOT NULL,
       REQUESTID            integer NOT NULL,
       REQUESTTYPE          integer NOT NULL,
       REQUESTTIME          character varying(14) NOT NULL,
       ITEMSCOUNT           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE INDEX XIE1SAMREQUESTSYNC ON SAMREQUESTSYNC
(
       UPDATENUM                      
);



 ALTER TABLE SAMREQUESTSYNC
        ADD   PRIMARY KEY(SAREAID , SYSTEMID , 
              REQUESTID );



 CREATE TABLE SAREA (
       SAREAID              integer NOT NULL,
       PRCLEVELID           integer NOT NULL,
       CASHPROFILEID        integer NOT NULL,
       ARTHOTKEYSETID       integer,
       FIRMID               integer NOT NULL,
       WAREHOUSEID          integer,
       PRNSCHEMEID          integer,
       CURRENCYID           integer,
       SAREANAME            character varying(50) NOT NULL,
       SAREAADDR            character varying(100),
       DELFLAG              smallint,
       ASKPINCODE           smallint NULL,
       RECEIPTHEADER        character varying(100),
       RECEIPTFOOTER        character varying(100),
       UPDATENUM            integer NOT NULL,
       RECEIPTFIRSTHEADER   character varying(100),
       RECEIPTENDFOOTER     character varying(100)
);



 ALTER TABLE SAREA
        ADD   PRIMARY KEY(SAREAID );



 CREATE TABLE SAREACASHIER (
       SAREAID              integer NOT NULL,
       CASHIERID            integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREACASHIER
        ADD   PRIMARY KEY(SAREAID , CASHIERID );



 CREATE TABLE SAREACLNTFORM (
       SAREAID              integer NOT NULL,
       CLNTFORMID           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer
);



 ALTER TABLE SAREACLNTFORM
        ADD   PRIMARY KEY(SAREAID , CLNTFORMID );



 CREATE TABLE SAREACLNTGRP (
       SAREAID              integer NOT NULL,
       CLNTGRPID            integer NOT NULL,
       DISCID               integer,
       BONUSID              integer,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREACLNTGRP
        ADD   PRIMARY KEY(SAREAID , CLNTGRPID );



 CREATE TABLE SAREAMSGSUB (
       SAREAID              integer NOT NULL,
       MSGSUBID             character varying (36) NOT NULL,
       MSGSUBCONDID         integer,
       ISACTIVE             smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREAMSGSUB
        ADD   PRIMARY KEY(SAREAID , MSGSUBID );



 CREATE TABLE SAREAOFFER (
       SAREAID              integer NOT NULL,
       OFFERID              integer NOT NULL,
       DISCOFFERID          integer,
       BONUSOFFERID         integer,
       DELFLAG              smallint,
       SALEOFFERID          integer,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREAOFFER
        ADD   PRIMARY KEY(SAREAID , OFFERID );



 CREATE TABLE SAREAPRC (
       SAREAID              integer NOT NULL,
       PRCLEVELID           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREAPRC
        ADD   PRIMARY KEY(SAREAID , PRCLEVELID );



 CREATE TABLE SAREASAUSER (
       SAREAID              integer NOT NULL,
       SAUSERID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREASAUSER
        ADD   PRIMARY KEY(SAREAID , SAUSERID );



 CREATE TABLE SAREATXTBIN (
       SAREAID              integer NOT NULL,
       TXTBINID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAREATXTBIN
        ADD   PRIMARY KEY(SAREAID , TXTBINID );



 CREATE TABLE SAUSER (
       SAUSERID             integer NOT NULL,
       SAUSERNAME           character varying(50) NOT NULL,
       SAUSERPASSWORD       character varying(30) NOT NULL,
       SAUSERDISABLED       smallint,
       SAUSERPROFILEID      integer NOT NULL,
       USERSAREACONTROL     smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAUSER
        ADD   PRIMARY KEY(SAUSERID );



 CREATE TABLE SAUSERPROFILE (
       SAUSERPROFILEID      integer NOT NULL,
       SAUSERPROFILENAME    character varying(50),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAUSERPROFILE
        ADD   PRIMARY KEY(SAUSERPROFILEID );



 CREATE TABLE SAUSERPVG (
       SAUSERPVGKEY         integer NOT NULL,
       SAUSERPROFILEID      integer NOT NULL,
       SAUSERPVGVALUE       integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SAUSERPVG
        ADD   PRIMARY KEY(SAUSERPVGKEY , SAUSERPROFILEID );



 CREATE TABLE SDEPT (
       SDEPTID              integer NOT NULL,
       SAREAID              integer NOT NULL,
       SDEPTNAME            character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SDEPT
        ADD   PRIMARY KEY(SDEPTID );



 CREATE TABLE STRINGS (
       STRINGID             integer NOT NULL,
       STRINGVALUE          character varying(1024),
       STRINGNAME           character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE STRINGS
        ADD   PRIMARY KEY(STRINGID );



 CREATE TABLE STRPROPERTY (
       STRPROPERTYKEY       integer NOT NULL,
       PROPERTYGRPID        integer NOT NULL,
       STRINGID             integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE STRPROPERTY
        ADD   PRIMARY KEY(STRPROPERTYKEY , PROPERTYGRPID );



 CREATE TABLE SYSLOG (
       SYSTEMID             integer NOT NULL,
       SEQ                  INTEGER NOT NULL DEFAULT nextval('SYSLOGSEQ_GEN'),
       SAREAID              integer NOT NULL,
       CASHIERID            integer,
       EVENTTIME            character varying(14),
       EVENTCODE            integer,
       EVENTDATA            character varying(2000),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);


 CREATE INDEX XIE1SYSLOG ON SYSLOG
(
       UPDATENUM                      
);


 CREATE INDEX XIE2SYSLOG ON SYSLOG
(
       EVENTTIME                      
);


 CREATE INDEX XIE3SYSLOG ON SYSLOG
(
       EVENTCODE                      
);



 ALTER TABLE SYSLOG
        ADD PRIMARY KEY(SYSTEMID , SEQ , SAREAID );



 CREATE TABLE SYSLOGEVENT (
       SYSLOGPROFILEID      integer NOT NULL,
       SYSLOGEVENTCODE      integer NOT NULL,
       SYSLOGEVENTVALUE     smallint,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SYSLOGEVENT
        ADD   PRIMARY KEY(SYSLOGPROFILEID , 
              SYSLOGEVENTCODE );



 CREATE TABLE SYSLOGPROFILE (
       SYSLOGPROFILEID      integer NOT NULL,
       SYSLOGPROFILENAME    character varying(50) NOT NULL,
       SYSLOGPROFILETYPE    integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE SYSLOGPROFILE
        ADD   PRIMARY KEY(SYSLOGPROFILEID );



 CREATE TABLE TARE (
       TAREID               integer NOT NULL,
       TARENAME             character varying(50),
       TAREWEIGHT           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TARE
        ADD   PRIMARY KEY(TAREID );



 CREATE TABLE TAX (
       TAXID                integer NOT NULL,
       TAXGRPID             integer NOT NULL,
       TAXNAME              character varying(50),
       TAXRATE              integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TAX
        ADD   PRIMARY KEY(TAXID );



 CREATE TABLE TAXGRP (
       TAXGRPID             integer NOT NULL,
       TAXGRPNAME           character varying(50),
       TAXGRPRATE           integer NOT NULL,
       TAXGRPTYPE           integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TAXGRP
        ADD   PRIMARY KEY(TAXGRPID );



 CREATE TABLE TRFDAY (
       TRFDAYOFWEEK         integer NOT NULL,
       TRFSCHEMEID          integer NOT NULL,
       TRFDAYPRICE          numeric(18, 6) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TRFDAY
        ADD   PRIMARY KEY(TRFDAYOFWEEK , TRFSCHEMEID );



 CREATE TABLE TRFDAYTRFTIME (
       TRFDAYOFWEEK         integer NOT NULL,
       TRFSCHEMEID          integer NOT NULL,
       TRFTIMEID            integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TRFDAYTRFTIME
        ADD   PRIMARY KEY(TRFDAYOFWEEK , TRFSCHEMEID , 
              TRFTIMEID );



 CREATE TABLE TRFSCHEME (
       TRFSCHEMEID          integer NOT NULL,
       TRFSCHEMENAME        character varying(50) NOT NULL,
       TRFSCHEMEPERIOD      integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TRFSCHEME
        ADD   PRIMARY KEY(TRFSCHEMEID );



 CREATE TABLE TRFTIME (
       TRFTIMEID            integer NOT NULL,
       TRFTIMENAME          character varying(50) NOT NULL,
       TRFTIMEBEGIN         character varying(14) NOT NULL,
       TRFTIMEEND           character varying(14) NOT NULL,
       TRFTIMEPRICE         numeric(18, 6) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TRFTIME
        ADD   PRIMARY KEY(TRFTIMEID );



 CREATE TABLE TXTBIN (
       TXTBINID             integer NOT NULL,
       TXTBINCLS            integer NOT NULL,
       TXTBINTEXT           character varying(100) NOT NULL,
       TXTBINKEY            integer NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE TXTBIN
        ADD   PRIMARY KEY(TXTBINID );



 CREATE TABLE UNIT (
       UNITID               integer NOT NULL,
       UNITNAME             character varying(50) NOT NULL,
       UNITFULLNAME         character varying(50),
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE UNIT
        ADD   PRIMARY KEY(UNITID );



 CREATE TABLE WAREHOUSE (
       WAREHOUSEID          integer NOT NULL,
       WAREHOUSENAME        character varying(50) NOT NULL,
       DELFLAG              smallint,
       UPDATENUM            integer NOT NULL
);



 ALTER TABLE WAREHOUSE
        ADD   PRIMARY KEY(WAREHOUSEID );



 ALTER TABLE ART
       ADD FOREIGN KEY (COMPOSCARDID)
                             REFERENCES COMPOSCARD  (COMPOSCARDID);



 ALTER TABLE ART
       ADD FOREIGN KEY (MODGRPID)
                             REFERENCES MODGRP  (MODGRPID);



 ALTER TABLE ART
       ADD FOREIGN KEY (GRPID)
                             REFERENCES GRP  (GRPID);



 ALTER TABLE ART
       ADD FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);



 ALTER TABLE ART
       ADD FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);



 ALTER TABLE ARTEXTGRP
       ADD FOREIGN KEY (EXTGRPID)
                             REFERENCES EXTGRP  (EXTGRPID);



 ALTER TABLE ARTEXTGRP
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE ARTHOTKEY
       ADD FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);



 ALTER TABLE ARTHOTKEY
       ADD FOREIGN KEY (ARTHOTKEYSETID)
                             REFERENCES ARTHOTKEYSET  (ARTHOTKEYSETID);



 ALTER TABLE ARTMODGRP
       ADD FOREIGN KEY (MODGRPID)
                             REFERENCES MODGRP  (MODGRPID);



 ALTER TABLE ARTMODGRP
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE ARTPRNGRP
       ADD FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);



 ALTER TABLE ARTPRNGRP
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE ARTSDEPT
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE ARTSDEPT
       ADD FOREIGN KEY (SDEPTID)
                             REFERENCES SDEPT  (SDEPTID);



 ALTER TABLE BINPROPERTY
       ADD FOREIGN KEY (BINARYDATAID)
                             REFERENCES BINARYDATA  (BINARYDATAID);



 ALTER TABLE BINPROPERTY
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHIER
       ADD FOREIGN KEY (CASHIERGRPID)
                             REFERENCES CASHIERGRP  (CASHIERGRPID);



 ALTER TABLE CASHIERPVG
       ADD FOREIGN KEY (CASHIERGRPID)
                             REFERENCES CASHIERGRP  (CASHIERGRPID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHPROFILE
       ADD FOREIGN KEY (SYSLOGPROFILEID)
                             REFERENCES SYSLOGPROFILE  (
              SYSLOGPROFILEID);



 ALTER TABLE CASHPROFILEBPVG
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHPROFILECOLOR
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHPROFILEKEY
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHPROFILEPVG
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE CASHPROFILESPVG
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNT
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID);



 ALTER TABLE CLNT
       ADD FOREIGN KEY (COMPANYID)
                             REFERENCES COMPANY  (COMPANYID);



 ALTER TABLE CLNT
       ADD FOREIGN KEY (CLNTGRPID)
                             REFERENCES CLNTGRP  (CLNTGRPID);



 ALTER TABLE CLNTFORMITEMS
       ADD FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTFORMPROPERTY
       ADD FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTFORMPROPERTY
       ADD FOREIGN KEY (CLNTFORMID, CLNTFORMITEMID)
                             REFERENCES CLNTFORMITEMS  (CLNTFORMID, 
              CLNTFORMITEMID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTGRP
       ADD FOREIGN KEY (BONUSID)
                             REFERENCES BONUS  (BONUSID);



 ALTER TABLE CLNTGRP
       ADD FOREIGN KEY (DISCID)
                             REFERENCES DISC  (DISCID);



 ALTER TABLE CLNTPROPERTY
       ADD FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTSUM
       ADD FOREIGN KEY (LOYALTYCLUBID)
                             REFERENCES LOYALTYCLUB  (LOYALTYCLUBID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTSUM
       ADD FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID)
                             ON DELETE CASCADE;



 ALTER TABLE CLNTSUM
       ADD FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID)
                             ON DELETE CASCADE;



 ALTER TABLE COMPANY
       ADD FOREIGN KEY (PURCHPRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);



 ALTER TABLE COMPANY
       ADD FOREIGN KEY (COMPANYGRPID)
                             REFERENCES COMPANYGRP  (COMPANYGRPID);



 ALTER TABLE COMPOSINGR
       ADD FOREIGN KEY (COMPOSCARDID)
                             REFERENCES COMPOSCARD  (COMPOSCARDID);



 ALTER TABLE COMPOSINGR
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE DCARD
       ADD FOREIGN KEY (CLNTID)
                             REFERENCES CLNT  (CLNTID);



 ALTER TABLE EXBARC
       ADD FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);



 ALTER TABLE EXTGRP
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE FIRM
       ADD FOREIGN KEY (LOYALTYCLUBID)
                             REFERENCES LOYALTYCLUB  (LOYALTYCLUBID);



 ALTER TABLE FIRM
       ADD FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);



 ALTER TABLE FIRMWAREHOUSE
       ADD FOREIGN KEY (FIRMID)
                             REFERENCES FIRM  (FIRMID)
                             ON DELETE CASCADE;



 ALTER TABLE FIRMWAREHOUSE
       ADD FOREIGN KEY (WAREHOUSEID)
                             REFERENCES WAREHOUSE  (WAREHOUSEID)
                             ON DELETE CASCADE;



 ALTER TABLE GRP
       ADD FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);



 ALTER TABLE HALL
       ADD FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);



 ALTER TABLE HALL
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE LOCALSAMGRDEVICEPARAM
       ADD FOREIGN KEY (LOCALSAMGRDEVICEID)
                             REFERENCES LOCALSAMGRDEVICE  (
              LOCALSAMGRDEVICEID)
                             ON DELETE CASCADE;



 ALTER TABLE LOYALTYCLUB
       ADD FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID);



 ALTER TABLE LOYALTYCLUB
       ADD FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);



 ALTER TABLE LOYALTYCLUB
       ADD FOREIGN KEY (BONUSACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);



 ALTER TABLE LOYALTYCLUB
       ADD FOREIGN KEY (ACCUMACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);



 ALTER TABLE MSGSUB
       ADD FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID);



 ALTER TABLE MSGSUBPARAM
       ADD FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID)
                             ON DELETE CASCADE;



 ALTER TABLE NUMPROPERTY
       ADD FOREIGN KEY (NUMBERID)
                             REFERENCES NUMBERS  (NUMBERID);



 ALTER TABLE NUMPROPERTY
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;



 ALTER TABLE OFFER
       ADD FOREIGN KEY (SALEOFFERID)
                             REFERENCES SALEOFFER  (SALEOFFERID);



 ALTER TABLE OFFER
       ADD FOREIGN KEY (BONUSOFFERID)
                             REFERENCES BONUSOFFER  (BONUSOFFERID);



 ALTER TABLE OFFER
       ADD FOREIGN KEY (DISCOFFERID)
                             REFERENCES DISCOFFER  (DISCOFFERID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (ARTID)
                             REFERENCES ART  (ARTID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (BARCID)
                             REFERENCES BARC  (BARCID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (TAREID)
                             REFERENCES TARE  (TAREID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);



 ALTER TABLE PACK
       ADD FOREIGN KEY (UNITID)
                             REFERENCES UNIT  (UNITID);



 ALTER TABLE PACKPRC
       ADD FOREIGN KEY (TRFSCHEMEID)
                             REFERENCES TRFSCHEME  (TRFSCHEMEID);



 ALTER TABLE PACKPRC
       ADD FOREIGN KEY (PACKID)
                             REFERENCES PACK  (PACKID);



 ALTER TABLE PACKPRC
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);



 ALTER TABLE PAYMENTSCHEMEITEMS
       ADD FOREIGN KEY (ACCOUNTTYPEID)
                             REFERENCES ACCOUNTTYPE  (ACCOUNTTYPEID);



 ALTER TABLE PAYMENTSCHEMEITEMS
       ADD FOREIGN KEY (PAYMENTSCHEMEID)
                             REFERENCES PAYMENTSCHEME  (
              PAYMENTSCHEMEID);



 ALTER TABLE PAYMENTSCHEMEITEMS
       ADD FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);



 ALTER TABLE PLACE
       ADD FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);



 ALTER TABLE PLACE
       ADD FOREIGN KEY (HALLID)
                             REFERENCES HALL  (HALLID);



 ALTER TABLE PRNGRPPRNSCHEME
       ADD FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);



 ALTER TABLE PRNGRPPRNSCHEME
       ADD FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);



 ALTER TABLE PRNPRNGRP
       ADD FOREIGN KEY (PRNGRPID)
                             REFERENCES PRNGRP  (PRNGRPID);



 ALTER TABLE PRNPRNGRP
       ADD FOREIGN KEY (PRNID)
                             REFERENCES PRN  (PRNID);



 ALTER TABLE SAMCLNTFORMRESULTITEMS
       ADD FOREIGN KEY (SAREAID, SYSTEMID, CLNTFORMRESULTID)
                             REFERENCES SAMCLNTFORMRESULT  (SAREAID, 
              SYSTEMID, CLNTFORMRESULTID)
                             ON DELETE CASCADE;



 ALTER TABLE SAMGRACTIONFIELDS
       ADD FOREIGN KEY (ACTIONID)
                             REFERENCES SAMGRACTION  (ACTIONID)
                             ON DELETE CASCADE;



 ALTER TABLE SAMREQUESTITEMSSYNC
       ADD FOREIGN KEY (SAREAID, SYSTEMID, REQUESTID)
                             REFERENCES SAMREQUESTSYNC  (SAREAID, 
              SYSTEMID, REQUESTID)
                             ON DELETE CASCADE;



 ALTER TABLE SAREA
       ADD FOREIGN KEY (CURRENCYID)
                             REFERENCES CURRENCY  (CURRENCYID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (PRNSCHEMEID)
                             REFERENCES PRNSCHEME  (PRNSCHEMEID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (WAREHOUSEID)
                             REFERENCES WAREHOUSE  (WAREHOUSEID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (ARTHOTKEYSETID)
                             REFERENCES ARTHOTKEYSET  (ARTHOTKEYSETID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (FIRMID)
                             REFERENCES FIRM  (FIRMID);



 ALTER TABLE SAREA
       ADD FOREIGN KEY (CASHPROFILEID)
                             REFERENCES CASHPROFILE  (CASHPROFILEID);



 ALTER TABLE SAREACASHIER
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREACASHIER
       ADD FOREIGN KEY (CASHIERID)
                             REFERENCES CASHIER  (CASHIERID);



 ALTER TABLE SAREACLNTFORM
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID)
                             ON DELETE CASCADE;



 ALTER TABLE SAREACLNTFORM
       ADD FOREIGN KEY (CLNTFORMID)
                             REFERENCES CLNTFORM  (CLNTFORMID)
                             ON DELETE CASCADE;



 ALTER TABLE SAREACLNTGRP
       ADD FOREIGN KEY (BONUSID)
                             REFERENCES BONUS  (BONUSID);



 ALTER TABLE SAREACLNTGRP
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREACLNTGRP
       ADD FOREIGN KEY (DISCID)
                             REFERENCES DISC  (DISCID);



 ALTER TABLE SAREACLNTGRP
       ADD FOREIGN KEY (CLNTGRPID)
                             REFERENCES CLNTGRP  (CLNTGRPID);



 ALTER TABLE SAREAMSGSUB
       ADD FOREIGN KEY (MSGSUBID)
                             REFERENCES MSGSUB  (MSGSUBID);



 ALTER TABLE SAREAMSGSUB
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREAMSGSUB
       ADD FOREIGN KEY (MSGSUBCONDID)
                             REFERENCES MSGSUBCOND  (MSGSUBCONDID);



 ALTER TABLE SAREAOFFER
       ADD FOREIGN KEY (SALEOFFERID)
                             REFERENCES SALEOFFER  (SALEOFFERID);



 ALTER TABLE SAREAOFFER
       ADD FOREIGN KEY (BONUSOFFERID)
                             REFERENCES BONUSOFFER  (BONUSOFFERID);



 ALTER TABLE SAREAOFFER
       ADD FOREIGN KEY (OFFERID)
                             REFERENCES OFFER  (OFFERID);



 ALTER TABLE SAREAOFFER
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREAOFFER
       ADD FOREIGN KEY (DISCOFFERID)
                             REFERENCES DISCOFFER  (DISCOFFERID);



 ALTER TABLE SAREAPRC
       ADD FOREIGN KEY (PRCLEVELID)
                             REFERENCES PRCLEVEL  (PRCLEVELID);



 ALTER TABLE SAREAPRC
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREASAUSER
       ADD FOREIGN KEY (SAUSERID)
                             REFERENCES SAUSER  (SAUSERID);



 ALTER TABLE SAREASAUSER
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREATXTBIN
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE SAREATXTBIN
       ADD FOREIGN KEY (TXTBINID)
                             REFERENCES TXTBIN  (TXTBINID);



 ALTER TABLE SAUSER
       ADD FOREIGN KEY (SAUSERPROFILEID)
                             REFERENCES SAUSERPROFILE  (
              SAUSERPROFILEID);



 ALTER TABLE SAUSERPVG
       ADD FOREIGN KEY (SAUSERPROFILEID)
                             REFERENCES SAUSERPROFILE  (
              SAUSERPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE SDEPT
       ADD FOREIGN KEY (SAREAID)
                             REFERENCES SAREA  (SAREAID);



 ALTER TABLE STRPROPERTY
       ADD FOREIGN KEY (STRINGID)
                             REFERENCES STRINGS  (STRINGID);



 ALTER TABLE STRPROPERTY
       ADD FOREIGN KEY (PROPERTYGRPID)
                             REFERENCES PROPERTYGRP  (PROPERTYGRPID)
                             ON DELETE CASCADE;



 ALTER TABLE SYSLOGEVENT
       ADD FOREIGN KEY (SYSLOGPROFILEID)
                             REFERENCES SYSLOGPROFILE  (
              SYSLOGPROFILEID)
                             ON DELETE CASCADE;



 ALTER TABLE TAX
       ADD FOREIGN KEY (TAXGRPID)
                             REFERENCES TAXGRP  (TAXGRPID);



 ALTER TABLE TRFDAY
       ADD FOREIGN KEY (TRFSCHEMEID)
                             REFERENCES TRFSCHEME  (TRFSCHEMEID);



 ALTER TABLE TRFDAYTRFTIME
       ADD FOREIGN KEY (TRFTIMEID)
                             REFERENCES TRFTIME  (TRFTIMEID);



 ALTER TABLE TRFDAYTRFTIME
       ADD FOREIGN KEY (TRFDAYOFWEEK, TRFSCHEMEID)
                             REFERENCES TRFDAY  (TRFDAYOFWEEK, 
              TRFSCHEMEID);


--|||||||||||||||||START_SCRIPT|||||||||||||||||||
update PROPERTYGRP set PROPERTYGRPTYPE = 0;
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 ALTER TABLE PROPERTYGRP  ALTER COLUMN  PROPERTYGRPTYPE TYPE INTEGER;
  ALTER TABLE PROPERTYGRP  ALTER COLUMN  PROPERTYGRPTYPE SET NOT NULL;
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||


 INSERT INTO PKHOLDER (TABLENAME,FIELDNAME,LASTPK) VALUES ('MSGSUBCOND'    ,'MSGSUBCONDID',0);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||


 INSERT INTO DATAPUMP (DIRNAME, RECORDNUM) VALUES ('MSGSUB',1);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATAPUMP (DIRNAME, RECORDNUM) VALUES ('MSGSUBCOND',1);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATAPUMP (DIRNAME, RECORDNUM) VALUES ('MSGSUBPARAM',1);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATAPUMP (DIRNAME, RECORDNUM) VALUES ('SAREAMSGSUB',1);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||


 INSERT INTO DATASYNCDIRS (DIRNAME, SYNCDIR, UPDATENUM, SYNCPRIORITY) VALUES ('MSGSUB', 1, 1, 2);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATASYNCDIRS (DIRNAME, SYNCDIR, UPDATENUM, SYNCPRIORITY) VALUES ('MSGSUBCOND', 1, 1, 0);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATASYNCDIRS (DIRNAME, SYNCDIR, UPDATENUM, SYNCPRIORITY) VALUES ('MSGSUBPARAM', 1, 1, 1);
--|||||||||||||||||_SCRIPT|||||||||||||||||||

--|||||||||||||||||START_SCRIPT|||||||||||||||||||

 INSERT INTO DATASYNCDIRS (DIRNAME, SYNCDIR, UPDATENUM, SYNCPRIORITY) VALUES ('SAREAMSGSUB', 1, 1, 5);
--|||||||||||||||||_SCRIPT|||||||||||||||||||


